/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context.aware;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanInitializingEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.spring.context.MicronautApplicationContext;
import io.micronaut.spring.context.env.MicronautEnvironment;
import io.micronaut.spring.context.factory.MicronautBeanFactory;
import jakarta.inject.Singleton;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@Singleton
@Internal
public class SpringAwareListener
implements BeanInitializedEventListener<Object>,
BeanCreatedEventListener<Object> {
    private final BeanProvider<MicronautBeanFactory> beanFactoryProvider;
    private final BeanProvider<MicronautEnvironment> environmentProvider;
    private final BeanProvider<MicronautApplicationContext> applicationContextProvider;

    public SpringAwareListener(BeanProvider<MicronautBeanFactory> beanFactoryProvider, BeanProvider<MicronautEnvironment> environmentProvider, BeanProvider<MicronautApplicationContext> applicationContextProvider) {
        this.beanFactoryProvider = beanFactoryProvider;
        this.environmentProvider = environmentProvider;
        this.applicationContextProvider = applicationContextProvider;
    }

    public Object onInitialized(BeanInitializingEvent<Object> event) {
        Object bean = event.getBean();
        this.wireAwareObjects(bean);
        return bean;
    }

    private void wireAwareObjects(Object bean) {
        if (bean instanceof EnvironmentAware) {
            ((EnvironmentAware)bean).setEnvironment((Environment)this.environmentProvider.get());
        }
        if (bean instanceof BeanFactoryAware) {
            ((BeanFactoryAware)bean).setBeanFactory((BeanFactory)this.beanFactoryProvider.get());
        }
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext((ApplicationContext)this.applicationContextProvider.get());
        }
    }

    public Object onCreated(BeanCreatedEvent<Object> event) {
        Object bean = event.getBean();
        return this.onBeanCreated(bean);
    }

    public Object onBeanCreated(Object bean) {
        this.wireAwareObjects(bean);
        if (bean instanceof InitializingBean) {
            try {
                ((InitializingBean)bean).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanCreationException(e.getMessage(), (Throwable)e);
            }
        }
        return bean;
    }
}

