/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.beans;

import io.micronaut.context.annotation.Executable;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.beans.BeanParameterElement;
import java.util.Objects;
import java.util.function.Consumer;

public interface BeanMethodElement
extends MethodElement {
    @NonNull
    default public BeanMethodElement executable() {
        this.annotate(Executable.class);
        return this;
    }

    @NonNull
    default public BeanMethodElement inject() {
        if (this.hasAnnotation("javax.annotation.PreDestroy")) {
            throw new IllegalStateException("Cannot inject a method annotated with @PreDestroy");
        }
        if (this.hasAnnotation("javax.annotation.PostConstruct")) {
            throw new IllegalStateException("Cannot inject a method annotated with @PostConstruct");
        }
        this.annotate("javax.inject.Inject");
        return this;
    }

    @NonNull
    default public BeanMethodElement preDestroy() {
        if (this.hasAnnotation("javax.inject.Inject")) {
            throw new IllegalStateException("Cannot make a method annotated with @Inject a @PreDestroy handler");
        }
        if (this.hasAnnotation("javax.annotation.PostConstruct")) {
            throw new IllegalStateException("Cannot make a method annotated with @PostConstruct a @PreDestroy handler");
        }
        this.annotate("javax.annotation.PreDestroy");
        return this;
    }

    @NonNull
    default public BeanMethodElement postConstruct() {
        if (this.hasAnnotation("javax.inject.Inject")) {
            throw new IllegalStateException("Cannot make a method annotated with @Inject a @PostConstruct handler");
        }
        if (this.hasAnnotation("javax.annotation.PreDestroy")) {
            throw new IllegalStateException("Cannot make a method annotated with @PreDestroy a @PostConstruct handler");
        }
        this.annotate("javax.annotation.PostConstruct");
        return this;
    }

    @NonNull
    default public BeanMethodElement withParameters(@NonNull Consumer<BeanParameterElement[]> parameterConsumer) {
        Objects.requireNonNull(parameterConsumer, "The parameter consumer cannot be null");
        parameterConsumer.accept(this.getParameters());
        return this;
    }

    @NonNull
    public BeanParameterElement[] getParameters();
}

