/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ReflectParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Objects;

public interface ParameterElement
extends TypedElement {
    @Override
    @NonNull
    public ClassElement getType();

    @Override
    @NonNull
    default public String getDescription(boolean simple) {
        if (simple) {
            return this.getType().getSimpleName() + " " + this.getName();
        }
        return this.getType().getName() + " " + this.getName();
    }

    @NonNull
    public static ParameterElement of(@NonNull Class<?> type, @NonNull String name) {
        Objects.requireNonNull(name, "Name cannot be null");
        return new ReflectParameterElement(ClassElement.of(type), name);
    }

    @NonNull
    public static ParameterElement of(@NonNull ClassElement type, @NonNull String name) {
        Objects.requireNonNull(name, "Name cannot be null");
        Objects.requireNonNull(type, "Type cannot be null");
        return new ReflectParameterElement(type, name);
    }
}

