/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Internal
class JavaFieldElement
extends AbstractJavaElement
implements FieldElement {
    private final JavaVisitorContext visitorContext;
    private final VariableElement variableElement;
    private JavaClassElement declaringElement;
    private ClassElement typeElement;
    private ClassElement genericType;
    private ClassElement resolvedDeclaringClass;

    JavaFieldElement(VariableElement variableElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(variableElement, annotationMetadata, visitorContext);
        this.variableElement = variableElement;
        this.visitorContext = visitorContext;
    }

    JavaFieldElement(JavaClassElement declaringElement, VariableElement variableElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        this(variableElement, annotationMetadata, visitorContext);
        this.declaringElement = declaringElement;
    }

    public ClassElement getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.declaringElement == null ? this.getType() : this.mirrorToClassElement(this.variableElement.asType(), this.visitorContext, this.declaringElement.getGenericTypeInfo(), false);
        }
        return this.genericType;
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    @NonNull
    public ClassElement getType() {
        if (this.typeElement == null) {
            TypeMirror returnType = this.variableElement.asType();
            this.typeElement = this.mirrorToClassElement(returnType, this.visitorContext);
        }
        return this.typeElement;
    }

    public ClassElement getDeclaringType() {
        if (this.resolvedDeclaringClass == null) {
            Element enclosingElement = this.variableElement.getEnclosingElement();
            if (enclosingElement instanceof TypeElement) {
                TypeElement te = (TypeElement)enclosingElement;
                this.resolvedDeclaringClass = this.declaringElement.getName().equals(te.getQualifiedName().toString()) ? this.declaringElement : this.mirrorToClassElement(te.asType(), this.visitorContext, this.declaringElement.getGenericTypeInfo());
            } else {
                return this.declaringElement;
            }
        }
        return this.resolvedDeclaringClass;
    }
}

