/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.writer.AbstractClassWriterOutputVisitor;
import io.micronaut.inject.writer.FileBackedGeneratedFile;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;

@Internal
public class DirectoryClassWriterOutputVisitor
extends AbstractClassWriterOutputVisitor {
    private final File targetDir;

    public DirectoryClassWriterOutputVisitor(File targetDir) {
        this.targetDir = targetDir;
    }

    @Override
    public OutputStream visitClass(String className) throws IOException {
        File targetFile = new File(this.targetDir, this.getClassFileName(className)).getCanonicalFile();
        File parentDir = targetFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Cannot create parent directory: " + targetFile.getParentFile());
        }
        return Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);
    }

    @Override
    public Optional<GeneratedFile> visitMetaInfFile(String path) {
        return Optional.ofNullable(this.targetDir).map(root -> new FileBackedGeneratedFile(new File((File)root, "META-INF" + File.separator + path)));
    }

    @Override
    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        File parentFile = this.targetDir.getParentFile();
        File generatedDir = new File(parentFile, "generated");
        File f = new File(generatedDir, path);
        if (f.getParentFile().mkdirs()) {
            return Optional.of(new FileBackedGeneratedFile(f));
        }
        return Optional.empty();
    }

    private String getClassFileName(String className) {
        return className.replace('.', File.separatorChar) + ".class";
    }
}

