/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.Qualifier;
import io.micronaut.core.reflect.InstantiationUtils;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface BeanLocator {
    @Nonnull
    public <T> T getBean(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public <T> Optional<T> findBean(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public <T> Collection<T> getBeansOfType(@Nonnull Class<T> var1);

    @Nonnull
    public <T> Collection<T> getBeansOfType(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public <T> Stream<T> streamOfType(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public <T> T getProxyTargetBean(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    default public <T> Stream<T> streamOfType(@Nonnull Class<T> beanType) {
        return this.streamOfType(beanType, null);
    }

    @Nonnull
    default public <T> T getBean(@Nonnull Class<T> beanType) {
        return this.getBean(beanType, null);
    }

    @Nonnull
    default public <T> Optional<T> findBean(@Nonnull Class<T> beanType) {
        return this.findBean(beanType, null);
    }

    @Nonnull
    default public <T> Optional<T> findOrInstantiateBean(@Nonnull Class<T> beanType) {
        Optional<T> bean = this.findBean(beanType, null);
        if (bean.isPresent()) {
            return bean;
        }
        return InstantiationUtils.tryInstantiate(beanType);
    }
}

