/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 
package javax.servlet.jsp;

/**
 * The JspEngineInfo is an abstract class that provides information on the
 * current JSP engine.
 */

public abstract class JspEngineInfo {

    /**
     * Sole constructor. (For invocation by subclass constructors, 
     * typically implicit.)
     */
    public JspEngineInfo() {
    }
    
    /**
     * Return the version number of the JSP specification that is supported by
     * this JSP engine.
     * <p>
     * Specification version numbers that consists of positive decimal integers
     * separated by periods ".", for example, "2.0" or "1.2.3.4.5.6.7".
     * This allows an extensible number to be used to
     * represent major, minor, micro, etc versions.
     * The version number must begin with a number.
     * </p>
     *
     * @return the specification version, null is returned if it is not known
     */

    public abstract String getSpecificationVersion();
}
