/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.Constants;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.IsReloadableTypePlugin;
import org.springsource.loaded.LoadtimeInstrumentationPlugin;
import org.springsource.loaded.Plugin;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.SystemClassReflectionRewriter;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;
import org.springsource.loaded.agent.CglibPlugin;
import org.springsource.loaded.agent.GroovyPlugin;
import org.springsource.loaded.agent.Impossible;
import org.springsource.loaded.agent.JVMPlugin;
import org.springsource.loaded.agent.SpringPlugin;
import org.springsource.loaded.ri.ReflectiveInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLoadedPreProcessor
implements Constants {
    private static Logger log = Logger.getLogger(SpringLoadedPreProcessor.class.getName());
    private static List<Plugin> plugins = null;
    public static boolean disabled = false;
    private static boolean firstReloadableTypeHit = false;
    private static List<String> systemClassesContainingReflection;
    private Map<String, Integer> systemClassesRequiringInitialization = new HashMap<String, Integer>();
    private static final Class<?> EMPTY_CLASS_ARRAY_CLAZZ;
    private static boolean prepared;
    private static Method method_jlcgdfs;
    private static Method method_jlcgdf;
    private static Method method_jlcgf;
    private static Method method_jlcgdms;
    private static Method method_jlcgdm;
    private static Method method_jlcgm;
    private static Method method_jlcgdc;
    private static Method method_jlcgc;
    private static Method method_jlcgmods;
    private static Method method_jlcgms;
    private static final String[] uninterestingPrefixes;
    private static List<IsReloadableTypePlugin> isReloadableTypePlugins;

    static {
        EMPTY_CLASS_ARRAY_CLAZZ = Class[].class;
        prepared = false;
        uninterestingPrefixes = new String[]{"org/codehaus/groovy/", "groovy/", "freemarker/", "org/springframework/"};
        isReloadableTypePlugins = null;
    }

    public void initialize() {
        GlobalConfiguration.directlyDefineTypes = false;
        GlobalConfiguration.fileSystemMonitoring = true;
        systemClassesContainingReflection = new ArrayList<String>();
        systemClassesContainingReflection.add("com/sun/xml/internal/bind/v2/model/nav/ReflectionNavigator");
        systemClassesContainingReflection.add("sun/misc/ProxyGenerator");
        systemClassesContainingReflection.add("java/lang/reflect/Proxy");
        systemClassesContainingReflection.add("java/beans/Introspector");
    }

    public byte[] preProcess(ClassLoader classLoader, String slashedClassName, ProtectionDomain protectionDomain, byte[] bytes) {
        block32: {
            if (disabled) {
                return bytes;
            }
            for (Plugin plugin : SpringLoadedPreProcessor.getGlobalPlugins()) {
                LoadtimeInstrumentationPlugin loadtimeInstrumentationPlugin;
                if (!(plugin instanceof LoadtimeInstrumentationPlugin) || !(loadtimeInstrumentationPlugin = (LoadtimeInstrumentationPlugin)plugin).accept(slashedClassName, classLoader, protectionDomain, bytes)) continue;
                bytes = loadtimeInstrumentationPlugin.modify(slashedClassName, classLoader, bytes);
            }
            this.tryToEnsureSystemClassesInitialized(slashedClassName);
            TypeRegistry typeRegistry = TypeRegistry.getTypeRegistryFor(classLoader);
            if (typeRegistry == null) {
                if (classLoader == null && systemClassesContainingReflection.contains(slashedClassName)) {
                    try {
                        SystemClassReflectionRewriter.RewriteResult rr = SystemClassReflectionRewriter.rewrite(slashedClassName, bytes);
                        this.systemClassesRequiringInitialization.put(slashedClassName, rr.bits);
                        return rr.bytes;
                    }
                    catch (Exception re) {
                        re.printStackTrace();
                    }
                }
                return bytes;
            }
            if (typeRegistry.isReloadableTypeName(slashedClassName, protectionDomain, bytes)) {
                if (!firstReloadableTypeHit) {
                    firstReloadableTypeHit = true;
                    this.tryToEnsureSystemClassesInitialized(slashedClassName);
                }
                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                    log.info("processing " + slashedClassName + " as a reloadable type");
                }
                try {
                    ReloadableType rtype;
                    String dottedClassName = slashedClassName.replace('/', '.');
                    String watchPath = this.getWatchPathFromProtectionDomain(protectionDomain, slashedClassName);
                    if (watchPath == null) {
                        String[] interfacesImplemented;
                        int proxyIndex;
                        int cglibIndex2;
                        boolean makeReloadableAnyway = false;
                        int cglibIndex = slashedClassName.indexOf("$$EnhancerByCGLIB");
                        if (cglibIndex != -1) {
                            String originalType = slashedClassName.substring(0, cglibIndex);
                            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                                log.info("Appears to be a CGLIB type, checking if type " + originalType + " is reloadable");
                            }
                            if (typeRegistry.isReloadableTypeName(originalType)) {
                                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                                    log.info("Type " + originalType + " is reloadable, so making CGLIB type " + slashedClassName + " reloadable");
                                }
                                makeReloadableAnyway = true;
                            }
                        }
                        if ((cglibIndex2 = slashedClassName.indexOf("$$FastClassByCGLIB")) != -1) {
                            String originalType = slashedClassName.substring(0, cglibIndex2);
                            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                                log.info("Appears to be a CGLIB FastClass type, checking if type " + originalType + " is reloadable");
                            }
                            if (typeRegistry.isReloadableTypeName(originalType)) {
                                if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                                    log.info("Type " + originalType + " is reloadable, so making CGLIB type " + slashedClassName + " reloadable");
                                }
                                makeReloadableAnyway = true;
                            }
                        }
                        if (((proxyIndex = slashedClassName.indexOf("$Proxy")) == 0 || proxyIndex > 0 && slashedClassName.charAt(proxyIndex - 1) == '/') && (interfacesImplemented = Utils.discoverInterfaces(bytes)) != null) {
                            int i = 0;
                            while (i < interfacesImplemented.length) {
                                if (typeRegistry.isReloadableTypeName(interfacesImplemented[i])) {
                                    makeReloadableAnyway = true;
                                }
                                ++i;
                            }
                        }
                        if (!makeReloadableAnyway && classLoader.getClass().getName().endsWith("GroovyClassLoader$InnerLoader")) {
                            makeReloadableAnyway = true;
                        }
                        if (!makeReloadableAnyway) {
                            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                                log.info("can't watch " + slashedClassName + ": not making it reloadable");
                            }
                            if (SpringLoadedPreProcessor.needsClientSideRewriting(slashedClassName)) {
                                bytes = typeRegistry.methodCallRewriteUseCacheIfAvailable(slashedClassName, bytes);
                            }
                            return bytes;
                        }
                    }
                    if ((rtype = typeRegistry.addType(dottedClassName, bytes)) == null && GlobalConfiguration.callsideRewritingOn) {
                        bytes = typeRegistry.methodCallRewrite(bytes);
                        break block32;
                    }
                    if (GlobalConfiguration.fileSystemMonitoring && watchPath != null) {
                        typeRegistry.monitorForUpdates(rtype, watchPath);
                    }
                    return rtype.bytesLoaded;
                }
                catch (RuntimeException re) {
                    log.throwing("SpringLoadedPreProcessor", "preProcess", re);
                    throw re;
                }
            }
            try {
                if (SpringLoadedPreProcessor.needsClientSideRewriting(slashedClassName)) {
                    bytes = typeRegistry.methodCallRewriteUseCacheIfAvailable(slashedClassName, bytes);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Unexpected problem transforming call sites", t);
            }
        }
        return bytes;
    }

    private void tryToEnsureSystemClassesInitialized(String slashedClassName) {
        if (firstReloadableTypeHit && !this.systemClassesRequiringInitialization.isEmpty()) {
            int lastSlash = slashedClassName.lastIndexOf(47);
            String pkg = lastSlash == -1 ? null : slashedClassName.substring(0, lastSlash);
            this.ensurePreparedForInjection();
            ArrayList<String> toRemoveList = new ArrayList<String>();
            for (Map.Entry<String, Integer> me : this.systemClassesRequiringInitialization.entrySet()) {
                String classname = me.getKey();
                if (pkg != null && classname.startsWith(pkg)) continue;
                int bits = me.getValue();
                try {
                    Class<?> clazz = SpringLoadedPreProcessor.class.getClassLoader().loadClass(classname.replace('/', '.'));
                    this.injectReflectiveInterceptorMethods(slashedClassName, bits, clazz);
                    toRemoveList.add(classname);
                }
                catch (ClassCircularityError clazz) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (String toRemove : toRemoveList) {
                this.systemClassesRequiringInitialization.remove(toRemove);
            }
        }
    }

    private void injectReflectiveInterceptorMethods(String slashedClassName, int bits, Class<?> clazz) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException {
        Field f;
        if ((bits & 1) != 0) {
            f = clazz.getDeclaredField("__sljlcgdfs");
            f.setAccessible(true);
            f.set(null, method_jlcgdfs);
        }
        if ((bits & 2) != 0) {
            f = clazz.getDeclaredField("__sljlcgdf");
            f.setAccessible(true);
            f.set(null, method_jlcgdf);
        }
        if ((bits & 4) != 0) {
            f = clazz.getDeclaredField("__sljlcgf");
            f.setAccessible(true);
            f.set(null, method_jlcgf);
        }
        if ((bits & 8) != 0) {
            f = clazz.getDeclaredField("__sljlcgdms");
            f.setAccessible(true);
            f.set(null, method_jlcgdms);
        }
        if ((bits & 0x10) != 0) {
            f = clazz.getDeclaredField("__sljlcgdm");
            f.setAccessible(true);
            f.set(null, method_jlcgdm);
        }
        if ((bits & 0x20) != 0) {
            f = clazz.getDeclaredField("__sljlcgm");
            f.setAccessible(true);
            f.set(null, method_jlcgm);
        }
        if ((bits & 0x40) != 0) {
            f = clazz.getDeclaredField("__sljlcgdc");
            f.setAccessible(true);
            f.set(null, method_jlcgdc);
        }
        if ((bits & 0x80) != 0) {
            f = clazz.getDeclaredField("__sljlcgmods");
            f.setAccessible(true);
            f.set(null, method_jlcgmods);
        }
        if ((bits & 0x100) != 0) {
            f = clazz.getDeclaredField("__sljlcgms");
            f.setAccessible(true);
            f.set(null, method_jlcgms);
        }
        if ((bits & 0x200) != 0) {
            f = clazz.getDeclaredField("__sljlcgc");
            f.setAccessible(true);
            f.set(null, method_jlcgc);
        }
    }

    private void ensurePreparedForInjection() {
        if (!prepared) {
            try {
                Class<ReflectiveInterceptor> clazz = ReflectiveInterceptor.class;
                method_jlcgdfs = clazz.getDeclaredMethod("jlClassGetDeclaredFields", Class.class);
                method_jlcgdf = clazz.getDeclaredMethod("jlClassGetDeclaredField", Class.class, String.class);
                method_jlcgf = clazz.getDeclaredMethod("jlClassGetField", Class.class, String.class);
                method_jlcgdms = clazz.getDeclaredMethod("jlClassGetDeclaredMethods", Class.class);
                method_jlcgdm = clazz.getDeclaredMethod("jlClassGetDeclaredMethod", Class.class, String.class, EMPTY_CLASS_ARRAY_CLAZZ);
                method_jlcgm = clazz.getDeclaredMethod("jlClassGetMethod", Class.class, String.class, EMPTY_CLASS_ARRAY_CLAZZ);
                method_jlcgdc = clazz.getDeclaredMethod("jlClassGetDeclaredConstructor", Class.class, EMPTY_CLASS_ARRAY_CLAZZ);
                method_jlcgc = clazz.getDeclaredMethod("jlClassGetConstructor", Class.class, EMPTY_CLASS_ARRAY_CLAZZ);
                method_jlcgmods = clazz.getDeclaredMethod("jlClassGetModifiers", Class.class);
                method_jlcgms = clazz.getDeclaredMethod("jlClassGetMethods", Class.class);
            }
            catch (NoSuchMethodException nsme) {
                throw new Impossible(nsme);
            }
            prepared = true;
        }
    }

    private static boolean needsClientSideRewriting(String slashedClassName) {
        return !slashedClassName.startsWith("org/springsource/loaded");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getWatchPathFromProtectionDomain(ProtectionDomain protectionDomain, String slashedClassName) {
        String watchPath = null;
        if (protectionDomain == null) {
            if (!GlobalConfiguration.isRuntimeLogging) return watchPath;
            if (!log.isLoggable(Level.WARNING)) return watchPath;
            log.warning("Changes to type cannot be tracked: " + slashedClassName + " - no protection domain");
            return watchPath;
        }
        try {
            File file;
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource.getLocation() == null) {
                if (!GlobalConfiguration.isRuntimeLogging) return watchPath;
                if (!log.isLoggable(Level.WARNING)) return watchPath;
                log.warning("null codesource for " + slashedClassName);
                return watchPath;
            }
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINEST)) {
                log.finest("Codesource.getLocation()=" + codeSource.getLocation());
            }
            if ((file = new File(codeSource.getLocation().toURI())).isDirectory()) {
                file = new File(file, String.valueOf(slashedClassName) + ".class");
            } else if (!file.getName().endsWith(".class")) {
                if (file.getName().endsWith(".jar")) {
                    if (!GlobalConfiguration.isRuntimeLogging) return null;
                    if (!log.isLoggable(Level.WARNING)) return null;
                    log.warning("unable to watch this jar file entry: " + slashedClassName.replace('/', '.') + ". Computed location=" + file.toString());
                    return null;
                }
                if (file.toString().equals("/groovy/script")) return null;
                if (file.toString().equals("\\groovy\\script")) {
                    return null;
                }
                if (file.toString().endsWith(".class")) throw new UnsupportedOperationException("unable to watch " + slashedClassName.replace('/', '.') + ". Computed location=" + file.toString());
                return null;
            }
            watchPath = file.toString();
            if (!GlobalConfiguration.isRuntimeLogging) return watchPath;
            if (!log.isLoggable(Level.INFO)) return watchPath;
            log.info("Watched location for changes to " + slashedClassName + " is " + watchPath);
            return watchPath;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unexpected problem processing URI ", e);
        }
    }

    private void logEntryToPreprocess(ClassLoader classLoader, String slashedClassName, TypeRegistry typeRegistry) {
        String clname;
        String string = clname = classLoader == null ? "null" : classLoader.getClass().getName();
        if (clname.indexOf(46) != -1) {
            clname = clname.substring(clname.lastIndexOf(46) + 1);
        }
        if (typeRegistry == null) {
            log.finer("classname=" + slashedClassName + " classloader=" + classLoader + " typeregistry=" + typeRegistry);
        } else {
            boolean ignore = false;
            String[] stringArray = uninterestingPrefixes;
            int n = uninterestingPrefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String uninterestingPrefix = stringArray[n2];
                if (slashedClassName.startsWith(uninterestingPrefix)) {
                    ignore = true;
                    break;
                }
                ++n2;
            }
            if (!ignore) {
                log.info("classname=" + slashedClassName + " classloader=" + clname + " typeregistry=" + typeRegistry);
            }
            log.finer("classname=" + slashedClassName + " classloader=" + classLoader + " typeregistry=" + typeRegistry);
        }
    }

    public static List<Plugin> getGlobalPlugins() {
        if (plugins == null) {
            plugins = new ArrayList<Plugin>();
            plugins.add(new JVMPlugin());
            plugins.add(new SpringPlugin());
            plugins.add(new GroovyPlugin());
            plugins.add(new CglibPlugin());
            List<String> extraGlobalPlugins = GlobalConfiguration.pluginClassnameList;
            if (extraGlobalPlugins != null) {
                for (String globalPlugin : extraGlobalPlugins) {
                    try {
                        Class<?> pluginClass = Class.forName(globalPlugin, false, SpringLoadedPreProcessor.class.getClassLoader());
                        plugins.add((Plugin)pluginClass.newInstance());
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Unexpected problem loading global plugin:" + globalPlugin);
                        e.printStackTrace(System.err);
                    }
                    catch (InstantiationException e) {
                        System.err.println("Unexpected problem loading global plugin:" + globalPlugin);
                        e.printStackTrace(System.err);
                    }
                    catch (IllegalAccessException e) {
                        System.err.println("Unexpected problem loading global plugin:" + globalPlugin);
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        return plugins;
    }

    public static List<IsReloadableTypePlugin> getIsReloadableTypePlugins() {
        if (isReloadableTypePlugins == null) {
            isReloadableTypePlugins = new ArrayList<IsReloadableTypePlugin>();
            for (Plugin p : SpringLoadedPreProcessor.getGlobalPlugins()) {
                if (!(p instanceof IsReloadableTypePlugin)) continue;
                isReloadableTypePlugins.add((IsReloadableTypePlugin)p);
            }
        }
        return isReloadableTypePlugins;
    }

    public static void registerGlobalPlugin(Plugin instance) {
        SpringLoadedPreProcessor.getGlobalPlugins();
        plugins.add(instance);
        isReloadableTypePlugins = null;
    }

    public static void unregisterGlobalPlugin(Plugin instance) {
        SpringLoadedPreProcessor.getGlobalPlugins();
        plugins.remove(instance);
        isReloadableTypePlugins = null;
    }
}

