/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.ISMgr;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.SSMgr;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldReaderWriter {
    private static Logger log = Logger.getLogger(FieldReaderWriter.class.getName());
    protected TypeDescriptor typeDescriptor;
    protected FieldMember theField;

    public FieldReaderWriter(FieldMember theField, TypeDescriptor typeDescriptor) {
        this.theField = theField;
        this.typeDescriptor = typeDescriptor;
        assert (theField.typename == typeDescriptor.typename);
    }

    protected FieldReaderWriter() {
    }

    public void setValue(Object instance, Object newValue, ISMgr stateManager) throws IllegalAccessException {
        if (this.typeDescriptor.isReloadable()) {
            if (stateManager == null) {
                stateManager = this.findInstanceStateManager(instance);
            }
            String declaringTypeName = this.typeDescriptor.getName();
            Map<String, Object> typeLevelValues = stateManager.getMap().get(declaringTypeName);
            if (typeLevelValues == null) {
                typeLevelValues = new HashMap<String, Object>();
                stateManager.getMap().put(declaringTypeName, typeLevelValues);
            }
            typeLevelValues.put(this.theField.getName(), newValue);
        } else {
            if (this.typeDescriptor.isInterface()) {
                throw new IncompatibleClassChangeError("Expected non-static field " + instance.getClass().getName() + "." + this.theField.getName());
            }
            this.findAndSetFieldValueInHierarchy(instance, newValue);
        }
    }

    public void setStaticFieldValue(Class<?> clazz, Object newValue, SSMgr stateManager) throws IllegalAccessException {
        if (clazz == null) {
            throw new IllegalStateException();
        }
        if (this.typeDescriptor.isReloadable()) {
            if (stateManager == null) {
                stateManager = this.findStaticStateManager(clazz);
            }
            String declaringTypeName = this.typeDescriptor.getName();
            Map<String, Object> typeLevelValues = stateManager.getMap().get(declaringTypeName);
            if (typeLevelValues == null) {
                typeLevelValues = new HashMap<String, Object>();
                stateManager.getMap().put(declaringTypeName, typeLevelValues);
            }
            typeLevelValues.put(this.theField.getName(), newValue);
        } else {
            try {
                Field f = this.locateFieldByReflection(clazz, this.typeDescriptor.getDottedName(), this.typeDescriptor.isInterface(), this.theField.getName());
                f.setAccessible(true);
                f.set(null, newValue);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpectedly unable to reflectively set the field " + this.theField.getName() + " on the type " + clazz.getName());
            }
        }
    }

    public Object getValue(Object instance, ISMgr stateManager) throws IllegalAccessException, IllegalArgumentException {
        Object result = null;
        String fieldname = this.theField.getName();
        if (this.typeDescriptor.isReloadable()) {
            if (stateManager == null) {
                stateManager = this.findInstanceStateManager(instance);
            }
            String declaringTypeName = this.typeDescriptor.getName();
            Map<String, Object> typeLevelValues = stateManager.getMap().get(declaringTypeName);
            boolean knownField = false;
            if (typeLevelValues != null) {
                knownField = typeLevelValues.containsKey(fieldname);
            }
            if (knownField) {
                result = typeLevelValues.get(fieldname);
            }
            if (typeLevelValues == null || !knownField) {
                FieldMember fieldOnOriginalType = this.typeDescriptor.getReloadableType().getTypeRegistry().getReloadableType(declaringTypeName).getTypeDescriptor().getField(fieldname);
                if (fieldOnOriginalType != null) {
                    ReloadableType rt = this.typeDescriptor.getReloadableType();
                    try {
                        Field f = rt.getClazz().getDeclaredField(fieldname);
                        f.setAccessible(true);
                        result = f.get(instance);
                        if (typeLevelValues == null) {
                            typeLevelValues = new HashMap<String, Object>();
                            stateManager.getMap().put(declaringTypeName, typeLevelValues);
                        }
                        typeLevelValues.put(fieldname, result);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unexpectedly unable to access field " + fieldname + " on class " + rt.getClazz(), e);
                    }
                } else {
                    result = Utils.toResultCheckIfNull(null, this.theField.getDescriptor());
                    if (typeLevelValues == null) {
                        typeLevelValues = new HashMap<String, Object>();
                        stateManager.getMap().put(declaringTypeName, typeLevelValues);
                    }
                    typeLevelValues.put(fieldname, result);
                    return result;
                }
            }
            if (result != null && (result = Utils.checkCompatibility(this.typeDescriptor.getTypeRegistry(), result, this.theField.getDescriptor())) == null) {
                typeLevelValues.remove(fieldname);
            }
            result = Utils.toResultCheckIfNull(result, this.theField.getDescriptor());
        } else {
            if (this.typeDescriptor.isInterface()) {
                throw new IncompatibleClassChangeError("Expected non-static field " + instance.getClass().getName() + "." + fieldname);
            }
            result = this.findAndGetFieldValueInHierarchy(instance);
        }
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
            log.finer("<getValue() value of " + this.theField + " is " + result);
        }
        return result;
    }

    public Object getStaticFieldValue(Class<?> clazz, SSMgr stateManager) throws IllegalAccessException, IllegalArgumentException {
        Object result = null;
        if (clazz == null) {
            throw new IllegalStateException();
        }
        if (this.typeDescriptor.isReloadable()) {
            if (stateManager == null && (stateManager = this.findStaticStateManager(clazz)) == null) {
                return Utils.toResultCheckIfNull(null, this.theField.descriptor);
            }
            String declaringTypeName = this.typeDescriptor.getName();
            Map<String, Object> typeLevelValues = stateManager.getMap().get(declaringTypeName);
            String fieldname = this.theField.getName();
            boolean knownField = false;
            if (typeLevelValues != null) {
                knownField = typeLevelValues.containsKey(fieldname);
            }
            if (knownField) {
                result = typeLevelValues.get(fieldname);
            }
            if (typeLevelValues == null || !knownField) {
                FieldMember fieldOnOriginalType = this.typeDescriptor.getReloadableType().getTypeRegistry().getReloadableType(declaringTypeName).getTypeDescriptor().getField(fieldname);
                if (fieldOnOriginalType != null) {
                    ReloadableType rt = this.typeDescriptor.getReloadableType();
                    try {
                        Field f = rt.getClazz().getDeclaredField(this.theField.getName());
                        if (!Modifier.isStatic(f.getModifiers())) {
                            result = Utils.toResultCheckIfNull(null, this.theField.getDescriptor());
                            if (typeLevelValues == null) {
                                typeLevelValues = new HashMap<String, Object>();
                                stateManager.getMap().put(declaringTypeName, typeLevelValues);
                            }
                            typeLevelValues.put(fieldname, result);
                            return result;
                        }
                        f.setAccessible(true);
                        result = f.get(null);
                        if (typeLevelValues == null) {
                            typeLevelValues = new HashMap<String, Object>();
                            stateManager.getMap().put(declaringTypeName, typeLevelValues);
                        }
                        typeLevelValues.put(this.theField.getName(), result);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unexpectedly unable to read field " + this.theField.getName() + " on type " + rt.getClazz(), e);
                    }
                } else {
                    result = Utils.toResultCheckIfNull(null, this.theField.getDescriptor());
                    if (typeLevelValues == null) {
                        typeLevelValues = new HashMap<String, Object>();
                        stateManager.getMap().put(declaringTypeName, typeLevelValues);
                    }
                    typeLevelValues.put(fieldname, result);
                    return result;
                }
            }
            if (result != null && (result = Utils.checkCompatibility(this.typeDescriptor.getTypeRegistry(), result, this.theField.getDescriptor())) == null) {
                typeLevelValues.remove(this.theField.getName());
            }
            result = Utils.toResultCheckIfNull(result, this.theField.getDescriptor());
        } else {
            try {
                Field f = this.locateFieldByReflection(clazz, this.typeDescriptor.getDottedName(), this.typeDescriptor.isInterface(), this.theField.getName());
                f.setAccessible(true);
                result = f.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpectedly unable to set static field " + this.theField.getName() + " on type " + this.typeDescriptor.getDottedName());
            }
        }
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
            log.finer("<getValue() value of " + this.theField + " is " + result);
        }
        return result;
    }

    private Field locateFieldByReflection(Class<?> clazz, String typeWanted, boolean isInterface, String name) {
        Class<?> superclass;
        Class<?>[] interfaces;
        int n;
        int n2;
        AnnotatedElement[] annotatedElementArray;
        Field[] fs;
        if (clazz.getName().equals(typeWanted) && (fs = clazz.getDeclaredFields()) != null) {
            annotatedElementArray = fs;
            n2 = fs.length;
            n = 0;
            while (n < n2) {
                AnnotatedElement f = annotatedElementArray[n];
                if (((Field)f).getName().equals(name)) {
                    return f;
                }
                ++n;
            }
        }
        if (!isInterface && (interfaces = clazz.getInterfaces()) != null) {
            annotatedElementArray = interfaces;
            n2 = interfaces.length;
            n = 0;
            while (n < n2) {
                AnnotatedElement intface = annotatedElementArray[n];
                Field f = this.locateFieldByReflection((Class<?>)intface, typeWanted, isInterface, name);
                if (f != null) {
                    return f;
                }
                ++n;
            }
        }
        if ((superclass = clazz.getSuperclass()) == null) {
            return null;
        }
        return this.locateFieldByReflection(superclass, typeWanted, isInterface, name);
    }

    private ISMgr findInstanceStateManager(Object instance) {
        Class<?> clazz = this.typeDescriptor.getReloadableType().getClazz();
        try {
            Field fieldAccessorField = clazz.getField("r$fields");
            if (fieldAccessorField == null) {
                throw new IllegalStateException("Cant find field accessor for type " + clazz.getName());
            }
            ISMgr stateManager = (ISMgr)fieldAccessorField.get(instance);
            if (stateManager == null) {
                throw new IllegalStateException("The class '" + clazz.getName() + "' has a null instance state manager object, instance is " + instance);
            }
            return stateManager;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpectedly unable to find instance state manager on class " + clazz.getName(), e);
        }
    }

    private SSMgr findStaticStateManager(Class<?> clazz) {
        try {
            Field stateManagerField = clazz.getField("r$sfields");
            if (stateManagerField == null) {
                throw new IllegalStateException("Cant find field accessor for type " + this.typeDescriptor.getReloadableType().getName());
            }
            SSMgr stateManager = (SSMgr)stateManagerField.get(null);
            if (stateManager == null) {
                throw new IllegalStateException("Instance of this class has no state manager: " + clazz.getName());
            }
            return stateManager;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpectedly unable to find static state manager on class " + clazz.getName(), e);
        }
    }

    public boolean isStatic() {
        return this.theField.isStatic();
    }

    private Object findAndGetFieldValueInHierarchy(Object instance) {
        Class<?> clazz = instance.getClass();
        String fieldname = this.theField.getName();
        String searchName = this.typeDescriptor.getName().replace('/', '.');
        while (clazz != null && !clazz.getName().equals(searchName)) {
            clazz = clazz.getSuperclass();
        }
        if (clazz == null) {
            throw new IllegalStateException("Failed to find " + searchName + " in hierarchy of " + instance.getClass());
        }
        try {
            Field f = clazz.getDeclaredField(fieldname);
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpectedly could not access field named " + fieldname + " on class " + clazz.getName());
        }
    }

    private void findAndSetFieldValueInHierarchy(Object instance, Object newValue) {
        Class<?> clazz = instance.getClass();
        String fieldname = this.theField.getName();
        String searchName = this.typeDescriptor.getName().replace('/', '.');
        while (clazz != null && !clazz.getName().equals(searchName)) {
            clazz = clazz.getSuperclass();
        }
        if (clazz == null) {
            throw new IllegalStateException("Failed to find " + searchName + " in hierarchy of " + instance.getClass());
        }
        try {
            Field f = clazz.getDeclaredField(fieldname);
            f.setAccessible(true);
            f.set(instance, newValue);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpectedly could not access field named " + fieldname + " on class " + clazz.getName());
        }
    }
}

