/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

public class CachingMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private volatile int cacheLimit = 256;
    private final Map<Resource, MetadataReader> classReaderCache = new LinkedHashMap<Resource, MetadataReader>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Resource, MetadataReader> eldest) {
            return this.size() > CachingMetadataReaderFactory.this.getCacheLimit();
        }
    };

    public CachingMetadataReaderFactory() {
    }

    public CachingMetadataReaderFactory(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public CachingMetadataReaderFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        if (this.getCacheLimit() <= 0) {
            return super.getMetadataReader(resource);
        }
        Map<Resource, MetadataReader> map = this.classReaderCache;
        synchronized (map) {
            MetadataReader metadataReader = this.classReaderCache.get(resource);
            if (metadataReader == null) {
                metadataReader = super.getMetadataReader(resource);
                this.classReaderCache.put(resource, metadataReader);
            }
            return metadataReader;
        }
    }
}

