/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.io.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.io.support.Resource;

public abstract class AbstractFileResolvingResource
implements Resource {
    public File getFile() throws IOException {
        URL url = this.getURL();
        return GrailsResourceUtils.getFile(url, this.getDescription());
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        URL url = this.getURL();
        if (GrailsResourceUtils.isJarURL(url)) {
            URL actualUrl = GrailsResourceUtils.extractJarFileURL(url);
            return GrailsResourceUtils.getFile(actualUrl, "Jar URL");
        }
        return this.getFile();
    }

    protected File getFile(URI uri) throws IOException {
        return GrailsResourceUtils.getFile(uri, this.getDescription());
    }

    private static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getName().startsWith("JNLP"));
    }

    public boolean exists() {
        try {
            HttpURLConnection httpCon;
            URL url = this.getURL();
            if (GrailsResourceUtils.isFileURL(url)) {
                return this.getFile().exists();
            }
            URLConnection con = url.openConnection();
            AbstractFileResolvingResource.useCachesIfNecessary(con);
            HttpURLConnection httpURLConnection = httpCon = con instanceof HttpURLConnection ? (HttpURLConnection)con : null;
            if (httpCon != null) {
                httpCon.setRequestMethod("HEAD");
                int code = httpCon.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code == 404) {
                    return false;
                }
            }
            if (con.getContentLength() >= 0) {
                return true;
            }
            if (httpCon != null) {
                httpCon.disconnect();
                return false;
            }
            InputStream is = this.getInputStream();
            is.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean isReadable() {
        try {
            URL url = this.getURL();
            if (GrailsResourceUtils.isFileURL(url)) {
                File file = this.getFile();
                return file.canRead() && !file.isDirectory();
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public long contentLength() throws IOException {
        URL url = this.getURL();
        if (GrailsResourceUtils.isFileURL(url)) {
            return this.getFile().length();
        }
        URLConnection con = url.openConnection();
        AbstractFileResolvingResource.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getContentLength();
    }

    public long lastModified() throws IOException {
        URL url = this.getURL();
        if (GrailsResourceUtils.isFileURL(url) || GrailsResourceUtils.isJarURL(url)) {
            return this.getFile().lastModified();
        }
        URLConnection con = url.openConnection();
        AbstractFileResolvingResource.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getLastModified();
    }
}

