/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.method.InvalidMethodKeyException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MethodKey
implements Serializable {
    private Class declaredType;
    private String methodName;
    private Class[] parameterTypes;
    private transient Method method;
    private static final Map primitiveWrapperTypeMap = new HashMap(8);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveWrapperTypeMap.put(clazz, Boolean.TYPE);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveWrapperTypeMap.put(clazz2, Byte.TYPE);
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveWrapperTypeMap.put(clazz3, Character.TYPE);
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveWrapperTypeMap.put(clazz4, Double.TYPE);
        Class<?> clazz5 = class$8;
        if (clazz5 == null) {
            try {
                clazz5 = class$8 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveWrapperTypeMap.put(clazz5, Float.TYPE);
        Class<?> clazz6 = class$10;
        if (clazz6 == null) {
            try {
                clazz6 = class$10 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveWrapperTypeMap.put(clazz6, Integer.TYPE);
        Class<?> clazz7 = class$12;
        if (clazz7 == null) {
            try {
                clazz7 = class$12 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveWrapperTypeMap.put(clazz7, Long.TYPE);
        Class<?> clazz8 = class$14;
        if (clazz8 == null) {
            try {
                clazz8 = class$14 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveWrapperTypeMap.put(clazz8, Short.TYPE);
    }

    public MethodKey(Class declaredType, String methodName, Class[] parameterTypes) {
        Assert.notNull((Object)declaredType, (String)"The method's declared type is required");
        Assert.notNull((Object)methodName, (String)"The method name is required");
        this.declaredType = declaredType;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public Class getDeclaredType() {
        return this.declaredType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Method getMethod() throws InvalidMethodKeyException {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected Method resolveMethod() throws InvalidMethodKeyException {
        try {
            return this.declaredType.getMethod(this.methodName, this.parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Method method = this.findMethodConsiderAssignableParameterTypes();
            if (method != null) {
                return method;
            }
            throw new InvalidMethodKeyException(this, e);
        }
    }

    protected Method findMethodConsiderAssignableParameterTypes() {
        Method[] candidateMethods = this.getDeclaredType().getMethods();
        int i = 0;
        while (i < candidateMethods.length) {
            Class<?>[] candidateParameterTypes;
            if (candidateMethods[i].getName().equals(this.methodName) && (candidateParameterTypes = candidateMethods[i].getParameterTypes()).length == this.parameterTypes.length) {
                int numberOfCorrectArguments = 0;
                int j = 0;
                while (j < candidateParameterTypes.length) {
                    Class<?> candidateType = candidateParameterTypes[j];
                    Class parameterType = this.parameterTypes[j];
                    if (parameterType != null) {
                        if (MethodKey.isAssignable(candidateType, parameterType)) {
                            ++numberOfCorrectArguments;
                        }
                    } else {
                        ++numberOfCorrectArguments;
                    }
                    ++j;
                }
                if (numberOfCorrectArguments == this.parameterTypes.length) {
                    return candidateMethods[i];
                }
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey other = (MethodKey)obj;
        return this.declaredType.equals(other.declaredType) && this.methodName.equals(other.methodName) && this.parameterTypesEqual(other.parameterTypes);
    }

    private boolean parameterTypesEqual(Class[] other) {
        if (this.parameterTypes == other) {
            return true;
        }
        if (this.parameterTypes.length != other.length) {
            return false;
        }
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (!ObjectUtils.nullSafeEquals((Object)this.parameterTypes[i], (Object)other[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.declaredType.hashCode() + this.methodName.hashCode() + this.parameterTypesHash();
    }

    private int parameterTypesHash() {
        if (this.parameterTypes == null) {
            return 0;
        }
        int hash = 0;
        int i = 0;
        while (i < this.parameterTypes.length) {
            Class parameterType = this.parameterTypes[i];
            if (parameterType != null) {
                hash += this.parameterTypes[i].hashCode();
            }
            ++i;
        }
        return hash;
    }

    public String toString() {
        return String.valueOf(this.methodName) + "(" + this.parameterTypesString() + ")";
    }

    private String parameterTypesString() {
        StringBuffer parameterTypesString = new StringBuffer();
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (this.parameterTypes[i] == null) {
                parameterTypesString.append("<any>");
            } else {
                parameterTypesString.append(ClassUtils.getShortName((Class)this.parameterTypes[i]));
            }
            if (i < this.parameterTypes.length - 1) {
                parameterTypesString.append(',');
            }
            ++i;
        }
        return parameterTypesString.toString();
    }

    private static boolean isAssignable(Class targetType, Class valueType) {
        return targetType.isAssignableFrom(valueType) || targetType.equals(primitiveWrapperTypeMap.get(valueType));
    }
}

