/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.context.BaseInitialRenderContext;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.Filter;
import org.radeox.filter.context.FilterContext;

public class FilterPipe {
    private static Log log = LogFactory.getLog(FilterPipe.class);
    public static final String FIRST_IN_PIPE = "all";
    public static final String LAST_IN_PIPE = "none";
    public static final String[] EMPTY_BEFORE = new String[0];
    public static final String[] NO_REPLACES = new String[0];
    public static final String[] FIRST_BEFORE = new String[]{"all"};
    private InitialRenderContext initialContext;
    private List activeFilters = new ArrayList();
    private Set inactiveFilters = new HashSet();

    public FilterPipe() {
        this(new BaseInitialRenderContext());
    }

    public FilterPipe(InitialRenderContext context) {
        this.initialContext = context;
    }

    public void init() {
        for (Filter filter : new ArrayList(this.activeFilters)) {
            String[] replaces = filter.replaces();
            for (int i = 0; i < replaces.length; ++i) {
                String replace = replaces[i];
                this.removeFilter(replace);
            }
        }
    }

    public void removeFilter(String filterClass) {
        Iterator iterator = this.activeFilters.iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            if (!filter.getClass().getName().equals(filterClass)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateFilter(String name) {
        Set set = this.inactiveFilters;
        synchronized (set) {
            for (Filter filter : this.inactiveFilters) {
                if (!filter.getClass().getName().startsWith(name)) continue;
                this.inactiveFilters.remove(filter);
            }
        }
    }

    public void deactivateFilter(String name) {
        for (Filter filter : this.activeFilters) {
            if (!filter.getClass().getName().startsWith(name)) continue;
            this.inactiveFilters.add(filter);
        }
    }

    public List getAllFilters() {
        return new ArrayList(this.activeFilters);
    }

    public List getInactiveFilters() {
        return new ArrayList(this.inactiveFilters);
    }

    public void addFilter(Filter filter) {
        filter.setInitialContext(this.initialContext);
        int minIndex = Integer.MAX_VALUE;
        String[] before = filter.before();
        for (int i = 0; i < before.length; ++i) {
            String s = before[i];
            int index = FilterPipe.index(this.activeFilters, s);
            if (index >= minIndex) continue;
            minIndex = index;
        }
        if (minIndex == Integer.MAX_VALUE) {
            minIndex = -1;
        }
        if (FilterPipe.contains(filter.before(), FIRST_IN_PIPE)) {
            this.activeFilters.add(0, filter);
        } else if (minIndex != -1) {
            this.activeFilters.add(minIndex, filter);
        } else {
            this.activeFilters.add(filter);
        }
    }

    public int index(String filterName) {
        return FilterPipe.index(this.activeFilters, filterName);
    }

    public static int index(List list, String filterName) {
        for (int i = 0; i < list.size(); ++i) {
            if (!filterName.equals(list.get(i).getClass().getName())) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object value) {
        return Arrays.binarySearch(array, value) != -1;
    }

    public String filter(String input, FilterContext context) {
        String output = input;
        Iterator filterIterator = this.activeFilters.iterator();
        RenderContext renderContext = context.getRenderContext();
        while (filterIterator.hasNext()) {
            Filter f = (Filter)filterIterator.next();
            if (this.inactiveFilters.contains(f)) continue;
            try {
                if (f instanceof CacheFilter) {
                    renderContext.setCacheable(true);
                } else {
                    renderContext.setCacheable(false);
                }
                String tmp = f.filter(output, context);
                if (output.equals(tmp)) {
                    renderContext.setCacheable(true);
                }
                if (null == tmp) {
                    log.warn((Object)("FilterPipe.filter: error while filtering: " + f));
                } else {
                    output = tmp;
                }
                renderContext.commitCache();
            }
            catch (Exception e) {
                log.warn((Object)("Filtering exception: " + f), (Throwable)e);
            }
        }
        return output;
    }

    public Filter getFilter(int index) {
        return (Filter)this.activeFilters.get(index);
    }
}

