/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import grails.persistence.Entity;
import java.util.Arrays;
import java.util.HashSet;
import org.codehaus.groovy.grails.commons.DefaultGrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.ConfigurableLocalSessionFactoryBean;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTransactionManager;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GORMEnhancingBeanPostProcessor;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsAnnotationConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.support.SpringLobHandlerDetectorFactoryBean;
import org.codehaus.groovy.grails.orm.hibernate.validation.HibernateDomainClassValidator;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GORMSessionFactoryDefinitionParser
implements BeanDefinitionParser {
    private static final String ID_ATTRIBUTE = "id";
    private static final String DATA_SOURCE_ATTRIBUTE = "data-source-ref";
    private static final String MESSAGE_SOURCE_ATTRIBUTE = "message-source-ref";
    private static final String LOB_HANDLER_ATTRIBUTE = "lob-handler-ref";
    private static final String BASE_PACKAGE_ATTRIBUTE = "base-package";
    private static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager-ref";
    private static final String CONFIG_CLASS_ATTRIBUTE = "config-class";
    private static final String CONFIG_LOCATION_ATTRIBUTE = "config-location";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        XmlReaderContext readerContext = parserContext.getReaderContext();
        ClassLoader beanClassLoader = readerContext.getBeanClassLoader() != null ? readerContext.getBeanClassLoader() : Thread.currentThread().getContextClassLoader();
        String[] basePackages = StringUtils.commaDelimitedListToStringArray((String)element.getAttribute(BASE_PACKAGE_ATTRIBUTE));
        String dataSourceId = element.getAttribute(DATA_SOURCE_ATTRIBUTE);
        if (!StringUtils.hasText((String)dataSourceId)) {
            throw new BeanDefinitionParsingException(new Problem("Attribute [data-source-ref] of tag <gorm:sessionFactory> must be specified!", new Location(readerContext.getResource())));
        }
        BeanDefinitionRegistry targetRegistry = parserContext.getRegistry();
        this.parseGrailsApplication(element, parserContext, readerContext, beanClassLoader, basePackages);
        GenericBeanDefinition postProccessingBeanDef = new GenericBeanDefinition();
        postProccessingBeanDef.setBeanClass(GORMEnhancingBeanPostProcessor.class);
        targetRegistry.registerBeanDefinition("gormEnhancingPostProcessor", (BeanDefinition)postProccessingBeanDef);
        return this.parseSessionFactory(element, dataSourceId, targetRegistry, parserContext);
    }

    private void parseGrailsApplication(Element element, ParserContext parserContext, XmlReaderContext readerContext, ClassLoader beanClassLoader, String[] basePackages) {
        SimpleBeanDefinitionRegistry simpleRegistry = new SimpleBeanDefinitionRegistry();
        ClassPathBeanDefinitionScanner scanner = this.configureScanner(parserContext, (BeanDefinitionRegistry)simpleRegistry);
        scanner.scan(basePackages);
        BeanDefinitionRegistry targetRegistry = parserContext.getRegistry();
        GenericBeanDefinition grailsApplicationBean = new GenericBeanDefinition();
        grailsApplicationBean.setBeanClass(DefaultGrailsApplication.class);
        grailsApplicationBean.setInitMethodName("initialise");
        ConstructorArgumentValues constructorArgs = grailsApplicationBean.getConstructorArgumentValues();
        HashSet classes = new HashSet();
        for (String beanName : simpleRegistry.getBeanDefinitionNames()) {
            BeanDefinition beanDef = simpleRegistry.getBeanDefinition(beanName);
            try {
                Class<?> entityClass = Class.forName(beanDef.getBeanClassName(), true, beanClassLoader);
                classes.add(entityClass);
                this.registerDomainBean(entityClass, targetRegistry, element.getAttribute(MESSAGE_SOURCE_ATTRIBUTE));
            }
            catch (ClassNotFoundException e) {
                throw new BeanDefinitionParsingException(new Problem("Unable to load class whilst configuring GORM: " + e.getMessage(), new Location(readerContext.getResource()), null, (Throwable)e));
            }
        }
        constructorArgs.addGenericArgumentValue((Object)classes.toArray(new Class[classes.size()]));
        constructorArgs.addGenericArgumentValue((Object)beanClassLoader);
        targetRegistry.registerBeanDefinition("grailsApplication", (BeanDefinition)grailsApplicationBean);
    }

    private void registerDomainBean(Class<?> entityClass, BeanDefinitionRegistry targetRegistry, String messageSourceRef) {
        GenericBeanDefinition beanDef = new GenericBeanDefinition();
        beanDef.setBeanClass(entityClass);
        beanDef.setScope("prototype");
        RootBeanDefinition domainDef = new RootBeanDefinition(MethodInvokingFactoryBean.class);
        domainDef.getPropertyValues().addPropertyValue("targetObject", (Object)new RuntimeBeanReference("grailsApplication"));
        domainDef.getPropertyValues().addPropertyValue("targetMethod", (Object)"getArtefact");
        domainDef.getPropertyValues().addPropertyValue("arguments", Arrays.asList("Domain", entityClass.getName()));
        String domainRef = entityClass.getName() + "Domain";
        if (StringUtils.hasText((String)messageSourceRef)) {
            GenericBeanDefinition validatorDef = new GenericBeanDefinition();
            validatorDef.setBeanClass(HibernateDomainClassValidator.class);
            validatorDef.getPropertyValues().addPropertyValue("messageSource", (Object)new RuntimeBeanReference(messageSourceRef));
            validatorDef.getPropertyValues().addPropertyValue("domainClass", (Object)new RuntimeBeanReference(domainRef));
            validatorDef.getPropertyValues().addPropertyValue("sessionFactory", (Object)new RuntimeBeanReference("sessionFactory"));
            targetRegistry.registerBeanDefinition(entityClass.getName() + "Validator", (BeanDefinition)validatorDef);
        }
        targetRegistry.registerBeanDefinition(entityClass.getName(), (BeanDefinition)beanDef);
        targetRegistry.registerBeanDefinition(domainRef, (BeanDefinition)domainDef);
    }

    private AbstractBeanDefinition parseSessionFactory(Element element, String dataSourceId, BeanDefinitionRegistry targetRegistry, ParserContext parserContext) {
        String sessionFactoryId = StringUtils.hasText((String)element.getAttribute(ID_ATTRIBUTE)) ? element.getAttribute(ID_ATTRIBUTE) : "sessionFactory";
        GenericBeanDefinition sessionFactoryBean = new GenericBeanDefinition();
        sessionFactoryBean.setBeanClass(ConfigurableLocalSessionFactoryBean.class);
        MutablePropertyValues propertyValues = sessionFactoryBean.getPropertyValues();
        RuntimeBeanReference dataSourceRef = new RuntimeBeanReference(dataSourceId);
        propertyValues.addPropertyValue("dataSource", (Object)dataSourceRef);
        Class<?> configClass = this.lookupConfigClass(element, parserContext);
        propertyValues.addPropertyValue("configClass", configClass);
        String configLocation = element.getAttribute(CONFIG_LOCATION_ATTRIBUTE);
        if (StringUtils.hasText((String)configLocation)) {
            propertyValues.addPropertyValue("configLocation", (Object)configLocation);
        }
        propertyValues.addPropertyValue("grailsApplication", (Object)new RuntimeBeanReference("grailsApplication"));
        targetRegistry.registerBeanDefinition(sessionFactoryId, (BeanDefinition)sessionFactoryBean);
        String lobHandlerRef = element.getAttribute(LOB_HANDLER_ATTRIBUTE);
        if (StringUtils.hasText((String)lobHandlerRef)) {
            propertyValues.addPropertyValue("lobHandler", (Object)new RuntimeBeanReference(lobHandlerRef));
        } else {
            GenericBeanDefinition lobHandler = new GenericBeanDefinition();
            lobHandler.setBeanClass(SpringLobHandlerDetectorFactoryBean.class);
            lobHandler.getPropertyValues().addPropertyValue("pooledConnection", (Object)true);
            lobHandler.getPropertyValues().addPropertyValue("dataSource", (Object)dataSourceRef);
            propertyValues.addPropertyValue("lobHandler", (Object)lobHandler);
        }
        String transactionManagerRef = element.getAttribute(TRANSACTION_MANAGER_ATTRIBUTE);
        if (StringUtils.hasText((String)transactionManagerRef)) {
            targetRegistry.registerAlias(transactionManagerRef, "transactionManager");
        } else {
            GenericBeanDefinition transactionManagerBean = new GenericBeanDefinition();
            transactionManagerBean.setBeanClass(GrailsHibernateTransactionManager.class);
            transactionManagerBean.getPropertyValues().addPropertyValue("sessionFactory", (Object)new RuntimeBeanReference(sessionFactoryId));
            targetRegistry.registerBeanDefinition("transactionManager", (BeanDefinition)transactionManagerBean);
        }
        parserContext.getDelegate().parsePropertyElements(element, (BeanDefinition)sessionFactoryBean);
        return sessionFactoryBean;
    }

    private Class<?> lookupConfigClass(Element element, ParserContext parserContext) {
        Class configClass = GrailsAnnotationConfiguration.class;
        ClassLoader classLoader = parserContext.getReaderContext().getBeanClassLoader();
        String configClassName = element.getAttribute(CONFIG_CLASS_ATTRIBUTE);
        if (StringUtils.hasText((String)configClassName)) {
            try {
                configClass = classLoader.loadClass(configClassName);
            }
            catch (ClassNotFoundException e) {
                throw new BeanDefinitionParsingException(new Problem("Unable to load specified SessionFactory configClass implementation: " + e.getMessage(), new Location(parserContext.getReaderContext().getResource()), null, (Throwable)e));
            }
        }
        return configClass;
    }

    private ClassPathBeanDefinitionScanner configureScanner(ParserContext parserContext, BeanDefinitionRegistry registry) {
        XmlReaderContext readerContext = parserContext.getReaderContext();
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry, false);
        scanner.setIncludeAnnotationConfig(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        scanner.setResourceLoader(readerContext.getResourceLoader());
        scanner.setBeanDefinitionDefaults(parserContext.getDelegate().getBeanDefinitionDefaults());
        scanner.setAutowireCandidatePatterns(parserContext.getDelegate().getAutowireCandidatePatterns());
        return scanner;
    }
}

