/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.naming.resources.DirContextURLStreamHandler;

public class DirContextURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static DirContextURLStreamHandlerFactory instance = new DirContextURLStreamHandlerFactory();
    private List<URLStreamHandlerFactory> userFactories = new CopyOnWriteArrayList<URLStreamHandlerFactory>();

    public static DirContextURLStreamHandlerFactory getInstance() {
        return instance;
    }

    public static void addUserFactory(URLStreamHandlerFactory factory) {
        DirContextURLStreamHandlerFactory.instance.userFactories.add(factory);
    }

    private DirContextURLStreamHandlerFactory() {
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol.equals("jndi")) {
            return new DirContextURLStreamHandler();
        }
        for (URLStreamHandlerFactory factory : this.userFactories) {
            URLStreamHandler handler = factory.createURLStreamHandler(protocol);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }
}

