/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import org.springframework.util.ObjectUtils;
import org.springframework.webflow.engine.model.AbstractMappingModel;
import org.springframework.webflow.engine.model.Model;

public class OutputModel
extends AbstractMappingModel {
    public OutputModel(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof OutputModel)) {
            return false;
        }
        OutputModel output = (OutputModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getName(), (Object)output.getName());
    }

    public void merge(Model model) {
        OutputModel output = (OutputModel)model;
        this.setValue(this.merge(this.getValue(), output.getValue()));
        this.setType(this.merge(this.getType(), output.getType()));
        this.setRequired(this.merge(this.getRequired(), output.getRequired()));
    }

    public Model createCopy() {
        OutputModel copy = new OutputModel(this.getName(), this.getValue());
        super.fillCopy(copy);
        return copy;
    }
}

