/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.core.JdkVersion;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.action.ResultEventFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ResultObjectBasedEventFactory
extends EventFactorySupport
implements ResultEventFactory {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public Event createResultEvent(Object source, Object resultObject, RequestContext context) {
        if (resultObject == null) {
            return this.event(source, this.getNullEventId());
        }
        if (this.isBoolean(resultObject.getClass())) {
            return this.event(source, (Boolean)resultObject);
        }
        if (this.isLabeledEnum(resultObject.getClass())) {
            String resultId = ((LabeledEnum)resultObject).getLabel();
            return this.event(source, resultId, this.getResultAttributeName(), resultObject);
        }
        if (this.isJdk5Enum(resultObject.getClass())) {
            String eventId = EnumUtils.getEnumName(resultObject);
            return this.event(source, eventId, this.getResultAttributeName(), resultObject);
        }
        if (this.isString(resultObject.getClass())) {
            String resultString = (String)resultObject;
            if (StringUtils.hasText((String)resultString)) {
                return this.event(source, resultString);
            }
            return this.event(source, this.getNullEventId());
        }
        if (this.isEvent(resultObject.getClass())) {
            return (Event)resultObject;
        }
        throw new IllegalArgumentException("Cannot deal with result object '" + resultObject + "' of type '" + resultObject.getClass() + "'");
    }

    public boolean isMappedValueType(Class type) {
        return this.isBoolean(type) || this.isLabeledEnum(type) || this.isJdk5Enum(type) || this.isString(type) || this.isEvent(type);
    }

    private boolean isBoolean(Class type) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.equals(type) || Boolean.TYPE.equals(type);
    }

    private boolean isLabeledEnum(Class type) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.springframework.core.enums.LabeledEnum");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.isAssignableFrom(type);
    }

    private boolean isJdk5Enum(Class type) {
        if (JdkVersion.getMajorJavaVersion() >= 2) {
            return EnumUtils.isEnum(type);
        }
        return false;
    }

    private boolean isString(Class type) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.equals(type);
    }

    private boolean isEvent(Class type) {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.springframework.webflow.execution.Event");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.isAssignableFrom(type);
    }

    private static class EnumUtils {
        private EnumUtils() {
        }

        public static String getEnumName(Object enumValue) {
            return ((Enum)enumValue).name();
        }

        public static boolean isEnum(Class type) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Enum");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.isAssignableFrom(type);
        }
    }
}

