/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.springframework.uaa.client.ProxyService;
import org.springframework.uaa.client.TransmissionService;
import org.springframework.uaa.client.util.Assert;
import org.springframework.uaa.client.util.PreferencesUtils;
import org.springframework.uaa.client.util.StreamUtils;

public class JdkUrlTransmissionServiceImpl
implements TransmissionService {
    static final String BUCKET_NAME_KEY = "bucket_name";
    static final String PATH_NAME_KEY = "path_name";
    static final String POLICY_KEY = "policy";
    static final String SIGNATURE_KEY = "signature";
    static final String ACCESS_KEY = "aws_access_key";
    private ProxyService proxyService;
    private static final Preferences P = PreferencesUtils.getPreferencesFor(JdkUrlTransmissionServiceImpl.class);

    public JdkUrlTransmissionServiceImpl(ProxyService proxyService) {
        Assert.notNull(proxyService, "Proxy service required");
        this.proxyService = proxyService;
    }

    public InputStream download(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL to download required");
        }
        return this.proxyService.prepareHttpUrlConnection(url).getInputStream();
    }

    public boolean upload(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream to transmit required");
        }
        String boundary = "------------" + UUID.randomUUID().toString();
        URL uaaUrl = new URL(P.get(BUCKET_NAME_KEY, "http://uaa.springsource.org/"));
        HttpURLConnection connection = this.proxyService.prepareHttpUrlConnection(uaaUrl);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        OutputStream output = connection.getOutputStream();
        PrintWriter writer = new PrintWriter(output, true);
        this.append("key", P.get(PATH_NAME_KEY, "uploads/") + UUID.randomUUID().toString(), boundary, writer);
        this.append("acl", "private", boundary, writer);
        this.append("AWSAccessKeyId", P.get(ACCESS_KEY, "0SCA5K7NAW330XGHMT02"), boundary, writer);
        this.append(POLICY_KEY, P.get(POLICY_KEY, "ewogICJleHBpcmF0aW9uIjogIjIwMTktMTItMzFUMTI6MDA6MDAuMDAwWiIsCiAgImNvbmRpdGlvbnMiOiBbCiAgICB7ImJ1Y2tldCI6ICJ1YWEuc3ByaW5nc291cmNlLm9yZyIgfSwKICAgIHsiYWNsIjogInByaXZhdGUiIH0sCiAgICBbInN0YXJ0cy13aXRoIiwgIiRrZXkiLCAidXBsb2Fkcy8iXSwKICAgIFsiY29udGVudC1sZW5ndGgtcmFuZ2UiLCAxLCAxMDQ4NTc2XQogIF0KfQo="), boundary, writer);
        this.append(SIGNATURE_KEY, P.get(SIGNATURE_KEY, "ZuVAJZxCiBzErDB2Jm4n/WvEpSE="), boundary, writer);
        this.println(writer, "--" + boundary);
        this.println(writer, "Content-Disposition: form-data; name=\"file\"; filename=\"not_important\"");
        this.println(writer, "Content-Type: application/octet-stream");
        this.println(writer, "");
        StreamUtils.copy(inputStream, output);
        this.println(writer, "");
        this.println(writer, "--" + boundary + "--");
        output.flush();
        this.close(inputStream, writer, output);
        return connection.getResponseCode() == 204;
    }

    private void append(String key, String value, String boundary, PrintWriter writer) {
        this.println(writer, "--" + boundary);
        this.println(writer, "Content-Disposition: form-data; name=\"" + key + "\"");
        this.println(writer, "");
        this.println(writer, value);
    }

    private void close(Closeable ... objs) {
        for (Closeable closeable : objs) {
            try {
                closeable.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    private void println(PrintWriter writer, String line) {
        if (!"".equals(line)) {
            writer.print(line);
        }
        writer.print("\r\n");
        writer.flush();
    }
}

