/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.config;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.config.groovy.MappingConfigurationBuilder;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGormMappingFactory<R, T>
extends MappingFactory<R, T> {
    protected Map<PersistentEntity, Map<String, T>> entityToPropertyMap = new HashMap<PersistentEntity, Map<String, T>>();

    @Override
    public R createMappedForm(PersistentEntity entity) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(entity.getJavaClass());
        Object family = BeanUtils.instantiate(this.getEntityMappedFormType());
        MappingConfigurationBuilder builder = new MappingConfigurationBuilder(family, this.getPropertyMappedFormType());
        Closure value = cpf.getStaticPropertyValue("mapping", Closure.class);
        if (value != null) {
            builder.evaluate(value);
        }
        if ((value = cpf.getStaticPropertyValue("constraints", Closure.class)) != null) {
            builder.evaluate(value);
        }
        this.entityToPropertyMap.put(entity, builder.getProperties());
        return (R)family;
    }

    protected abstract Class<T> getPropertyMappedFormType();

    protected abstract Class<R> getEntityMappedFormType();

    @Override
    public IdentityMapping createIdentityMapping(ClassMapping classMapping) {
        T property;
        IdentityMapping customIdentityMapping;
        Map<String, T> props = this.entityToPropertyMap.get(classMapping.getEntity());
        if (props != null && (customIdentityMapping = this.getIdentityMappedForm(classMapping, property = props.get("id"))) != null) {
            return customIdentityMapping;
        }
        return super.createIdentityMapping(classMapping);
    }

    protected IdentityMapping getIdentityMappedForm(ClassMapping classMapping, T property) {
        return null;
    }

    @Override
    public T createMappedForm(PersistentProperty mpp) {
        Property property;
        Map<String, T> properties = this.entityToPropertyMap.get(mpp.getOwner());
        if (properties != null && properties.containsKey(mpp.getName())) {
            return properties.get(mpp.getName());
        }
        if (properties != null && (property = (Property)properties.get("id")) != null && mpp.getName().equals(property.getName())) {
            return (T)property;
        }
        return (T)BeanUtils.instantiate(this.getPropertyMappedFormType());
    }
}

