
#include "videobroadcast.h"

#define kVIDBRC_ID_PROPERTY_WIDTH	                   	0
#define kVIDBRC_ID_PROPERTY_HEIGHT	                  	1
#define kVIDBRC_ID_PROPERTY_FULLSCREEN					2
#define kVIDBRC_ID_PROPERTY_ONCHANNELCHANGEERROR		3
#define kVIDBRC_ID_PROPERTY_PLAYSTATE					4
#define kVIDBRC_ID_PROPERTY_ONPLAYSTATECHANGE			5
#define kVIDBRC_ID_PROPERTY_ONCHANNELCHANGESUCCEEDED	6
#define kVIDBRC_ID_PROPERTY_ONFULLSCREENCHANGE			7
#define kVIDBRC_ID_PROPERTY_ONFOCUS						8
#define kVIDBRC_ID_PROPERTY_ONBLUR						9
#define kVIDBRC_NUM_PROPERTY_IDENTIFIERS                10

#define kVIDBRC_ID_METHOD_GETCHANNELCONFIG              0
#define kVIDBRC_ID_METHOD_BINDTOCURRENTCHANNEL          1
#define kVIDBRC_ID_METHOD_CREATECHANNELOBJECT			2
#define kVIDBRC_ID_METHOD_CREATECHANNELOBJECT2   	    3
#define kVIDBRC_ID_METHOD_SETCHANNEL              		4
#define kVIDBRC_ID_METHOD_PREVCHANNEL					5
#define kVIDBRC_ID_METHOD_NEXTCHANNEL					6
#define kVIDBRC_ID_METHOD_SETFULLSCREEN					7
#define kVIDBRC_ID_METHOD_GETVOLUME						8
#define kVIDBRC_ID_METHOD_RELEASE						9
#define kVIDBRC_NUM_METHOD_IDENTIFIERS					10


bool            v_bVIDBRCIdentifiersInitialized = false;

NPIdentifier    v_VIDBRCPropertyIdentifiers[kVIDBRC_NUM_PROPERTY_IDENTIFIERS];
const NPUTF8 *  v_VIDBRCPropertyNames[kVIDBRC_NUM_PROPERTY_IDENTIFIERS] = {
	"width",
	"height",
	"fullScreen",
	"onChannelChangeError",
	"playState",
	"onPlayStateChange",
	"onchannelChangeSuceeded",
	"onFullScreenChange",
	"onFocus",
	"onBlur"
	};

NPIdentifier    v_VIDBRCMethodIdentifiers[kVIDBRC_NUM_METHOD_IDENTIFIERS];
const NPUTF8 *  v_VIDBRCMethodNames[kVIDBRC_NUM_METHOD_IDENTIFIERS] = {
	"getChannelConfig",
	"bindToCurrentChannel",
	"createChannelObject",
	"createChannelObject2",
	"setChannel",
	"prevChannel",
	"nextChannel",
	"setFullScreen",
	"getVolume",
	"release"
};

static  void    VIDBRCinitializeIdentifiers(void)
{
    sBrowserFuncs->getstringidentifiers( v_VIDBRCPropertyNames, kVIDBRC_NUM_PROPERTY_IDENTIFIERS, v_VIDBRCPropertyIdentifiers );
    sBrowserFuncs->getstringidentifiers( v_VIDBRCMethodNames,   kVIDBRC_NUM_METHOD_IDENTIFIERS,   v_VIDBRCMethodIdentifiers );
}

NPClass  stVIDBRCclass;
NPClass* pVIDBRCclass = NULL;

NPClass* fillVIDBRCpclass(void)
{
    TRACEINFO;
    if (pVIDBRCclass == NULL)
    {
        stVIDBRCclass.allocate          = VIDBRC_Allocate;
        stVIDBRCclass.deallocate        = VIDBRC_Deallocate;
        stVIDBRCclass.invalidate        = VIDBRC_Invalidate;
        stVIDBRCclass.hasMethod         = VIDBRC_HasMethod;
        stVIDBRCclass.invoke            = VIDBRC_Invoke;
        stVIDBRCclass.invokeDefault     = VIDBRC_InvokeDefault;
        stVIDBRCclass.hasProperty       = VIDBRC_HasProperty;
        stVIDBRCclass.getProperty       = VIDBRC_GetProperty;
        stVIDBRCclass.setProperty       = VIDBRC_SetProperty;
        stVIDBRCclass.removeProperty    = VIDBRC_RemoveProperty;
        stVIDBRCclass.enumerate         = VIDBRC_Enumerate;
        pVIDBRCclass = &stVIDBRCclass;
    }

    return pVIDBRCclass;
}


NPObject *          VIDBRC_Allocate(NPP npp, NPClass *theClass)
{
    TRACEINFO;

    NPObject* newvidbrc = NULL;
    if (!v_bVIDBRCIdentifiersInitialized)
    {
        v_bVIDBRCIdentifiersInitialized = true;
        VIDBRCinitializeIdentifiers();
    }

    newvidbrc = malloc(sizeof(NPObject));
    return newvidbrc;
}

  void        VIDBRC_Deallocate(NPObject* obj)
{
    TRACEINFO;
    OnVIDBRC_SetFullScreen(true);
    free(obj);
    return;
}

  void        VIDBRC_Invalidate(NPObject* obj)
{
    TRACEINFO;
    return;
}

  bool        VIDBRC_HasMethod(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;

    bool result = false;
    int i = 0;
    NPUTF8* utf8methodname = (char*)sBrowserFuncs->utf8fromidentifier(name);
    while ((i < kVIDBRC_NUM_METHOD_IDENTIFIERS) && (result == false))
    {
        if ( name == v_VIDBRCMethodIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }
	printf("\tVIDBRC has method \"%s\" : %s \n", utf8methodname, booltostr(result));

    return result;
}

bool        VIDBRC_Invoke(NPObject* obj, NPIdentifier name, const NPVariant* args, uint32_t argCount, NPVariant* result)
{
    TRACEINFO;
	bool fctresult = false;

    if (name == v_VIDBRCMethodIdentifiers[kVIDBRC_ID_METHOD_SETFULLSCREEN])
    {
    	VIDBRC_Invoke_setFullScreen(obj, args, argCount);
    	fctresult = true;
    }

    if (name == v_VIDBRCMethodIdentifiers[kVIDBRC_ID_METHOD_BINDTOCURRENTCHANNEL])
    {
    	VIDBRC_Invoke_bindToCurrentChannel(obj, args, argCount);
    	fctresult = true;
    }
    return fctresult;
}

 bool        VIDBRC_InvokeDefault(NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result)
{
    TRACEINFO;
    return true;
}

  bool        VIDBRC_HasProperty(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;
    bool result = false;
    NPUTF8* utf8propertyname = (char*)sBrowserFuncs->utf8fromidentifier(name);

    int i = 0;
    while ((i < kVIDBRC_NUM_PROPERTY_IDENTIFIERS) && (result == false))
    {
        if ( name == v_VIDBRCPropertyIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }

    printf("\tVIDBRC has property \"%s\" : %s \n", utf8propertyname, booltostr(result));
    return result;
}

 bool        VIDBRC_GetProperty(NPObject* obj, NPIdentifier name, NPVariant* result)
{
    TRACEINFO;

    return true;
}

  bool        VIDBRC_SetProperty(NPObject *obj, NPIdentifier name, const NPVariant *value)
{
    TRACEINFO;
    return true;
}

 bool        VIDBRC_RemoveProperty(NPObject *npobj, NPIdentifier name)
{
    TRACEINFO;
    return true;
}


 bool        VIDBRC_Enumerate(NPObject *npobj, NPIdentifier **value, uint32_t *count)
{
    TRACEINFO;
    return true;
}

/** implementation of methods **/

void		VIDBRC_Invoke_setFullScreen(NPObject* obj,const NPVariant* args, uint32_t argCount)
{
	TRACEINFO;
	NOTIMPLEMENTED; ///inprogress
	int param;
	if (argCount != 1 || !NPVARIANT_IS_BOOLEAN(args[0]))
    {
		return;
    }
    else
    {
		param = NPVARIANT_TO_BOOLEAN( args[0] );
		OnVIDBRC_SetFullScreen(param);
    }
}

void		VIDBRC_Invoke_bindToCurrentChannel(NPObject* obj,const NPVariant* args, uint32_t argCount)
{
	TRACEINFO;
	//OnBindToCurrentChannel();
}
