"""Generated client library for faulttesting version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.faulttesting.v1alpha import faulttesting_v1alpha_messages as messages


class FaulttestingV1alpha(base_api.BaseApiClient):
  """Generated client library for service faulttesting version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://faulttesting.googleapis.com/'
  MTLS_BASE_URL = 'https://faulttesting.mtls.googleapis.com/'

  _PACKAGE = 'faulttesting'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'FaulttestingV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new faulttesting handle."""
    url = url or self.BASE_URL
    super(FaulttestingV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_experimentTemplates = self.ProjectsLocationsExperimentTemplatesService(self)
    self.projects_locations_experiments_affectedResources = self.ProjectsLocationsExperimentsAffectedResourcesService(self)
    self.projects_locations_experiments = self.ProjectsLocationsExperimentsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_validations_validationResources = self.ProjectsLocationsValidationsValidationResourcesService(self)
    self.projects_locations_validations = self.ProjectsLocationsValidationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsExperimentTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_experimentTemplates resource."""

    _NAME = 'projects_locations_experimentTemplates'

    def __init__(self, client):
      super(FaulttestingV1alpha.ProjectsLocationsExperimentTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""CreateExperimentTemplate creates a new experiment template.

      Args:
        request: (FaulttestingProjectsLocationsExperimentTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExperimentTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experimentTemplates',
        http_method='POST',
        method_id='faulttesting.projects.locations.experimentTemplates.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['experimentTemplateId'],
        relative_path='v1alpha/{+parent}/experimentTemplates',
        request_field='experimentTemplate',
        request_type_name='FaulttestingProjectsLocationsExperimentTemplatesCreateRequest',
        response_type_name='ExperimentTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""DeleteExperimentTemplate deletes an experiment template.

      Args:
        request: (FaulttestingProjectsLocationsExperimentTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experimentTemplates/{experimentTemplatesId}',
        http_method='DELETE',
        method_id='faulttesting.projects.locations.experimentTemplates.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsExperimentTemplatesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""GetExperimentTemplate gets an experiment template.

      Args:
        request: (FaulttestingProjectsLocationsExperimentTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExperimentTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experimentTemplates/{experimentTemplatesId}',
        http_method='GET',
        method_id='faulttesting.projects.locations.experimentTemplates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsExperimentTemplatesGetRequest',
        response_type_name='ExperimentTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""ListExperimentTemplates lists all experiment templates in a project.

      Args:
        request: (FaulttestingProjectsLocationsExperimentTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExperimentTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experimentTemplates',
        http_method='GET',
        method_id='faulttesting.projects.locations.experimentTemplates.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/experimentTemplates',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsExperimentTemplatesListRequest',
        response_type_name='ListExperimentTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""UpdateExperimentTemplate updates an experiment template.

      Args:
        request: (FaulttestingProjectsLocationsExperimentTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExperimentTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experimentTemplates/{experimentTemplatesId}',
        http_method='PATCH',
        method_id='faulttesting.projects.locations.experimentTemplates.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='experimentTemplate',
        request_type_name='FaulttestingProjectsLocationsExperimentTemplatesPatchRequest',
        response_type_name='ExperimentTemplate',
        supports_download=False,
    )

  class ProjectsLocationsExperimentsAffectedResourcesService(base_api.BaseApiService):
    """Service class for the projects_locations_experiments_affectedResources resource."""

    _NAME = 'projects_locations_experiments_affectedResources'

    def __init__(self, client):
      super(FaulttestingV1alpha.ProjectsLocationsExperimentsAffectedResourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get the details of an affected resource.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsAffectedResourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AffectedResource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments/{experimentsId}/affectedResources/{affectedResourcesId}',
        http_method='GET',
        method_id='faulttesting.projects.locations.experiments.affectedResources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsExperimentsAffectedResourcesGetRequest',
        response_type_name='AffectedResource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all the affected resources for a given experiment.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsAffectedResourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAffectedResourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments/{experimentsId}/affectedResources',
        http_method='GET',
        method_id='faulttesting.projects.locations.experiments.affectedResources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/affectedResources',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsExperimentsAffectedResourcesListRequest',
        response_type_name='ListAffectedResourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsExperimentsService(base_api.BaseApiService):
    """Service class for the projects_locations_experiments resource."""

    _NAME = 'projects_locations_experiments'

    def __init__(self, client):
      super(FaulttestingV1alpha.ProjectsLocationsExperimentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""CreateExperiment creates a new experiment. If experiment.experiment_template is specified, a regular experiment is created. If experiment.action is specified, a template-validation experiment is created. Either way, the initial state will be PREPARING. If it's a regular Experiment, when the system is finished preparing it, the state will change to PREPARED, after which it can be started. If it's a template validation Experiment, the state will go directly from PREPARING to COMPLETED.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Experiment) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments',
        http_method='POST',
        method_id='faulttesting.projects.locations.experiments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['experimentId'],
        relative_path='v1alpha/{+parent}/experiments',
        request_field='experiment',
        request_type_name='FaulttestingProjectsLocationsExperimentsCreateRequest',
        response_type_name='Experiment',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""DeleteExperiment deletes an experiment. Running experiments must be stopped first.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments/{experimentsId}',
        http_method='DELETE',
        method_id='faulttesting.projects.locations.experiments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsExperimentsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""GetExperiment gets an experiment.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Experiment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments/{experimentsId}',
        http_method='GET',
        method_id='faulttesting.projects.locations.experiments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsExperimentsGetRequest',
        response_type_name='Experiment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""ListExperiments lists all experiments in a project.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExperimentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments',
        http_method='GET',
        method_id='faulttesting.projects.locations.experiments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/experiments',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsExperimentsListRequest',
        response_type_name='ListExperimentsResponse',
        supports_download=False,
    )

    def Start(self, request, global_params=None):
      r"""StartExperiment starts an existing experiment. The experiment must already be in the PREPARED state. On return, the new state will be INJECTING. When injection is complete, the state becomes INJECTED.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsStartRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Experiment) The response message.
      """
      config = self.GetMethodConfig('Start')
      return self._RunMethod(
          config, request, global_params=global_params)

    Start.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments/{experimentsId}:start',
        http_method='POST',
        method_id='faulttesting.projects.locations.experiments.start',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:start',
        request_field='startExperimentRequest',
        request_type_name='FaulttestingProjectsLocationsExperimentsStartRequest',
        response_type_name='Experiment',
        supports_download=False,
    )

    def Stop(self, request, global_params=None):
      r"""StopExperiment stops a running experiment. On return, the new state will be REVERTING. Once the revert process completes it will become COMPLETED.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsStopRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Experiment) The response message.
      """
      config = self.GetMethodConfig('Stop')
      return self._RunMethod(
          config, request, global_params=global_params)

    Stop.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments/{experimentsId}:stop',
        http_method='POST',
        method_id='faulttesting.projects.locations.experiments.stop',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:stop',
        request_field='stopExperimentRequest',
        request_type_name='FaulttestingProjectsLocationsExperimentsStopRequest',
        response_type_name='Experiment',
        supports_download=False,
    )

    def StopAll(self, request, global_params=None):
      r"""StopAllExperiments stops all running experiments for a given project and location. On return, the process of stopping all experiments will have begun, but may not be completed. Call ListExperiments with filter="state!=COMPLETED" to check the progress. Returns an RPC error if it can't list experiments at all. Otherwise, it lists and stops all experiments it can, and returns a response including success count and a list of errors. If there are no experiments to stop, it returns successfully with an empty response message.

      Args:
        request: (FaulttestingProjectsLocationsExperimentsStopAllRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StopAllExperimentsResponse) The response message.
      """
      config = self.GetMethodConfig('StopAll')
      return self._RunMethod(
          config, request, global_params=global_params)

    StopAll.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/experiments:stopAll',
        http_method='POST',
        method_id='faulttesting.projects.locations.experiments.stopAll',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha/{+parent}/experiments:stopAll',
        request_field='stopAllExperimentsRequest',
        request_type_name='FaulttestingProjectsLocationsExperimentsStopAllRequest',
        response_type_name='StopAllExperimentsResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(FaulttestingV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (FaulttestingProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='faulttesting.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='FaulttestingProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (FaulttestingProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='faulttesting.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (FaulttestingProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='faulttesting.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (FaulttestingProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='faulttesting.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1alpha/{+name}/operations',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsValidationsValidationResourcesService(base_api.BaseApiService):
    """Service class for the projects_locations_validations_validationResources resource."""

    _NAME = 'projects_locations_validations_validationResources'

    def __init__(self, client):
      super(FaulttestingV1alpha.ProjectsLocationsValidationsValidationResourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get the details of a ValidationResource.

      Args:
        request: (FaulttestingProjectsLocationsValidationsValidationResourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ValidationResource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/validations/{validationsId}/validationResources/{validationResourcesId}',
        http_method='GET',
        method_id='faulttesting.projects.locations.validations.validationResources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsValidationsValidationResourcesGetRequest',
        response_type_name='ValidationResource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all the validation resources for a given Validation.

      Args:
        request: (FaulttestingProjectsLocationsValidationsValidationResourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListValidationResourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/validations/{validationsId}/validationResources',
        http_method='GET',
        method_id='faulttesting.projects.locations.validations.validationResources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/validationResources',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsValidationsValidationResourcesListRequest',
        response_type_name='ListValidationResourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsValidationsService(base_api.BaseApiService):
    """Service class for the projects_locations_validations resource."""

    _NAME = 'projects_locations_validations'

    def __init__(self, client):
      super(FaulttestingV1alpha.ProjectsLocationsValidationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""CreateValidation creates a new template validation. The initial state will be PREPARING. When finished, it will change to COMPLETED.

      Args:
        request: (FaulttestingProjectsLocationsValidationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Validation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/validations',
        http_method='POST',
        method_id='faulttesting.projects.locations.validations.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['validationId'],
        relative_path='v1alpha/{+parent}/validations',
        request_field='validation',
        request_type_name='FaulttestingProjectsLocationsValidationsCreateRequest',
        response_type_name='Validation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""DeleteValidation deletes a Validation.

      Args:
        request: (FaulttestingProjectsLocationsValidationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/validations/{validationsId}',
        http_method='DELETE',
        method_id='faulttesting.projects.locations.validations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsValidationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""GetValidation gets a Validation.

      Args:
        request: (FaulttestingProjectsLocationsValidationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Validation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/validations/{validationsId}',
        http_method='GET',
        method_id='faulttesting.projects.locations.validations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsValidationsGetRequest',
        response_type_name='Validation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""ListValidations lists all Validations in a project.

      Args:
        request: (FaulttestingProjectsLocationsValidationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListValidationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/validations',
        http_method='GET',
        method_id='faulttesting.projects.locations.validations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/validations',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsValidationsListRequest',
        response_type_name='ListValidationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(FaulttestingV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (FaulttestingProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='faulttesting.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (FaulttestingProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='faulttesting.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='FaulttestingProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(FaulttestingV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
