"""Generated client library for dlp version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.dlp.v2 import dlp_v2_messages as messages


class DlpV2(base_api.BaseApiClient):
  """Generated client library for service dlp version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://dlp.googleapis.com/'

  _PACKAGE = u'dlp'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'DlpV2'
  _URL_VERSION = u'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new dlp handle."""
    url = url or self.BASE_URL
    super(DlpV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.infoTypes = self.InfoTypesService(self)
    self.locations_infoTypes = self.LocationsInfoTypesService(self)
    self.locations = self.LocationsService(self)
    self.organizations_deidentifyTemplates = self.OrganizationsDeidentifyTemplatesService(self)
    self.organizations_inspectTemplates = self.OrganizationsInspectTemplatesService(self)
    self.organizations_locations_deidentifyTemplates = self.OrganizationsLocationsDeidentifyTemplatesService(self)
    self.organizations_locations_inspectTemplates = self.OrganizationsLocationsInspectTemplatesService(self)
    self.organizations_locations_storedInfoTypes = self.OrganizationsLocationsStoredInfoTypesService(self)
    self.organizations_locations = self.OrganizationsLocationsService(self)
    self.organizations_storedInfoTypes = self.OrganizationsStoredInfoTypesService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_content = self.ProjectsContentService(self)
    self.projects_deidentifyTemplates = self.ProjectsDeidentifyTemplatesService(self)
    self.projects_dlpJobs = self.ProjectsDlpJobsService(self)
    self.projects_image = self.ProjectsImageService(self)
    self.projects_inspectTemplates = self.ProjectsInspectTemplatesService(self)
    self.projects_jobTriggers = self.ProjectsJobTriggersService(self)
    self.projects_locations_content = self.ProjectsLocationsContentService(self)
    self.projects_locations_deidentifyTemplates = self.ProjectsLocationsDeidentifyTemplatesService(self)
    self.projects_locations_dlpJobs = self.ProjectsLocationsDlpJobsService(self)
    self.projects_locations_image = self.ProjectsLocationsImageService(self)
    self.projects_locations_inspectTemplates = self.ProjectsLocationsInspectTemplatesService(self)
    self.projects_locations_jobTriggers = self.ProjectsLocationsJobTriggersService(self)
    self.projects_locations_storedInfoTypes = self.ProjectsLocationsStoredInfoTypesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects_storedInfoTypes = self.ProjectsStoredInfoTypesService(self)
    self.projects = self.ProjectsService(self)

  class InfoTypesService(base_api.BaseApiService):
    """Service class for the infoTypes resource."""

    _NAME = u'infoTypes'

    def __init__(self, client):
      super(DlpV2.InfoTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns a list of the sensitive information types that the DLP API.
supports. See https://cloud.google.com/dlp/docs/infotypes-reference to
learn more.

      Args:
        request: (DlpInfoTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListInfoTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'dlp.infoTypes.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'filter', u'languageCode', u'locationId'],
        relative_path=u'v2/infoTypes',
        request_field='',
        request_type_name=u'DlpInfoTypesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListInfoTypesResponse',
        supports_download=False,
    )

  class LocationsInfoTypesService(base_api.BaseApiService):
    """Service class for the locations_infoTypes resource."""

    _NAME = u'locations_infoTypes'

    def __init__(self, client):
      super(DlpV2.LocationsInfoTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns a list of the sensitive information types that the DLP API.
supports. See https://cloud.google.com/dlp/docs/infotypes-reference to
learn more.

      Args:
        request: (DlpLocationsInfoTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListInfoTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'dlp.locations.infoTypes.list',
        ordered_params=[u'locationId'],
        path_params=[u'locationId'],
        query_params=[u'filter', u'languageCode'],
        relative_path=u'v2/locations/{locationId}/infoTypes',
        request_field='',
        request_type_name=u'DlpLocationsInfoTypesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListInfoTypesResponse',
        supports_download=False,
    )

  class LocationsService(base_api.BaseApiService):
    """Service class for the locations resource."""

    _NAME = u'locations'

    def __init__(self, client):
      super(DlpV2.LocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsDeidentifyTemplatesService(base_api.BaseApiService):
    """Service class for the organizations_deidentifyTemplates resource."""

    _NAME = u'organizations_deidentifyTemplates'

    def __init__(self, client):
      super(DlpV2.OrganizationsDeidentifyTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a DeidentifyTemplate for re-using frequently used configuration.
for de-identifying content, images, and storage.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsDeidentifyTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/deidentifyTemplates',
        http_method=u'POST',
        method_id=u'dlp.organizations.deidentifyTemplates.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/deidentifyTemplates',
        request_field=u'googlePrivacyDlpV2CreateDeidentifyTemplateRequest',
        request_type_name=u'DlpOrganizationsDeidentifyTemplatesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsDeidentifyTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'DELETE',
        method_id=u'dlp.organizations.deidentifyTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsDeidentifyTemplatesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsDeidentifyTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'GET',
        method_id=u'dlp.organizations.deidentifyTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsDeidentifyTemplatesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DeidentifyTemplates.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsDeidentifyTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListDeidentifyTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/deidentifyTemplates',
        http_method=u'GET',
        method_id=u'dlp.organizations.deidentifyTemplates.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'locationId', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/deidentifyTemplates',
        request_field='',
        request_type_name=u'DlpOrganizationsDeidentifyTemplatesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListDeidentifyTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsDeidentifyTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'PATCH',
        method_id=u'dlp.organizations.deidentifyTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateDeidentifyTemplateRequest',
        request_type_name=u'DlpOrganizationsDeidentifyTemplatesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

  class OrganizationsInspectTemplatesService(base_api.BaseApiService):
    """Service class for the organizations_inspectTemplates resource."""

    _NAME = u'organizations_inspectTemplates'

    def __init__(self, client):
      super(DlpV2.OrganizationsInspectTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an InspectTemplate for re-using frequently used configuration.
for inspecting content, images, and storage.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsInspectTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/inspectTemplates',
        http_method=u'POST',
        method_id=u'dlp.organizations.inspectTemplates.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/inspectTemplates',
        request_field=u'googlePrivacyDlpV2CreateInspectTemplateRequest',
        request_type_name=u'DlpOrganizationsInspectTemplatesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsInspectTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'DELETE',
        method_id=u'dlp.organizations.inspectTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsInspectTemplatesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsInspectTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'GET',
        method_id=u'dlp.organizations.inspectTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsInspectTemplatesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists InspectTemplates.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsInspectTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListInspectTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/inspectTemplates',
        http_method=u'GET',
        method_id=u'dlp.organizations.inspectTemplates.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'locationId', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/inspectTemplates',
        request_field='',
        request_type_name=u'DlpOrganizationsInspectTemplatesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListInspectTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsInspectTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'PATCH',
        method_id=u'dlp.organizations.inspectTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateInspectTemplateRequest',
        request_type_name=u'DlpOrganizationsInspectTemplatesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

  class OrganizationsLocationsDeidentifyTemplatesService(base_api.BaseApiService):
    """Service class for the organizations_locations_deidentifyTemplates resource."""

    _NAME = u'organizations_locations_deidentifyTemplates'

    def __init__(self, client):
      super(DlpV2.OrganizationsLocationsDeidentifyTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a DeidentifyTemplate for re-using frequently used configuration.
for de-identifying content, images, and storage.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsLocationsDeidentifyTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationId}/deidentifyTemplates',
        http_method=u'POST',
        method_id=u'dlp.organizations.locations.deidentifyTemplates.create',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/deidentifyTemplates',
        request_field=u'googlePrivacyDlpV2CreateDeidentifyTemplateRequest',
        request_type_name=u'DlpOrganizationsLocationsDeidentifyTemplatesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsLocationsDeidentifyTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'DELETE',
        method_id=u'dlp.organizations.locations.deidentifyTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsDeidentifyTemplatesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsLocationsDeidentifyTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'GET',
        method_id=u'dlp.organizations.locations.deidentifyTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsDeidentifyTemplatesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DeidentifyTemplates.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsLocationsDeidentifyTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListDeidentifyTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationId}/deidentifyTemplates',
        http_method=u'GET',
        method_id=u'dlp.organizations.locations.deidentifyTemplates.list',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/locations/{locationId}/deidentifyTemplates',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsDeidentifyTemplatesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListDeidentifyTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpOrganizationsLocationsDeidentifyTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'PATCH',
        method_id=u'dlp.organizations.locations.deidentifyTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateDeidentifyTemplateRequest',
        request_type_name=u'DlpOrganizationsLocationsDeidentifyTemplatesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

  class OrganizationsLocationsInspectTemplatesService(base_api.BaseApiService):
    """Service class for the organizations_locations_inspectTemplates resource."""

    _NAME = u'organizations_locations_inspectTemplates'

    def __init__(self, client):
      super(DlpV2.OrganizationsLocationsInspectTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an InspectTemplate for re-using frequently used configuration.
for inspecting content, images, and storage.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsLocationsInspectTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationId}/inspectTemplates',
        http_method=u'POST',
        method_id=u'dlp.organizations.locations.inspectTemplates.create',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/inspectTemplates',
        request_field=u'googlePrivacyDlpV2CreateInspectTemplateRequest',
        request_type_name=u'DlpOrganizationsLocationsInspectTemplatesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsLocationsInspectTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'DELETE',
        method_id=u'dlp.organizations.locations.inspectTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsInspectTemplatesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsLocationsInspectTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'GET',
        method_id=u'dlp.organizations.locations.inspectTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsInspectTemplatesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists InspectTemplates.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsLocationsInspectTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListInspectTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationId}/inspectTemplates',
        http_method=u'GET',
        method_id=u'dlp.organizations.locations.inspectTemplates.list',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/locations/{locationId}/inspectTemplates',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsInspectTemplatesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListInspectTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpOrganizationsLocationsInspectTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'PATCH',
        method_id=u'dlp.organizations.locations.inspectTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateInspectTemplateRequest',
        request_type_name=u'DlpOrganizationsLocationsInspectTemplatesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

  class OrganizationsLocationsStoredInfoTypesService(base_api.BaseApiService):
    """Service class for the organizations_locations_storedInfoTypes resource."""

    _NAME = u'organizations_locations_storedInfoTypes'

    def __init__(self, client):
      super(DlpV2.OrganizationsLocationsStoredInfoTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a pre-built stored infoType to be used for inspection.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsLocationsStoredInfoTypesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationId}/storedInfoTypes',
        http_method=u'POST',
        method_id=u'dlp.organizations.locations.storedInfoTypes.create',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/storedInfoTypes',
        request_field=u'googlePrivacyDlpV2CreateStoredInfoTypeRequest',
        request_type_name=u'DlpOrganizationsLocationsStoredInfoTypesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a stored infoType.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsLocationsStoredInfoTypesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'DELETE',
        method_id=u'dlp.organizations.locations.storedInfoTypes.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsStoredInfoTypesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a stored infoType.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsLocationsStoredInfoTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'GET',
        method_id=u'dlp.organizations.locations.storedInfoTypes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsStoredInfoTypesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists stored infoTypes.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsLocationsStoredInfoTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListStoredInfoTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationId}/storedInfoTypes',
        http_method=u'GET',
        method_id=u'dlp.organizations.locations.storedInfoTypes.list',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/locations/{locationId}/storedInfoTypes',
        request_field='',
        request_type_name=u'DlpOrganizationsLocationsStoredInfoTypesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListStoredInfoTypesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the stored infoType by creating a new version. The existing version.
will continue to be used until the new version is ready.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsLocationsStoredInfoTypesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'PATCH',
        method_id=u'dlp.organizations.locations.storedInfoTypes.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateStoredInfoTypeRequest',
        request_type_name=u'DlpOrganizationsLocationsStoredInfoTypesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

  class OrganizationsLocationsService(base_api.BaseApiService):
    """Service class for the organizations_locations resource."""

    _NAME = u'organizations_locations'

    def __init__(self, client):
      super(DlpV2.OrganizationsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsStoredInfoTypesService(base_api.BaseApiService):
    """Service class for the organizations_storedInfoTypes resource."""

    _NAME = u'organizations_storedInfoTypes'

    def __init__(self, client):
      super(DlpV2.OrganizationsStoredInfoTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a pre-built stored infoType to be used for inspection.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsStoredInfoTypesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/storedInfoTypes',
        http_method=u'POST',
        method_id=u'dlp.organizations.storedInfoTypes.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/storedInfoTypes',
        request_field=u'googlePrivacyDlpV2CreateStoredInfoTypeRequest',
        request_type_name=u'DlpOrganizationsStoredInfoTypesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a stored infoType.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsStoredInfoTypesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'DELETE',
        method_id=u'dlp.organizations.storedInfoTypes.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsStoredInfoTypesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a stored infoType.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsStoredInfoTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'GET',
        method_id=u'dlp.organizations.storedInfoTypes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpOrganizationsStoredInfoTypesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists stored infoTypes.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsStoredInfoTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListStoredInfoTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/storedInfoTypes',
        http_method=u'GET',
        method_id=u'dlp.organizations.storedInfoTypes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'locationId', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/storedInfoTypes',
        request_field='',
        request_type_name=u'DlpOrganizationsStoredInfoTypesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListStoredInfoTypesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the stored infoType by creating a new version. The existing version.
will continue to be used until the new version is ready.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpOrganizationsStoredInfoTypesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'PATCH',
        method_id=u'dlp.organizations.storedInfoTypes.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateStoredInfoTypeRequest',
        request_type_name=u'DlpOrganizationsStoredInfoTypesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = u'organizations'

    def __init__(self, client):
      super(DlpV2.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsContentService(base_api.BaseApiService):
    """Service class for the projects_content resource."""

    _NAME = u'projects_content'

    def __init__(self, client):
      super(DlpV2.ProjectsContentService, self).__init__(client)
      self._upload_configs = {
          }

    def Deidentify(self, request, global_params=None):
      r"""De-identifies potentially sensitive info from a ContentItem.
This method has limits on input size and output size.
See https://cloud.google.com/dlp/docs/deidentify-sensitive-data to
learn more.

When no InfoTypes or CustomInfoTypes are specified in this request, the
system will automatically choose what detectors to run. By default this may
be all types, but may change over time as detectors are updated.

      Args:
        request: (DlpProjectsContentDeidentifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyContentResponse) The response message.
      """
      config = self.GetMethodConfig('Deidentify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deidentify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/content:deidentify',
        http_method=u'POST',
        method_id=u'dlp.projects.content.deidentify',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/content:deidentify',
        request_field=u'googlePrivacyDlpV2DeidentifyContentRequest',
        request_type_name=u'DlpProjectsContentDeidentifyRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyContentResponse',
        supports_download=False,
    )

    def Inspect(self, request, global_params=None):
      r"""Finds potentially sensitive info in content.
This method has limits on input size, processing time, and output size.

When no InfoTypes or CustomInfoTypes are specified in this request, the
system will automatically choose what detectors to run. By default this may
be all types, but may change over time as detectors are updated.

For how to guides, see https://cloud.google.com/dlp/docs/inspecting-images
and https://cloud.google.com/dlp/docs/inspecting-text,

      Args:
        request: (DlpProjectsContentInspectRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectContentResponse) The response message.
      """
      config = self.GetMethodConfig('Inspect')
      return self._RunMethod(
          config, request, global_params=global_params)

    Inspect.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/content:inspect',
        http_method=u'POST',
        method_id=u'dlp.projects.content.inspect',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/content:inspect',
        request_field=u'googlePrivacyDlpV2InspectContentRequest',
        request_type_name=u'DlpProjectsContentInspectRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectContentResponse',
        supports_download=False,
    )

    def Reidentify(self, request, global_params=None):
      r"""Re-identifies content that has been de-identified.
See
https://cloud.google.com/dlp/docs/pseudonymization#re-identification_in_free_text_code_example
to learn more.

      Args:
        request: (DlpProjectsContentReidentifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ReidentifyContentResponse) The response message.
      """
      config = self.GetMethodConfig('Reidentify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Reidentify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/content:reidentify',
        http_method=u'POST',
        method_id=u'dlp.projects.content.reidentify',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/content:reidentify',
        request_field=u'googlePrivacyDlpV2ReidentifyContentRequest',
        request_type_name=u'DlpProjectsContentReidentifyRequest',
        response_type_name=u'GooglePrivacyDlpV2ReidentifyContentResponse',
        supports_download=False,
    )

  class ProjectsDeidentifyTemplatesService(base_api.BaseApiService):
    """Service class for the projects_deidentifyTemplates resource."""

    _NAME = u'projects_deidentifyTemplates'

    def __init__(self, client):
      super(DlpV2.ProjectsDeidentifyTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a DeidentifyTemplate for re-using frequently used configuration.
for de-identifying content, images, and storage.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsDeidentifyTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/deidentifyTemplates',
        http_method=u'POST',
        method_id=u'dlp.projects.deidentifyTemplates.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/deidentifyTemplates',
        request_field=u'googlePrivacyDlpV2CreateDeidentifyTemplateRequest',
        request_type_name=u'DlpProjectsDeidentifyTemplatesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsDeidentifyTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.deidentifyTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsDeidentifyTemplatesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsDeidentifyTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'GET',
        method_id=u'dlp.projects.deidentifyTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsDeidentifyTemplatesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DeidentifyTemplates.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsDeidentifyTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListDeidentifyTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/deidentifyTemplates',
        http_method=u'GET',
        method_id=u'dlp.projects.deidentifyTemplates.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'locationId', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/deidentifyTemplates',
        request_field='',
        request_type_name=u'DlpProjectsDeidentifyTemplatesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListDeidentifyTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsDeidentifyTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'PATCH',
        method_id=u'dlp.projects.deidentifyTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateDeidentifyTemplateRequest',
        request_type_name=u'DlpProjectsDeidentifyTemplatesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

  class ProjectsDlpJobsService(base_api.BaseApiService):
    """Service class for the projects_dlpJobs resource."""

    _NAME = u'projects_dlpJobs'

    def __init__(self, client):
      super(DlpV2.ProjectsDlpJobsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running DlpJob. The server.
makes a best effort to cancel the DlpJob, but success is not
guaranteed.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

      Args:
        request: (DlpProjectsDlpJobsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/dlpJobs/{dlpJobsId}:cancel',
        http_method=u'POST',
        method_id=u'dlp.projects.dlpJobs.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:cancel',
        request_field=u'googlePrivacyDlpV2CancelDlpJobRequest',
        request_type_name=u'DlpProjectsDlpJobsCancelRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new job to inspect storage or calculate risk metrics.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
system will automatically choose what detectors to run. By default this may
be all types, but may change over time as detectors are updated.

      Args:
        request: (DlpProjectsDlpJobsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DlpJob) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/dlpJobs',
        http_method=u'POST',
        method_id=u'dlp.projects.dlpJobs.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/dlpJobs',
        request_field=u'googlePrivacyDlpV2CreateDlpJobRequest',
        request_type_name=u'DlpProjectsDlpJobsCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2DlpJob',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running DlpJob. This method indicates that the client is.
no longer interested in the DlpJob result. The job will be cancelled if
possible.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

      Args:
        request: (DlpProjectsDlpJobsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/dlpJobs/{dlpJobsId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.dlpJobs.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsDlpJobsDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running DlpJob.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

      Args:
        request: (DlpProjectsDlpJobsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DlpJob) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/dlpJobs/{dlpJobsId}',
        http_method=u'GET',
        method_id=u'dlp.projects.dlpJobs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsDlpJobsGetRequest',
        response_type_name=u'GooglePrivacyDlpV2DlpJob',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DlpJobs that match the specified filter in the request.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

      Args:
        request: (DlpProjectsDlpJobsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListDlpJobsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/dlpJobs',
        http_method=u'GET',
        method_id=u'dlp.projects.dlpJobs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'locationId', u'orderBy', u'pageSize', u'pageToken', u'type'],
        relative_path=u'v2/{+parent}/dlpJobs',
        request_field='',
        request_type_name=u'DlpProjectsDlpJobsListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListDlpJobsResponse',
        supports_download=False,
    )

  class ProjectsImageService(base_api.BaseApiService):
    """Service class for the projects_image resource."""

    _NAME = u'projects_image'

    def __init__(self, client):
      super(DlpV2.ProjectsImageService, self).__init__(client)
      self._upload_configs = {
          }

    def Redact(self, request, global_params=None):
      r"""Redacts potentially sensitive info from an image.
This method has limits on input size, processing time, and output size.
See https://cloud.google.com/dlp/docs/redacting-sensitive-data-images to
learn more.

When no InfoTypes or CustomInfoTypes are specified in this request, the
system will automatically choose what detectors to run. By default this may
be all types, but may change over time as detectors are updated.

      Args:
        request: (DlpProjectsImageRedactRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2RedactImageResponse) The response message.
      """
      config = self.GetMethodConfig('Redact')
      return self._RunMethod(
          config, request, global_params=global_params)

    Redact.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/image:redact',
        http_method=u'POST',
        method_id=u'dlp.projects.image.redact',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/image:redact',
        request_field=u'googlePrivacyDlpV2RedactImageRequest',
        request_type_name=u'DlpProjectsImageRedactRequest',
        response_type_name=u'GooglePrivacyDlpV2RedactImageResponse',
        supports_download=False,
    )

  class ProjectsInspectTemplatesService(base_api.BaseApiService):
    """Service class for the projects_inspectTemplates resource."""

    _NAME = u'projects_inspectTemplates'

    def __init__(self, client):
      super(DlpV2.ProjectsInspectTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an InspectTemplate for re-using frequently used configuration.
for inspecting content, images, and storage.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsInspectTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/inspectTemplates',
        http_method=u'POST',
        method_id=u'dlp.projects.inspectTemplates.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/inspectTemplates',
        request_field=u'googlePrivacyDlpV2CreateInspectTemplateRequest',
        request_type_name=u'DlpProjectsInspectTemplatesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsInspectTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.inspectTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsInspectTemplatesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsInspectTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'GET',
        method_id=u'dlp.projects.inspectTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsInspectTemplatesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists InspectTemplates.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsInspectTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListInspectTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/inspectTemplates',
        http_method=u'GET',
        method_id=u'dlp.projects.inspectTemplates.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'locationId', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/inspectTemplates',
        request_field='',
        request_type_name=u'DlpProjectsInspectTemplatesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListInspectTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsInspectTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'PATCH',
        method_id=u'dlp.projects.inspectTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateInspectTemplateRequest',
        request_type_name=u'DlpProjectsInspectTemplatesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

  class ProjectsJobTriggersService(base_api.BaseApiService):
    """Service class for the projects_jobTriggers resource."""

    _NAME = u'projects_jobTriggers'

    def __init__(self, client):
      super(DlpV2.ProjectsJobTriggersService, self).__init__(client)
      self._upload_configs = {
          }

    def Activate(self, request, global_params=None):
      r"""Activate a job trigger. Causes the immediate execute of a trigger.
instead of waiting on the trigger event to occur.

      Args:
        request: (DlpProjectsJobTriggersActivateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DlpJob) The response message.
      """
      config = self.GetMethodConfig('Activate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Activate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/jobTriggers/{jobTriggersId}:activate',
        http_method=u'POST',
        method_id=u'dlp.projects.jobTriggers.activate',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:activate',
        request_field=u'googlePrivacyDlpV2ActivateJobTriggerRequest',
        request_type_name=u'DlpProjectsJobTriggersActivateRequest',
        response_type_name=u'GooglePrivacyDlpV2DlpJob',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a job trigger to run DLP actions such as scanning storage for.
sensitive information on a set schedule.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsJobTriggersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2JobTrigger) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/jobTriggers',
        http_method=u'POST',
        method_id=u'dlp.projects.jobTriggers.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/jobTriggers',
        request_field=u'googlePrivacyDlpV2CreateJobTriggerRequest',
        request_type_name=u'DlpProjectsJobTriggersCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2JobTrigger',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a job trigger.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsJobTriggersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/jobTriggers/{jobTriggersId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.jobTriggers.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsJobTriggersDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a job trigger.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsJobTriggersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2JobTrigger) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/jobTriggers/{jobTriggersId}',
        http_method=u'GET',
        method_id=u'dlp.projects.jobTriggers.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsJobTriggersGetRequest',
        response_type_name=u'GooglePrivacyDlpV2JobTrigger',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists job triggers.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsJobTriggersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListJobTriggersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/jobTriggers',
        http_method=u'GET',
        method_id=u'dlp.projects.jobTriggers.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'locationId', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/jobTriggers',
        request_field='',
        request_type_name=u'DlpProjectsJobTriggersListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListJobTriggersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a job trigger.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsJobTriggersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2JobTrigger) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/jobTriggers/{jobTriggersId}',
        http_method=u'PATCH',
        method_id=u'dlp.projects.jobTriggers.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateJobTriggerRequest',
        request_type_name=u'DlpProjectsJobTriggersPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2JobTrigger',
        supports_download=False,
    )

  class ProjectsLocationsContentService(base_api.BaseApiService):
    """Service class for the projects_locations_content resource."""

    _NAME = u'projects_locations_content'

    def __init__(self, client):
      super(DlpV2.ProjectsLocationsContentService, self).__init__(client)
      self._upload_configs = {
          }

    def Deidentify(self, request, global_params=None):
      r"""De-identifies potentially sensitive info from a ContentItem.
This method has limits on input size and output size.
See https://cloud.google.com/dlp/docs/deidentify-sensitive-data to
learn more.

When no InfoTypes or CustomInfoTypes are specified in this request, the
system will automatically choose what detectors to run. By default this may
be all types, but may change over time as detectors are updated.

      Args:
        request: (DlpProjectsLocationsContentDeidentifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyContentResponse) The response message.
      """
      config = self.GetMethodConfig('Deidentify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deidentify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/content:deidentify',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.content.deidentify',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/content:deidentify',
        request_field=u'googlePrivacyDlpV2DeidentifyContentRequest',
        request_type_name=u'DlpProjectsLocationsContentDeidentifyRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyContentResponse',
        supports_download=False,
    )

    def Inspect(self, request, global_params=None):
      r"""Finds potentially sensitive info in content.
This method has limits on input size, processing time, and output size.

When no InfoTypes or CustomInfoTypes are specified in this request, the
system will automatically choose what detectors to run. By default this may
be all types, but may change over time as detectors are updated.

For how to guides, see https://cloud.google.com/dlp/docs/inspecting-images
and https://cloud.google.com/dlp/docs/inspecting-text,

      Args:
        request: (DlpProjectsLocationsContentInspectRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectContentResponse) The response message.
      """
      config = self.GetMethodConfig('Inspect')
      return self._RunMethod(
          config, request, global_params=global_params)

    Inspect.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/content:inspect',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.content.inspect',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/content:inspect',
        request_field=u'googlePrivacyDlpV2InspectContentRequest',
        request_type_name=u'DlpProjectsLocationsContentInspectRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectContentResponse',
        supports_download=False,
    )

    def Reidentify(self, request, global_params=None):
      r"""Re-identifies content that has been de-identified.
See
https://cloud.google.com/dlp/docs/pseudonymization#re-identification_in_free_text_code_example
to learn more.

      Args:
        request: (DlpProjectsLocationsContentReidentifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ReidentifyContentResponse) The response message.
      """
      config = self.GetMethodConfig('Reidentify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Reidentify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/content:reidentify',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.content.reidentify',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/content:reidentify',
        request_field=u'googlePrivacyDlpV2ReidentifyContentRequest',
        request_type_name=u'DlpProjectsLocationsContentReidentifyRequest',
        response_type_name=u'GooglePrivacyDlpV2ReidentifyContentResponse',
        supports_download=False,
    )

  class ProjectsLocationsDeidentifyTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_deidentifyTemplates resource."""

    _NAME = u'projects_locations_deidentifyTemplates'

    def __init__(self, client):
      super(DlpV2.ProjectsLocationsDeidentifyTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a DeidentifyTemplate for re-using frequently used configuration.
for de-identifying content, images, and storage.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsLocationsDeidentifyTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/deidentifyTemplates',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.deidentifyTemplates.create',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/deidentifyTemplates',
        request_field=u'googlePrivacyDlpV2CreateDeidentifyTemplateRequest',
        request_type_name=u'DlpProjectsLocationsDeidentifyTemplatesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsLocationsDeidentifyTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.locations.deidentifyTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsDeidentifyTemplatesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsLocationsDeidentifyTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.deidentifyTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsDeidentifyTemplatesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DeidentifyTemplates.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsLocationsDeidentifyTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListDeidentifyTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/deidentifyTemplates',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.deidentifyTemplates.list',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/locations/{locationId}/deidentifyTemplates',
        request_field='',
        request_type_name=u'DlpProjectsLocationsDeidentifyTemplatesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListDeidentifyTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the DeidentifyTemplate.
See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
more.

      Args:
        request: (DlpProjectsLocationsDeidentifyTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DeidentifyTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/deidentifyTemplates/{deidentifyTemplatesId}',
        http_method=u'PATCH',
        method_id=u'dlp.projects.locations.deidentifyTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateDeidentifyTemplateRequest',
        request_type_name=u'DlpProjectsLocationsDeidentifyTemplatesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2DeidentifyTemplate',
        supports_download=False,
    )

  class ProjectsLocationsDlpJobsService(base_api.BaseApiService):
    """Service class for the projects_locations_dlpJobs resource."""

    _NAME = u'projects_locations_dlpJobs'

    def __init__(self, client):
      super(DlpV2.ProjectsLocationsDlpJobsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running DlpJob. The server.
makes a best effort to cancel the DlpJob, but success is not
guaranteed.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

      Args:
        request: (DlpProjectsLocationsDlpJobsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/dlpJobs/{dlpJobsId}:cancel',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.dlpJobs.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:cancel',
        request_field=u'googlePrivacyDlpV2CancelDlpJobRequest',
        request_type_name=u'DlpProjectsLocationsDlpJobsCancelRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new job to inspect storage or calculate risk metrics.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
system will automatically choose what detectors to run. By default this may
be all types, but may change over time as detectors are updated.

      Args:
        request: (DlpProjectsLocationsDlpJobsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DlpJob) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/dlpJobs',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.dlpJobs.create',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/dlpJobs',
        request_field=u'googlePrivacyDlpV2CreateDlpJobRequest',
        request_type_name=u'DlpProjectsLocationsDlpJobsCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2DlpJob',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running DlpJob. This method indicates that the client is.
no longer interested in the DlpJob result. The job will be cancelled if
possible.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

      Args:
        request: (DlpProjectsLocationsDlpJobsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/dlpJobs/{dlpJobsId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.locations.dlpJobs.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsDlpJobsDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running DlpJob.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

      Args:
        request: (DlpProjectsLocationsDlpJobsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DlpJob) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/dlpJobs/{dlpJobsId}',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.dlpJobs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsDlpJobsGetRequest',
        response_type_name=u'GooglePrivacyDlpV2DlpJob',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DlpJobs that match the specified filter in the request.
See https://cloud.google.com/dlp/docs/inspecting-storage and
https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.

      Args:
        request: (DlpProjectsLocationsDlpJobsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListDlpJobsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/dlpJobs',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.dlpJobs.list',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken', u'type'],
        relative_path=u'v2/{+parent}/locations/{locationId}/dlpJobs',
        request_field='',
        request_type_name=u'DlpProjectsLocationsDlpJobsListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListDlpJobsResponse',
        supports_download=False,
    )

  class ProjectsLocationsImageService(base_api.BaseApiService):
    """Service class for the projects_locations_image resource."""

    _NAME = u'projects_locations_image'

    def __init__(self, client):
      super(DlpV2.ProjectsLocationsImageService, self).__init__(client)
      self._upload_configs = {
          }

    def Redact(self, request, global_params=None):
      r"""Redacts potentially sensitive info from an image.
This method has limits on input size, processing time, and output size.
See https://cloud.google.com/dlp/docs/redacting-sensitive-data-images to
learn more.

When no InfoTypes or CustomInfoTypes are specified in this request, the
system will automatically choose what detectors to run. By default this may
be all types, but may change over time as detectors are updated.

      Args:
        request: (DlpProjectsLocationsImageRedactRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2RedactImageResponse) The response message.
      """
      config = self.GetMethodConfig('Redact')
      return self._RunMethod(
          config, request, global_params=global_params)

    Redact.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/image:redact',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.image.redact',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/image:redact',
        request_field=u'googlePrivacyDlpV2RedactImageRequest',
        request_type_name=u'DlpProjectsLocationsImageRedactRequest',
        response_type_name=u'GooglePrivacyDlpV2RedactImageResponse',
        supports_download=False,
    )

  class ProjectsLocationsInspectTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_inspectTemplates resource."""

    _NAME = u'projects_locations_inspectTemplates'

    def __init__(self, client):
      super(DlpV2.ProjectsLocationsInspectTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an InspectTemplate for re-using frequently used configuration.
for inspecting content, images, and storage.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsLocationsInspectTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/inspectTemplates',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.inspectTemplates.create',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/inspectTemplates',
        request_field=u'googlePrivacyDlpV2CreateInspectTemplateRequest',
        request_type_name=u'DlpProjectsLocationsInspectTemplatesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsLocationsInspectTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.locations.inspectTemplates.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsInspectTemplatesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsLocationsInspectTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.inspectTemplates.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsInspectTemplatesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists InspectTemplates.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsLocationsInspectTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListInspectTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/inspectTemplates',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.inspectTemplates.list',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/locations/{locationId}/inspectTemplates',
        request_field='',
        request_type_name=u'DlpProjectsLocationsInspectTemplatesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListInspectTemplatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the InspectTemplate.
See https://cloud.google.com/dlp/docs/creating-templates to learn more.

      Args:
        request: (DlpProjectsLocationsInspectTemplatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2InspectTemplate) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/inspectTemplates/{inspectTemplatesId}',
        http_method=u'PATCH',
        method_id=u'dlp.projects.locations.inspectTemplates.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateInspectTemplateRequest',
        request_type_name=u'DlpProjectsLocationsInspectTemplatesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2InspectTemplate',
        supports_download=False,
    )

  class ProjectsLocationsJobTriggersService(base_api.BaseApiService):
    """Service class for the projects_locations_jobTriggers resource."""

    _NAME = u'projects_locations_jobTriggers'

    def __init__(self, client):
      super(DlpV2.ProjectsLocationsJobTriggersService, self).__init__(client)
      self._upload_configs = {
          }

    def Activate(self, request, global_params=None):
      r"""Activate a job trigger. Causes the immediate execute of a trigger.
instead of waiting on the trigger event to occur.

      Args:
        request: (DlpProjectsLocationsJobTriggersActivateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2DlpJob) The response message.
      """
      config = self.GetMethodConfig('Activate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Activate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/jobTriggers/{jobTriggersId}:activate',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.jobTriggers.activate',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:activate',
        request_field=u'googlePrivacyDlpV2ActivateJobTriggerRequest',
        request_type_name=u'DlpProjectsLocationsJobTriggersActivateRequest',
        response_type_name=u'GooglePrivacyDlpV2DlpJob',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a job trigger to run DLP actions such as scanning storage for.
sensitive information on a set schedule.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsLocationsJobTriggersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2JobTrigger) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/jobTriggers',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.jobTriggers.create',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/jobTriggers',
        request_field=u'googlePrivacyDlpV2CreateJobTriggerRequest',
        request_type_name=u'DlpProjectsLocationsJobTriggersCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2JobTrigger',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a job trigger.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsLocationsJobTriggersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/jobTriggers/{jobTriggersId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.locations.jobTriggers.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsJobTriggersDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a job trigger.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsLocationsJobTriggersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2JobTrigger) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/jobTriggers/{jobTriggersId}',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.jobTriggers.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsJobTriggersGetRequest',
        response_type_name=u'GooglePrivacyDlpV2JobTrigger',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists job triggers.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsLocationsJobTriggersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListJobTriggersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/jobTriggers',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.jobTriggers.list',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/locations/{locationId}/jobTriggers',
        request_field='',
        request_type_name=u'DlpProjectsLocationsJobTriggersListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListJobTriggersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a job trigger.
See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.

      Args:
        request: (DlpProjectsLocationsJobTriggersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2JobTrigger) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/jobTriggers/{jobTriggersId}',
        http_method=u'PATCH',
        method_id=u'dlp.projects.locations.jobTriggers.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateJobTriggerRequest',
        request_type_name=u'DlpProjectsLocationsJobTriggersPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2JobTrigger',
        supports_download=False,
    )

  class ProjectsLocationsStoredInfoTypesService(base_api.BaseApiService):
    """Service class for the projects_locations_storedInfoTypes resource."""

    _NAME = u'projects_locations_storedInfoTypes'

    def __init__(self, client):
      super(DlpV2.ProjectsLocationsStoredInfoTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a pre-built stored infoType to be used for inspection.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsLocationsStoredInfoTypesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/storedInfoTypes',
        http_method=u'POST',
        method_id=u'dlp.projects.locations.storedInfoTypes.create',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/locations/{locationId}/storedInfoTypes',
        request_field=u'googlePrivacyDlpV2CreateStoredInfoTypeRequest',
        request_type_name=u'DlpProjectsLocationsStoredInfoTypesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a stored infoType.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsLocationsStoredInfoTypesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.locations.storedInfoTypes.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsStoredInfoTypesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a stored infoType.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsLocationsStoredInfoTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.storedInfoTypes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsLocationsStoredInfoTypesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists stored infoTypes.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsLocationsStoredInfoTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListStoredInfoTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationId}/storedInfoTypes',
        http_method=u'GET',
        method_id=u'dlp.projects.locations.storedInfoTypes.list',
        ordered_params=[u'parent', u'locationId'],
        path_params=[u'locationId', u'parent'],
        query_params=[u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/locations/{locationId}/storedInfoTypes',
        request_field='',
        request_type_name=u'DlpProjectsLocationsStoredInfoTypesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListStoredInfoTypesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the stored infoType by creating a new version. The existing version.
will continue to be used until the new version is ready.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsLocationsStoredInfoTypesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'PATCH',
        method_id=u'dlp.projects.locations.storedInfoTypes.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateStoredInfoTypeRequest',
        request_type_name=u'DlpProjectsLocationsStoredInfoTypesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(DlpV2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsStoredInfoTypesService(base_api.BaseApiService):
    """Service class for the projects_storedInfoTypes resource."""

    _NAME = u'projects_storedInfoTypes'

    def __init__(self, client):
      super(DlpV2.ProjectsStoredInfoTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a pre-built stored infoType to be used for inspection.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsStoredInfoTypesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/storedInfoTypes',
        http_method=u'POST',
        method_id=u'dlp.projects.storedInfoTypes.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/storedInfoTypes',
        request_field=u'googlePrivacyDlpV2CreateStoredInfoTypeRequest',
        request_type_name=u'DlpProjectsStoredInfoTypesCreateRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a stored infoType.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsStoredInfoTypesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'DELETE',
        method_id=u'dlp.projects.storedInfoTypes.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsStoredInfoTypesDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a stored infoType.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsStoredInfoTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'GET',
        method_id=u'dlp.projects.storedInfoTypes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'DlpProjectsStoredInfoTypesGetRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists stored infoTypes.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsStoredInfoTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2ListStoredInfoTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/storedInfoTypes',
        http_method=u'GET',
        method_id=u'dlp.projects.storedInfoTypes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'locationId', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/storedInfoTypes',
        request_field='',
        request_type_name=u'DlpProjectsStoredInfoTypesListRequest',
        response_type_name=u'GooglePrivacyDlpV2ListStoredInfoTypesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the stored infoType by creating a new version. The existing version.
will continue to be used until the new version is ready.
See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
learn more.

      Args:
        request: (DlpProjectsStoredInfoTypesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GooglePrivacyDlpV2StoredInfoType) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/storedInfoTypes/{storedInfoTypesId}',
        http_method=u'PATCH',
        method_id=u'dlp.projects.storedInfoTypes.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field=u'googlePrivacyDlpV2UpdateStoredInfoTypeRequest',
        request_type_name=u'DlpProjectsStoredInfoTypesPatchRequest',
        response_type_name=u'GooglePrivacyDlpV2StoredInfoType',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(DlpV2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
