"""Generated message classes for speech version v1p1beta1.

Converts audio to text by applying powerful neural network models.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'speech'


class DataErrors(_messages.Message):
  r"""Different types of dataset errors and the stats associated with each
  error.

  Enums:
    ErrorTypeValueValuesEnum: Type of the error.

  Fields:
    count: Number of records having errors associated with the enum.
    errorType: Type of the error.
  """

  class ErrorTypeValueValuesEnum(_messages.Enum):
    r"""Type of the error.

    Values:
      ERROR_TYPE_UNSPECIFIED: Not specified.
      UNSUPPORTED_AUDIO_FORMAT: Audio format not in the formats supported by
        the cloud speech API
      FILE_EXTENSION_MISMATCH_WITH_AUDIO_FORMAT: File format different from
        what is specified in the file name extension
      FILE_TOO_LARGE: File too large. Maximum allowed size is 500 MB.
    """
    ERROR_TYPE_UNSPECIFIED = 0
    UNSUPPORTED_AUDIO_FORMAT = 1
    FILE_EXTENSION_MISMATCH_WITH_AUDIO_FORMAT = 2
    FILE_TOO_LARGE = 3

  count = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  errorType = _messages.EnumField('ErrorTypeValueValuesEnum', 2)


class DataStats(_messages.Message):
  r"""Contains stats about the data which was uploaded and preprocessed to be
  use by downstream pipelines like training, evals pipelines.

  Fields:
    dataErrors: Different types of data errors and the counts associated with
      them.
    testExampleCount: The number of examples used for testing.
    trainingExampleCount: The number of examples used for training.
    trainingWordCount: The number of words used for training.
  """

  dataErrors = _messages.MessageField('DataErrors', 1, repeated=True)
  testExampleCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  trainingExampleCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  trainingWordCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Dataset(_messages.Message):
  r"""Specifies the parameters needed for creating a dataset. In addition this
  is also the message returned to the client by the `CreateDataset` method. It
  is included in the `result.response` field of the `Operation` returned by
  the `GetOperation` call of the `google::longrunning::Operations` service.

  Fields:
    blockingOperationIds: Output only. All the blocking operations associated
      with this dataset. Like (pre-processing, training-model, testing-model)
    bucketName: If set, the log data to be used in this dataset is restricted
      to the bucket specified. This field is only applicable if
      use_logged_data is true. If use_logged_data is true, but this field is
      not set, then all logs will be used for training the models. See:
      RecognitionMetadata for information on setting up data logs.
    createTime: Output only. The timestamp this dataset is created.
    dataProcessingRegion: Location where the data should be processed. If not
      specified then we will pick a location on behalf of the user for storing
      and processing the data. Currently only us-central is supported.
    dataStats: Output only. Stats assoiated with the data.
    displayName: Required. Name of the data set for display.
    hasSufficientData: Output only. True if the data is sufficient to create
      custom models.
    languageCode: Required. The language of the supplied audio as a
      [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
      Example: "en-US". See [Language Support](/speech-to-text/docs/languages)
      for a list of the currently supported language codes.
    lastError: Output only. The error status, if any, of the last operation
      performed on this dataset. Empty if there is still pending operation, or
      if the last operation completed with success.
    models: All the models (including models pending training) built using the
      dataset.
    name: Output only. Resource name of the dataset. Form :-
      'projects/{project_number}/locations/{location_id}/datasets/{dataset_id}
      '
    updateTime: Output only. The timestamp this dataset is last updated.
    uri: URI that points to a file in csv file where each row has following
      format. <gs_path_to_audio>,<gs_path_to_transcript>,<label> label can be
      HUMAN_TRANSCRIBED or MACHINE_TRANSCRIBED. Rows must comply to the
      following to be valid: 1. Each row must have at least a label and
      <gs_path_to_transcript> 2. If a row is marked HUMAN_TRANSCRIBED, then
      you must specify both <gs_path_to_audio> and <gs_path_to_transcript>.
      Only WAV file formats which encode linear 16-bit pulse-code modulation
      (PCM) audio format are supported. The maximum audio file size is 500 MB.
      Also note that the audio has to be single channel audio. 3. There has to
      be at least 500 rows labelled HUMAN_TRANSCRIBED covering at least ~10K
      words in order to get reliable word error rate results. 4. To create a
      language model, you should provide at least 100,000 words in your
      transcriptions as training data if you have conversational and captions
      type of data. You should provide at least 10,000 words if you have short
      utterances like voice commands and search type of use cases. Currently,
      only Google Cloud Storage URIs are supported, which must be specified in
      the following format: `gs://bucket_name/object_name` (other URI formats
      will be ignored). For more information, see [Request URIs](/storage/docs
      /reference-uris).
    useLoggedData: If this is true, then use the previously logged data (for
      the project) The logs data for this project will be preprocessed and
      prepared for downstream pipelines (like training). All logs are logged
      to the consumer project.
  """

  blockingOperationIds = _messages.StringField(1, repeated=True)
  bucketName = _messages.StringField(2)
  createTime = _messages.StringField(3)
  dataProcessingRegion = _messages.StringField(4)
  dataStats = _messages.MessageField('DataStats', 5)
  displayName = _messages.StringField(6)
  hasSufficientData = _messages.BooleanField(7)
  languageCode = _messages.StringField(8)
  lastError = _messages.MessageField('Status', 9)
  models = _messages.MessageField('Model', 10, repeated=True)
  name = _messages.StringField(11)
  updateTime = _messages.StringField(12)
  uri = _messages.StringField(13)
  useLoggedData = _messages.BooleanField(14)


class DeployModelRequest(_messages.Message):
  r"""Message sent by the client for the `DeployModel` method."""


class EvaluateModelRequest(_messages.Message):
  r"""Message sent by the client for the `EvaluateModel` method."""


class EvaluateModelResponse(_messages.Message):
  r"""The only message returned to the client by the `EvaluateModel` method.
  This is also returned as part of the Dataset message returned to the client
  by the CreateDataset method. It is included in the `result.response` field
  of the `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Enums:
    ModelTypeValueValuesEnum: Required. The type of model used in this
      evaluation.

  Fields:
    isEnhancedModel: If true then it means we are referring to the results of
      an enhanced version of the model_type. Currently only PHONE_CALL
      model_type has an enhanced version.
    modelType: Required. The type of model used in this evaluation.
    wordCount: Number of words used in the word_error_rate computation.
    wordErrorRate: Word error rate metric computed on the test set using the
      AutoML model.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of model used in this evaluation.

    Values:
      MODEL_TYPE_UNSPECIFIED: <no description>
      DEFAULT: Model for audio that is not one of the specific models below.
        This is a generic model and can be used in various scenarios but is
        not necessarily the best in any particular scenario.
      COMMAND_AND_SEARCH: Model for audio from short queries like voice
        commands or voice search
      PHONE_CALL: Model for phone call conversation type op audio.
      VIDEO: Model for audio that originated from from video or includes
        multiple speakers.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    DEFAULT = 1
    COMMAND_AND_SEARCH = 2
    PHONE_CALL = 3
    VIDEO = 4

  isEnhancedModel = _messages.BooleanField(1)
  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 2)
  wordCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  wordErrorRate = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class ListDatasetsResponse(_messages.Message):
  r"""A ListDatasetsResponse object.

  Fields:
    datasets: Repeated list of data sets containing details about each data
      set.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  datasets = _messages.MessageField('Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLogDataStatsResponse(_messages.Message):
  r"""Message received by the client for the `ListLogDataStats` method.

  Fields:
    logDataEnabled: Output only. True if user has opted in for log data
      collection.
    logDataStats: The stats for each bucket.
    totalCount: The overall count for log data (including all bucket data).
  """

  logDataEnabled = _messages.BooleanField(1)
  logDataStats = _messages.MessageField('LogBucketStats', 2, repeated=True)
  totalCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ListModelsResponse(_messages.Message):
  r"""A ListModelsResponse object.

  Fields:
    models: Repeated list of models containing details about each model.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  models = _messages.MessageField('Model', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class LogBucketStats(_messages.Message):
  r"""Stats for log data within a bucket.

  Fields:
    bucketName: The display name for the bucket in which logs are collected.
    count: Number of audio samples that have been collected in this bucket.
  """

  bucketName = _messages.StringField(1)
  count = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class LongRunningRecognizeMetadata(_messages.Message):
  r"""Describes the progress of a long-running `LongRunningRecognize` call. It
  is included in the `metadata` field of the `Operation` returned by the
  `GetOperation` call of the `google::longrunning::Operations` service.

  Fields:
    lastUpdateTime: Time of the most recent processing update.
    progressPercent: Approximate percentage of audio processed thus far.
      Guaranteed to be 100 when the audio is fully processed and the results
      are available.
    startTime: Time when the request was received.
  """

  lastUpdateTime = _messages.StringField(1)
  progressPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(3)


class LongRunningRecognizeRequest(_messages.Message):
  r"""The top-level message sent by the client for the `LongRunningRecognize`
  method.

  Fields:
    audio: *Required* The audio data to be recognized.
    config: *Required* Provides information to the recognizer that specifies
      how to process the request.
  """

  audio = _messages.MessageField('RecognitionAudio', 1)
  config = _messages.MessageField('RecognitionConfig', 2)


class LongRunningRecognizeResponse(_messages.Message):
  r"""The only message returned to the client by the `LongRunningRecognize`
  method. It contains the result as zero or more sequential
  `SpeechRecognitionResult` messages. It is included in the `result.response`
  field of the `Operation` returned by the `GetOperation` call of the
  `google::longrunning::Operations` service.

  Fields:
    results: Output only. Sequential list of transcription results
      corresponding to sequential portions of audio.
  """

  results = _messages.MessageField('SpeechRecognitionResult', 1, repeated=True)


class Model(_messages.Message):
  r"""Specifies the model parameters needed for training a model. In addition
  this is also the message returned to the client by the `CreateModel` method.
  It is included in the `result.response` field of the `Operation` returned by
  the `GetOperation` call of the `google::longrunning::Operations` service.

  Enums:
    TrainingTypeValueValuesEnum: Required. Type of the training to perform.

  Fields:
    createTime: Output only. Timestamp when this model was created.
    displayName: Required. Display name of the model to be trained.
    evaluateModelResponses: Output only. Evaluation results associated with
      this model. A model can contain multiple sub-models in which case the
      evaluation results for all of those are available. If there are no sub
      models then there would be just a single EvaluateModelResponse.
    name: Output only. Resource name of the model. Format:
      "projects/{project_id}/locations/{location_id}/models/{model_id}"
    trainingType: Required. Type of the training to perform.
  """

  class TrainingTypeValueValuesEnum(_messages.Enum):
    r"""Required. Type of the training to perform.

    Values:
      TRAINING_TYPE_UNSPECIFIED: <no description>
      CUSTOM_ADAPTATION_LANGUAGE_MODEL: Build adaptation language model based
        on the users data. These models are built on top of the existing
        prebuilt models (like phone_call, video etc.).
      PREBUILT_MODEL: Output only. This is set to indicate that the model we
        are talking about is a prebuilt model (for e.g in the context of
        evaluations).
    """
    TRAINING_TYPE_UNSPECIFIED = 0
    CUSTOM_ADAPTATION_LANGUAGE_MODEL = 1
    PREBUILT_MODEL = 2

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  evaluateModelResponses = _messages.MessageField('EvaluateModelResponse', 3, repeated=True)
  name = _messages.StringField(4)
  trainingType = _messages.EnumField('TrainingTypeValueValuesEnum', 5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class RecognitionAudio(_messages.Message):
  r"""Contains audio data in the encoding specified in the
  `RecognitionConfig`. Either `content` or `uri` must be supplied. Supplying
  both or neither returns google.rpc.Code.INVALID_ARGUMENT. See [content
  limits](/speech-to-text/quotas#content).

  Fields:
    content: The audio data bytes encoded as specified in `RecognitionConfig`.
      Note: as with all bytes fields, protobuffers use a pure binary
      representation, whereas JSON representations use base64.
    uri: URI that points to a file that contains audio data bytes as specified
      in `RecognitionConfig`. The file must not be compressed (for example,
      gzip). Currently, only Google Cloud Storage URIs are supported, which
      must be specified in the following format:
      `gs://bucket_name/object_name` (other URI formats return
      google.rpc.Code.INVALID_ARGUMENT). For more information, see [Request
      URIs](https://cloud.google.com/storage/docs/reference-uris).
  """

  content = _messages.BytesField(1)
  uri = _messages.StringField(2)


class RecognitionConfig(_messages.Message):
  r"""Provides information to the recognizer that specifies how to process the
  request.

  Enums:
    EncodingValueValuesEnum: Encoding of audio data sent in all
      `RecognitionAudio` messages. This field is optional for `FLAC` and `WAV`
      audio files and required for all other audio formats. For details, see
      AudioEncoding.

  Fields:
    alternativeLanguageCodes: *Optional* A list of up to 3 additional
      [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tags,
      listing possible alternative languages of the supplied audio. See
      [Language Support](/speech-to-text/docs/languages) for a list of the
      currently supported language codes. If alternative languages are listed,
      recognition result will contain recognition in the most likely language
      detected including the main language_code. The recognition result will
      include the language tag of the language detected in the audio. Note:
      This feature is only supported for Voice Command and Voice Search use
      cases and performance may vary for other use cases (e.g., phone call
      transcription).
    audioChannelCount: *Optional* The number of channels in the input audio
      data. ONLY set this for MULTI-CHANNEL recognition. Valid values for
      LINEAR16 and FLAC are `1`-`8`. Valid values for OGG_OPUS are '1'-'254'.
      Valid value for MULAW, AMR, AMR_WB and SPEEX_WITH_HEADER_BYTE is only
      `1`. If `0` or omitted, defaults to one channel (mono). Note: We only
      recognize the first channel by default. To perform independent
      recognition on each channel set
      `enable_separate_recognition_per_channel` to 'true'.
    diarizationConfig: *Optional* Config to enable speaker diarization and set
      additional parameters to make diarization better suited for your
      application. Note: When this is enabled, we send all the words from the
      beginning of the audio for the top alternative in every consecutive
      STREAMING responses. This is done in order to improve our speaker tags
      as our models learn to identify the speakers in the conversation over
      time. For non-streaming requests, the diarization results will be
      provided only in the top alternative of the FINAL
      SpeechRecognitionResult.
    diarizationSpeakerCount: *Optional* If set, specifies the estimated number
      of speakers in the conversation. If not set, defaults to '2'. Ignored
      unless enable_speaker_diarization is set to true." Note: Use
      diarization_config instead. This field will be DEPRECATED soon.
    enableAutomaticPunctuation: *Optional* If 'true', adds punctuation to
      recognition result hypotheses. This feature is only available in select
      languages. Setting this for requests in other languages has no effect at
      all. The default 'false' value does not add punctuation to result
      hypotheses. Note: This is currently offered as an experimental service,
      complimentary to all users. In the future this may be exclusively
      available as a premium feature.
    enableSeparateRecognitionPerChannel: This needs to be set to 'true'
      explicitly and `audio_channel_count` > 1 to get each channel recognized
      separately. The recognition result will contain a `channel_tag` field to
      state which channel that result belongs to. If this is not true, we will
      only recognize the first channel. The request is billed cumulatively for
      all channels recognized: `audio_channel_count` multiplied by the length
      of the audio.
    enableSpeakerDiarization: *Optional* If 'true', enables speaker detection
      for each recognized word in the top alternative of the recognition
      result using a speaker_tag provided in the WordInfo. Note: Use
      diarization_config instead. This field will be DEPRECATED soon.
    enableWordConfidence: *Optional* If `true`, the top result includes a list
      of words and the confidence for those words. If `false`, no word-level
      confidence information is returned. The default is `false`.
    enableWordTimeOffsets: *Optional* If `true`, the top result includes a
      list of words and the start and end time offsets (timestamps) for those
      words. If `false`, no word-level time offset information is returned.
      The default is `false`.
    encoding: Encoding of audio data sent in all `RecognitionAudio` messages.
      This field is optional for `FLAC` and `WAV` audio files and required for
      all other audio formats. For details, see AudioEncoding.
    languageCode: *Required* The language of the supplied audio as a
      [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
      Example: "en-US". See [Language Support](/speech-to-text/docs/languages)
      for a list of the currently supported language codes.
    maxAlternatives: *Optional* Maximum number of recognition hypotheses to be
      returned. Specifically, the maximum number of
      `SpeechRecognitionAlternative` messages within each
      `SpeechRecognitionResult`. The server may return fewer than
      `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1`
      will return a maximum of one. If omitted, will return a maximum of one.
    metadata: *Optional* Metadata regarding this request.
    model: *Optional* Which model to select for the given request. Select the
      model best suited to your domain to get best results. If a model is not
      explicitly specified, then we auto-select a model based on the
      parameters in the RecognitionConfig. <table>   <tr>
      <td><b>Model</b></td>     <td><b>Description</b></td>   </tr>   <tr>
      <td><code>command_and_search</code></td>     <td>Best for short queries
      such as voice commands or voice search.</td>   </tr>   <tr>
      <td><code>phone_call</code></td>     <td>Best for audio that originated
      from a phone call (typically     recorded at an 8khz sampling
      rate).</td>   </tr>   <tr>     <td><code>video</code></td>     <td>Best
      for audio that originated from from video or includes multiple
      speakers. Ideally the audio is recorded at a 16khz or greater
      sampling rate. This is a premium model that costs more than the
      standard rate.</td>   </tr>   <tr>     <td><code>default</code></td>
      <td>Best for audio that is not one of the specific audio models.
      For example, long-form audio. Ideally the audio is high-fidelity,
      recorded at a 16khz or greater sampling rate.</td>   </tr> </table>
    profanityFilter: *Optional* If set to `true`, the server will attempt to
      filter out profanities, replacing all but the initial character in each
      filtered word with asterisks, e.g. "f***". If set to `false` or omitted,
      profanities won't be filtered out.
    sampleRateHertz: Sample rate in Hertz of the audio data sent in all
      `RecognitionAudio` messages. Valid values are: 8000-48000. 16000 is
      optimal. For best results, set the sampling rate of the audio source to
      16000 Hz. If that's not possible, use the native sample rate of the
      audio source (instead of re-sampling). This field is optional for `FLAC`
      and `WAV` audio files and required for all other audio formats. For
      details, see AudioEncoding.
    speechContexts: *Optional* array of SpeechContext. A means to provide
      context to assist the speech recognition. For more information, see
      [Phrase Hints](/speech-to-text/docs/basics#phrase-hints).
    useEnhanced: *Optional* Set to true to use an enhanced model for speech
      recognition. If `use_enhanced` is set to true and the `model` field is
      not set, then an appropriate enhanced model is chosen if: 1. project is
      eligible for requesting enhanced models 2. an enhanced model exists for
      the audio  If `use_enhanced` is true and an enhanced version of the
      specified model does not exist, then the speech is recognized using the
      standard version of the specified model.  Enhanced speech models require
      that you opt-in to data logging using instructions in the [documentation
      ](/speech-to-text/docs/enable-data-logging). If you set `use_enhanced`
      to true and you have not enabled audio logging, then you will receive an
      error.
  """

  class EncodingValueValuesEnum(_messages.Enum):
    r"""Encoding of audio data sent in all `RecognitionAudio` messages. This
    field is optional for `FLAC` and `WAV` audio files and required for all
    other audio formats. For details, see AudioEncoding.

    Values:
      ENCODING_UNSPECIFIED: Not specified.
      LINEAR16: Uncompressed 16-bit signed little-endian samples (Linear PCM).
      FLAC: `FLAC` (Free Lossless Audio Codec) is the recommended encoding
        because it is lossless--therefore recognition is not compromised--and
        requires only about half the bandwidth of `LINEAR16`. `FLAC` stream
        encoding supports 16-bit and 24-bit samples, however, not all fields
        in `STREAMINFO` are supported.
      MULAW: 8-bit samples that compand 14-bit audio samples using G.711 PCMU
        /mu-law.
      AMR: Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be
        8000.
      AMR_WB: Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be
        16000.
      OGG_OPUS: Opus encoded audio frames in Ogg container
        ([OggOpus](https://wiki.xiph.org/OggOpus)). `sample_rate_hertz` must
        be one of 8000, 12000, 16000, 24000, or 48000.
      SPEEX_WITH_HEADER_BYTE: Although the use of lossy encodings is not
        recommended, if a very low bitrate encoding is required, `OGG_OPUS` is
        highly preferred over Speex encoding. The [Speex](https://speex.org/)
        encoding supported by Cloud Speech API has a header byte in each
        block, as in MIME type `audio/x-speex-with-header-byte`. It is a
        variant of the RTP Speex encoding defined in [RFC
        5574](https://tools.ietf.org/html/rfc5574). The stream is a sequence
        of blocks, one block per RTP packet. Each block starts with a byte
        containing the length of the block, in bytes, followed by one or more
        frames of Speex data, padded to an integral number of bytes (octets)
        as specified in RFC 5574. In other words, each RTP header is replaced
        with a single byte containing the block length. Only Speex wideband is
        supported. `sample_rate_hertz` must be 16000.
    """
    ENCODING_UNSPECIFIED = 0
    LINEAR16 = 1
    FLAC = 2
    MULAW = 3
    AMR = 4
    AMR_WB = 5
    OGG_OPUS = 6
    SPEEX_WITH_HEADER_BYTE = 7

  alternativeLanguageCodes = _messages.StringField(1, repeated=True)
  audioChannelCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  diarizationConfig = _messages.MessageField('SpeakerDiarizationConfig', 3)
  diarizationSpeakerCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  enableAutomaticPunctuation = _messages.BooleanField(5)
  enableSeparateRecognitionPerChannel = _messages.BooleanField(6)
  enableSpeakerDiarization = _messages.BooleanField(7)
  enableWordConfidence = _messages.BooleanField(8)
  enableWordTimeOffsets = _messages.BooleanField(9)
  encoding = _messages.EnumField('EncodingValueValuesEnum', 10)
  languageCode = _messages.StringField(11)
  maxAlternatives = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  metadata = _messages.MessageField('RecognitionMetadata', 13)
  model = _messages.StringField(14)
  profanityFilter = _messages.BooleanField(15)
  sampleRateHertz = _messages.IntegerField(16, variant=_messages.Variant.INT32)
  speechContexts = _messages.MessageField('SpeechContext', 17, repeated=True)
  useEnhanced = _messages.BooleanField(18)


class RecognitionMetadata(_messages.Message):
  r"""Description of audio data to be recognized.

  Enums:
    InteractionTypeValueValuesEnum: The use case most closely describing the
      audio content to be recognized.
    MicrophoneDistanceValueValuesEnum: The audio type that most closely
      describes the audio being recognized.
    OriginalMediaTypeValueValuesEnum: The original media the speech was
      recorded on.
    RecordingDeviceTypeValueValuesEnum: The type of device the speech was
      recorded with.

  Fields:
    audioTopic: Description of the content. Eg. "Recordings of federal supreme
      court hearings from 2012".
    industryNaicsCodeOfAudio: The industry vertical to which this speech
      recognition request most closely applies. This is most indicative of the
      topics contained in the audio.  Use the 6-digit NAICS code to identify
      the industry vertical - see https://www.naics.com/search/.
    interactionType: The use case most closely describing the audio content to
      be recognized.
    microphoneDistance: The audio type that most closely describes the audio
      being recognized.
    obfuscatedId: Obfuscated (privacy-protected) ID of the user, to identify
      number of unique users using the service.
    originalMediaType: The original media the speech was recorded on.
    originalMimeType: Mime type of the original audio file.  For example
      `audio/m4a`, `audio/x-alaw-basic`, `audio/mp3`, `audio/3gpp`. A list of
      possible audio mime types is maintained at
      http://www.iana.org/assignments/media-types/media-types.xhtml#audio
    recordingDeviceName: The device used to make the recording.  Examples
      'Nexus 5X' or 'Polycom SoundStation IP 6000' or 'POTS' or 'VoIP' or
      'Cardioid Microphone'.
    recordingDeviceType: The type of device the speech was recorded with.
    tags: A freeform field to tag this input sample with. This can be used for
      grouping the logs into separate buckets. This enables selective purging
      of data based on the tags, and also for training models in AutoML.
  """

  class InteractionTypeValueValuesEnum(_messages.Enum):
    r"""The use case most closely describing the audio content to be
    recognized.

    Values:
      INTERACTION_TYPE_UNSPECIFIED: Use case is either unknown or is something
        other than one of the other values below.
      DISCUSSION: Multiple people in a conversation or discussion. For example
        in a meeting with two or more people actively participating. Typically
        all the primary people speaking would be in the same room (if not, see
        PHONE_CALL)
      PRESENTATION: One or more persons lecturing or presenting to others,
        mostly uninterrupted.
      PHONE_CALL: A phone-call or video-conference in which two or more
        people, who are not in the same room, are actively participating.
      VOICEMAIL: A recorded message intended for another person to listen to.
      PROFESSIONALLY_PRODUCED: Professionally produced audio (eg. TV Show,
        Podcast).
      VOICE_SEARCH: Transcribe spoken questions and queries into text.
      VOICE_COMMAND: Transcribe voice commands, such as for controlling a
        device.
      DICTATION: Transcribe speech to text to create a written document, such
        as a text-message, email or report.
    """
    INTERACTION_TYPE_UNSPECIFIED = 0
    DISCUSSION = 1
    PRESENTATION = 2
    PHONE_CALL = 3
    VOICEMAIL = 4
    PROFESSIONALLY_PRODUCED = 5
    VOICE_SEARCH = 6
    VOICE_COMMAND = 7
    DICTATION = 8

  class MicrophoneDistanceValueValuesEnum(_messages.Enum):
    r"""The audio type that most closely describes the audio being recognized.

    Values:
      MICROPHONE_DISTANCE_UNSPECIFIED: Audio type is not known.
      NEARFIELD: The audio was captured from a closely placed microphone. Eg.
        phone, dictaphone, or handheld microphone. Generally if there speaker
        is within 1 meter of the microphone.
      MIDFIELD: The speaker if within 3 meters of the microphone.
      FARFIELD: The speaker is more than 3 meters away from the microphone.
    """
    MICROPHONE_DISTANCE_UNSPECIFIED = 0
    NEARFIELD = 1
    MIDFIELD = 2
    FARFIELD = 3

  class OriginalMediaTypeValueValuesEnum(_messages.Enum):
    r"""The original media the speech was recorded on.

    Values:
      ORIGINAL_MEDIA_TYPE_UNSPECIFIED: Unknown original media type.
      AUDIO: The speech data is an audio recording.
      VIDEO: The speech data originally recorded on a video.
    """
    ORIGINAL_MEDIA_TYPE_UNSPECIFIED = 0
    AUDIO = 1
    VIDEO = 2

  class RecordingDeviceTypeValueValuesEnum(_messages.Enum):
    r"""The type of device the speech was recorded with.

    Values:
      RECORDING_DEVICE_TYPE_UNSPECIFIED: The recording device is unknown.
      SMARTPHONE: Speech was recorded on a smartphone.
      PC: Speech was recorded using a personal computer or tablet.
      PHONE_LINE: Speech was recorded over a phone line.
      VEHICLE: Speech was recorded in a vehicle.
      OTHER_OUTDOOR_DEVICE: Speech was recorded outdoors.
      OTHER_INDOOR_DEVICE: Speech was recorded indoors.
    """
    RECORDING_DEVICE_TYPE_UNSPECIFIED = 0
    SMARTPHONE = 1
    PC = 2
    PHONE_LINE = 3
    VEHICLE = 4
    OTHER_OUTDOOR_DEVICE = 5
    OTHER_INDOOR_DEVICE = 6

  audioTopic = _messages.StringField(1)
  industryNaicsCodeOfAudio = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  interactionType = _messages.EnumField('InteractionTypeValueValuesEnum', 3)
  microphoneDistance = _messages.EnumField('MicrophoneDistanceValueValuesEnum', 4)
  obfuscatedId = _messages.IntegerField(5)
  originalMediaType = _messages.EnumField('OriginalMediaTypeValueValuesEnum', 6)
  originalMimeType = _messages.StringField(7)
  recordingDeviceName = _messages.StringField(8)
  recordingDeviceType = _messages.EnumField('RecordingDeviceTypeValueValuesEnum', 9)
  tags = _messages.StringField(10, repeated=True)


class RecognizeRequest(_messages.Message):
  r"""The top-level message sent by the client for the `Recognize` method.

  Fields:
    audio: *Required* The audio data to be recognized.
    config: *Required* Provides information to the recognizer that specifies
      how to process the request.
  """

  audio = _messages.MessageField('RecognitionAudio', 1)
  config = _messages.MessageField('RecognitionConfig', 2)


class RecognizeResponse(_messages.Message):
  r"""The only message returned to the client by the `Recognize` method. It
  contains the result as zero or more sequential `SpeechRecognitionResult`
  messages.

  Fields:
    results: Output only. Sequential list of transcription results
      corresponding to sequential portions of audio.
  """

  results = _messages.MessageField('SpeechRecognitionResult', 1, repeated=True)


class RefreshDataRequest(_messages.Message):
  r"""Message sent by the client to refresh data in a existing dataset.

  Fields:
    uri: URI that points to a file in csv file where each row has following
      format. <gs_path_to_audio>,<gs_path_to_transcript>,<label> label can be
      HUMAN_TRANSCRIBED or MACHINE_TRANSCRIBED. Rows must comply to the
      following to be valid: 1. Each row must have at least a label and
      <gs_path_to_transcript> 2. If a row is marked HUMAN_TRANSCRIBED, then
      you must specify both <gs_path_to_audio> and <gs_path_to_transcript>.
      Only WAV file formats which encode linear 16-bit pulse-code modulation
      (PCM) audio format are supported. The maximum audio file size is 500 MB.
      Also note that the audio has to be single channel audio. 3. There has to
      be at least 500 rows labelled HUMAN_TRANSCRIBED covering at least ~10K
      words in order to get reliable word error rate results. 4. To create a
      language model, you should provide at least 100,000 words in your
      transcriptions as training data if you have conversational and captions
      type of data. You should provide at least 10,000 words if you have short
      utterances like voice commands and search type of use cases. Currently,
      only Google Cloud Storage URIs are supported, which must be specified in
      the following format: `gs://bucket_name/object_name` (other URI formats
      will be ignored). For more information, see [Request URIs](/storage/docs
      /reference-uris).
  """

  uri = _messages.StringField(1)


class SpeakerDiarizationConfig(_messages.Message):
  r"""A SpeakerDiarizationConfig object.

  Fields:
    enableSpeakerDiarization: *Optional* If 'true', enables speaker detection
      for each recognized word in the top alternative of the recognition
      result using a speaker_tag provided in the WordInfo.
    maxSpeakerCount: *Optional* Only used if diarization_speaker_count is not
      set. Maximum number of speakers in the conversation. This range gives
      you more flexibility by allowing the system to automatically determine
      the correct number of speakers. If not set, the default value is 6.
    minSpeakerCount: *Optional* Only used if diarization_speaker_count is not
      set. Minimum number of speakers in the conversation. This range gives
      you more flexibility by allowing the system to automatically determine
      the correct number of speakers. If not set, the default value is 2.
  """

  enableSpeakerDiarization = _messages.BooleanField(1)
  maxSpeakerCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minSpeakerCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class SpeechContext(_messages.Message):
  r"""Provides "hints" to the speech recognizer to favor specific words and
  phrases in the results.

  Fields:
    phrases: *Optional* A list of strings containing words and phrases "hints"
      so that the speech recognition is more likely to recognize them. This
      can be used to improve the accuracy for specific words and phrases, for
      example, if specific commands are typically spoken by the user. This can
      also be used to add additional words to the vocabulary of the
      recognizer. See [usage limits](/speech-to-text/quotas#content).
  """

  phrases = _messages.StringField(1, repeated=True)


class SpeechOperationMetadata(_messages.Message):
  r"""Describes the progress of a long-running call. It is included in the
  `metadata` field of the `Operation` returned by the `GetOperation` call of
  the `google::longrunning::Operations` service.

  Fields:
    lastUpdateTime: Time of the most recent processing update.
    progressPercent: Approximate percentage of progress, from AutoML Operation
      Metadata.
    startTime: Time when the request was received.
    worksOn: The resource being worked on.
  """

  lastUpdateTime = _messages.StringField(1)
  progressPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(3)
  worksOn = _messages.StringField(4)


class SpeechOperationsGetRequest(_messages.Message):
  r"""A SpeechOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class SpeechOperationsListRequest(_messages.Message):
  r"""A SpeechOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SpeechProjectsLocationsDatasetsCreateRequest(_messages.Message):
  r"""A SpeechProjectsLocationsDatasetsCreateRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    parent: Required. Resource name of the parent. Has the format :-
      "projects/{project_id}/locations/{location_id}"
  """

  dataset = _messages.MessageField('Dataset', 1)
  parent = _messages.StringField(2, required=True)


class SpeechProjectsLocationsDatasetsGetRequest(_messages.Message):
  r"""A SpeechProjectsLocationsDatasetsGetRequest object.

  Fields:
    includeModelInfo: If true then also include information about the models
      built using this dataset.
    name: The resource name of the dataset to retrieve. Form :-
      'projects/{project_number}/locations/{location_id}/datasets/{dataset_id}
      '
  """

  includeModelInfo = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class SpeechProjectsLocationsDatasetsListRequest(_messages.Message):
  r"""A SpeechProjectsLocationsDatasetsListRequest object.

  Fields:
    filter: Filter the response based on display_name of the dataset. For e.g
      display_name=Foo The filter string is case sensitive
    includeModelInfo: If true then also include information about the models
      built using the datasets.
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. Resource name of the parent. Has the format :-
      "projects/{project_id}/locations/{location_id}"
  """

  filter = _messages.StringField(1)
  includeModelInfo = _messages.BooleanField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class SpeechProjectsLocationsDatasetsRefreshDataRequest(_messages.Message):
  r"""A SpeechProjectsLocationsDatasetsRefreshDataRequest object.

  Fields:
    name: The resource name of the destination dataset.
    refreshDataRequest: A RefreshDataRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  refreshDataRequest = _messages.MessageField('RefreshDataRequest', 2)


class SpeechProjectsLocationsLogDataStatsListRequest(_messages.Message):
  r"""A SpeechProjectsLocationsLogDataStatsListRequest object.

  Fields:
    parent: Required. Resource name of the parent. Has the format :-
      "projects/{project_id}/locations/{location_id}"
  """

  parent = _messages.StringField(1, required=True)


class SpeechProjectsLocationsModelsCreateRequest(_messages.Message):
  r"""A SpeechProjectsLocationsModelsCreateRequest object.

  Fields:
    model: A Model resource to be passed as the request body.
    name: Required. Resource name of the dataset being used to create the
      model.
      'projects/{project_id}/locations/{location_id}/datasets/{dataset_id}'
    parent: Required. Resource name of the parent. Has the format :-
      "projects/{project_id}/locations/{location_id}"
  """

  model = _messages.MessageField('Model', 1)
  name = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SpeechProjectsLocationsModelsDeployRequest(_messages.Message):
  r"""A SpeechProjectsLocationsModelsDeployRequest object.

  Fields:
    deployModelRequest: A DeployModelRequest resource to be passed as the
      request body.
    name: Resource name of the model. Format:
      "projects/{project_id}/locations/{location_id}/models/{model_id}"
  """

  deployModelRequest = _messages.MessageField('DeployModelRequest', 1)
  name = _messages.StringField(2, required=True)


class SpeechProjectsLocationsModelsEvaluateRequest(_messages.Message):
  r"""A SpeechProjectsLocationsModelsEvaluateRequest object.

  Fields:
    evaluateModelRequest: A EvaluateModelRequest resource to be passed as the
      request body.
    name: Resource name of the model. Format:
      "projects/{project_id}/locations/{location_id}/models/{model_id}"
  """

  evaluateModelRequest = _messages.MessageField('EvaluateModelRequest', 1)
  name = _messages.StringField(2, required=True)


class SpeechProjectsLocationsModelsListRequest(_messages.Message):
  r"""A SpeechProjectsLocationsModelsListRequest object.

  Fields:
    filter: Filter the response based on display_name of the model. For e.g
      display_name=Foo The filter string is case sensitive
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. Resource name of the parent. Has the format :-
      "projects/{project_id}/locations/{location_id}"
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SpeechRecognitionAlternative(_messages.Message):
  r"""Alternative hypotheses (a.k.a. n-best list).

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative of a non-streaming result or, of a streaming result where
      `is_final=true`. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    transcript: Output only. Transcript text representing the words that the
      user spoke.
    words: Output only. A list of word-specific information for each
      recognized word. Note: When `enable_speaker_diarization` is true, you
      will see all the words from the beginning of the audio.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  transcript = _messages.StringField(2)
  words = _messages.MessageField('WordInfo', 3, repeated=True)


class SpeechRecognitionResult(_messages.Message):
  r"""A speech recognition result corresponding to a portion of the audio.

  Fields:
    alternatives: Output only. May contain one or more recognition hypotheses
      (up to the maximum specified in `max_alternatives`). These alternatives
      are ordered in terms of accuracy, with the top (first) alternative being
      the most probable, as ranked by the recognizer.
    channelTag: For multi-channel audio, this is the channel number
      corresponding to the recognized result for the audio from that channel.
      For audio_channel_count = N, its output values can range from '1' to
      'N'.
    languageCode: Output only. The [BCP-47](https://www.rfc-
      editor.org/rfc/bcp/bcp47.txt) language tag of the language in this
      result. This language code was detected to have the most likelihood of
      being spoken in the audio.
  """

  alternatives = _messages.MessageField('SpeechRecognitionAlternative', 1, repeated=True)
  channelTag = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  languageCode = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class WordInfo(_messages.Message):
  r"""Word-specific information for recognized words.

  Fields:
    confidence: Output only. The confidence estimate between 0.0 and 1.0. A
      higher number indicates an estimated greater likelihood that the
      recognized words are correct. This field is set only for the top
      alternative of a non-streaming result or, of a streaming result where
      `is_final=true`. This field is not guaranteed to be accurate and users
      should not rely on it to be always provided. The default of 0.0 is a
      sentinel value indicating `confidence` was not set.
    endTime: Output only. Time offset relative to the beginning of the audio,
      and corresponding to the end of the spoken word. This field is only set
      if `enable_word_time_offsets=true` and only in the top hypothesis. This
      is an experimental feature and the accuracy of the time offset can vary.
    speakerTag: Output only. A distinct integer value is assigned for every
      speaker within the audio. This field specifies which one of those
      speakers was detected to have spoken this word. Value ranges from '1' to
      diarization_speaker_count. speaker_tag is set if
      enable_speaker_diarization = 'true' and only in the top alternative.
    startTime: Output only. Time offset relative to the beginning of the
      audio, and corresponding to the start of the spoken word. This field is
      only set if `enable_word_time_offsets=true` and only in the top
      hypothesis. This is an experimental feature and the accuracy of the time
      offset can vary.
    word: Output only. The word corresponding to this set of information.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  endTime = _messages.StringField(2)
  speakerTag = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(4)
  word = _messages.StringField(5)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
