"""Generated message classes for dns version v1.

Configures and serves authoritative DNS records.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'dns'


class Change(_messages.Message):
  r"""An atomic update to a collection of ResourceRecordSets.

  Enums:
    StatusValueValuesEnum: Status of the operation (output only).

  Fields:
    additions: Which ResourceRecordSets to add?
    deletions: Which ResourceRecordSets to remove? Must match existing data
      exactly.
    id: Unique identifier for the resource; defined by the server (output
      only).
    isServing: If the DNS queries for the zone will be served.
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#change".
    startTime: The time that this operation was started by the server (output
      only). This is in RFC3339 text format.
    status: Status of the operation (output only).
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of the operation (output only).

    Values:
      done: <no description>
      pending: <no description>
    """
    done = 0
    pending = 1

  additions = _messages.MessageField('ResourceRecordSet', 1, repeated=True)
  deletions = _messages.MessageField('ResourceRecordSet', 2, repeated=True)
  id = _messages.StringField(3)
  isServing = _messages.BooleanField(4)
  kind = _messages.StringField(5, default=u'dns#change')
  startTime = _messages.StringField(6)
  status = _messages.EnumField('StatusValueValuesEnum', 7)


class ChangesListResponse(_messages.Message):
  r"""The response to a request to enumerate Changes to a ResourceRecordSets
  collection.

  Fields:
    changes: The requested changes.
    header: A ResponseHeader attribute.
    kind: Type of resource.
    nextPageToken: The presence of this field indicates that there exist more
      results following your last page of results in pagination order. To
      fetch them, make another list request using this value as your
      pagination token.  In this way you can retrieve the complete contents of
      even very large collections one page at a time. However, if the contents
      of the collection change between the first and last paginated list
      request, the set of all elements returned will be an inconsistent view
      of the collection. There is no way to retrieve a "snapshot" of
      collections larger than the maximum page size.
  """

  changes = _messages.MessageField('Change', 1, repeated=True)
  header = _messages.MessageField('ResponseHeader', 2)
  kind = _messages.StringField(3, default=u'dns#changesListResponse')
  nextPageToken = _messages.StringField(4)


class DnsChangesCreateRequest(_messages.Message):
  r"""A DnsChangesCreateRequest object.

  Fields:
    change: A Change resource to be passed as the request body.
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    project: Identifies the project addressed by this request.
  """

  change = _messages.MessageField('Change', 1)
  clientOperationId = _messages.StringField(2)
  managedZone = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class DnsChangesGetRequest(_messages.Message):
  r"""A DnsChangesGetRequest object.

  Fields:
    changeId: The identifier of the requested change, from a previous
      ResourceRecordSetsChangeResponse.
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    project: Identifies the project addressed by this request.
  """

  changeId = _messages.StringField(1, required=True)
  clientOperationId = _messages.StringField(2)
  managedZone = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class DnsChangesListRequest(_messages.Message):
  r"""A DnsChangesListRequest object.

  Enums:
    SortByValueValuesEnum: Sorting criterion. The only supported value is
      change sequence.

  Fields:
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    maxResults: Optional. Maximum number of results to be returned. If
      unspecified, the server will decide how many results to return.
    pageToken: Optional. A tag returned by a previous list request that was
      truncated. Use this parameter to continue a previous list request.
    project: Identifies the project addressed by this request.
    sortBy: Sorting criterion. The only supported value is change sequence.
    sortOrder: Sorting order direction: 'ascending' or 'descending'.
  """

  class SortByValueValuesEnum(_messages.Enum):
    r"""Sorting criterion. The only supported value is change sequence.

    Values:
      changeSequence: <no description>
    """
    changeSequence = 0

  managedZone = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)
  sortBy = _messages.EnumField('SortByValueValuesEnum', 5, default=u'changeSequence')
  sortOrder = _messages.StringField(6)


class DnsDnsKeysGetRequest(_messages.Message):
  r"""A DnsDnsKeysGetRequest object.

  Fields:
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    digestType: An optional comma-separated list of digest types to compute
      and display for key signing keys. If omitted, the recommended digest
      type will be computed and displayed.
    dnsKeyId: The identifier of the requested DnsKey.
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    project: Identifies the project addressed by this request.
  """

  clientOperationId = _messages.StringField(1)
  digestType = _messages.StringField(2)
  dnsKeyId = _messages.StringField(3, required=True)
  managedZone = _messages.StringField(4, required=True)
  project = _messages.StringField(5, required=True)


class DnsDnsKeysListRequest(_messages.Message):
  r"""A DnsDnsKeysListRequest object.

  Fields:
    digestType: An optional comma-separated list of digest types to compute
      and display for key signing keys. If omitted, the recommended digest
      type will be computed and displayed.
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    maxResults: Optional. Maximum number of results to be returned. If
      unspecified, the server will decide how many results to return.
    pageToken: Optional. A tag returned by a previous list request that was
      truncated. Use this parameter to continue a previous list request.
    project: Identifies the project addressed by this request.
  """

  digestType = _messages.StringField(1)
  managedZone = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class DnsKey(_messages.Message):
  r"""A DNSSEC key pair.

  Enums:
    AlgorithmValueValuesEnum: String mnemonic specifying the DNSSEC algorithm
      of this key. Immutable after creation time.
    TypeValueValuesEnum: One of "KEY_SIGNING" or "ZONE_SIGNING". Keys of type
      KEY_SIGNING have the Secure Entry Point flag set and, when active, will
      be used to sign only resource record sets of type DNSKEY. Otherwise, the
      Secure Entry Point flag will be cleared and this key will be used to
      sign only resource record sets of other types. Immutable after creation
      time.

  Fields:
    algorithm: String mnemonic specifying the DNSSEC algorithm of this key.
      Immutable after creation time.
    creationTime: The time that this resource was created in the control
      plane. This is in RFC3339 text format. Output only.
    description: A mutable string of at most 1024 characters associated with
      this resource for the user's convenience. Has no effect on the
      resource's function.
    digests: Cryptographic hashes of the DNSKEY resource record associated
      with this DnsKey. These digests are needed to construct a DS record that
      points at this DNS key. Output only.
    id: Unique identifier for the resource; defined by the server (output
      only).
    isActive: Active keys will be used to sign subsequent changes to the
      ManagedZone. Inactive keys will still be present as DNSKEY Resource
      Records for the use of resolvers validating existing signatures.
    keyLength: Length of the key in bits. Specified at creation time then
      immutable.
    keyTag: The key tag is a non-cryptographic hash of the a DNSKEY resource
      record associated with this DnsKey. The key tag can be used to identify
      a DNSKEY more quickly (but it is not a unique identifier). In
      particular, the key tag is used in a parent zone's DS record to point at
      the DNSKEY in this child ManagedZone. The key tag is a number in the
      range [0, 65535] and the algorithm to calculate it is specified in
      RFC4034 Appendix B. Output only.
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#dnsKey".
    publicKey: Base64 encoded public half of this key. Output only.
    type: One of "KEY_SIGNING" or "ZONE_SIGNING". Keys of type KEY_SIGNING
      have the Secure Entry Point flag set and, when active, will be used to
      sign only resource record sets of type DNSKEY. Otherwise, the Secure
      Entry Point flag will be cleared and this key will be used to sign only
      resource record sets of other types. Immutable after creation time.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""String mnemonic specifying the DNSSEC algorithm of this key. Immutable
    after creation time.

    Values:
      ecdsap256sha256: <no description>
      ecdsap384sha384: <no description>
      rsasha1: <no description>
      rsasha256: <no description>
      rsasha512: <no description>
    """
    ecdsap256sha256 = 0
    ecdsap384sha384 = 1
    rsasha1 = 2
    rsasha256 = 3
    rsasha512 = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""One of "KEY_SIGNING" or "ZONE_SIGNING". Keys of type KEY_SIGNING have
    the Secure Entry Point flag set and, when active, will be used to sign
    only resource record sets of type DNSKEY. Otherwise, the Secure Entry
    Point flag will be cleared and this key will be used to sign only resource
    record sets of other types. Immutable after creation time.

    Values:
      keySigning: <no description>
      zoneSigning: <no description>
    """
    keySigning = 0
    zoneSigning = 1

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  creationTime = _messages.StringField(2)
  description = _messages.StringField(3)
  digests = _messages.MessageField('DnsKeyDigest', 4, repeated=True)
  id = _messages.StringField(5)
  isActive = _messages.BooleanField(6)
  keyLength = _messages.IntegerField(7, variant=_messages.Variant.UINT32)
  keyTag = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  kind = _messages.StringField(9, default=u'dns#dnsKey')
  publicKey = _messages.StringField(10)
  type = _messages.EnumField('TypeValueValuesEnum', 11)


class DnsKeyDigest(_messages.Message):
  r"""A DnsKeyDigest object.

  Enums:
    TypeValueValuesEnum: Specifies the algorithm used to calculate this
      digest.

  Fields:
    digest: The base-16 encoded bytes of this digest. Suitable for use in a DS
      resource record.
    type: Specifies the algorithm used to calculate this digest.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Specifies the algorithm used to calculate this digest.

    Values:
      sha1: <no description>
      sha256: <no description>
      sha384: <no description>
    """
    sha1 = 0
    sha256 = 1
    sha384 = 2

  digest = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class DnsKeySpec(_messages.Message):
  r"""Parameters for DnsKey key generation. Used for generating initial keys
  for a new ManagedZone and as default when adding a new DnsKey.

  Enums:
    AlgorithmValueValuesEnum: String mnemonic specifying the DNSSEC algorithm
      of this key.
    KeyTypeValueValuesEnum: Specifies whether this is a key signing key (KSK)
      or a zone signing key (ZSK). Key signing keys have the Secure Entry
      Point flag set and, when active, will only be used to sign resource
      record sets of type DNSKEY. Zone signing keys do not have the Secure
      Entry Point flag set and will be used to sign all other types of
      resource record sets.

  Fields:
    algorithm: String mnemonic specifying the DNSSEC algorithm of this key.
    keyLength: Length of the keys in bits.
    keyType: Specifies whether this is a key signing key (KSK) or a zone
      signing key (ZSK). Key signing keys have the Secure Entry Point flag set
      and, when active, will only be used to sign resource record sets of type
      DNSKEY. Zone signing keys do not have the Secure Entry Point flag set
      and will be used to sign all other types of resource record sets.
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#dnsKeySpec".
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""String mnemonic specifying the DNSSEC algorithm of this key.

    Values:
      ecdsap256sha256: <no description>
      ecdsap384sha384: <no description>
      rsasha1: <no description>
      rsasha256: <no description>
      rsasha512: <no description>
    """
    ecdsap256sha256 = 0
    ecdsap384sha384 = 1
    rsasha1 = 2
    rsasha256 = 3
    rsasha512 = 4

  class KeyTypeValueValuesEnum(_messages.Enum):
    r"""Specifies whether this is a key signing key (KSK) or a zone signing
    key (ZSK). Key signing keys have the Secure Entry Point flag set and, when
    active, will only be used to sign resource record sets of type DNSKEY.
    Zone signing keys do not have the Secure Entry Point flag set and will be
    used to sign all other types of resource record sets.

    Values:
      keySigning: <no description>
      zoneSigning: <no description>
    """
    keySigning = 0
    zoneSigning = 1

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  keyLength = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  keyType = _messages.EnumField('KeyTypeValueValuesEnum', 3)
  kind = _messages.StringField(4, default=u'dns#dnsKeySpec')


class DnsKeysListResponse(_messages.Message):
  r"""The response to a request to enumerate DnsKeys in a ManagedZone.

  Fields:
    dnsKeys: The requested resources.
    header: A ResponseHeader attribute.
    kind: Type of resource.
    nextPageToken: The presence of this field indicates that there exist more
      results following your last page of results in pagination order. To
      fetch them, make another list request using this value as your
      pagination token.  In this way you can retrieve the complete contents of
      even very large collections one page at a time. However, if the contents
      of the collection change between the first and last paginated list
      request, the set of all elements returned will be an inconsistent view
      of the collection. There is no way to retrieve a "snapshot" of
      collections larger than the maximum page size.
  """

  dnsKeys = _messages.MessageField('DnsKey', 1, repeated=True)
  header = _messages.MessageField('ResponseHeader', 2)
  kind = _messages.StringField(3, default=u'dns#dnsKeysListResponse')
  nextPageToken = _messages.StringField(4)


class DnsManagedZoneOperationsGetRequest(_messages.Message):
  r"""A DnsManagedZoneOperationsGetRequest object.

  Fields:
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    managedZone: Identifies the managed zone addressed by this request.
    operation: Identifies the operation addressed by this request.
    project: Identifies the project addressed by this request.
  """

  clientOperationId = _messages.StringField(1)
  managedZone = _messages.StringField(2, required=True)
  operation = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class DnsManagedZoneOperationsListRequest(_messages.Message):
  r"""A DnsManagedZoneOperationsListRequest object.

  Enums:
    SortByValueValuesEnum: Sorting criterion. The only supported values are
      START_TIME and ID.

  Fields:
    managedZone: Identifies the managed zone addressed by this request.
    maxResults: Optional. Maximum number of results to be returned. If
      unspecified, the server will decide how many results to return.
    pageToken: Optional. A tag returned by a previous list request that was
      truncated. Use this parameter to continue a previous list request.
    project: Identifies the project addressed by this request.
    sortBy: Sorting criterion. The only supported values are START_TIME and
      ID.
  """

  class SortByValueValuesEnum(_messages.Enum):
    r"""Sorting criterion. The only supported values are START_TIME and ID.

    Values:
      id: <no description>
      startTime: <no description>
    """
    id = 0
    startTime = 1

  managedZone = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)
  sortBy = _messages.EnumField('SortByValueValuesEnum', 5, default=u'startTime')


class DnsManagedZonesCreateRequest(_messages.Message):
  r"""A DnsManagedZonesCreateRequest object.

  Fields:
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    managedZone: A ManagedZone resource to be passed as the request body.
    project: Identifies the project addressed by this request.
  """

  clientOperationId = _messages.StringField(1)
  managedZone = _messages.MessageField('ManagedZone', 2)
  project = _messages.StringField(3, required=True)


class DnsManagedZonesDeleteRequest(_messages.Message):
  r"""A DnsManagedZonesDeleteRequest object.

  Fields:
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    project: Identifies the project addressed by this request.
  """

  clientOperationId = _messages.StringField(1)
  managedZone = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class DnsManagedZonesDeleteResponse(_messages.Message):
  r"""An empty DnsManagedZonesDelete response."""


class DnsManagedZonesGetRequest(_messages.Message):
  r"""A DnsManagedZonesGetRequest object.

  Fields:
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    project: Identifies the project addressed by this request.
  """

  clientOperationId = _messages.StringField(1)
  managedZone = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class DnsManagedZonesListRequest(_messages.Message):
  r"""A DnsManagedZonesListRequest object.

  Fields:
    dnsName: Restricts the list to return only zones with this domain name.
    maxResults: Optional. Maximum number of results to be returned. If
      unspecified, the server will decide how many results to return.
    pageToken: Optional. A tag returned by a previous list request that was
      truncated. Use this parameter to continue a previous list request.
    project: Identifies the project addressed by this request.
  """

  dnsName = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class DnsManagedZonesPatchRequest(_messages.Message):
  r"""A DnsManagedZonesPatchRequest object.

  Fields:
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    managedZoneResource: A ManagedZone resource to be passed as the request
      body.
    project: Identifies the project addressed by this request.
  """

  clientOperationId = _messages.StringField(1)
  managedZone = _messages.StringField(2, required=True)
  managedZoneResource = _messages.MessageField('ManagedZone', 3)
  project = _messages.StringField(4, required=True)


class DnsManagedZonesUpdateRequest(_messages.Message):
  r"""A DnsManagedZonesUpdateRequest object.

  Fields:
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    managedZoneResource: A ManagedZone resource to be passed as the request
      body.
    project: Identifies the project addressed by this request.
  """

  clientOperationId = _messages.StringField(1)
  managedZone = _messages.StringField(2, required=True)
  managedZoneResource = _messages.MessageField('ManagedZone', 3)
  project = _messages.StringField(4, required=True)


class DnsProjectsGetRequest(_messages.Message):
  r"""A DnsProjectsGetRequest object.

  Fields:
    clientOperationId: For mutating operation requests only. An optional
      identifier specified by the client. Must be unique for operation
      resources in the Operations collection.
    project: Identifies the project addressed by this request.
  """

  clientOperationId = _messages.StringField(1)
  project = _messages.StringField(2, required=True)


class DnsResourceRecordSetsListRequest(_messages.Message):
  r"""A DnsResourceRecordSetsListRequest object.

  Fields:
    managedZone: Identifies the managed zone addressed by this request. Can be
      the managed zone name or id.
    maxResults: Optional. Maximum number of results to be returned. If
      unspecified, the server will decide how many results to return.
    name: Restricts the list to return only records with this fully qualified
      domain name.
    pageToken: Optional. A tag returned by a previous list request that was
      truncated. Use this parameter to continue a previous list request.
    project: Identifies the project addressed by this request.
    type: Restricts the list to return only records of this type. If present,
      the "name" parameter must also be present.
  """

  managedZone = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  name = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  type = _messages.StringField(6)


class ManagedZone(_messages.Message):
  r"""A zone is a subtree of the DNS namespace under one administrative
  responsibility. A ManagedZone is a resource that represents a DNS zone
  hosted by the Cloud DNS service.

  Messages:
    LabelsValue: User labels.

  Fields:
    creationTime: The time that this resource was created on the server. This
      is in RFC3339 text format. Output only.
    description: A mutable string of at most 1024 characters associated with
      this resource for the user's convenience. Has no effect on the managed
      zone's function.
    dnsName: The DNS name of this managed zone, for instance "example.com.".
    dnssecConfig: DNSSEC configuration.
    id: Unique identifier for the resource; defined by the server (output
      only)
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#managedZone".
    labels: User labels.
    name: User assigned name for this resource. Must be unique within the
      project. The name must be 1-63 characters long, must begin with a
      letter, end with a letter or digit, and only contain lowercase letters,
      digits or dashes.
    nameServerSet: Optionally specifies the NameServerSet for this
      ManagedZone. A NameServerSet is a set of DNS name servers that all host
      the same ManagedZones. Most users will leave this field unset.
    nameServers: Delegate your managed_zone to these virtual name servers;
      defined by the server (output only)
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  creationTime = _messages.StringField(1)
  description = _messages.StringField(2)
  dnsName = _messages.StringField(3)
  dnssecConfig = _messages.MessageField('ManagedZoneDnsSecConfig', 4)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(6, default=u'dns#managedZone')
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  nameServerSet = _messages.StringField(9)
  nameServers = _messages.StringField(10, repeated=True)


class ManagedZoneDnsSecConfig(_messages.Message):
  r"""A ManagedZoneDnsSecConfig object.

  Enums:
    NonExistenceValueValuesEnum: Specifies the mechanism used to provide
      authenticated denial-of-existence responses. Output only while state is
      not OFF.
    StateValueValuesEnum: Specifies whether DNSSEC is enabled, and what mode
      it is in.

  Fields:
    defaultKeySpecs: Specifies parameters that will be used for generating
      initial DnsKeys for this ManagedZone. Output only while state is not
      OFF.
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#managedZoneDnsSecConfig".
    nonExistence: Specifies the mechanism used to provide authenticated
      denial-of-existence responses. Output only while state is not OFF.
    state: Specifies whether DNSSEC is enabled, and what mode it is in.
  """

  class NonExistenceValueValuesEnum(_messages.Enum):
    r"""Specifies the mechanism used to provide authenticated denial-of-
    existence responses. Output only while state is not OFF.

    Values:
      nsec: <no description>
      nsec3: <no description>
    """
    nsec = 0
    nsec3 = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""Specifies whether DNSSEC is enabled, and what mode it is in.

    Values:
      off: <no description>
      on: <no description>
      transfer: <no description>
    """
    off = 0
    on = 1
    transfer = 2

  defaultKeySpecs = _messages.MessageField('DnsKeySpec', 1, repeated=True)
  kind = _messages.StringField(2, default=u'dns#managedZoneDnsSecConfig')
  nonExistence = _messages.EnumField('NonExistenceValueValuesEnum', 3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class ManagedZoneOperationsListResponse(_messages.Message):
  r"""A ManagedZoneOperationsListResponse object.

  Fields:
    header: A ResponseHeader attribute.
    kind: Type of resource.
    nextPageToken: The presence of this field indicates that there exist more
      results following your last page of results in pagination order. To
      fetch them, make another list request using this value as your page
      token.  In this way you can retrieve the complete contents of even very
      large collections one page at a time. However, if the contents of the
      collection change between the first and last paginated list request, the
      set of all elements returned will be an inconsistent view of the
      collection. There is no way to retrieve a consistent snapshot of a
      collection larger than the maximum page size.
    operations: The operation resources.
  """

  header = _messages.MessageField('ResponseHeader', 1)
  kind = _messages.StringField(2, default=u'dns#managedZoneOperationsListResponse')
  nextPageToken = _messages.StringField(3)
  operations = _messages.MessageField('Operation', 4, repeated=True)


class ManagedZonesListResponse(_messages.Message):
  r"""A ManagedZonesListResponse object.

  Fields:
    header: A ResponseHeader attribute.
    kind: Type of resource.
    managedZones: The managed zone resources.
    nextPageToken: The presence of this field indicates that there exist more
      results following your last page of results in pagination order. To
      fetch them, make another list request using this value as your page
      token.  In this way you can retrieve the complete contents of even very
      large collections one page at a time. However, if the contents of the
      collection change between the first and last paginated list request, the
      set of all elements returned will be an inconsistent view of the
      collection. There is no way to retrieve a consistent snapshot of a
      collection larger than the maximum page size.
  """

  header = _messages.MessageField('ResponseHeader', 1)
  kind = _messages.StringField(2, default=u'dns#managedZonesListResponse')
  managedZones = _messages.MessageField('ManagedZone', 3, repeated=True)
  nextPageToken = _messages.StringField(4)


class Operation(_messages.Message):
  r"""An operation represents a successful mutation performed on a Cloud DNS
  resource. Operations provide: - An audit log of server resource mutations. -
  A way to recover/retry API calls in the case where the response is never
  received by the caller. Use the caller specified client_operation_id.

  Enums:
    StatusValueValuesEnum: Status of the operation. Can be one of the
      following: "PENDING" or "DONE" (output only).

  Fields:
    dnsKeyContext: Only populated if the operation targeted a DnsKey (output
      only).
    id: Unique identifier for the resource. This is the client_operation_id if
      the client specified it when the mutation was initiated, otherwise, it
      is generated by the server. The name must be 1-63 characters long and
      match the regular expression [-a-z0-9]? (output only)
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#operation".
    startTime: The time that this operation was started by the server. This is
      in RFC3339 text format (output only).
    status: Status of the operation. Can be one of the following: "PENDING" or
      "DONE" (output only).
    type: Type of the operation. Operations include insert, update, and delete
      (output only).
    user: User who requested the operation, for example: user@example.com.
      cloud-dns-system for operations automatically done by the system.
      (output only)
    zoneContext: Only populated if the operation targeted a ManagedZone
      (output only).
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of the operation. Can be one of the following: "PENDING" or
    "DONE" (output only).

    Values:
      done: <no description>
      pending: <no description>
    """
    done = 0
    pending = 1

  dnsKeyContext = _messages.MessageField('OperationDnsKeyContext', 1)
  id = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'dns#operation')
  startTime = _messages.StringField(4)
  status = _messages.EnumField('StatusValueValuesEnum', 5)
  type = _messages.StringField(6)
  user = _messages.StringField(7)
  zoneContext = _messages.MessageField('OperationManagedZoneContext', 8)


class OperationDnsKeyContext(_messages.Message):
  r"""A OperationDnsKeyContext object.

  Fields:
    newValue: The post-operation DnsKey resource.
    oldValue: The pre-operation DnsKey resource.
  """

  newValue = _messages.MessageField('DnsKey', 1)
  oldValue = _messages.MessageField('DnsKey', 2)


class OperationManagedZoneContext(_messages.Message):
  r"""A OperationManagedZoneContext object.

  Fields:
    newValue: The post-operation ManagedZone resource.
    oldValue: The pre-operation ManagedZone resource.
  """

  newValue = _messages.MessageField('ManagedZone', 1)
  oldValue = _messages.MessageField('ManagedZone', 2)


class Project(_messages.Message):
  r"""A project resource. The project is a top level container for resources
  including Cloud DNS ManagedZones. Projects can be created only in the APIs
  console.

  Fields:
    id: User assigned unique identifier for the resource (output only).
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#project".
    number: Unique numeric identifier for the resource; defined by the server
      (output only).
    quota: Quotas assigned to this project (output only).
  """

  id = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'dns#project')
  number = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  quota = _messages.MessageField('Quota', 4)


class Quota(_messages.Message):
  r"""Limits associated with a Project.

  Fields:
    dnsKeysPerManagedZone: Maximum allowed number of DnsKeys per ManagedZone.
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#quota".
    managedZones: Maximum allowed number of managed zones in the project.
    resourceRecordsPerRrset: Maximum allowed number of ResourceRecords per
      ResourceRecordSet.
    rrsetAdditionsPerChange: Maximum allowed number of ResourceRecordSets to
      add per ChangesCreateRequest.
    rrsetDeletionsPerChange: Maximum allowed number of ResourceRecordSets to
      delete per ChangesCreateRequest.
    rrsetsPerManagedZone: Maximum allowed number of ResourceRecordSets per
      zone in the project.
    totalRrdataSizePerChange: Maximum allowed size for total rrdata in one
      ChangesCreateRequest in bytes.
    whitelistedKeySpecs: DNSSEC algorithm and key length types that can be
      used for DnsKeys.
  """

  dnsKeysPerManagedZone = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  kind = _messages.StringField(2, default=u'dns#quota')
  managedZones = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourceRecordsPerRrset = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  rrsetAdditionsPerChange = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  rrsetDeletionsPerChange = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  rrsetsPerManagedZone = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  totalRrdataSizePerChange = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  whitelistedKeySpecs = _messages.MessageField('DnsKeySpec', 9, repeated=True)


class ResourceRecordSet(_messages.Message):
  r"""A unit of data that will be returned by the DNS servers.

  Fields:
    kind: Identifies what kind of resource this is. Value: the fixed string
      "dns#resourceRecordSet".
    name: For example, www.example.com.
    rrdatas: As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
    signatureRrdatas: As defined in RFC 4034 (section 3.2).
    ttl: Number of seconds that this ResourceRecordSet can be cached by
      resolvers.
    type: The identifier of a supported record type, for example, A, AAAA, MX,
      TXT, and so on.
  """

  kind = _messages.StringField(1, default=u'dns#resourceRecordSet')
  name = _messages.StringField(2)
  rrdatas = _messages.StringField(3, repeated=True)
  signatureRrdatas = _messages.StringField(4, repeated=True)
  ttl = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  type = _messages.StringField(6)


class ResourceRecordSetsListResponse(_messages.Message):
  r"""A ResourceRecordSetsListResponse object.

  Fields:
    header: A ResponseHeader attribute.
    kind: Type of resource.
    nextPageToken: The presence of this field indicates that there exist more
      results following your last page of results in pagination order. To
      fetch them, make another list request using this value as your
      pagination token.  In this way you can retrieve the complete contents of
      even very large collections one page at a time. However, if the contents
      of the collection change between the first and last paginated list
      request, the set of all elements returned will be an inconsistent view
      of the collection. There is no way to retrieve a consistent snapshot of
      a collection larger than the maximum page size.
    rrsets: The resource record set resources.
  """

  header = _messages.MessageField('ResponseHeader', 1)
  kind = _messages.StringField(2, default=u'dns#resourceRecordSetsListResponse')
  nextPageToken = _messages.StringField(3)
  rrsets = _messages.MessageField('ResourceRecordSet', 4, repeated=True)


class ResponseHeader(_messages.Message):
  r"""Elements common to every response.

  Fields:
    operationId: For mutating operation requests that completed successfully.
      This is the client_operation_id if the client specified it, otherwise it
      is generated by the server (output only).
  """

  operationId = _messages.StringField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: An opaque string that represents a user for quota purposes.
      Must not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: Deprecated. Please use quotaUser instead.
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


