---
slug: /contributing/
sidebar_position: 11
---

# Помощь проекту

Любой вклад в Task очень приветствуется, но мы просим вас прочитать этот документ, прежде чем отправлять pull request(PR).

:::note

Этот документ относится к основному репозиторию [Task][task] _и_ [ Task for Visual Studio Code][vscode-task]

:::

## Введение

- **Текущее состояние разработки** - Проверьте уже открытые PR. Есть ли открытые "issues", обсуждающие особенности/изменения, которые вы хотите выполнить? Пожалуйста, убедитесь, что вы учитываете результаты этих обсуждений в своей работе.
- **Обратная совместимость** - Повлияют ли ваши изменения на уже существующие TaskFile'ы? Скорее всего, ваше изменение будет применено, если оно обладает обратной совместимостью. Существует ли подход, который вы можете использовать для поддержания обратной совместимости? Если нет, откройте проблему(Вот тут ["Issues"](https://github.com/go-task/task/issues)), чтобы изменения API могли быть обсуждены до того, как вы потратите своё время на PR.
- **Experiments** - If there is no way to make your change backward compatible then there is a procedure to introduce breaking changes into minor versions. We call these "\[experiments\]\[experiments\]". If you're intending to work on an experiment, then please read the \[experiments workflow\]\[experiments-workflow\] document carefully and submit a proposal first.

## 1. Настройка

- **Go** - Task написан на [Go][go]. Мы всегда поддерживаем две последних основных версий Go, поэтому убедитесь, что у вас установлена актуальная версия.
- **Node.js** - [Node.js][nodejs] используется для хостинга сервера документации Task и требуется для локального запуска этого сервера. Node.js также необходим для того, чтобы внести свой вклад в расширение Visual Studio Code.
- **Yarn** - [Yarn][yarn] является менеджером пакетов Node.js, используемым в Task.

## 2. Внести изменения

- **Code style** - Настоятельно рекомендуем поддерживать существующий стиль кода по мере возможности. Код должен быть отформатирован [`gofumpt`][gofumpt] и проверен [`golangci-lint`][golangci-lint] линтером. Любые файлы Markdown или TypeScript должны быть отформатированы с помощью [Prettier][prettier]. Стиль кода внедряется нашим CI для обеспечения того, чтобы у всех был одинаковый стиль кода в рамках проекта. Вы можете использовать команду `task lint` для локальной проверки линтером и `task lint:fix` для автоматического исправления любых обнаруженных проблем.
- **Документация** - Убедитесь, что вы добавляете/обновляете любую соответствующую документацию. Секцию [обновления документации](#updating-documentation) можно увидеть ниже.
- **Тесты** - Убедитесь, что вы добавляете/обновляете любые релевантные тесты и что все тесты проходят перед отправкой PR. Секцию [написание тестов](#writing-tests) можно увидеть ниже.

### Запуск ваших изменений

Чтобы запустить Task с рабочими изменениями, используйте `go run ./cmd/task`. Для запуска тестовой сборки задачи с Taskfile в `testdata`, вы можете использовать `go run ./cmd/task --dir ./testdata/<my_test_dir> <task_name>`.

Для запуска Task для Visual Studio кода, вы можете открыть проект в VSCode и нажать F5 (или любую другую клавишу, к которой вы привязали функцию отладки). Это откроет новое окно VSCode с запущенным расширением. Мы рекомендуем использовать функцию отладки, так как это позволит вам задать точки останова. Также вы можете запустить пакет задач `task package` для генерации `.vsix` файла, который может быть использован для ручной установки расширения.

### Обновление документации

Task использует [Docusaurus][docusaurus] для размещения сервера документации. Код для неё находится в основном Task репозитории. Документация может быть настроена и запущена локально с помощью `task docs` (требуется установка `nodejs` & `yarn`). Все содержимое написано в Markdown и находится в директории `docs/docs`. Все документы Markdown должны иметь максимальную длину строки 80 символов (этого требует Prettier).

При внесении изменений подумайте, является ли необходимым изменение [Руководства по использованию](./usage.md). Этот документ содержит описания и примеры использования Task функций. Если вы добавляете новую функцию, попробуйте найти подходящее место для добавления новой секции. Если вы обновляете существующую функцию, убедитесь, что документация и любые примеры актуальны. Убедитесь, что любые примеры следуют [Taskfile Styleguide](./styleguide.md).

Если вы добавили новое поле, команду или флаг, убедитесь, что вы добавляете его в [Справочник API](./api_reference.md). Новые поля также необходимо добавить в [JSON][json-schema] схему. Описания полей в справочнике API и JSON схеме должны совпадать.

### Написание тестов

Тесты расположены в файле `task_test.go` в корневом каталоге, рекомендуем добавлять новые тесты именно в него. Большинство этих тестов также имеют поддиректорию в `testdata`, где хранятся любые Taskfiles/данные, необходимые для запуска тестов.

При внесении изменений подумайте о необходимости новых тестов. Эти тесты должны гарантировать, что функционал, который вы добавили, продолжит работу в будущем. Существующие тесты также могут потребовать обновления, если вы изменили поведение Task.

Вы также можете добавить модульный тест для любых новых функций, которые добавляете. Модульные тесты должны следовать Go соглашению о местоположении в файле `*_test.o` в том же пакете, что и тестируемый код.

## 3. Внесение кода

Попробуйте написать содержательное сообщение к коммиту и не иметь слишком много коммитов в PR. Большинство PR, желательно, должны иметь один коммит (хотя для больших PR может быть разумным разделить его несколько коммитов). Используйте git squash и rebase!

Если вы не уверены, как отформатировать ваше сообщение, проверьте [Соглашение о коммитах][conventional-commits]. Этот стиль не используется в проекте, но это хороший способ сделать ваше сообщение для коммита более читаемым и последовательным.

## 4. Отправка PR

- **Опишите ваши изменения** - Убедитесь, что вы предоставили подробное описание ваших изменений.
- **Issue/PR ссылки** - Укажите ссылки на предыдущую работу, которая связанна с вашим PR. Пожалуйста, опишите, как ваши изменения изменяют или расширяют эту работу.
- **Примеры** - Добавьте любые примеры или скриншоты, которые демонстрируют ваши изменения.
- **Черновик PRs** - Если ваши изменения не закончены, но вы хотели бы обсудить их, открыть PR как черновик и добавьте комментарии, чтобы начать обсуждение. Использование комментариев, а не PR описания позволяет обновить описание позже при сохранении любых обсуждений.

## Ответы на вопросы

> Я хочу внести свой вклад, с чего начать?

Ознакомьтесь со списком [open issues for Task][task-open-issues] или [Task for Visual Studio Code][vscode-task-open-issues]. У нас есть лейбл [good first issue][good-first-issue] для простейших проблем, который идеально подходит для контрибьюторов, который первых вносят свой вклад.

Приветствуются всевозможные вклады, будь то маленький фикс или новая функция. Вы также можете внести свой вклад, комментируя вопросы, помогая ответить на вопросы или внести вклад в другие [проекты сообщества](./community.md).

> Где можно получить помощь?

Если у вас есть вопросы, не стесняйтесь спросить их в канале `#help` на нашем [Discord сервере][discord-server] или откройте [Discussion][discussion] на GitHub.

---

<!-- prettier-ignore-start -->

<!-- prettier-ignore-end -->
[task]: https://github.com/go-task/task
[vscode-task]: https://github.com/go-task/vscode-task
[go]: https://go.dev
[gofumpt]: https://github.com/mvdan/gofumpt
[golangci-lint]: https://golangci-lint.run
[prettier]: https://prettier.io
[nodejs]: https://nodejs.org/en/
[yarn]: https://yarnpkg.com/
[docusaurus]: https://docusaurus.io
[json-schema]: https://github.com/go-task/task/blob/main/docs/static/schema.json
[task-open-issues]: https://github.com/go-task/task/issues
[vscode-task-open-issues]: https://github.com/go-task/vscode-task/issues
[good-first-issue]: https://github.com/go-task/task/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22
[discord-server]: https://discord.gg/6TY36E39UK
[discussion]: https://github.com/go-task/task/discussions
[conventional-commits]: https://www.conventionalcommits.org
