<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw dedibox`
Dedibox Phoenix API.
  
- [Billing commands](#billing-commands)
  - [Download-invoice dedibox resources](#download-invoice-dedibox-resources)
  - [Download-refund dedibox resources](#download-refund-dedibox-resources)
  - [Get-invoice dedibox resources](#get-invoice-dedibox-resources)
  - [Get-order-capacity dedibox resources](#get-order-capacity-dedibox-resources)
  - [Get-refund dedibox resources](#get-refund-dedibox-resources)
  - [List-invoice dedibox resources](#list-invoice-dedibox-resources)
  - [List-refund dedibox resources](#list-refund-dedibox-resources)
- [BMC (Baseboard Management Controller) access commands](#bmc-(baseboard-management-controller)-access-commands)
  - [Get BMC (Baseboard Management Controller) access for a given baremetal server](#get-bmc-(baseboard-management-controller)-access-for-a-given-baremetal-server)
  - [Start BMC (Baseboard Management Controller) access for a given baremetal server](#start-bmc-(baseboard-management-controller)-access-for-a-given-baremetal-server)
  - [Stop BMC (Baseboard Management Controller) access for a given baremetal server](#stop-bmc-(baseboard-management-controller)-access-for-a-given-baremetal-server)
- [Failover IPs commands](#failover-ips-commands)
  - [Attach failovers on baremetal server](#attach-failovers-on-baremetal-server)
  - [Attach a failover IP to a MAC address](#attach-a-failover-ip-to-a-mac-address)
  - [Order failover IPs](#order-failover-ips)
  - [Delete a failover server](#delete-a-failover-server)
  - [Detach failovers on baremetal server](#detach-failovers-on-baremetal-server)
  - [Detach a failover IP from a MAC address](#detach-a-failover-ip-from-a-mac-address)
  - [Get a specific baremetal server](#get-a-specific-baremetal-server)
  - [Get remaining quota](#get-remaining-quota)
  - [List failovers for project](#list-failovers-for-project)
- [IPv6 block commands](#ipv6-block-commands)
  - [Create IPv6 block for baremetal server](#create-ipv6-block-for-baremetal-server)
  - [Create IPv6 block subnet](#create-ipv6-block-subnet)
  - [Delete IPv6 block](#delete-ipv6-block)
  - [Get a specific IPv6 block](#get-a-specific-ipv6-block)
  - [Get IPv6 block quota](#get-ipv6-block-quota)
  - [List available IPv6 block subnets](#list-available-ipv6-block-subnets)
  - [Update IPv6 block](#update-ipv6-block)
- [Offer commands](#offer-commands)
  - [Get offer](#get-offer)
  - [List offers](#list-offers)
- [Subscribable server options commands](#subscribable-server-options-commands)
  - [List subscribable server options](#list-subscribable-server-options)
  - [Subscribe server option](#subscribe-server-option)
  - [Subscribe storage server option](#subscribe-storage-server-option)
- [OS commands](#os-commands)
  - [Get an OS with a given ID](#get-an-os-with-a-given-id)
  - [List all available OS that can be install on a baremetal server](#list-all-available-os-that-can-be-install-on-a-baremetal-server)
- [RAID commands](#raid-commands)
  - [Get raid](#get-raid)
  - [Update RAID](#update-raid)
- [Rescue commands](#rescue-commands)
  - [Get rescue information](#get-rescue-information)
  - [Start in rescue baremetal server](#start-in-rescue-baremetal-server)
  - [Stop rescue on baremetal server](#stop-rescue-on-baremetal-server)
- [Reverse-IP commands](#reverse-ip-commands)
  - [Update reverse of ip](#update-reverse-of-ip)
- [RPN's information commands](#rpn's-information-commands)
  - [Get dedibox resources](#get-dedibox-resources)
  - [List dedibox resources](#list-dedibox-resources)
- [RPN V1 commands](#rpn-v1-commands)
  - [Accept-invite dedibox resources](#accept-invite-dedibox-resources)
  - [Add-members dedibox resources](#add-members-dedibox-resources)
  - [Create dedibox resources](#create-dedibox-resources)
  - [Delete dedibox resources](#delete-dedibox-resources)
  - [Delete-members dedibox resources](#delete-members-dedibox-resources)
  - [Get dedibox resources](#get-dedibox-resources)
  - [Invite dedibox resources](#invite-dedibox-resources)
  - [Leave dedibox resources](#leave-dedibox-resources)
  - [List dedibox resources](#list-dedibox-resources)
  - [List-capable-san-server dedibox resources](#list-capable-san-server-dedibox-resources)
  - [List-capable-server dedibox resources](#list-capable-server-dedibox-resources)
  - [List-invites dedibox resources](#list-invites-dedibox-resources)
  - [List-members dedibox resources](#list-members-dedibox-resources)
  - [Refuse-invite dedibox resources](#refuse-invite-dedibox-resources)
  - [Update dedibox resources](#update-dedibox-resources)
- [](#)
  - [Add-members dedibox resources](#add-members-dedibox-resources)
  - [Create dedibox resources](#create-dedibox-resources)
  - [Delete dedibox resources](#delete-dedibox-resources)
  - [Delete-members dedibox resources](#delete-members-dedibox-resources)
  - [Disable-compatibility dedibox resources](#disable-compatibility-dedibox-resources)
  - [Enable-compatibility dedibox resources](#enable-compatibility-dedibox-resources)
  - [Get dedibox resources](#get-dedibox-resources)
  - [List dedibox resources](#list-dedibox-resources)
  - [List-capable-resources dedibox resources](#list-capable-resources-dedibox-resources)
  - [List-logs dedibox resources](#list-logs-dedibox-resources)
  - [List-members dedibox resources](#list-members-dedibox-resources)
  - [Update dedibox resources](#update-dedibox-resources)
  - [Update-vlan-members dedibox resources](#update-vlan-members-dedibox-resources)
- [RPN SAN (Storage Area Network) commands](#rpn-san-(storage-area-network)-commands)
  - [Add-ip dedibox resources](#add-ip-dedibox-resources)
  - [Create dedibox resources](#create-dedibox-resources)
  - [Delete dedibox resources](#delete-dedibox-resources)
  - [Get dedibox resources](#get-dedibox-resources)
  - [List dedibox resources](#list-dedibox-resources)
  - [List-available-ips dedibox resources](#list-available-ips-dedibox-resources)
  - [List-ips dedibox resources](#list-ips-dedibox-resources)
  - [Remove-ip dedibox resources](#remove-ip-dedibox-resources)
- [Baremetal server commands](#baremetal-server-commands)
  - [Cancels the current (running) server installation](#cancels-the-current-(running)-server-installation)
  - [Create a baremetal server](#create-a-baremetal-server)
  - [Delete a baremetal server](#delete-a-baremetal-server)
  - [Get a specific baremetal server](#get-a-specific-baremetal-server)
  - [Get a specific server installation status](#get-a-specific-server-installation-status)
  - [Get server default partitioning](#get-server-default-partitioning)
  - [Install a baremetal server](#install-a-baremetal-server)
  - [List baremetal servers for project](#list-baremetal-servers-for-project)
  - [List server disks](#list-server-disks)
  - [List server events](#list-server-events)
  - [Reboot a baremetal server](#reboot-a-baremetal-server)
  - [Start a baremetal server](#start-a-baremetal-server)
  - [Stop a baremetal server](#stop-a-baremetal-server)
  - [Update a baremetal server](#update-a-baremetal-server)
- [Service commands](#service-commands)
  - [Delete a specific service](#delete-a-specific-service)
  - [Get a specific service](#get-a-specific-service)
  - [List services](#list-services)

  
## Billing commands

Billing commands.


### Download-invoice dedibox resources

Download-invoice dedibox resources.

**Usage:**

```
scw dedibox billing download-invoice [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| invoice-id | Required |  |



### Download-refund dedibox resources

Download-refund dedibox resources.

**Usage:**

```
scw dedibox billing download-refund [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| refund-id | Required |  |



### Get-invoice dedibox resources

Get-invoice dedibox resources.

**Usage:**

```
scw dedibox billing get-invoice [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| invoice-id | Required |  |



### Get-order-capacity dedibox resources

Get-order-capacity dedibox resources.

**Usage:**

```
scw dedibox billing get-order-capacity [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Get-refund dedibox resources

Get-refund dedibox resources.

**Usage:**

```
scw dedibox billing get-refund [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| refund-id | Required |  |



### List-invoice dedibox resources

List-invoice dedibox resources.

**Usage:**

```
scw dedibox billing list-invoice [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| project-id | Default: `<retrieved from config>` |  |



### List-refund dedibox resources

List-refund dedibox resources.

**Usage:**

```
scw dedibox billing list-refund [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| project-id | Default: `<retrieved from config>` |  |



## BMC (Baseboard Management Controller) access commands

BMC (Baseboard Management Controller) access commands.


### Get BMC (Baseboard Management Controller) access for a given baremetal server

Get the BMC (Baseboard Management Controller) access associated with the given ID.

**Usage:**

```
scw dedibox bmc get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to get BMC access |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Start BMC (Baseboard Management Controller) access for a given baremetal server

Start BMC (Baseboard Management Controller) access associated with the given ID.
The BMC (Baseboard Management Controller) access is available one hour after the installation of the server.

**Usage:**

```
scw dedibox bmc start [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to start the BMC access |
| ip |  | The IP authorized to connect to the given server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Stop BMC (Baseboard Management Controller) access for a given baremetal server

Stop BMC (Baseboard Management Controller) access associated with the given ID.

**Usage:**

```
scw dedibox bmc stop [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to stop BMC access |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## Failover IPs commands

Failover IPs commands.


### Attach failovers on baremetal server

Attach failovers on the server associated with the given ID.

**Usage:**

```
scw dedibox fip attach [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id |  | ID of the server |
| fips-ids.{index} | Required | List of ID of failovers IP to attach |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Attach a failover IP to a MAC address

Attach a failover IP to a MAC address.

**Usage:**

```
scw dedibox fip attach-mac [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | ID of the failover IP |
| type | One of: `mac_type_unknown`, `vmware`, `kvm`, `xen` | A mac type |
| mac |  | A valid mac address (existing or not) |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Order failover IPs

Order X failover IPs.

**Usage:**

```
scw dedibox fip create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id |  | Failover IP offer ID |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| quantity |  | Quantity |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Delete a failover server

Delete the failover associated with the given ID.

**Usage:**

```
scw dedibox fip delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | ID of the failover IP to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Detach failovers on baremetal server

Detach failovers on the server associated with the given ID.

**Usage:**

```
scw dedibox fip detach [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fips-ids.{index} | Required | List of IDs of failovers IP to detach |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Detach a failover IP from a MAC address

Detach a failover IP from a MAC address.

**Usage:**

```
scw dedibox fip detach-mac [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | ID of the failover IP |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get a specific baremetal server

Get the server associated with the given ID.

**Usage:**

```
scw dedibox fip get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | ID of the failover IP |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get remaining quota

Get remaining quota.

**Usage:**

```
scw dedibox fip get-quota [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Default: `<retrieved from config>` | Project ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### List failovers for project

List failovers servers for project.

**Usage:**

```
scw dedibox fip list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `ip_asc`, `ip_desc` | Order of the failovers IP |
| project-id | Required<br />Default: `<retrieved from config>` | Filter failovers IP by project ID |
| search |  | Filter failovers IP which matching with this field |
| only-available |  | True: return all failovers IP not attached on server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



## IPv6 block commands

IPv6 block commands.


### Create IPv6 block for baremetal server

Create IPv6 block associated with the given project ID.

**Usage:**

```
scw dedibox ipv6-block create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Default: `<retrieved from config>` | ID of the project |



### Create IPv6 block subnet

Create IPv6 block subnet for the given IP ID.
/48 could create subnet in /56 (quota link to your number of server).
/56 could create subnet in /64 (quota link to your number of failover IP).

**Usage:**

```
scw dedibox ipv6-block create-subnet [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| block-id | Required | ID of the IPv6 block |
| address |  | Address of the IPv6 |
| cidr |  | Classless InterDomain Routing notation of the IPv6 |



### Delete IPv6 block

Delete IPv6 block subnet with the given ID.

**Usage:**

```
scw dedibox ipv6-block delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| block-id | Required | ID of the IPv6 block to delete |



### Get a specific IPv6 block

Get the IPv6 block associated with the given ID.

**Usage:**

```
scw dedibox ipv6-block get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Default: `<retrieved from config>` | ID of the project |



### Get IPv6 block quota

Get IPv6 block quota with the given project ID.
/48 one per organization.
/56 link to your number of server.
/64 link to your number of failover IP.

**Usage:**

```
scw dedibox ipv6-block get-quota [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Default: `<retrieved from config>` | ID of the project |



### List available IPv6 block subnets

List all available IPv6 block subnets for given IP ID.

**Usage:**

```
scw dedibox ipv6-block list-subnet [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| block-id | Required | ID of the IPv6 block |



### Update IPv6 block

Update DNS associated to IPv6 block.
If DNS is used, minimum of 2 is necessary and maximum of 5 (no duplicate).

**Usage:**

```
scw dedibox ipv6-block update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| block-id | Required | ID of the IPv6 block |
| nameservers.{index} |  | DNS to link to the IPv6 |



## Offer commands

Offer commands.


### Get offer

Return specific offer for the given ID.

**Usage:**

```
scw dedibox offer get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id | Required | ID of offer |
| project-id | Default: `<retrieved from config>` | Project ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### List offers

List all available server offers.

**Usage:**

```
scw dedibox offer list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `price_asc`, `price_desc` | Order of the offers |
| commercial-range |  | Filter on commercial range |
| catalog | One of: `all`, `default`, `beta`, `reseller`, `premium`, `volume`, `admin`, `inactive` | Filter on catalog |
| project-id | Default: `<retrieved from config>` | Project ID |
| is-failover-ip |  | Get the current failover IP offer |
| is-failover-block |  | Get the current failover IP block offer |
| sold-in |  | Filter offers depending on their datacenter |
| available-only |  | Set this filter to true to only return available offers |
| is-rpn-san |  | Get the RPN SAN offers |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



## Subscribable server options commands

Subscribable server options commands.


### List subscribable server options

List subscribable options associated to the given server ID.

**Usage:**

```
scw dedibox option list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID of the subscribable server options |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



### Subscribe server option

Subscribe option for the given server ID.

**Usage:**

```
scw dedibox option subscribe [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to subscribe server option |
| option-id |  | Option ID to subscribe |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Subscribe storage server option

Subscribe storage option for the given server ID.

**Usage:**

```
scw dedibox option subscribe-storage [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID of the storage options to subscribe |
| options-ids.{index} | Required | Option IDs of the storage options to subscribe |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## OS commands

OS commands.


### Get an OS with a given ID

Return specific OS for the given ID.

**Usage:**

```
scw dedibox os get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| os-id | Required | ID of the OS |
| server-id |  | ID of the server |
| project-id | Default: `<retrieved from config>` | Project ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### List all available OS that can be install on a baremetal server

List all available OS that can be install on a baremetal server.

**Usage:**

```
scw dedibox os list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `released_at_asc`, `released_at_desc` | Order of the OS |
| type | One of: `unknown_type`, `server`, `virtu`, `panel`, `desktop`, `custom`, `rescue` | Type of the OS |
| server-id |  | Filter OS by compatible server ID |
| project-id | Default: `<retrieved from config>` | Project ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



## RAID commands

RAID commands.


### Get raid

Return raid for the given server ID.

**Usage:**

```
scw dedibox raid get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Update RAID

Update RAID associated with the given server ID.

**Usage:**

```
scw dedibox raid update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| raid-arrays.{index}.raid-level | One of: `no_raid`, `raid0`, `raid1`, `raid5`, `raid6`, `raid10` | The RAID level |
| raid-arrays.{index}.disk-ids.{index} | Required | The list of Disk ID of the updatable RAID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## Rescue commands

Rescue commands.


### Get rescue information

Return rescue information for the given server ID.

**Usage:**

```
scw dedibox rescue get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to get rescue |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Start in rescue baremetal server

Start in rescue the server associated with the given ID.

**Usage:**

```
scw dedibox rescue start [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to start rescue |
| os-id |  | OS ID to use to start rescue |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Stop rescue on baremetal server

Stop rescue on the server associated with the given ID.

**Usage:**

```
scw dedibox rescue stop [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to stop rescue |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## Reverse-IP commands

Reverse-IP commands.


### Update reverse of ip

Update reverse of ip associated with the given ID.

**Usage:**

```
scw dedibox reverse-ip update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ip-id | Required | ID of the IP |
| reverse |  | Reverse to apply on the IP |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## RPN's information commands

RPN's information commands.


### Get dedibox resources

Get dedibox resources.

**Usage:**

```
scw dedibox rpn-info get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Default: `<retrieved from config>` | A project ID |
| rpnv1-group-id |  | An RPN v1 group ID |
| rpnv2-group-id |  | An RPN v2 group ID |



### List dedibox resources

List dedibox resources.

**Usage:**

```
scw dedibox rpn-info list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the servers |
| project-id | Default: `<retrieved from config>` | Filter servers by project ID |



## RPN V1 commands

RPN V1 commands.


### Accept-invite dedibox resources

Accept-invite dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 accept-invite [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| member-id | Required | The member ID |



### Add-members dedibox resources

Add-members dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 add-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | The rpn v1 group ID |
| server-ids.{index} |  | A collection of rpn v1 capable server IDs |
| san-server-ids.{index} |  | A collection of rpn v1 capable RPN SAN server IDs |



### Create dedibox resources

Create dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | Rpn v1 group name |
| server-ids.{index} |  | A collection of rpn v1 capable servers |
| san-server-ids.{index} |  | A collection of rpn v1 capable rpn sans servers |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Delete dedibox resources

Delete dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | Rpn v1 group ID |



### Delete-members dedibox resources

Delete-members dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 delete-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | The rpn v1 group ID |
| member-ids.{index} | Required | A collection of rpn v1 group members IDs |



### Get dedibox resources

Get dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | Rpn v1 group ID |



### Invite dedibox resources

Invite dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 invite [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | The RPN V1 group ID |
| server-ids.{index} | Required | A collection of external server IDs |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Leave dedibox resources

Leave dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 leave [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | The RPN V1 group ID |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| member-ids.{index} | Required | A collection of rpn v1 group members IDs |



### List dedibox resources

List dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn v1 groups |
| project-id | Default: `<retrieved from config>` | Filter rpn v1 groups by project ID |



### List-capable-san-server dedibox resources

List-capable-san-server dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 list-capable-san-server [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn capable resources |
| project-id | Default: `<retrieved from config>` | Filter rpn capable resources by project ID |



### List-capable-server dedibox resources

List-capable-server dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 list-capable-server [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn capable resources |
| project-id | Default: `<retrieved from config>` | Filter rpn capable resources by project ID |



### List-invites dedibox resources

List-invites dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 list-invites [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn capable resources |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### List-members dedibox resources

List-members dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 list-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn v1 group members |
| group-id | Required | Filter rpn v1 group members by group ID |
| project-id | Default: `<retrieved from config>` | A project ID |



### Refuse-invite dedibox resources

Refuse-invite dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 refuse-invite [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| member-id | Required | The member ID |



### Update dedibox resources

Update dedibox resources.

**Usage:**

```
scw dedibox rpn-v1 update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | Rpn v1 group ID |
| name | Required | New rpn v1 group name |



## 




### Add-members dedibox resources

Add-members dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 add-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | RPN V2 group ID |
| servers.{index} | Required | A collection of server IDs |



### Create dedibox resources

Create dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| type | One of: `unknown_type`, `standard`, `qinq` | RPN V2 group type (qing / standard) |
| name |  | RPN V2 group name |
| servers.{index} | Required | A collection of server IDs |



### Delete dedibox resources

Delete dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | RPN V2 group ID |



### Delete-members dedibox resources

Delete-members dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 delete-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | RPN V2 group ID |
| member-ids.{index} | Required | A collection of member IDs |



### Disable-compatibility dedibox resources

Disable-compatibility dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 disable-compatibility [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | RPN V2 group ID |



### Enable-compatibility dedibox resources

Enable-compatibility dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 enable-compatibility [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | RPN V2 group ID |
| rpnv1-group-id |  | RPN V1 group ID |



### Get dedibox resources

Get dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | RPN V2 group ID |



### List dedibox resources

List dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn v2 groups |
| project-id | Default: `<retrieved from config>` | Filter rpn v2 groups by project ID |



### List-capable-resources dedibox resources

List-capable-resources dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 list-capable-resources [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn v2 capable resources |
| project-id | Default: `<retrieved from config>` | Filter rpn v2 capable resources by project ID |



### List-logs dedibox resources

List-logs dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 list-logs [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn v2 group logs |
| group-id | Required | RPN V2 group ID |



### List-members dedibox resources

List-members dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 list-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the rpn v2 group members |
| group-id | Required | RPN V2 group ID |
| type | One of: `unknown_type`, `rpnv1_group`, `server` | Filter members by type |



### Update dedibox resources

Update dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | RPN V2 group ID |
| name |  | RPN V2 group name |



### Update-vlan-members dedibox resources

Update-vlan-members dedibox resources.

**Usage:**

```
scw dedibox rpn-v2 update-vlan-members [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| group-id | Required | RPN V2 group ID |
| member-ids.{index} | Required | RPN V2 member IDs |
| vlan |  | A vlan |



## RPN SAN (Storage Area Network) commands

RPN SAN (Storage Area Network) commands.


### Add-ip dedibox resources

Add-ip dedibox resources.

**Usage:**

```
scw dedibox san add-ip [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| rpn-san-id | Required | RPN SAN ID |
| ip-ids.{index} | Required | An array of IP ID |



### Create dedibox resources

Create dedibox resources.

**Usage:**

```
scw dedibox san create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id | Required | Offer ID |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Delete dedibox resources

Delete dedibox resources.

**Usage:**

```
scw dedibox san delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| rpn-san-id | Required | RPN SAN ID |



### Get dedibox resources

Get dedibox resources.

**Usage:**

```
scw dedibox san get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| rpn-san-id | Required | RPN SAN ID |



### List dedibox resources

List dedibox resources.

**Usage:**

```
scw dedibox san list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the RPN SANs |
| project-id | Default: `<retrieved from config>` | Filter RPN SANs by project ID |



### List-available-ips dedibox resources

List-available-ips dedibox resources.

**Usage:**

```
scw dedibox san list-available-ips [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| rpn-san-id | Required | RPN SAN ID |
| type | One of: `unknown`, `server_ip`, `rpnv2_subnet` | Filter by IP type (server | rpnv2_subnet) |



### List-ips dedibox resources

List-ips dedibox resources.

**Usage:**

```
scw dedibox san list-ips [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| rpn-san-id | Required | RPN SAN ID |
| type | One of: `unknown`, `server_ip`, `rpnv2_subnet` | Filter by IP type (server | rpnv2_subnet) |



### Remove-ip dedibox resources

Remove-ip dedibox resources.

**Usage:**

```
scw dedibox san remove-ip [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| rpn-san-id | Required | RPN SAN ID |
| ip-ids.{index} | Required | An array of IP ID |



## Baremetal server commands

Baremetal server commands.


### Cancels the current (running) server installation

Cancels the current server installation associated with the given server ID.

**Usage:**

```
scw dedibox server cancel-install [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID of the server to cancel install |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Create a baremetal server

Create a new baremetal server. The order return you a service ID to follow the provisionning status you could call GetService.

**Usage:**

```
scw dedibox server create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id |  | Offer ID of the new server |
| server-option-ids.{index} | Required | Server option IDs of the new server |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| datacenter-name |  | Datacenter name of the new server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Delete a baremetal server

Delete the server associated with the given ID.

**Usage:**

```
scw dedibox server delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get a specific baremetal server

Get the server associated with the given ID.

**Usage:**

```
scw dedibox server get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get a specific server installation status

Get the server installation status associated with the given server ID.

**Usage:**

```
scw dedibox server get-install [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID of the server to install |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get server default partitioning

Get the server default partitioning schema associated with the given server ID and OS ID.

**Usage:**

```
scw dedibox server get-partitioning [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| os-id | Required | OS ID of the default partitioning |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Install a baremetal server

Install an OS on the server associated with the given ID.

**Usage:**

```
scw dedibox server install [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to install |
| os-id |  | OS ID to install on the server |
| hostname |  | Hostname of the server |
| user-login |  | User to install on the server |
| user-password |  | User password to install on the server |
| panel-password |  | Panel password to install on the server |
| root-password |  | Root password to install on the server |
| partitions.{index}.file-system | One of: `unknown`, `efi`, `swap`, `ext4`, `ext3`, `ext2`, `xfs`, `ntfs`, `fat32`, `ufs` | File system of the installation partition |
| partitions.{index}.mount-point |  | Mount point of the installation partition |
| partitions.{index}.raid-level | One of: `no_raid`, `raid0`, `raid1`, `raid5`, `raid6`, `raid10` | RAID level of the installation partition |
| partitions.{index}.capacity |  | Capacity of the installation partition |
| partitions.{index}.connectors.{index} |  | Connectors of the installation partition |
| ssh-key-ids.{index} |  | SSH key IDs authorized on the server |
| license-offer-id |  | Offer ID of license to install on server |
| ip-id |  | IP to link at the license to install on server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### List baremetal servers for project

List baremetal servers for project.

**Usage:**

```
scw dedibox server list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the servers |
| project-id | Required<br />Default: `<retrieved from config>` | Filter servers by project ID |
| search |  | Filter servers by hostname |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



### List server disks

List disks associated to the given server ID.

**Usage:**

```
scw dedibox server list-disks [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the server disks |
| server-id | Required | Server ID of the server disks |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



### List server events

List events associated to the given server ID.

**Usage:**

```
scw dedibox server list-events [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the server events |
| server-id | Required | Server ID of the server events |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



### Reboot a baremetal server

Reboot the server associated with the given ID, use boot param to reboot in rescue.

**Usage:**

```
scw dedibox server reboot [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to reboot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Start a baremetal server

Start the server associated with the given ID.

**Usage:**

```
scw dedibox server start [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to start |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Stop a baremetal server

Stop the server associated with the given ID.

**Usage:**

```
scw dedibox server stop [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to stop |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Update a baremetal server

Update the server associated with the given ID.

**Usage:**

```
scw dedibox server update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to update |
| hostname |  | Hostname of the server to update |
| enable-ipv6 |  | Flag to enable or not the IPv6 of server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## Service commands

Service commands.


### Delete a specific service

Delete the service associated with the given ID.

**Usage:**

```
scw dedibox service delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| service-id | Required | ID of the service |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get a specific service

Get the service associated with the given ID.

**Usage:**

```
scw dedibox service get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| service-id | Required | ID of the service |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### List services

List services.

**Usage:**

```
scw dedibox service list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the services |
| project-id | Default: `<retrieved from config>` | Project ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



