// This file was automatically generated. DO NOT EDIT.
// If you have any remark or suggestion do not hesitate to open an issue.

package cockpit

import (
	"context"
	"reflect"

	"github.com/scaleway/scaleway-cli/v2/internal/core"
	"github.com/scaleway/scaleway-sdk-go/api/cockpit/v1beta1"
	"github.com/scaleway/scaleway-sdk-go/scw"
)

// always import dependencies
var (
	_ = scw.RegionFrPar
)

func GetGeneratedCommands() *core.Commands {
	return core.NewCommands(
		cockpitRoot(),
		cockpitCockpit(),
		cockpitDatasource(),
		cockpitToken(),
		cockpitGrafanaUser(),
		cockpitPlan(),
		cockpitAlert(),
		cockpitContact(),
		cockpitProductDashboards(),
		cockpitCockpitActivate(),
		cockpitCockpitGet(),
		cockpitCockpitDeactivate(),
		cockpitTokenCreate(),
		cockpitTokenList(),
		cockpitTokenGet(),
		cockpitTokenDelete(),
		cockpitContactCreate(),
		cockpitContactList(),
		cockpitContactDelete(),
		cockpitAlertEnable(),
		cockpitAlertDisable(),
		cockpitAlertTest(),
		cockpitGrafanaUserCreate(),
		cockpitGrafanaUserList(),
		cockpitGrafanaUserDelete(),
		cockpitGrafanaUserResetPassword(),
		cockpitPlanList(),
		cockpitPlanSelect(),
	)
}
func cockpitRoot() *core.Command {
	return &core.Command{
		Short:     `This API allows you to manage your Scaleway Cockpit, for storing and visualizing metrics and logs`,
		Long:      `This API allows you to manage your Scaleway Cockpit, for storing and visualizing metrics and logs.`,
		Namespace: "cockpit",
	}
}

func cockpitCockpit() *core.Command {
	return &core.Command{
		Short:     `Cockpit management commands`,
		Long:      `Cockpit management commands.`,
		Namespace: "cockpit",
		Resource:  "cockpit",
	}
}

func cockpitDatasource() *core.Command {
	return &core.Command{
		Short:     `Datasource management commands`,
		Long:      `Datasource management commands.`,
		Namespace: "cockpit",
		Resource:  "datasource",
	}
}

func cockpitToken() *core.Command {
	return &core.Command{
		Short:     `Token management commands`,
		Long:      `Token management commands.`,
		Namespace: "cockpit",
		Resource:  "token",
	}
}

func cockpitGrafanaUser() *core.Command {
	return &core.Command{
		Short:     `Grafana user management commands`,
		Long:      `Grafana user management commands.`,
		Namespace: "cockpit",
		Resource:  "grafana-user",
	}
}

func cockpitPlan() *core.Command {
	return &core.Command{
		Short:     `Pricing plans management commands`,
		Long:      `Pricing plans management commands.`,
		Namespace: "cockpit",
		Resource:  "plan",
	}
}

func cockpitAlert() *core.Command {
	return &core.Command{
		Short:     `Managed alerts management commands`,
		Long:      `Managed alerts management commands.`,
		Namespace: "cockpit",
		Resource:  "alert",
	}
}

func cockpitContact() *core.Command {
	return &core.Command{
		Short:     `Contacts management commands`,
		Long:      `Contacts management commands.`,
		Namespace: "cockpit",
		Resource:  "contact",
	}
}

func cockpitProductDashboards() *core.Command {
	return &core.Command{
		Short:     `Product dashboards management commands`,
		Long:      `Product dashboards management commands.`,
		Namespace: "cockpit",
		Resource:  "product-dashboards",
	}
}

func cockpitCockpitActivate() *core.Command {
	return &core.Command{
		Short:     `Activate the Cockpit of a given Project specified by the Project ID`,
		Long:      `Activate the Cockpit of a given Project specified by the Project ID.`,
		Namespace: "cockpit",
		Resource:  "cockpit",
		Verb:      "activate",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.ActivateCockpitRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.ActivateCockpitRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.ActivateCockpit(request)

		},
	}
}

func cockpitCockpitGet() *core.Command {
	return &core.Command{
		Short:     `Retrieve the Cockpit of a given Project specified by the Project ID`,
		Long:      `Retrieve the Cockpit of a given Project specified by the Project ID.`,
		Namespace: "cockpit",
		Resource:  "cockpit",
		Verb:      "get",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.GetCockpitRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.GetCockpitRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.GetCockpit(request)

		},
	}
}

func cockpitCockpitDeactivate() *core.Command {
	return &core.Command{
		Short:     `Deactivate the Cockpit of a given Project specified by the Project ID`,
		Long:      `Deactivate the Cockpit of a given Project specified by the Project ID.`,
		Namespace: "cockpit",
		Resource:  "cockpit",
		Verb:      "deactivate",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.DeactivateCockpitRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.DeactivateCockpitRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.DeactivateCockpit(request)

		},
	}
}

func cockpitTokenCreate() *core.Command {
	return &core.Command{
		Short:     `Create a token in a given Project specified by the Project ID`,
		Long:      `Create a token in a given Project specified by the Project ID.`,
		Namespace: "cockpit",
		Resource:  "token",
		Verb:      "create",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.CreateTokenRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
			{
				Name:       "name",
				Short:      `Name of the token`,
				Required:   false,
				Deprecated: false,
				Positional: false,
				Default:    core.RandomValueGenerator("token"),
			},
			{
				Name:       "scopes.query-metrics",
				Short:      `Permission to fetch metrics`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "scopes.write-metrics",
				Short:      `Permission to write metrics`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "scopes.setup-metrics-rules",
				Short:      `Permission to setup metrics rules`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "scopes.query-logs",
				Short:      `Permission to fetch logs`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "scopes.write-logs",
				Short:      `Permission to write logs`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "scopes.setup-logs-rules",
				Short:      `Permission to set up logs rules`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "scopes.setup-alerts",
				Short:      `Permission to set up alerts`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "scopes.query-traces",
				Short:      `Permission to fetch traces`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "scopes.write-traces",
				Short:      `Permission to write traces`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.CreateTokenRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.CreateToken(request)

		},
	}
}

func cockpitTokenList() *core.Command {
	return &core.Command{
		Short:     `Get a list of tokens in a given Project specified by the Project ID`,
		Long:      `Get a list of tokens in a given Project specified by the Project ID.`,
		Namespace: "cockpit",
		Resource:  "token",
		Verb:      "list",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.ListTokensRequest{}),
		ArgSpecs: core.ArgSpecs{
			{
				Name:       "order-by",
				Short:      `How the response is ordered`,
				Required:   false,
				Deprecated: false,
				Positional: false,
				EnumValues: []string{"created_at_asc", "created_at_desc", "name_asc", "name_desc"},
			},
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.ListTokensRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			opts := []scw.RequestOption{scw.WithAllPages()}
			resp, err := api.ListTokens(request, opts...)
			if err != nil {
				return nil, err
			}
			return resp.Tokens, nil

		},
	}
}

func cockpitTokenGet() *core.Command {
	return &core.Command{
		Short:     `Retrieve a given token specified by the token ID`,
		Long:      `Retrieve a given token specified by the token ID.`,
		Namespace: "cockpit",
		Resource:  "token",
		Verb:      "get",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.GetTokenRequest{}),
		ArgSpecs: core.ArgSpecs{
			{
				Name:       "token-id",
				Short:      `ID of the token`,
				Required:   true,
				Deprecated: false,
				Positional: true,
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.GetTokenRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.GetToken(request)

		},
	}
}

func cockpitTokenDelete() *core.Command {
	return &core.Command{
		Short:     `Delete a given token specified by the token ID`,
		Long:      `Delete a given token specified by the token ID.`,
		Namespace: "cockpit",
		Resource:  "token",
		Verb:      "delete",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.DeleteTokenRequest{}),
		ArgSpecs: core.ArgSpecs{
			{
				Name:       "token-id",
				Short:      `ID of the token`,
				Required:   true,
				Deprecated: false,
				Positional: false,
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.DeleteTokenRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			e = api.DeleteToken(request)
			if e != nil {
				return nil, e
			}
			return &core.SuccessResult{
				Resource: "token",
				Verb:     "delete",
			}, nil
		},
	}
}

func cockpitContactCreate() *core.Command {
	return &core.Command{
		Short:     `Create a contact point associated with the default receiver, to receive alerts`,
		Long:      `Create a contact point associated with the default receiver, to receive alerts.`,
		Namespace: "cockpit",
		Resource:  "contact",
		Verb:      "create",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.CreateContactPointRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
			{
				Name:       "contact-point.email.to",
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.CreateContactPointRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.CreateContactPoint(request)

		},
	}
}

func cockpitContactList() *core.Command {
	return &core.Command{
		Short:     `Get a list of contact points created for a given Cockpit, specified by the ID of the Project the Cockpit belongs to`,
		Long:      `Get a list of contact points created for a given Cockpit, specified by the ID of the Project the Cockpit belongs to.`,
		Namespace: "cockpit",
		Resource:  "contact",
		Verb:      "list",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.ListContactPointsRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.ListContactPointsRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			opts := []scw.RequestOption{scw.WithAllPages()}
			resp, err := api.ListContactPoints(request, opts...)
			if err != nil {
				return nil, err
			}
			return resp.ContactPoints, nil

		},
	}
}

func cockpitContactDelete() *core.Command {
	return &core.Command{
		Short:     `Delete a contact point associated with the default receiver`,
		Long:      `Delete a contact point associated with the default receiver.`,
		Namespace: "cockpit",
		Resource:  "contact",
		Verb:      "delete",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.DeleteContactPointRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
			{
				Name:       "contact-point.email.to",
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.DeleteContactPointRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			e = api.DeleteContactPoint(request)
			if e != nil {
				return nil, e
			}
			return &core.SuccessResult{
				Resource: "contact",
				Verb:     "delete",
			}, nil
		},
	}
}

func cockpitAlertEnable() *core.Command {
	return &core.Command{
		Short:     `Enable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to`,
		Long:      `Enable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to.`,
		Namespace: "cockpit",
		Resource:  "alert",
		Verb:      "enable",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.EnableManagedAlertsRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.EnableManagedAlertsRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			e = api.EnableManagedAlerts(request)
			if e != nil {
				return nil, e
			}
			return &core.SuccessResult{
				Resource: "alert",
				Verb:     "enable",
			}, nil
		},
	}
}

func cockpitAlertDisable() *core.Command {
	return &core.Command{
		Short:     `Disable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to`,
		Long:      `Disable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to.`,
		Namespace: "cockpit",
		Resource:  "alert",
		Verb:      "disable",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.DisableManagedAlertsRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.DisableManagedAlertsRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			e = api.DisableManagedAlerts(request)
			if e != nil {
				return nil, e
			}
			return &core.SuccessResult{
				Resource: "alert",
				Verb:     "disable",
			}, nil
		},
	}
}

func cockpitAlertTest() *core.Command {
	return &core.Command{
		Short:     `Send a test alert to make sure your contact points get notified when an actual alert is triggered`,
		Long:      `Send a test alert to make sure your contact points get notified when an actual alert is triggered.`,
		Namespace: "cockpit",
		Resource:  "alert",
		Verb:      "test",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.TriggerTestAlertRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.TriggerTestAlertRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			e = api.TriggerTestAlert(request)
			if e != nil {
				return nil, e
			}
			return &core.SuccessResult{
				Resource: "alert",
				Verb:     "test",
			}, nil
		},
	}
}

func cockpitGrafanaUserCreate() *core.Command {
	return &core.Command{
		Short:     `Create a Grafana user for your Cockpit's Grafana. Make sure you save the automatically-generated password and the Grafana user ID`,
		Long:      `Create a Grafana user for your Cockpit's Grafana. Make sure you save the automatically-generated password and the Grafana user ID.`,
		Namespace: "cockpit",
		Resource:  "grafana-user",
		Verb:      "create",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.CreateGrafanaUserRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
			{
				Name:       "login",
				Short:      `Username of the Grafana user`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
			{
				Name:       "role",
				Short:      `Role assigned to the Grafana user`,
				Required:   false,
				Deprecated: false,
				Positional: false,
				EnumValues: []string{"unknown_role", "editor", "viewer"},
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.CreateGrafanaUserRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.CreateGrafanaUser(request)

		},
	}
}

func cockpitGrafanaUserList() *core.Command {
	return &core.Command{
		Short:     `Get a list of all Grafana users created in your Cockpit's Grafana`,
		Long:      `Get a list of all Grafana users created in your Cockpit's Grafana.`,
		Namespace: "cockpit",
		Resource:  "grafana-user",
		Verb:      "list",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.ListGrafanaUsersRequest{}),
		ArgSpecs: core.ArgSpecs{
			{
				Name:       "order-by",
				Required:   false,
				Deprecated: false,
				Positional: false,
				EnumValues: []string{"login_asc", "login_desc"},
			},
			core.ProjectIDArgSpec(),
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.ListGrafanaUsersRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			opts := []scw.RequestOption{scw.WithAllPages()}
			resp, err := api.ListGrafanaUsers(request, opts...)
			if err != nil {
				return nil, err
			}
			return resp.GrafanaUsers, nil

		},
	}
}

func cockpitGrafanaUserDelete() *core.Command {
	return &core.Command{
		Short:     `Delete a Grafana user from your Cockpit's Grafana, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user`,
		Long:      `Delete a Grafana user from your Cockpit's Grafana, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user.`,
		Namespace: "cockpit",
		Resource:  "grafana-user",
		Verb:      "delete",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.DeleteGrafanaUserRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
			{
				Name:       "grafana-user-id",
				Short:      `ID of the Grafana user`,
				Required:   true,
				Deprecated: false,
				Positional: false,
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.DeleteGrafanaUserRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			e = api.DeleteGrafanaUser(request)
			if e != nil {
				return nil, e
			}
			return &core.SuccessResult{
				Resource: "grafana-user",
				Verb:     "delete",
			}, nil
		},
	}
}

func cockpitGrafanaUserResetPassword() *core.Command {
	return &core.Command{
		Short:     `Reset the password of a Grafana user, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user`,
		Long:      `Reset the password of a Grafana user, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user.`,
		Namespace: "cockpit",
		Resource:  "grafana-user",
		Verb:      "reset-password",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.ResetGrafanaUserPasswordRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
			{
				Name:       "grafana-user-id",
				Short:      `ID of the Grafana user`,
				Required:   true,
				Deprecated: false,
				Positional: false,
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.ResetGrafanaUserPasswordRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.ResetGrafanaUserPassword(request)

		},
	}
}

func cockpitPlanList() *core.Command {
	return &core.Command{
		Short:     `Get a list of all pricing plans available`,
		Long:      `Get a list of all pricing plans available.`,
		Namespace: "cockpit",
		Resource:  "plan",
		Verb:      "list",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.ListPlansRequest{}),
		ArgSpecs: core.ArgSpecs{
			{
				Name:       "order-by",
				Required:   false,
				Deprecated: false,
				Positional: false,
				EnumValues: []string{"name_asc", "name_desc"},
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.ListPlansRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			opts := []scw.RequestOption{scw.WithAllPages()}
			resp, err := api.ListPlans(request, opts...)
			if err != nil {
				return nil, err
			}
			return resp.Plans, nil

		},
	}
}

func cockpitPlanSelect() *core.Command {
	return &core.Command{
		Short:     `Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request`,
		Long:      `Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request.`,
		Namespace: "cockpit",
		Resource:  "plan",
		Verb:      "select",
		// Deprecated:    false,
		ArgsType: reflect.TypeOf(cockpit.SelectPlanRequest{}),
		ArgSpecs: core.ArgSpecs{
			core.ProjectIDArgSpec(),
			{
				Name:       "plan-id",
				Short:      `ID of the pricing plan`,
				Required:   false,
				Deprecated: false,
				Positional: false,
			},
		},
		Run: func(ctx context.Context, args interface{}) (i interface{}, e error) {
			request := args.(*cockpit.SelectPlanRequest)

			client := core.ExtractClient(ctx)
			api := cockpit.NewAPI(client)
			return api.SelectPlan(request)

		},
	}
}
