<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw ipfs`
IPFS Pinning service API.
  
- [A pin is an abstract object that holds a Content Identifier (CID). It is defined that during the lifespan of a pin, the CID (and all sub-CIDs) must be hosted by the service](#a-pin-is-an-abstract-object-that-holds-a-content-identifier-(cid).-it-is-defined-that-during-the-lifespan-of-a-pin,-the-cid-(and-all-sub-cids)-must-be-hosted-by-the-service)
  - [Create a pin by CID](#create-a-pin-by-cid)
  - [Create a pin by URL](#create-a-pin-by-url)
  - [Create an unpin request](#create-an-unpin-request)
  - [Get pin information](#get-pin-information)
  - [List all pins within a volume](#list-all-pins-within-a-volume)
  - [Replace pin by CID](#replace-pin-by-cid)
- [A volume is bucket of pins. It is similar to an Object Storage bucket. Volumes are useful to gather pins with similar lifespans](#a-volume-is-bucket-of-pins.-it-is-similar-to-an-object-storage-bucket.-volumes-are-useful-to-gather-pins-with-similar-lifespans)
  - [Create a new volume](#create-a-new-volume)
  - [Delete an existing volume](#delete-an-existing-volume)
  - [Get information about a volume](#get-information-about-a-volume)
  - [List all volumes by a Project ID](#list-all-volumes-by-a-project-id)
  - [Update volume information](#update-volume-information)

  
## A pin is an abstract object that holds a Content Identifier (CID). It is defined that during the lifespan of a pin, the CID (and all sub-CIDs) must be hosted by the service

It is possible that many pins target the same CID, regardless of the user.


### Create a pin by CID

Will fetch and store the content pointed by the provided CID. The content must be available on the public IPFS network.
The content (IPFS blocks) will be host by the pinning service until pin deletion.
From that point, any other IPFS peer can fetch and host your content: Make sure to pin public or encrypted content.
Many pin requests (from different users) can target the same CID.
A pin is defined by its ID (UUID), its status (queued, pinning, pinned or failed) and target CID.

**Usage:**

```
scw ipfs pin create-by-cid [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | Volume ID on which you want to pin your content |
| cid | Required | CID containing the content you want to pin |
| origins.{index} |  | Node containing the content you want to pin |
| name |  | Pin name |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create a pin by URL

Will fetch and store the content pointed by the provided URL. The content must be available on the public IPFS network.
The content (IPFS blocks) will be host by the pinning service until pin deletion.
From that point, any other IPFS peer can fetch and host your content: Make sure to pin public or encrypted content.
Many pin requests (from different users) can target the same CID.
A pin is defined by its ID (UUID), its status (queued, pinning, pinned or failed) and target CID.

**Usage:**

```
scw ipfs pin create-by-url [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | Volume ID on which you want to pin your content |
| url | Required | URL containing the content you want to pin |
| name |  | Pin name |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create an unpin request

An unpin request means that you no longer own the content.
This content can therefore be removed and no longer provided on the IPFS network.

**Usage:**

```
scw ipfs pin delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id |  | Volume ID |
| pin-id | Required | Pin ID you want to remove from the volume |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get pin information

Retrieve information about the provided **pin ID**, such as status, last modification, and CID.

**Usage:**

```
scw ipfs pin get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id |  | Volume ID |
| pin-id | Required | Pin ID of which you want to obtain information |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all pins within a volume

Retrieve information about all pins within a volume.

**Usage:**

```
scw ipfs pin list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | Volume ID of which you want to list the pins |
| project-id |  | Project ID |
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of the returned Volume |
| status | One of: `unknown_status`, `queued`, `pinning`, `failed`, `pinned` | List pins by status |
| organization-id |  | Organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Replace pin by CID

Deletes the given resource ID and pins the new CID in its place.
Will fetch and store the content pointed by the provided CID. The content must be available on the public IPFS network.
The content (IPFS blocks) is hosted by the pinning service until the pin is deleted.
While the content is available any other IPFS peer can fetch and host your content. For this reason, we recommend that you pin either public or encrypted content.
Several different pin requests can target the same CID.
A pin is defined by its ID (UUID), its status (queued, pinning, pinned or failed) and target CID.

**Usage:**

```
scw ipfs pin replace [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id |  | Volume ID |
| pin-id | Required | Pin ID whose information you wish to replace |
| cid |  | New CID you want to pin in place of the old one |
| name |  | New name to replace |
| origins.{index} |  | Node containing the content you want to pin |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## A volume is bucket of pins. It is similar to an Object Storage bucket. Volumes are useful to gather pins with similar lifespans

All pins must be attached to a volume. And all volumes must be attached to a Project ID.


### Create a new volume

Create a new volume from a Project ID. Volume is identified by an ID and used to host pin references.
Volume is personal (at least to your organization) even if IPFS blocks and CID are available to anyone.
Should be the first command you made because every pin must be attached to a volume.

**Usage:**

```
scw ipfs volume create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Volume name |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an existing volume

Delete a volume by its ID and every pin attached to this volume. This process can take a while to conclude, depending on the size of your pinned content.

**Usage:**

```
scw ipfs volume delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | Volume ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get information about a volume

Retrieve information about a specific volume.

**Usage:**

```
scw ipfs volume get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| volume-id | Required | Volume ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all volumes by a Project ID

Retrieve information about all volumes from a Project ID.

**Usage:**

```
scw ipfs volume list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort the order of the returned volumes |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update volume information

Update volume information (tag, name...).

**Usage:**

```
scw ipfs volume update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Volume name |
| volume-id | Required | Volume ID |
| tags.{index} |  | Tags of the volume |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



