<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw secret`
This API allows you to conveniently store, access and share sensitive data.
  
- [Folder management commands](#folder-management-commands)
  - [Create folder](#create-folder)
  - [Delete a given folder specified by the `region` and `folder_id` parameters](#delete-a-given-folder-specified-by-the-`region`-and-`folder_id`-parameters)
  - [List folders](#list-folders)
- [Secret management commands](#secret-management-commands)
  - [Allow a product to use the secret](#allow-a-product-to-use-the-secret)
  - [Create a secret](#create-a-secret)
  - [Delete a secret](#delete-a-secret)
  - [Get metadata using the secret's ID](#get-metadata-using-the-secret's-id)
  - [List secrets](#list-secrets)
  - [Protect a secret](#protect-a-secret)
  - [Unprotect a secret](#unprotect-a-secret)
  - [Update metadata of a secret](#update-metadata-of-a-secret)
- [Tag management commands](#tag-management-commands)
  - [List tags](#list-tags)
- [Secret Version management commands](#secret-version-management-commands)
  - [Access a secret's version using the secret's ID](#access-a-secret's-version-using-the-secret's-id)
  - [Create a version](#create-a-version)
  - [Delete a version](#delete-a-version)
  - [Disable a version](#disable-a-version)
  - [Enable a version](#enable-a-version)
  - [Generate a password in a new version](#generate-a-password-in-a-new-version)
  - [Get metadata of a secret's version using the secret's ID](#get-metadata-of-a-secret's-version-using-the-secret's-id)
  - [List versions of a secret using the secret's ID](#list-versions-of-a-secret-using-the-secret's-id)
  - [Update metadata of a version](#update-metadata-of-a-version)

  
## Folder management commands

Location of the secret in the directory structure.


### Create folder

Create folder.

**Usage:**

```
scw secret folder create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | Name of the folder |
| path |  | Path of the folder |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a given folder specified by the `region` and `folder_id` parameters

Delete a given folder specified by the `region` and `folder_id` parameters.

**Usage:**

```
scw secret folder delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| folder-id | Required | ID of the folder |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List folders

Retrieve the list of folders created within a Project.

**Usage:**

```
scw secret folder list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Filter by Project ID (optional) |
| path |  | Filter by path (optional) |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Secret management commands

Secrets are logical containers made up of zero or more immutable versions, that contain sensitive data.


### Allow a product to use the secret

Allow a product to use the secret.

**Usage:**

```
scw secret secret add-owner <secret-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| ~~product-name~~ | Deprecated | (Deprecated: use `product` field) Name of the product to add |
| product | One of: `unknown`, `edge_services` | ID of the product to add |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create a secret

You must specify the `region` to create a secret.

**Usage:**

```
scw secret secret create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | Name of the secret |
| tags.{index} |  | List of the secret's tags |
| description |  | Description of the secret |
| type | One of: `unknown_secret_type`, `opaque`, `certificate`, `key_value` | Type of the secret |
| path |  | Path of the secret |
| ephemeral-policy.time-to-live |  | Time frame, from one second and up to one year, during which the secret's versions are valid. |
| ephemeral-policy.expires-once-accessed |  | Returns `true` if the version expires after a single user access. |
| ephemeral-policy.action | One of: `unknown_action`, `delete`, `disable` | Action to perform when the version of a secret expires |
| is-protected |  | Returns `true` if secret protection is enabled on a given secret |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Add a given secret
```
scw secret secret create name=foobar description="$(cat <path/to/your/secret>)"
```




### Delete a secret

Delete a given secret specified by the `region` and `secret_id` parameters.

**Usage:**

```
scw secret secret delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Delete a given secret
```
scw secret secret delete secret-id=11111111-1111-1111-1111-111111111111
```




### Get metadata using the secret's ID

Retrieve the metadata of a secret specified by the `region` and `secret_id` parameters.

**Usage:**

```
scw secret secret get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List secrets

Retrieve the list of secrets created within an Organization and/or Project. You must specify either the `organization_id` or the `project_id` and the `region`.

**Usage:**

```
scw secret secret list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Filter by Project ID (optional) |
| order-by | One of: `name_asc`, `name_desc`, `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` |  |
| tags.{index} |  | List of tags to filter on (optional) |
| name |  | Filter by secret name (optional) |
| is-managed |  | Filter by managed / not managed (optional) |
| path |  | Filter by path (optional) |
| is-ephemeral |  | Filter by ephemeral / not ephemeral (optional) |
| organization-id |  | Filter by Organization ID (optional) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Protect a secret

Protect a given secret specified by the `secret_id` parameter. A protected secret can be read and modified but cannot be deleted.

**Usage:**

```
scw secret secret protect <secret-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret to protect |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Protect a secret
```
scw secret secret protect 11111111-1111-1111-1111-111111111111
```




### Unprotect a secret

Unprotect a given secret specified by the `secret_id` parameter. An unprotected secret can be read, modified and deleted.

**Usage:**

```
scw secret secret unprotect <secret-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret to unprotect |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Unprotect a secret
```
scw secret secret unprotect 11111111-1111-1111-1111-111111111111
```




### Update metadata of a secret

Edit a secret's metadata such as name, tag(s), description and ephemeral policy. The secret to update is specified by the `secret_id` and `region` parameters.

**Usage:**

```
scw secret secret update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| name |  | Secret's updated name (optional) |
| tags.{index} |  | Secret's updated list of tags (optional) |
| description |  | Description of the secret |
| path |  | Path of the folder |
| ephemeral-policy.time-to-live |  | Time frame, from one second and up to one year, during which the secret's versions are valid. |
| ephemeral-policy.expires-once-accessed |  | Returns `true` if the version expires after a single user access. |
| ephemeral-policy.action | One of: `unknown_action`, `delete`, `disable` | Action to perform when the version of a secret expires |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Tag management commands

Tag management commands.


### List tags

List all tags associated with secrets within a given Project.

**Usage:**

```
scw secret tag list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | ID of the Project to target |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Secret Version management commands

Versions store the sensitive data contained in your secrets (API keys, passwords, or certificates).


### Access a secret's version using the secret's ID

Access sensitive data in a secret's version specified by the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version access [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create a version

Create a version of a given secret specified by the `region` and `secret_id` parameters.

**Usage:**

```
scw secret version create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| data | Required | Content of the secret version. Base64 is handled by the SDK |
| description |  | Description of the version |
| disable-previous |  | Disable the previous secret version |
| password-generation.length |  | Length of the password to generate (between 1 and 1024) |
| password-generation.no-lowercase-letters |  | Do not include lower case letters by default in the alphabet |
| password-generation.no-uppercase-letters |  | Do not include upper case letters by default in the alphabet |
| password-generation.no-digits |  | Do not include digits by default in the alphabet |
| password-generation.additional-chars |  | Additional ascii characters to be included in the alphabet |
| data-crc32 |  | (Optional.) The CRC32 checksum of the data as a base-10 integer |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a version

Delete a secret's version and the sensitive data contained in it. Deleting a version is permanent and cannot be undone.

**Usage:**

```
scw secret version delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |


**Examples:**


Delete a given Secret Version
```
scw secret version delete secret-id=11111111-1111-1111-1111-111111111111 revision=1
```




### Disable a version

Make a specific version inaccessible. You must specify the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version disable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Enable a version

Make a specific version accessible. You must specify the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version enable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Generate a password in a new version

Generate a password for the given secret specified by the `region` and `secret_id` parameters. This will also create a new version of the secret that will store the password.

**Usage:**

```
scw secret version generate-password [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| description |  | Description of the version |
| disable-previous |  | (Optional.) Disable the previous secret version |
| length |  | Length of the password to generate (between 1 and 1024 characters) |
| no-lowercase-letters |  | (Optional.) Exclude lower case letters by default in the password character set |
| no-uppercase-letters |  | (Optional.) Exclude upper case letters by default in the password character set |
| no-digits |  | (Optional.) Exclude digits by default in the password character set |
| additional-chars |  | (Optional.) Additional ASCII characters to be included in the password character set |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get metadata of a secret's version using the secret's ID

Retrieve the metadata of a secret's given version specified by the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List versions of a secret using the secret's ID

Retrieve the list of a given secret's versions specified by the `secret_id` and `region` parameters.

**Usage:**

```
scw secret version list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| status.{index} | One of: `unknown`, `enabled`, `disabled`, `destroyed` | Filter results by status |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update metadata of a version

Edit the metadata of a secret's given version, specified by the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number |
| description |  | Description of the version |
| ephemeral-properties.expires-at |  | The version's expiration date |
| ephemeral-properties.expires-once-accessed |  | Returns `true` if the version expires after a single user access. |
| ephemeral-properties.action | One of: `unknown_action`, `delete`, `disable` | Action to perform when the version of a secret expires |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



