<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw cockpit`
Cockpit's API allows you to activate your Cockpit on your Projects. Scaleway's Cockpit stores metrics and logs and provides a dedicated Grafana for dashboarding to visualize them.
  
- [Managed alerts management commands](#managed-alerts-management-commands)
  - [Disable managed alerts](#disable-managed-alerts)
  - [Enable managed alerts](#enable-managed-alerts)
  - [Trigger a test alert](#trigger-a-test-alert)
- [Cockpit management commands](#cockpit-management-commands)
  - [Activate a Cockpit](#activate-a-cockpit)
  - [Deactivate a Cockpit](#deactivate-a-cockpit)
  - [Get a Cockpit](#get-a-cockpit)
  - [Reset a Grafana](#reset-a-grafana)
  - [Wait for a cockpit to reach a stable state (installation)](#wait-for-a-cockpit-to-reach-a-stable-state-(installation))
- [Contacts management commands](#contacts-management-commands)
  - [Create a contact point](#create-a-contact-point)
  - [Delete an alert contact point](#delete-an-alert-contact-point)
  - [List contact points](#list-contact-points)
- [Grafana user management commands](#grafana-user-management-commands)
  - [Create a Grafana user](#create-a-grafana-user)
  - [Delete a Grafana user](#delete-a-grafana-user)
  - [List Grafana users](#list-grafana-users)
  - [Reset a Grafana user's password](#reset-a-grafana-user's-password)
- [Pricing plans management commands](#pricing-plans-management-commands)
  - [List pricing plans](#list-pricing-plans)
  - [Select pricing plan](#select-pricing-plan)
- [Token management commands](#token-management-commands)
  - [Create a token](#create-a-token)
  - [Delete a token](#delete-a-token)
  - [Get a token](#get-a-token)
  - [List tokens](#list-tokens)

  
## Managed alerts management commands

Managed alerts management commands.


### Disable managed alerts

Disable the sending of managed alerts for the specified Project's Cockpit.

**Usage:**

```
scw cockpit alert disable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Enable managed alerts

Enable the sending of managed alerts for the specified Project's Cockpit.

**Usage:**

```
scw cockpit alert enable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Trigger a test alert

Trigger a test alert to all of the Cockpit's receivers.

**Usage:**

```
scw cockpit alert test [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



## Cockpit management commands

Cockpit management commands.


### Activate a Cockpit

Activate the Cockpit of the specified Project ID.

**Usage:**

```
scw cockpit cockpit activate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Deactivate a Cockpit

Deactivate the Cockpit of the specified Project ID.

**Usage:**

```
scw cockpit cockpit deactivate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Get a Cockpit

Retrieve the Cockpit of the specified Project ID.

**Usage:**

```
scw cockpit cockpit get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Reset a Grafana

Reset your Cockpit's Grafana associated with the specified Project ID.

**Usage:**

```
scw cockpit cockpit reset-grafana [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Wait for a cockpit to reach a stable state (installation)

Wait for a cockpit to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the cockpit.

**Usage:**

```
scw cockpit cockpit wait <project-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Required | The ID of the project the cockpit is attached to |
| timeout | Default: `3m0s` | Timeout of the wait |


**Examples:**


Wait for a cockpit to reach a stable state
```
scw cockpit cockpit wait 11111111-1111-1111-1111-111111111111
```




## Contacts management commands

Contacts management commands.


### Create a contact point

Create a contact point to receive alerts for the default receiver.

**Usage:**

```
scw cockpit contact create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| contact-point.email.to |  |  |



### Delete an alert contact point

Delete a contact point for the default receiver.

**Usage:**

```
scw cockpit contact delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| contact-point.email.to |  |  |



### List contact points

Get a list of contact points for the Cockpit associated with the specified Project ID.

**Usage:**

```
scw cockpit contact list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



## Grafana user management commands

Grafana user management commands.


### Create a Grafana user

Create a Grafana user for your Cockpit's Grafana instance. Make sure you save the automatically-generated password and the Grafana user ID.

**Usage:**

```
scw cockpit grafana-user create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| login |  | Username of the Grafana user |
| role | One of: `unknown_role`, `editor`, `viewer` | Role assigned to the Grafana user |



### Delete a Grafana user

Delete a Grafana user from a Grafana instance, specified by the Cockpit's Project ID and the Grafana user ID.

**Usage:**

```
scw cockpit grafana-user delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| grafana-user-id | Required | ID of the Grafana user |



### List Grafana users

Get a list of Grafana users who are able to connect to the Cockpit's Grafana instance.

**Usage:**

```
scw cockpit grafana-user list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `login_asc`, `login_desc` |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Reset a Grafana user's password

Reset a Grafana user's password specified by the Cockpit's Project ID and the Grafana user ID.

**Usage:**

```
scw cockpit grafana-user reset-password [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| grafana-user-id | Required | ID of the Grafana user |



## Pricing plans management commands

Pricing plans management commands.


### List pricing plans

Get a list of all pricing plans available.

**Usage:**

```
scw cockpit plan list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc` |  |



### Select pricing plan

Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request.

**Usage:**

```
scw cockpit plan select [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| plan-id |  | ID of the pricing plan |



## Token management commands

Token management commands.


### Create a token

Create a token associated with the specified Project ID.

**Usage:**

```
scw cockpit token create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Default: `<generated>` | Name of the token |
| scopes.query-metrics |  | Permission to fetch metrics |
| scopes.write-metrics |  | Permission to write metrics |
| scopes.setup-metrics-rules |  | Permission to setup metrics rules |
| scopes.query-logs |  | Permission to fetch logs |
| scopes.write-logs |  | Permission to write logs |
| scopes.setup-logs-rules |  | Permission to setup logs rules |
| scopes.setup-alerts |  | Permission to setup alerts |



### Delete a token

Delete the token associated with the specified token ID.

**Usage:**

```
scw cockpit token delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required | ID of the token |



### Get a token

Retrieve the token associated with the specified token ID.

**Usage:**

```
scw cockpit token get <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required | ID of the token |



### List tokens

Get a list of tokens associated with the specified Project ID.

**Usage:**

```
scw cockpit token list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



