<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw apple-silicon`
Apple silicon API.
  
- [OS management commands](#os-management-commands)
  - [Get an Operating System (OS)](#get-an-operating-system-(os))
  - [List all Operating Systems (OS)](#list-all-operating-systems-(os))
- [Apple silicon management commands](#apple-silicon-management-commands)
  - [Create a server](#create-a-server)
  - [Delete a server](#delete-a-server)
  - [Get a server](#get-a-server)
  - [List all servers](#list-all-servers)
  - [Reboot a server](#reboot-a-server)
  - [Reinstall a server](#reinstall-a-server)
  - [SSH into a server](#ssh-into-a-server)
  - [Update a server](#update-a-server)
  - [Wait for a server to reach a stable state](#wait-for-a-server-to-reach-a-stable-state)
- [Server-Types management commands](#server-types-management-commands)
  - [Get a server type](#get-a-server-type)
  - [List server types](#list-server-types)

  
## OS management commands

OS management commands


### Get an Operating System (OS)

Get an Operating System (OS).  The response will include the OS's unique ID as well as its name and label.

**Usage:**

```
scw apple-silicon os get <os-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| os-id | Required | UUID of the OS you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



### List all Operating Systems (OS)

List all Operating Systems (OS). The response will include the total number of OS as well as their associated IDs, names and labels.

**Usage:**

```
scw apple-silicon os list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-type |  | List of compatible server types |
| name |  | Filter OS by name (note that "11.1" will return "11.1.2" and "11.1" but not "12")) |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3`, `all` | Zone to target. If none is passed will use default zone from the config |



## Apple silicon management commands

Apple silicon management commands


### Create a server

Create a new server in the targeted zone, specifying its configuration including name and type.

**Usage:**

```
scw apple-silicon server create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Create a server with this given name |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| type | Default: `M1-M` | Create a server of the given type |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



### Delete a server

Delete an existing Apple silicon server, specified by its server ID. Deleting a server is permanent, and cannot be undone. Note that the minimum allocation period for Apple silicon-as-a-service is 24 hours, meaning you cannot delete your server prior to that.

**Usage:**

```
scw apple-silicon server delete <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server you want to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



### Get a server

Retrieve information about an existing Apple silicon server, specified by its server ID. Its full details, including name, status and IP address, are returned in the response object.

**Usage:**

```
scw apple-silicon server get <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server you want to get |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



### List all servers

List all servers in the specified zone. By default, returned servers in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw apple-silicon server list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of the returned servers |
| project-id |  | Only list servers of this project ID |
| organization-id |  | Only list servers of this Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3`, `all` | Zone to target. If none is passed will use default zone from the config |



### Reboot a server

Reboot an existing Apple silicon server, specified by its server ID.

**Usage:**

```
scw apple-silicon server reboot <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server you want to reboot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



### Reinstall a server

Reinstall an existing Apple silicon server (specified by its server ID) from a new image (OS). All the data on the disk is deleted and all configuration is reset to the defailt configuration values of the image (OS).

**Usage:**

```
scw apple-silicon server reinstall <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server you want to reinstall |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



### SSH into a server

Connect to distant server via the SSH protocol.

**Usage:**

```
scw apple-silicon server ssh <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to SSH into |
| username | Default: `m1` | Username used for the SSH connection |
| port | Default: `22` | Port used for the SSH connection |
| command |  | Command to execute on the remote server |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |



### Update a server

Update the parameters of an existing Apple silicon server, specified by its server ID.

**Usage:**

```
scw apple-silicon server update <name ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | UUID of the server you want to update |
| name | Required | Updated name for your server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



### Wait for a server to reach a stable state

Wait for server to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the server.

**Usage:**

```
scw apple-silicon server wait <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |
| timeout | Default: `1h0m0s` | Timeout of the wait |


**Examples:**


Wait for a server to reach a stable state
```
scw apple-silicon server wait 11111111-1111-1111-1111-111111111111
```




## Server-Types management commands

Server-Types management commands


### Get a server type

Get technical details (CPU, disk size etc.) of a server type.

**Usage:**

```
scw apple-silicon server-type get <server-type ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-type | Required | Server type identifier |
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



### List server types

List all technical details about Apple silicon server types available in the specified zone. Since there is only one Availability Zone for Apple silicon servers, the targeted value is `fr-par-3`.

**Usage:**

```
scw apple-silicon server-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| zone | Default: `fr-par-1`<br />One of: `fr-par-3` | Zone to target. If none is passed will use default zone from the config |



