<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw tem`
Transactional Email API documentation.
  
- [Domain management commands](#domain-management-commands)
  - [Domain DNS check](#domain-dns-check)
  - [Register a domain in a project](#register-a-domain-in-a-project)
  - [Get information about a domain](#get-information-about-a-domain)
  - [List domains](#list-domains)
  - [Delete a domain](#delete-a-domain)
- [Email management commands](#email-management-commands)
  - [Cancel an email](#cancel-an-email)
  - [Send an email](#send-an-email)
  - [Get an email](#get-an-email)
  - [Email statuses](#email-statuses)
  - [List emails](#list-emails)

  
## Domain management commands

Domain management commands.


### Domain DNS check

Perform an immediate DNS check of a domain using the `region` and `domain_id` parameters.

**Usage:**

```
scw tem domain check <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | ID of the domain to check |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Register a domain in a project

You must specify the `region`, `project_id` and `domain_name` to register a domain in a specific Project.

**Usage:**

```
scw tem domain create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| domain-name |  | Fully qualified domain dame |
| accept-tos |  | Accept Scaleway's Terms of Service |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get information about a domain

Retrieve information about a specific domain using the `region` and `domain_id` parameters.

**Usage:**

```
scw tem domain get <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | ID of the domain |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List domains

Retrieve domains in a specific project or in a specific Organization using the `region` parameter.

**Usage:**

```
scw tem domain list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  |  |
| status.{index} | One of: `unknown`, `checked`, `unchecked`, `invalid`, `locked`, `revoked`, `pending` |  |
| name |  |  |
| organization-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Delete a domain

You must specify the domain you want to delete by the `region` and `domain_id`. Deleting a domain is permanent and cannot be undone.

**Usage:**

```
scw tem domain revoke <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | ID of the domain to delete |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



## Email management commands

Email management commands.


### Cancel an email

You can cancel the sending of an email if it has not been sent yet. You must specify the `region` and the `email_id` of the email you want to cancel.

**Usage:**

```
scw tem email cancel <email-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| email-id | Required | ID of the email to cancel |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Send an email

You must specify the `region`, the sender and the recipient's information and the `project_id` to send an email from a checked domain. The subject of the email must contain at least 6 characters.

**Usage:**

```
scw tem email create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| from.email |  | Email address |
| from.name |  | (Optional) Name displayed |
| to.{index}.email |  | Email address |
| to.{index}.name |  | (Optional) Name displayed |
| cc.{index}.email |  | Email address |
| cc.{index}.name |  | (Optional) Name displayed |
| bcc.{index}.email |  | Email address |
| bcc.{index}.name |  | (Optional) Name displayed |
| subject |  | Subject of the email |
| text |  | Text content |
| html |  | HTML content |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| attachments.{index}.name |  | Filename of the attachment |
| attachments.{index}.type |  | MIME type of the attachment |
| attachments.{index}.content |  | Content of the attachment encoded in base64 |
| send-before |  | Maximum date to deliver the email |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get an email

Retrieve information about a specific email using the `email_id` and `region` parameters.

**Usage:**

```
scw tem email get <email-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| email-id | Required | ID of the email to retrieve |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Email statuses

Get information on your emails' statuses.

**Usage:**

```
scw tem email get-statistics [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Number of emails for this Project (optional) |
| domain-id |  | Number of emails sent from this domain (must be coherent with the `project_id` and the `organization_id`) (optional) |
| since |  | Number of emails created after this date (optional) |
| until |  | Number of emails created before this date (optional) |
| mail-from |  | Number of emails sent with this `mail_from` sender's address (optional) |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List emails

Retrieve the list of emails sent from a specific domain or for a specific Project or Organization. You must specify the `region`.

**Usage:**

```
scw tem email list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | ID of the Project in which to list the emails (optional) |
| domain-id |  | ID of the domain for which to list the emails (optional) |
| message-id |  | ID of the message for which to list the emails (optional) |
| subject |  | Subject of the email |
| since |  | List emails created after this date (optional) |
| until |  | List emails created before this date (optional) |
| mail-from |  | List emails sent with this `mail_from` sender's address (optional) |
| mail-to |  | List emails sent with this `mail_to` recipient's address (optional) |
| statuses.{index} | One of: `unknown`, `new`, `sending`, `sent`, `failed`, `canceled` | List emails having any of this status (optional) |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



