<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw secret`
Secret Manager API documentation.
  
- [Secret management commands](#secret-management-commands)
  - [Create a secret](#create-a-secret)
  - [Delete a secret](#delete-a-secret)
  - [Get metadata using the secret's name](#get-metadata-using-the-secret's-name)
  - [List secrets](#list-secrets)
  - [Update metadata of a secret](#update-metadata-of-a-secret)
- [Secret Version management commands](#secret-version-management-commands)
  - [Access a secret's version using the secret's ID](#access-a-secret's-version-using-the-secret's-id)
  - [Create a version](#create-a-version)
  - [Delete a version](#delete-a-version)
  - [Disable a version](#disable-a-version)
  - [Enable a version](#enable-a-version)
  - [Get metadata of a secret's version using the secret's ID](#get-metadata-of-a-secret's-version-using-the-secret's-id)
  - [List versions of a secret using the secret's ID](#list-versions-of-a-secret-using-the-secret's-id)
  - [Update metadata of a version](#update-metadata-of-a-version)

  
## Secret management commands

Secrets are logical containers made up of zero or more immutable versions, that contain sensitive data.



### Create a secret

You must sepcify the `region` to create a secret.

**Usage:**

```
scw secret secret create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | Name of the secret |
| tags.{index} |  | List of the secret's tags |
| description |  | Description of the secret |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |


**Examples:**


Add a given secret
```
scw secret secret create name=foobar description="$(cat <path/to/your/secret>)"
```




### Delete a secret

Delete a given secret specified by the `region` and `secret_id` parameters.

**Usage:**

```
scw secret secret delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |


**Examples:**


Delete a given secret
```
scw secret secret delete secret-id=11111111-1111-1111-1111-111111111111
```




### Get metadata using the secret's name

Retrieve the metadata of a secret specified by the `region` and the `secret_name` parameters.

**Usage:**

```
scw secret secret get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List secrets

Retrieve the list of secrets created within an Organization and/or Project. You must specify either the `organization_id` or the `project_id` and the `region`.

**Usage:**

```
scw secret secret list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Filter by Project ID (optional) |
| name |  | Filter by secret name (optional) |
| tags.{index} |  | List of tags to filter on (optional) |
| order-by | One of: `name_asc`, `name_desc`, `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` |  |
| organization-id |  | Filter by Organization ID (optional) |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Update metadata of a secret

Edit a secret's metadata such as name, tag(s) and description. The secret to update is specified by the `secret_id` and `region` parameters.

**Usage:**

```
scw secret secret update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| name |  | Secret's updated name (optional) |
| tags.{index} |  | Secret's updated list of tags (optional) |
| description |  | Description of the secret |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



## Secret Version management commands

Versions store the sensitive data contained in your secrets (API keys, passwords, or certificates).



### Access a secret's version using the secret's ID

Access sensitive data in a secret's version specified by the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version access [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number. The first version of the secret is numbered 1, and all subsequent revisions augment by 1. Value can be a number or "latest" |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Create a version

Create a version of a given secret specified by the `region` and `secret_id` parameters.

**Usage:**

```
scw secret version create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| data | Required | Content of the secret version. Base64 is handled by the SDK |
| description |  | Description of the version |
| disable-previous |  | Disable the previous secret version |
| password-generation.length |  | Length of the password to generate (between 1 and 1024) |
| password-generation.no-lowercase-letters |  | Do not include lower case letters by default in the alphabet |
| password-generation.no-uppercase-letters |  | Do not include upper case letters by default in the alphabet |
| password-generation.no-digits |  | Do not include digits by default in the alphabet |
| password-generation.additional-chars |  | Additional ascii characters to be included in the alphabet |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete a version

Delete a secret's version and the sensitive data contained in it. Deleting a version is permanent and cannot be undone.

**Usage:**

```
scw secret version delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number. The first version of the secret is numbered 1, and all subsequent revisions augment by 1. Value can be a number or "latest" |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |


**Examples:**


Delete a given Secret Version
```
scw secret version delete secret-id=11111111-1111-1111-1111-111111111111 revision=1
```




### Disable a version

Make a specific version inaccessible. You must specify the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version disable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number. The first version of the secret is numbered 1, and all subsequent revisions augment by 1. Value can be a number or "latest" |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Enable a version

Make a specific version accessible. You must specify the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version enable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number. The first version of the secret is numbered 1, and all subsequent revisions augment by 1. Value can be a number or "latest" |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get metadata of a secret's version using the secret's ID

Retrieve the metadata of a secret's given version specified by the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number. The first version of the secret is numbered 1, and all subsequent revisions augment by 1. Value can be a number or "latest" |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List versions of a secret using the secret's ID

Retrieve the list of a given secret's versions specified by the `secret_id` and `region` parameters.

**Usage:**

```
scw secret version list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| status.{index} | One of: `unknown`, `enabled`, `disabled`, `destroyed` | Filter results by status |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Update metadata of a version

Edit the metadata of a secret's given version, specified by the `region`, `secret_id` and `revision` parameters.

**Usage:**

```
scw secret version update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secret-id | Required | ID of the secret |
| revision | Required | Version number. The first version of the secret is numbered 1, and all subsequent revisions augment by 1. Value can be a number or "latest" |
| description |  | Description of the version |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



