<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw function`
Functions API.
  
- [Cron management commands](#cron-management-commands)
  - [Create a new cron](#create-a-new-cron)
  - [Delete an existing cron](#delete-an-existing-cron)
  - [Get a cron](#get-a-cron)
  - [List all your crons](#list-all-your-crons)
  - [Update an existing cron](#update-an-existing-cron)
- [Domain management commands](#domain-management-commands)
  - [Create a domain name binding](#create-a-domain-name-binding)
  - [Delete a domain name binding](#delete-a-domain-name-binding)
  - [Get a domain name binding](#get-a-domain-name-binding)
  - [List all domain name bindings](#list-all-domain-name-bindings)
- [Function management commands](#function-management-commands)
  - [Create a new function](#create-a-new-function)
  - [Delete a function](#delete-a-function)
  - [Deploy a function](#deploy-a-function)
  - [Get a function](#get-a-function)
  - [Get a download URL of a function](#get-a-download-url-of-a-function)
  - [List your application logs](#list-your-application-logs)
  - [Get an upload URL of a function](#get-an-upload-url-of-a-function)
  - [List all your functions](#list-all-your-functions)
  - [Update an existing function](#update-an-existing-function)
- [Function namespace management commands](#function-namespace-management-commands)
  - [Create a new namespace](#create-a-new-namespace)
  - [Delete an existing namespace](#delete-an-existing-namespace)
  - [Get a namespace](#get-a-namespace)
  - [List all your namespaces](#list-all-your-namespaces)
  - [Update an existing namespace](#update-an-existing-namespace)
- [Runtime management commands](#runtime-management-commands)
  - [List function runtimes](#list-function-runtimes)
- [Token management commands](#token-management-commands)
  - [Create a new revocable token](#create-a-new-revocable-token)
  - [Delete a token](#delete-a-token)
  - [Get a token](#get-a-token)
  - [List all tokens](#list-all-tokens)

  
## Cron management commands

Cron management commands.


### Create a new cron

Create a new cron.

**Usage:**

```
scw function cron create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id |  |  |
| schedule |  |  |
| args |  |  |
| name |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an existing cron

Delete the cron associated with the given id.

**Usage:**

```
scw function cron delete <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a cron

Get the cron associated with the given id.

**Usage:**

```
scw function cron get <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all your crons

List all your crons.

**Usage:**

```
scw function cron list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| function-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing cron

Update the cron associated with the given id.

**Usage:**

```
scw function cron update <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required |  |
| function-id |  |  |
| schedule |  |  |
| args |  |  |
| name |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Domain management commands

Domain management commands.


### Create a domain name binding

Create a domain name binding.

**Usage:**

```
scw function domain create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hostname |  |  |
| function-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a domain name binding

Delete a domain name binding.

**Usage:**

```
scw function domain delete <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a domain name binding

Get a domain name binding.

**Usage:**

```
scw function domain get <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all domain name bindings

List all domain name bindings.

**Usage:**

```
scw function domain list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `hostname_asc`, `hostname_desc` |  |
| function-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Function management commands

Function management commands.


### Create a new function

Create a new function.

**Usage:**

```
scw function function create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` |  |
| namespace-id |  |  |
| environment-variables.{key} |  |  |
| min-scale |  |  |
| max-scale |  |  |
| runtime | One of: `unknown_runtime`, `golang`, `python`, `python3`, `node8`, `node10`, `node14`, `node16`, `node17`, `python37`, `python38`, `python39`, `python310`, `go113`, `go117`, `go118`, `node18`, `rust165`, `go119`, `python311`, `php82`, `node19`, `go120` |  |
| memory-limit |  |  |
| timeout.seconds |  |  |
| timeout.nanos |  |  |
| handler |  |  |
| privacy | One of: `unknown_privacy`, `public`, `private` |  |
| description |  |  |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| http-option | Default: `enabled`<br />One of: `unknown_http_option`, `enabled`, `redirected` | Configure how HTTP and HTTPS requests are handled |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a function

Delete the function associated with the given id.

**Usage:**

```
scw function function delete <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Deploy a function

Deploy a function associated with the given id.

**Usage:**

```
scw function function deploy <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a function

Get the function associated with the given id.

**Usage:**

```
scw function function get <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a download URL of a function

Get a download URL for a function associated with the given id.

**Usage:**

```
scw function function get-download-url <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List your application logs

List your application logs.

**Usage:**

```
scw function function get-logs <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required |  |
| order-by | One of: `timestamp_desc`, `timestamp_asc` |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Get an upload URL of a function

Get an upload URL of a function associated with the given id.

**Usage:**

```
scw function function get-upload-url <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required |  |
| content-length |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all your functions

List all your functions.

**Usage:**

```
scw function function list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` |  |
| namespace-id |  |  |
| name |  |  |
| project-id |  |  |
| organization-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing function

Update the function associated with the given id.

**Usage:**

```
scw function function update <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required |  |
| environment-variables.{key} |  |  |
| min-scale |  |  |
| max-scale |  |  |
| runtime | One of: `unknown_runtime`, `golang`, `python`, `python3`, `node8`, `node10`, `node14`, `node16`, `node17`, `python37`, `python38`, `python39`, `python310`, `go113`, `go117`, `go118`, `node18`, `rust165`, `go119`, `python311`, `php82`, `node19`, `go120` |  |
| memory-limit |  |  |
| timeout.seconds |  |  |
| timeout.nanos |  |  |
| redeploy |  |  |
| handler |  |  |
| privacy | One of: `unknown_privacy`, `public`, `private` |  |
| description |  |  |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| http-option | Default: `enabled`<br />One of: `unknown_http_option`, `enabled`, `redirected` | Configure how HTTP and HTTPS requests are handled |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Function namespace management commands

Function namespace management commands.


### Create a new namespace

Create a new namespace.

**Usage:**

```
scw function namespace create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` |  |
| environment-variables.{key} |  |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| description |  |  |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an existing namespace

Delete the namespace associated with the given id.

**Usage:**

```
scw function namespace delete <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a namespace

Get the namespace associated with the given id.

**Usage:**

```
scw function namespace get <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all your namespaces

List all your namespaces.

**Usage:**

```
scw function namespace list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` |  |
| name |  |  |
| project-id |  |  |
| organization-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing namespace

Update the space associated with the given id.

**Usage:**

```
scw function namespace update <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required |  |
| environment-variables.{key} |  |  |
| description |  |  |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Runtime management commands

Runtime management commands.


### List function runtimes

List available function runtimes.

**Usage:**

```
scw function runtime list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Token management commands

Token management commands.


### Create a new revocable token

Create a new revocable token.

**Usage:**

```
scw function token create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id |  |  |
| namespace-id |  |  |
| description |  |  |
| expires-at |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a token

Delete a token.

**Usage:**

```
scw function token delete <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a token

Get a token.

**Usage:**

```
scw function token get <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all tokens

List all tokens.

**Usage:**

```
scw function token list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| function-id |  |  |
| namespace-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



