<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw fip`
Flexible IP API.
  
- [Flexible IP management commands](#flexible-ip-management-commands)
  - [Attach a Flexible IP to a server](#attach-a-flexible-ip-to-a-server)
  - [Create a Flexible IP](#create-a-flexible-ip)
  - [Delete a Flexible IP](#delete-a-flexible-ip)
  - [Detach a Flexible IP from a server](#detach-a-flexible-ip-from-a-server)
  - [Get a Flexible IP](#get-a-flexible-ip)
  - [List Flexible IPs](#list-flexible-ips)
  - [Update a Flexible IP](#update-a-flexible-ip)
- [MAC address management commands](#mac-address-management-commands)
  - [Generate a virtual MAC on a given Flexible IP](#generate-a-virtual-mac-on-a-given-flexible-ip)
  - [Remove a virtual MAC from a Flexible IP](#remove-a-virtual-mac-from-a-flexible-ip)
  - [Duplicate a Virtual MAC](#duplicate-a-virtual-mac)
  - [Move a virtual MAC](#move-a-virtual-mac)

  
## Flexible IP management commands

A Flexible IP can be attached to any server in the same zone.
A server can be linked with multiple Flexible IPs attached to it.



### Attach a Flexible IP to a server

Attach a Flexible IP to a server.

**Usage:**

```
scw fip ip attach [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fips-ids.{index} | Required | A list of Flexible IP IDs to attach |
| server-id | Required | A server ID on which to attach the Flexible IPs |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Create a Flexible IP

Create a Flexible IP.

**Usage:**

```
scw fip ip create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| description |  | Description to associate with the Flexible IP, max 255 characters |
| tags.{index} |  | Tags to associate to the Flexible IP |
| server-id |  | Server ID on which to attach the created Flexible IP |
| reverse |  | Reverse DNS value |
| is-ipv6 |  | If true, creates a Flexible IP with an ipv6 address |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Delete a Flexible IP

Delete a Flexible IP.

**Usage:**

```
scw fip ip delete <fip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | ID of the Flexible IP to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Detach a Flexible IP from a server

Detach a Flexible IP from a server.

**Usage:**

```
scw fip ip detach [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fips-ids.{index} | Required | A list of Flexible IP IDs to detach |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Get a Flexible IP

Get a Flexible IP.

**Usage:**

```
scw fip ip get <fip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | Flexible IP ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### List Flexible IPs

List Flexible IPs.

**Usage:**

```
scw fip ip list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | The sort order of the returned Flexible IPs |
| tags.{index} |  | Filter Flexible IPs with one or more matching tags |
| status.{index} | One of: `unknown`, `ready`, `updating`, `attached`, `error`, `detaching`, `locked` | Filter Flexible IPs by status |
| server-ids.{index} |  | Filter Flexible IPs by server IDs |
| project-id |  | Filter Flexible IPs by project ID |
| organization-id |  | Filter Flexible IPs by organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update a Flexible IP

Update a Flexible IP.

**Usage:**

```
scw fip ip update <fip-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | ID of the Flexible IP to update |
| description |  | Description to associate with the Flexible IP, max 255 characters |
| tags.{index} |  | Tags to associate with the Flexible IP |
| reverse |  | Reverse DNS value |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## MAC address management commands

MAC address management commands.


### Generate a virtual MAC on a given Flexible IP

Generate a virtual MAC on a given Flexible IP.

**Usage:**

```
scw fip mac create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | Flexible IP ID on which to generate a Virtual MAC |
| mac-type | Required<br />One of: `unknown_type`, `vmware`, `xen`, `kvm` | TODO |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Remove a virtual MAC from a Flexible IP

Remove a virtual MAC from a Flexible IP.

**Usage:**

```
scw fip mac delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | Flexible IP ID from which to delete the Virtual MAC |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Duplicate a Virtual MAC

Duplicate a Virtual MAC from a given Flexible IP onto another attached on the same server.

**Usage:**

```
scw fip mac duplicate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required | Flexible IP ID on which to duplicate the Virtual MAC |
| duplicate-from-fip-id | Required | Flexible IP ID to duplicate the Virtual MAC from |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Move a virtual MAC

Move a Virtual MAC from a given Flexible IP onto another Flexible IP.

**Usage:**

```
scw fip mac move [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fip-id | Required |  |
| dst-fip-id |  |  |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



