<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw cockpit`
Cockpit API.
  
- [Managed alerts management commands](#managed-alerts-management-commands)
  - [Disable managed alerts](#disable-managed-alerts)
  - [Enable managed alerts](#enable-managed-alerts)
  - [Trigger a test alert](#trigger-a-test-alert)
- [Cockpit management commands](#cockpit-management-commands)
  - [Activate a cockpit](#activate-a-cockpit)
  - [Deactivate a cockpit](#deactivate-a-cockpit)
  - [Get cockpit](#get-cockpit)
  - [Get cockpit metrics](#get-cockpit-metrics)
  - [Reset Grafana](#reset-grafana)
  - [Wait for a cockpit to reach a stable state (installation)](#wait-for-a-cockpit-to-reach-a-stable-state-(installation))
- [Contacts management commands](#contacts-management-commands)
  - [Create an alert contact point](#create-an-alert-contact-point)
  - [Delete an alert contact point](#delete-an-alert-contact-point)
  - [List alert contact points](#list-alert-contact-points)
- [Grafana user management commands](#grafana-user-management-commands)
  - [Create a grafana user](#create-a-grafana-user)
  - [Delete a grafana user](#delete-a-grafana-user)
  - [List grafana users](#list-grafana-users)
  - [Reset Grafana user password](#reset-grafana-user-password)
- [Pricing plans management commands](#pricing-plans-management-commands)
- [Token management commands](#token-management-commands)
  - [Create a token](#create-a-token)
  - [Delete token](#delete-token)
  - [Get token](#get-token)
  - [List tokens](#list-tokens)

  
## Managed alerts management commands

Managed alerts management commands.


### Disable managed alerts

Disable managed alerts.

**Usage:**

```
scw cockpit alert disable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Enable managed alerts

Enable managed alerts.

**Usage:**

```
scw cockpit alert enable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Trigger a test alert

Trigger a test alert to all receivers.

**Usage:**

```
scw cockpit alert test [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



## Cockpit management commands

Cockpit management commands.


### Activate a cockpit

Activate a cockpit associated with the given project ID.

**Usage:**

```
scw cockpit cockpit activate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Deactivate a cockpit

Deactivate a cockpit associated with the given project ID.

**Usage:**

```
scw cockpit cockpit deactivate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Get cockpit

Get the cockpit associated with the given project ID.

**Usage:**

```
scw cockpit cockpit get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Get cockpit metrics

Get the cockpit metrics with the given project ID.

**Usage:**

```
scw cockpit cockpit get-metrics [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| start-date |  | Start date |
| end-date |  | End date |
| metric-name |  | Metric name |



### Reset Grafana

Reset the Grafana of your cockpit associated with the given project ID.

**Usage:**

```
scw cockpit cockpit reset-grafana [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Wait for a cockpit to reach a stable state (installation)

Wait for a cockpit to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the cockpit.

**Usage:**

```
scw cockpit cockpit wait <project-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Required | The ID of the project the cockpit is attached to |


**Examples:**


Wait for a cockpit to reach a stable state
```
scw cockpit cockpit wait 11111111-1111-1111-1111-111111111111
```




## Contacts management commands

Contacts management commands.


### Create an alert contact point

Create an alert contact point for the default receiver.

**Usage:**

```
scw cockpit contact create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| contact-point.email.to |  |  |



### Delete an alert contact point

Delete an alert contact point for the default receiver.

**Usage:**

```
scw cockpit contact delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| contact-point.email.to |  |  |



### List alert contact points

List alert contact points associated with the given cockpit ID.

**Usage:**

```
scw cockpit contact list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



## Grafana user management commands

Grafana user management commands.


### Create a grafana user

Create a grafana user for your grafana instance.

**Usage:**

```
scw cockpit grafana-user create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| login |  |  |
| role | One of: `unknown_role`, `editor`, `viewer` |  |



### Delete a grafana user

Delete a grafana user from your grafana instance.

**Usage:**

```
scw cockpit grafana-user delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| grafana-user-id | Required |  |



### List grafana users

List grafana users who are able to connect to your grafana instance.

**Usage:**

```
scw cockpit grafana-user list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `login_asc`, `login_desc` |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Reset Grafana user password

Reset the Grafana user password from your grafana instance.

**Usage:**

```
scw cockpit grafana-user reset-password [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| grafana-user-id | Required |  |



## Pricing plans management commands

Pricing plans management commands.

Pricing plans management commands.

**Usage:**

```
scw cockpit plan
```



## Token management commands

Token management commands.


### Create a token

Create a token associated with the given project ID.

**Usage:**

```
scw cockpit token create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Default: `<generated>` |  |
| scopes.query-metrics |  |  |
| scopes.write-metrics |  |  |
| scopes.setup-metrics-rules |  |  |
| scopes.query-logs |  |  |
| scopes.write-logs |  |  |
| scopes.setup-logs-rules |  |  |
| scopes.setup-alerts |  |  |



### Delete token

Delete the token associated with the given ID.

**Usage:**

```
scw cockpit token delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required |  |



### Get token

Get the token associated with the given ID.

**Usage:**

```
scw cockpit token get <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required |  |



### List tokens

List tokens associated with the given project ID.

**Usage:**

```
scw cockpit token list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



