<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw account`
Account API
  
- [SSH keys management commands](#ssh-keys-management-commands)
  - [Add a SSH key to your organization](#add-a-ssh-key-to-your-organization)
  - [Get a SSH key from your organization](#get-a-ssh-key-from-your-organization)
  - [Initialize SSH key](#initialize-ssh-key)
  - [List all SSH keys of your organization](#list-all-ssh-keys-of-your-organization)
  - [Remove a SSH key from your organization](#remove-a-ssh-key-from-your-organization)
  - [Update a SSH key on your organization](#update-a-ssh-key-on-your-organization)

  
## SSH keys management commands

SSH keys management commands.


### Add a SSH key to your organization

Add a SSH key to your organization.

**Usage:**

```
scw account ssh-key add [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | The name of the SSH key |
| public-key | Required | SSH public key. Currently ssh-rsa, ssh-dss (DSA), ssh-ed25519 and ecdsa keys with NIST curves are supported |
| project-id |  | Project owning the resource |
| organization-id |  | Organization ID to use. If none is passed will use default organization ID from the config |


**Examples:**


Add a given ssh key
```
scw account ssh-key add name=foobar public_key="$(cat <path/to/your/public/key>)"
```




### Get a SSH key from your organization

Get a SSH key from your organization.

**Usage:**

```
scw account ssh-key get <ssh-key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ssh-key-id | Required | The ID of the SSH key |



### Initialize SSH key

Initialize SSH key.

**Usage:**

```
scw account ssh-key init
```



### List all SSH keys of your organization

List all SSH keys of your organization.

**Usage:**

```
scw account ssh-key list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `name_asc`, `name_desc` |  |
| name |  |  |
| project-id |  |  |
| organization-id |  |  |



### Remove a SSH key from your organization

Remove a SSH key from your organization.

**Usage:**

```
scw account ssh-key remove <ssh-key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ssh-key-id | Required |  |


**Examples:**


Remove a given SSH key
```
scw account ssh-key remove 11111111-1111-1111-1111-111111111111
```




### Update a SSH key on your organization

Update a SSH key on your organization.

**Usage:**

```
scw account ssh-key update <ssh-key-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| ssh-key-id | Required |  |
| name |  |  |



