# Examples of Breaking and Non-Breaking Changes
These examples are automatically generated from unit tests.
## Examples of breaking changes
[Deleting a value from an x-extensible-enum parameter is breaking](../checker/check_request_parameter_x_extensible_enum_value_removed_test.go?plain=1#L11)  
[Deleting a value from an x-extensible-enum property is breaking](../checker/check_request_property_x_extensible_enum_value_removed_test.go?plain=1#L11)  
[adding 'allOf' subschema to the request body or request body property is breaking](../checker/check_breaking_test.go?plain=1#L727)  
[adding a new required property in request body is breaking](../checker/check_breaking_property_test.go?plain=1#L353)  
[adding a pattern to a schema is breaking for recursive properties](../checker/check_breaking_test.go?plain=1#L490)  
[adding a pattern to a schema is breaking](../checker/check_breaking_test.go?plain=1#L473)  
[adding a required request body is breaking](../checker/check_breaking_test.go?plain=1#L61)  
[changing a request body to enum is breaking](../checker/check_breaking_property_test.go?plain=1#L123)  
[changing a request body type and changing it to enum simultaneously is breaking](../checker/check_breaking_property_test.go?plain=1#L153)  
[changing a request property to not nullable is breaking](../checker/check_breaking_property_test.go?plain=1#L233)  
[changing a required property in response body to optional and also deleting it is breaking](../checker/check_breaking_property_test.go?plain=1#L281)  
[changing a response body to nullable is breaking](../checker/check_breaking_property_test.go?plain=1#L217)  
[changing a response property to nullable is breaking](../checker/check_breaking_property_test.go?plain=1#L249)  
[changing a response property to optional under AllOf, AnyOf or OneOf is breaking](../checker/check_breaking_property_test.go?plain=1#L660)  
[changing an embedded response property to nullable is breaking](../checker/check_breaking_property_test.go?plain=1#L265)  
[changing an existing header param from optional to required is breaking](../checker/check_breaking_test.go?plain=1#L190)  
[changing an existing path param to enum is breaking](../checker/check_breaking_property_test.go?plain=1#L185)  
[changing an existing property in request body anyOf to required is breaking](../checker/check_breaking_property_test.go?plain=1#L628)  
[changing an existing property in request body items to required is breaking](../checker/check_breaking_property_test.go?plain=1#L597)  
[changing an existing property in request body to enum is breaking](../checker/check_breaking_property_test.go?plain=1#L169)  
[changing an existing property in request body to required is breaking](../checker/check_breaking_property_test.go?plain=1#L337)  
[changing an existing property in request header to enum is breaking](../checker/check_breaking_property_test.go?plain=1#L201)  
[changing an existing property in request header to required is breaking](../checker/check_breaking_property_test.go?plain=1#L57)  
[changing an existing property in response body to optional is breaking](../checker/check_breaking_property_test.go?plain=1#L107)  
[changing an existing property under another property in request body to required is breaking](../checker/check_breaking_property_test.go?plain=1#L644)  
[changing an existing request body from optional to required is breaking](../checker/check_breaking_test.go?plain=1#L79)  
[changing an existing required property in response body to not-write-only is breaking](../checker/check_breaking_property_test.go?plain=1#L561)  
[changing an existing response header from required to optional is breaking](../checker/check_breaking_test.go?plain=1#L214)  
[changing max length in request from nil to any value is breaking](../checker/check_breaking_min_max_test.go?plain=1#L110)  
[changing max length in response from any value to nil is breaking](../checker/check_breaking_min_max_test.go?plain=1#L160)  
[changing request's body schema type from number to integer is breaking](../checker/check_breaking_request_type_changed_test.go?plain=1#L52)  
[changing request's body schema type from number to string is breaking](../checker/check_breaking_request_type_changed_test.go?plain=1#L32)  
[changing request's body schema type from number/none to integer/int32 is breaking](../checker/check_breaking_request_type_changed_test.go?plain=1#L92)  
[changing request's body schema type from string to number is breaking](../checker/check_breaking_request_type_changed_test.go?plain=1#L12)  
[changing request's query param property type from number to string is breaking](../checker/check_request_parameters_type_changed_test.go?plain=1#L208)  
[changing response's body schema type from integer to number is breaking](../checker/check_breaking_response_type_changed_test.go?plain=1#L70)  
[changing response's body schema type from number to string is breaking](../checker/check_breaking_response_type_changed_test.go?plain=1#L32)  
[changing response's body schema type from string to number is breaking](../checker/check_breaking_response_type_changed_test.go?plain=1#L12)  
[changing response's embedded property schema type from string/none to integer/int32 is breaking](../checker/check_breaking_response_type_changed_test.go?plain=1#L109)  
[changing sunset from an invalid date for a deprecated endpoint is breaking](../checker/check_api_sunset_changed_test.go?plain=1#L65)  
[changing sunset to an earlier date for a deprecated endpoint with a deprecation policy is breaking](../checker/check_api_sunset_changed_test.go?plain=1#L29)  
[changing sunset to an invalid date for a deprecated endpoint is breaking](../checker/check_api_sunset_changed_test.go?plain=1#L47)  
[decreasing stability level is breaking](../checker/checker_test.go?plain=1#L11)  
[deleting a media-type from response is breaking](../checker/check_breaking_test.go?plain=1#L442)  
[deleting a non-required non-write-only property in response body is breaking with warning](../checker/check_breaking_property_test.go?plain=1#L512)  
[deleting a path is breaking](../checker/check_breaking_test.go?plain=1#L37)  
[deleting a path with some operations having sunset date in the future is breaking](../checker/check_api_removed_test.go?plain=1#L86)  
[deleting a required property in request is breaking with warn](../checker/check_breaking_property_test.go?plain=1#L369)  
[deleting a required property in response body is breaking](../checker/check_breaking_property_test.go?plain=1#L421)  
[deleting a required property under AllOf in response body is breaking](../checker/check_breaking_property_test.go?plain=1#L451)  
[deleting an embedded optional property in request is breaking with warn](../checker/check_breaking_property_test.go?plain=1#L386)  
[deleting an enum value is breaking](../checker/check_breaking_test.go?plain=1#L101)  
[deleting an operation before sunset date is breaking](../checker/check_api_removed_test.go?plain=1#L11)  
[deleting an operation is breaking](../checker/check_breaking_test.go?plain=1#L45)  
[deleting sunset header for a deprecated endpoint is breaking](../checker/check_api_sunset_changed_test.go?plain=1#L11)  
[deprecating an operation with a deprecation policy and an invalid stability level is breaking](../checker/check_api_deprecation_test.go?plain=1#L67)  
[deprecating an operation with a deprecation policy and an invalid sunset date is breaking](../checker/check_api_deprecation_test.go?plain=1#L48)  
[deprecating an operation with a deprecation policy and sunset date before required deprecation period is breaking](../checker/check_api_deprecation_test.go?plain=1#L214)  
[deprecating an operation with a deprecation policy but without specifying sunset date is breaking](../checker/check_api_deprecation_test.go?plain=1#L103)  
[inclreasing request body min items is breaking](../checker/check_request_property_min_items_increased_test.go?plain=1#L12)  
[increasing max length in response is breaking](../checker/check_breaking_min_max_test.go?plain=1#L93)  
[increasing min items in request is breaking](../checker/check_breaking_min_max_test.go?plain=1#L236)  
[modifying a pattern in a schema is breaking](../checker/check_breaking_test.go?plain=1#L507)  
[modifying a pattern in request parameter is breaking](../checker/check_breaking_test.go?plain=1#L539)  
[modifying the default value of an optional request parameter is breaking](../checker/check_breaking_test.go?plain=1#L570)  
[new header, query and cookie required request default param is breaking](../checker/check_new_request_non_path_default_parameter_test.go?plain=1#L12)  
[new required header param is breaking](../checker/check_breaking_test.go?plain=1#L173)  
[new required path param is breaking](../checker/check_breaking_test.go?plain=1#L156)  
[new required property in request header is breaking](../checker/check_breaking_property_test.go?plain=1#L18)  
[reducing max in request is breaking](../checker/check_breaking_min_max_test.go?plain=1#L264)  
[reducing max length in request is breaking](../checker/check_breaking_min_max_test.go?plain=1#L12)  
[reducing min items in response is breaking](../checker/check_breaking_min_max_test.go?plain=1#L220)  
[reducing min length in response is breaking](../checker/check_breaking_min_max_test.go?plain=1#L62)  
[removing 'allOf' subschema from the request body or request body property is breaking with warn](../checker/check_breaking_test.go?plain=1#L749)  
[removing 'anyOf' schema from the request body or request body property is breaking](../checker/check_breaking_test.go?plain=1#L684)  
[removing 'oneOf' schema from the request body or request body property is breaking](../checker/check_breaking_test.go?plain=1#L706)  
[removing a deprecated enpoint with an invalid date is breaking](../checker/check_api_removed_test.go?plain=1#L104)  
[removing a media type from request body is breaking](../checker/check_breaking_test.go?plain=1#L668)  
[removing a success status is breaking](../checker/check_response_status_updated_test.go?plain=1#L87)  
[removing an existing optional response header is breaking as warn](../checker/check_breaking_test.go?plain=1#L422)  
[removing an existing required response header is breaking as error](../checker/check_breaking_test.go?plain=1#L231)  
[removing an existing response with non-successful status is breaking (optional)](../checker/check_breaking_test.go?plain=1#L270)  
[removing an existing response with successful status is breaking](../checker/check_breaking_test.go?plain=1#L251)  
[removing an schema object from components is breaking (optional)](../checker/check_breaking_test.go?plain=1#L643)  
[removing the default value of an optional request parameter is breaking](../checker/check_breaking_test.go?plain=1#L606)  
[removing the path without a deprecation policy and without specifying sunset date is breaking if some APIs are not alpha stability level](../checker/check_api_removed_test.go?plain=1#L44)  
[removing the path without a deprecation policy and without specifying sunset date is breaking if some APIs are not draft stability level](../checker/check_api_removed_test.go?plain=1#L64)  
[removing/updating a property enum in response is breaking (optional)](../checker/check_breaking_test.go?plain=1#L333)  
[removing/updating a tag is breaking (optional)](../checker/check_breaking_test.go?plain=1#L351)  
[removing/updating an enum in request body is breaking (optional)](../checker/check_breaking_test.go?plain=1#L310)  
[removing/updating an operation id is breaking (optional)](../checker/check_breaking_test.go?plain=1#L289)  
[setting the default value of an optional request parameter is breaking](../checker/check_breaking_test.go?plain=1#L588)  
[specializing request's query param property type from string to number is breaking](../checker/check_request_parameters_type_changed_test.go?plain=1#L225)  
[specifying a non-text, not-json stability level in base is breaking](../checker/checker_test.go?plain=1#L82)  
[specifying an invalid stability level in base is breaking](../checker/checker_test.go?plain=1#L65)  
[specifying an invalid stability level in revision is breaking](../checker/checker_test.go?plain=1#L48)  

## Examples of non-breaking changes
[adding a media-type to response is not breaking](../checker/check_not_breaking_test.go?plain=1#L184)  
[adding a new required property in response body is not breaking](../checker/check_breaking_property_test.go?plain=1#L407)  
[adding a new required property under AllOf in response body is not breaking](../checker/check_breaking_property_test.go?plain=1#L437)  
[adding a new required read-only property in request body is not breaking](../checker/check_breaking_property_test.go?plain=1#L467)  
[adding a non-existent required property in request body is not breaking](../checker/check_breaking_property_test.go?plain=1#L295)  
[adding a required property to response is not breaking](../checker/check_not_breaking_test.go?plain=1#L289)  
[adding a tag is not breaking](../checker/check_not_breaking_test.go?plain=1#L266)  
[adding an enum value is not breaking](../checker/check_not_breaking_test.go?plain=1#L82)  
[adding an enum value to request body is not breaking](../checker/check_breaking_property_test.go?plain=1#L139)  
[adding an operation ID is not breaking](../checker/check_not_breaking_test.go?plain=1#L277)  
[adding an optional request body is not breaking](../checker/check_not_breaking_test.go?plain=1#L38)  
[both max lengths in request are nil is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L178)  
[both max lengths in response are nil is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L192)  
[changing a link to operation ID is not breaking](../checker/check_not_breaking_test.go?plain=1#L175)  
[changing an existing property in request body items to required with a default value is not breaking](../checker/check_breaking_property_test.go?plain=1#L614)  
[changing an existing property in request body to optional is not breaking](../checker/check_breaking_property_test.go?plain=1#L323)  
[changing an existing property in request header to optional is not breaking](../checker/check_breaking_property_test.go?plain=1#L83)  
[changing an existing property in response body to required is not breaking](../checker/check_breaking_property_test.go?plain=1#L309)  
[changing an existing read-only property in request body to required is not breaking](../checker/check_breaking_property_test.go?plain=1#L481)  
[changing an existing required property in response body to write-only is not breaking](../checker/check_breaking_property_test.go?plain=1#L547)  
[changing an existing write-only property in response body to optional is not breaking](../checker/check_breaking_property_test.go?plain=1#L533)  
[changing comments is not breaking](../checker/check_not_breaking_test.go?plain=1#L106)  
[changing extensions is not breaking](../checker/check_not_breaking_test.go?plain=1#L94)  
[changing max length in request from any value to nil is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L144)  
[changing max length in response from nil to any value is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L128)  
[changing operation ID is not breaking](../checker/check_not_breaking_test.go?plain=1#L166)  
[changing request's body schema type from integer to number is not breaking](../checker/check_breaking_request_type_changed_test.go?plain=1#L72)  
[changing response's body schema type from number to integer is not breaking](../checker/check_breaking_response_type_changed_test.go?plain=1#L52)  
[changing response's body schema type from number/none to integer/int32 is not breaking](../checker/check_breaking_response_type_changed_test.go?plain=1#L90)  
[changing servers is not breaking](../checker/check_not_breaking_test.go?plain=1#L252)  
[deleting a path after sunset date of all contained operations is not breaking](../checker/check_api_deprecation_test.go?plain=1#L255)  
[deleting a pattern from a schema is not breaking](../checker/check_breaking_test.go?plain=1#L459)  
[deleting a required write-only property in response body is not breaking](../checker/check_breaking_property_test.go?plain=1#L495)  
[deleting a tag is not breaking](../checker/check_not_breaking_test.go?plain=1#L71)  
[deleting an operation after sunset date is not breaking](../checker/check_api_deprecation_test.go?plain=1#L33)  
[deleting an operation without sunset date is not breaking](../checker/check_api_removed_test.go?plain=1#L29)  
[deleting other extension (not sunset) header for a deprecated endpoint is not breaking](../checker/check_api_sunset_changed_test.go?plain=1#L84)  
[deprecating a header is not breaking](../checker/check_not_breaking_test.go?plain=1#L226)  
[deprecating a parameter is not breaking](../checker/check_not_breaking_test.go?plain=1#L213)  
[deprecating a schema is not breaking](../checker/check_not_breaking_test.go?plain=1#L239)  
[deprecating an operation with a default deprecation policy but without specifying sunset date is not breaking](../checker/check_api_deprecation_test.go?plain=1#L121)  
[deprecating an operation with a deprecation policy and sunset date after required deprecation period is not breaking](../checker/check_api_deprecation_test.go?plain=1#L234)  
[deprecating an operation without a deprecation policy and without specifying sunset date is not breaking for alpha level](../checker/check_api_deprecation_test.go?plain=1#L137)  
[deprecating an operation without a deprecation policy and without specifying sunset date is not breaking for draft level](../checker/check_api_deprecation_test.go?plain=1#L171)  
[deprecating an operation without a deprecation policy but without specifying sunset date is not breaking](../checker/check_api_deprecation_test.go?plain=1#L87)  
[descreasing request body min items is not breaking](../checker/check_request_property_min_items_increased_test.go?plain=1#L35)  
[increasing max length in request is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L76)  
[increasing min items in response is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L250)  
[increasing stability level is not breaking](../checker/checker_test.go?plain=1#L33)  
[modifying a pattern to ".*" in a schema is not breaking](../checker/check_breaking_test.go?plain=1#L556)  
[modifying a pattern to .* in a schema is not breaking](../checker/check_breaking_test.go?plain=1#L525)  
[modifying the default value of a required request parameter is not breaking](../checker/check_breaking_test.go?plain=1#L624)  
[new optional header param is not breaking](../checker/check_not_breaking_test.go?plain=1#L118)  
[new optional property in request header is not breaking](../checker/check_breaking_property_test.go?plain=1#L39)  
[new required response header param is not breaking](../checker/check_not_breaking_test.go?plain=1#L152)  
[no change is not breaking](../checker/check_not_breaking_test.go?plain=1#L27)  
[no change to headers for a deprecated endpoint is not breaking](../checker/check_api_sunset_changed_test.go?plain=1#L99)  
[reducing max in response is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L281)  
[reducing max length in response is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L31)  
[reducing min items in request is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L206)  
[reducing min length in request is not breaking](../checker/check_breaking_min_max_test.go?plain=1#L48)  
[removing an existing response with error status is not breaking](../checker/check_breaking_test.go?plain=1#L406)  
[removing an existing response with unparseable status is not breaking](../checker/check_breaking_test.go?plain=1#L390)  
[removing the path without a deprecation policy and without specifying sunset date is not breaking for alpha level](../checker/check_api_deprecation_test.go?plain=1#L152)  
[removing the path without a deprecation policy and without specifying sunset date is not breaking for draft level](../checker/check_api_deprecation_test.go?plain=1#L188)  
[renaming a path parameter is not breaking](../checker/check_breaking_test.go?plain=1#L136)  

## Examples of info-level changes for changelog
[adding 'allOf' subschema to the request body or request body property](../checker/check_request_property_all_of_updated_test.go?plain=1#L12)  
[adding 'allOf' subschema to the response body or response body property](../checker/check_response_property_all_of_updated_test.go?plain=1#L12)  
[adding 'anyOf' schema to the request body or request body property](../checker/check_request_property_any_of_updated_test.go?plain=1#L12)  
[adding 'anyOf' schema to the response body or response body property](../checker/check_response_property_any_of_updated_test.go?plain=1#L12)  
[adding 'oneOf' schema to the request body or request body property](../checker/check_request_property_one_of_updated_test.go?plain=1#L12)  
[adding 'oneOf' schema to the response body or response body property](../checker/check_response_property_one_of_updated_test.go?plain=1#L12)  
[adding a new global security to the API](../checker/check_api_security_updated_test.go?plain=1#L12)  
[adding a new media type to request body](../checker/check_request_body_mediatype_updated_test.go?plain=1#L12)  
[adding a new media type to response](../checker/check_response_mediatype_updated_test.go?plain=1#L12)  
[adding a new oauth security scope](../checker/check_components_security_updated_test.go?plain=1#L117)  
[adding a new operation id](../checker/check_api_operation_id_updated_test.go?plain=1#L62)  
[adding a new optional request property](../checker/check_request_property_updated_test.go?plain=1#L65)  
[adding a new required request property with a default value](../checker/check_request_property_updated_test.go?plain=1#L110)  
[adding a new required request property](../checker/check_request_property_updated_test.go?plain=1#L12)  
[adding a new security component](../checker/check_components_security_updated_test.go?plain=1#L77)  
[adding a new security to the API endpoint](../checker/check_api_security_updated_test.go?plain=1#L90)  
[adding a new tag](../checker/check_api_tag_updated_test.go?plain=1#L12)  
[adding a non-success response status](../checker/check_response_status_updated_test.go?plain=1#L37)  
[adding a required property to response body is detected](../checker/check_response_required_property_updated_test.go?plain=1#L12)  
[adding a required write-only property to response body is detected](../checker/check_response_required_property_updated_test.go?plain=1#L58)  
[adding a security scope from an API global security](../checker/check_api_security_updated_test.go?plain=1#L70)  
[adding a security scope to an API endpoint security](../checker/check_api_security_updated_test.go?plain=1#L156)  
[adding a success response status](../checker/check_response_status_updated_test.go?plain=1#L12)  
[adding an enum value to a response property](../checker/check_response_property_enum_value_added_test.go?plain=1#L12)  
[adding an enum value to a response write-only property](../checker/check_response_property_enum_value_added_test.go?plain=1#L38)  
[adding an enum value to request parameter](../checker/check_request_parameter_enum_value_updated_test.go?plain=1#L35)  
[adding an optional write-only property to a response](../checker/check_response_optional_property_updated_test.go?plain=1#L34)  
[adding discriminator to the request body or request body property](../checker/check_request_discriminator_updated_test.go?plain=1#L13)  
[adding discriminator to the response body or response property](../checker/check_response_discriminator_updated_test.go?plain=1#L13)  
[adding pattern to request parameters](../checker/check_request_parameter_pattern_added_or_changed_test.go?plain=1#L60)  
[adding request body default value or request property default value](../checker/check_request_property_default_value_changed_test.go?plain=1#L58)  
[adding request parameter default value](../checker/check_request_parameters_default_value_changed_test.go?plain=1#L34)  
[adding request property enum values](../checker/check_request_property_enum_value_updated_test.go?plain=1#L67)  
[adding request property pattern](../checker/check_request_property_pattern_added_or_changed_test.go?plain=1#L60)  
[adding response body default value or response body property default value](../checker/check_response_property_default_value_changed_test.go?plain=1#L64)  
[adding response property pattern](../checker/check_response_pattern_added_or_changed_test.go?plain=1#L37)  
[adding two new request properties, one required, one optional](../checker/check_request_property_updated_test.go?plain=1#L34)  
[changing a response property schema format](../checker/check_response_property_type_changed_test.go?plain=1#L60)  
[changing a response property schema type from a single value to to multiple types](../checker/check_response_property_type_changed_test.go?plain=1#L126)  
[changing a response property schema type from string to integer](../checker/check_response_property_type_changed_test.go?plain=1#L36)  
[changing a response schema type](../checker/check_response_property_type_changed_test.go?plain=1#L14)  
[changing an existing header param from required to optional](../checker/check_request_parameter_required_value_updated_test.go?plain=1#L35)  
[changing an existing header param to optional](../checker/check_not_breaking_test.go?plain=1#L132)  
[changing an existing request body from required to optional](../checker/check_not_breaking_test.go?plain=1#L53)  
[changing discriminator mapping in the request body or request body property](../checker/check_request_discriminator_updated_test.go?plain=1#L113)  
[changing discriminator mapping in the response body or response property](../checker/check_response_discriminator_updated_test.go?plain=1#L115)  
[changing discriminator propertyName in the request body or request body property](../checker/check_request_discriminator_updated_test.go?plain=1#L79)  
[changing discriminator propertyName in the response body or response property](../checker/check_response_discriminator_updated_test.go?plain=1#L81)  
[changing optional request property to not read-only](../checker/check_request_property_write_only_read_only_test.go?plain=1#L87)  
[changing optional request property to not write-only](../checker/check_request_property_write_only_read_only_test.go?plain=1#L37)  
[changing optional request property to read-only](../checker/check_request_property_write_only_read_only_test.go?plain=1#L62)  
[changing optional request property to write-only](../checker/check_request_property_write_only_read_only_test.go?plain=1#L12)  
[changing optional response property to not read-only](../checker/check_response_optional_property_write_only_read_only_test.go?plain=1#L87)  
[changing optional response property to not write-only](../checker/check_response_optional_property_write_only_read_only_test.go?plain=1#L37)  
[changing optional response property to read-only](../checker/check_response_optional_property_write_only_read_only_test.go?plain=1#L62)  
[changing optional response property to required](../checker/check_response_property_became_required_test.go?plain=1#L12)  
[changing optional response property to write-only](../checker/check_response_optional_property_write_only_read_only_test.go?plain=1#L12)  
[changing optional response write-only property to required](../checker/check_response_property_became_required_test.go?plain=1#L33)  
[changing pattern of request parameters](../checker/check_request_parameter_pattern_added_or_changed_test.go?plain=1#L12)  
[changing properties of subschemas under allOf](../checker/check_response_property_type_changed_test.go?plain=1#L84)  
[changing request body and property types from array to object](../checker/check_request_property_type_changed_test.go?plain=1#L87)  
[changing request body and property types from object to array](../checker/check_request_property_type_changed_test.go?plain=1#L119)  
[changing request body default value](../checker/check_request_property_default_value_changed_test.go?plain=1#L12)  
[changing request body to not nullable](../checker/check_request_property_became_not_nuallable_test.go?plain=1#L81)  
[changing request body to nullable](../checker/check_request_property_became_not_nuallable_test.go?plain=1#L57)  
[changing request body type](../checker/check_request_property_type_changed_test.go?plain=1#L14)  
[changing request header parameter format](../checker/check_request_parameters_type_changed_test.go?plain=1#L134)  
[changing request header parameter type](../checker/check_request_parameters_type_changed_test.go?plain=1#L62)  
[changing request parameter default value](../checker/check_request_parameters_default_value_changed_test.go?plain=1#L12)  
[changing request parameter type to enum](../checker/check_request_parameter_became_enum_test.go?plain=1#L12)  
[changing request path parameter format](../checker/check_request_parameters_type_changed_test.go?plain=1#L86)  
[changing request path parameter type by adding "string"](../checker/check_request_parameters_type_changed_test.go?plain=1#L158)  
[changing request path parameter type by replacing "integer" with "number"](../checker/check_request_parameters_type_changed_test.go?plain=1#L183)  
[changing request path parameter type](../checker/check_request_parameters_type_changed_test.go?plain=1#L14)  
[changing request property default value](../checker/check_request_property_default_value_changed_test.go?plain=1#L34)  
[changing request property format](../checker/check_request_property_type_changed_test.go?plain=1#L151)  
[changing request property pattern](../checker/check_request_property_pattern_added_or_changed_test.go?plain=1#L12)  
[changing request property required value to false](../checker/check_request_property_required_updated_test.go?plain=1#L35)  
[changing request property required value to true](../checker/check_request_property_required_updated_test.go?plain=1#L12)  
[changing request property to not nullable](../checker/check_request_property_became_not_nuallable_test.go?plain=1#L12)  
[changing request property to nullable](../checker/check_request_property_became_not_nuallable_test.go?plain=1#L34)  
[changing request property type](../checker/check_request_property_type_changed_test.go?plain=1#L64)  
[changing request query parameter format](../checker/check_request_parameters_type_changed_test.go?plain=1#L110)  
[changing request query parameter type](../checker/check_request_parameters_type_changed_test.go?plain=1#L38)  
[changing request's body to optional](../checker/check_request_body_required_value_updated_test.go?plain=1#L35)  
[changing request's body to required is breaking](../checker/check_request_body_required_value_updated_test.go?plain=1#L12)  
[changing required request property to not read-only](../checker/check_request_property_write_only_read_only_test.go?plain=1#L187)  
[changing required request property to not write-only](../checker/check_request_property_write_only_read_only_test.go?plain=1#L137)  
[changing required request property to read-only](../checker/check_request_property_write_only_read_only_test.go?plain=1#L162)  
[changing required request property to write-only](../checker/check_request_property_write_only_read_only_test.go?plain=1#L112)  
[changing required response property to not read-only](../checker/check_response_required_property_write_only_read_only_test.go?plain=1#L90)  
[changing required response property to not write-only](../checker/check_response_required_property_write_only_read_only_test.go?plain=1#L37)  
[changing required response property to optional](../checker/check_response_property_became_optional_test.go?plain=1#L12)  
[changing required response property to read-only](../checker/check_response_required_property_write_only_read_only_test.go?plain=1#L65)  
[changing required response property to write-only](../checker/check_response_required_property_write_only_read_only_test.go?plain=1#L12)  
[changing response body default value](../checker/check_response_property_default_value_changed_test.go?plain=1#L41)  
[changing response body property default value](../checker/check_response_property_default_value_changed_test.go?plain=1#L12)  
[changing response property pattern](../checker/check_response_pattern_added_or_changed_test.go?plain=1#L12)  
[changing security component oauth's url](../checker/check_components_security_updated_test.go?plain=1#L11)  
[changing security component token url](../checker/check_components_security_updated_test.go?plain=1#L33)  
[changing security component type](../checker/check_components_security_updated_test.go?plain=1#L55)  
[changing write-only required response property to optional](../checker/check_response_property_became_optional_test.go?plain=1#L33)  
[decreasing max length of request body](../checker/check_request_property_max_length_updated_test.go?plain=1#L40)  
[decreasing max length of request property](../checker/check_request_property_max_length_updated_test.go?plain=1#L68)  
[decreasing max length of request read-only property](../checker/check_request_property_max_length_updated_test.go?plain=1#L96)  
[decreasing maxItems of request parameters](../checker/check_request_parameters_max_items_updated_test.go?plain=1#L34)  
[decreasing maxLength of request parameters](../checker/check_request_parameters_max_length_updated_test.go?plain=1#L33)  
[decreasing maximum value of request parameter](../checker/check_request_parameters_max_updated_test.go?plain=1#L34)  
[decreasing minItems value of request parameter](../checker/check_request_parameters_min_items_updated_test.go?plain=1#L34)  
[decreasing minLength of request body](../checker/check_request_property_min_length_updated_test.go?plain=1#L84)  
[decreasing minLength of request property](../checker/check_request_property_min_length_updated_test.go?plain=1#L12)  
[decreasing minLength value of request parameter](../checker/check_request_parameters_min_length_updated_test.go?plain=1#L35)  
[decreasing minimum value of request parameter](../checker/check_request_parameters_min_updated_test.go?plain=1#L34)  
[decreasing minimum value of request property](../checker/check_request_property_min_updated_test.go?plain=1#L60)  
[decreasing request body maximum value](../checker/check_request_property_max_updated_test.go?plain=1#L119)  
[decreasing request property maximum value](../checker/check_request_property_max_updated_test.go?plain=1#L12)  
[decreasing request read-only property maximum value](../checker/check_request_property_max_updated_test.go?plain=1#L38)  
[deprecating an operation with sunset greater than min](../checker/check_not_breaking_test.go?plain=1#L198)  
[generalizing pattern of request parameters](../checker/check_request_parameter_pattern_added_or_changed_test.go?plain=1#L37)  
[generalizing request property format](../checker/check_request_property_type_changed_test.go?plain=1#L176)  
[generalizing request property pattern](../checker/check_request_property_pattern_added_or_changed_test.go?plain=1#L37)  
[generalizing request's query param property type from integer to number](../checker/check_request_parameters_type_changed_test.go?plain=1#L242)  
[increasing max length of request body](../checker/check_request_property_max_length_updated_test.go?plain=1#L12)  
[increasing max length of request property](../checker/check_request_property_max_length_updated_test.go?plain=1#L126)  
[increasing maxItems of request parameters](../checker/check_request_parameters_max_items_updated_test.go?plain=1#L12)  
[increasing maxLength of request parameters](../checker/check_request_parameters_max_length_updated_test.go?plain=1#L12)  
[increasing maximum value of request parameter](../checker/check_request_parameters_max_updated_test.go?plain=1#L12)  
[increasing minItems value of request parameter](../checker/check_request_parameters_min_items_updated_test.go?plain=1#L12)  
[increasing minLength of request body](../checker/check_request_property_min_length_updated_test.go?plain=1#L60)  
[increasing minLength of request property](../checker/check_request_property_min_length_updated_test.go?plain=1#L36)  
[increasing minLength value of request parameter](../checker/check_request_parameters_min_length_updated_test.go?plain=1#L12)  
[increasing minimum value of request parameter](../checker/check_request_parameters_min_updated_test.go?plain=1#L12)  
[increasing minimum value of request property](../checker/check_request_property_min_updated_test.go?plain=1#L12)  
[increasing minimum value of request read-only property](../checker/check_request_property_min_updated_test.go?plain=1#L35)  
[increasing request body maximum value](../checker/check_request_property_max_updated_test.go?plain=1#L91)  
[increasing request property maximum value](../checker/check_request_property_max_updated_test.go?plain=1#L65)  
[making request property required, while also giving it a default value](../checker/check_request_property_required_updated_test.go?plain=1#L58)  
[new header, query and cookie request params](../checker/check_new_request_non_path_parameter_test.go?plain=1#L11)  
[new paths or path operations](../checker/check_api_added_test.go?plain=1#L11)  
[path operations that became deprecated](../checker/check_api_deprecation_test.go?plain=1#L270)  
[path operations that were re-activated](../checker/check_api_deprecation_test.go?plain=1#L293)  
[removing 'allOf' subschema from the request body or request body property](../checker/check_request_property_all_of_updated_test.go?plain=1#L46)  
[removing 'allOf' subschema from the response body or response body property](../checker/check_response_property_all_of_updated_test.go?plain=1#L46)  
[removing 'anyOf' schema from the request body or request body property](../checker/check_request_property_any_of_updated_test.go?plain=1#L46)  
[removing 'anyOf' schema from the response body or response body property](../checker/check_response_property_any_of_updated_test.go?plain=1#L46)  
[removing 'oneOf' schema from the request body or request body property](../checker/check_request_property_one_of_updated_test.go?plain=1#L46)  
[removing 'oneOf' schema from the response body or response body property](../checker/check_response_property_one_of_updated_test.go?plain=1#L55)  
[removing a global security from the API](../checker/check_api_security_updated_test.go?plain=1#L31)  
[removing a new media type to response](../checker/check_response_mediatype_updated_test.go?plain=1#L34)  
[removing a new oauth security scope](../checker/check_components_security_updated_test.go?plain=1#L139)  
[removing a new security component](../checker/check_components_security_updated_test.go?plain=1#L97)  
[removing a new security to the API endpoint](../checker/check_api_security_updated_test.go?plain=1#L112)  
[removing a non-success response status](../checker/check_response_status_updated_test.go?plain=1#L62)  
[removing a required request property](../checker/check_request_property_updated_test.go?plain=1#L88)  
[removing a required write-only property that was required in response body is detected](../checker/check_response_required_property_updated_test.go?plain=1#L83)  
[removing a security scope from an API endpoint security](../checker/check_api_security_updated_test.go?plain=1#L134)  
[removing a security scope from an API global security](../checker/check_api_security_updated_test.go?plain=1#L50)  
[removing an enum value from a response property](../checker/check_response_property_enum_value_removed_test.go?plain=1#L12)  
[removing an enum value from a response write-only property](../checker/check_response_property_enum_value_removed_test.go?plain=1#L36)  
[removing an enum value from request parameter](../checker/check_request_parameter_enum_value_updated_test.go?plain=1#L12)  
[removing an existent property that was required in response body is detected](../checker/check_response_required_property_updated_test.go?plain=1#L35)  
[removing an existing operation id](../checker/check_api_operation_id_updated_test.go?plain=1#L12)  
[removing an existing tag](../checker/check_api_tag_updated_test.go?plain=1#L37)  
[removing an optional write-only property from a response](../checker/check_response_optional_property_updated_test.go?plain=1#L12)  
[removing discriminator from the request body or request body property](../checker/check_request_discriminator_updated_test.go?plain=1#L46)  
[removing discriminator from the response body or response property](../checker/check_response_discriminator_updated_test.go?plain=1#L47)  
[removing media type from request body](../checker/check_request_body_mediatype_updated_test.go?plain=1#L34)  
[removing pattern from request parameters](../checker/check_request_parameter_pattern_added_or_changed_test.go?plain=1#L83)  
[removing request body default value or request property default value](../checker/check_request_property_default_value_changed_test.go?plain=1#L91)  
[removing request parameter default value](../checker/check_request_parameters_default_value_changed_test.go?plain=1#L58)  
[removing request property enum values](../checker/check_request_property_enum_value_updated_test.go?plain=1#L12)  
[removing request property pattern](../checker/check_request_property_pattern_added_or_changed_test.go?plain=1#L83)  
[removing request read-only property enum values](../checker/check_request_property_enum_value_updated_test.go?plain=1#L39)  
[removing response body default value or response body property default value](../checker/check_response_property_default_value_changed_test.go?plain=1#L97)  
[removing response property pattern](../checker/check_response_pattern_added_or_changed_test.go?plain=1#L62)  
[setting max of request body](../checker/check_request_property_max_set_test.go?plain=1#L12)  
[setting max of request propreties](../checker/check_request_property_max_set_test.go?plain=1#L35)  
[setting maxLength of request body](../checker/check_request_property_max_length_set_test.go?plain=1#L12)  
[setting maxLength of request parameters](../checker/check_request_parameters_max_length_set_test.go?plain=1#L12)  
[setting maxLength of request propreties](../checker/check_request_property_max_length_set_test.go?plain=1#L35)  
[updating an existing operation id](../checker/check_api_operation_id_updated_test.go?plain=1#L36)  
[updating an existing tag](../checker/check_api_tag_updated_test.go?plain=1#L64)  
