package common

import (
	"os/exec"
	"runtime"
	"strings"

	"github.com/gravitl/netmaker/logger"
)

// *** Added here to avoid cyclic pkg import dependency with netclient ***
const (
	// LinuxAppDataPath - linux path
	LinuxAppDataPath = "/etc/netclient/"
	// MacAppDataPath - mac path
	MacAppDataPath = "/Applications/Netclient/"
	// WindowsAppDataPath - windows path
	WindowsAppDataPath = "C:\\Program Files (x86)\\Netclient\\"
)

// RunCmd - runs a local command
func RunCmd(command string, printerr bool) (string, error) {
	args := strings.Fields(command)
	cmd := exec.Command(args[0], args[1:]...)
	cmd.Wait()
	out, err := cmd.CombinedOutput()
	if err != nil && printerr {
		logger.Log(1, "error running command: ", command)
		logger.Log(1, strings.TrimSuffix(string(out), "\n"))
	}
	return string(out), err
}

// GetDataPath - returns path to netclient config directory
func GetDataPath() string {
	if runtime.GOOS == "windows" {
		return WindowsAppDataPath
	} else if runtime.GOOS == "darwin" {
		return MacAppDataPath
	} else {
		return LinuxAppDataPath
	}
}
