{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='daemonSetStatus', url='', help='"DaemonSetStatus represents the current status of a daemon set."'),
  '#withCollisionCount':: d.fn(help='"Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision."', args=[d.arg(name='collisionCount', type=d.T.integer)]),
  withCollisionCount(collisionCount): { collisionCount: collisionCount },
  '#withConditions':: d.fn(help="\"Represents the latest available observations of a DaemonSet's current state.\"", args=[d.arg(name='conditions', type=d.T.array)]),
  withConditions(conditions): { conditions: if std.isArray(v=conditions) then conditions else [conditions] },
  '#withConditionsMixin':: d.fn(help="\"Represents the latest available observations of a DaemonSet's current state.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='conditions', type=d.T.array)]),
  withConditionsMixin(conditions): { conditions+: if std.isArray(v=conditions) then conditions else [conditions] },
  '#withCurrentNumberScheduled':: d.fn(help='"The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/"', args=[d.arg(name='currentNumberScheduled', type=d.T.integer)]),
  withCurrentNumberScheduled(currentNumberScheduled): { currentNumberScheduled: currentNumberScheduled },
  '#withDesiredNumberScheduled':: d.fn(help='"The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/"', args=[d.arg(name='desiredNumberScheduled', type=d.T.integer)]),
  withDesiredNumberScheduled(desiredNumberScheduled): { desiredNumberScheduled: desiredNumberScheduled },
  '#withNumberAvailable':: d.fn(help='"The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)"', args=[d.arg(name='numberAvailable', type=d.T.integer)]),
  withNumberAvailable(numberAvailable): { numberAvailable: numberAvailable },
  '#withNumberMisscheduled':: d.fn(help='"The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/"', args=[d.arg(name='numberMisscheduled', type=d.T.integer)]),
  withNumberMisscheduled(numberMisscheduled): { numberMisscheduled: numberMisscheduled },
  '#withNumberReady':: d.fn(help='"numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition."', args=[d.arg(name='numberReady', type=d.T.integer)]),
  withNumberReady(numberReady): { numberReady: numberReady },
  '#withNumberUnavailable':: d.fn(help='"The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)"', args=[d.arg(name='numberUnavailable', type=d.T.integer)]),
  withNumberUnavailable(numberUnavailable): { numberUnavailable: numberUnavailable },
  '#withObservedGeneration':: d.fn(help='"The most recent generation observed by the daemon set controller."', args=[d.arg(name='observedGeneration', type=d.T.integer)]),
  withObservedGeneration(observedGeneration): { observedGeneration: observedGeneration },
  '#withUpdatedNumberScheduled':: d.fn(help='"The total number of nodes that are running updated daemon pod"', args=[d.arg(name='updatedNumberScheduled', type=d.T.integer)]),
  withUpdatedNumberScheduled(updatedNumberScheduled): { updatedNumberScheduled: updatedNumberScheduled },
  '#mixin': 'ignore',
  mixin: self,
}
