// Code generated by protoc-gen-validate
// source: envoy/api/v2/endpoint/endpoint.proto
// DO NOT EDIT!!!

package endpoint

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on Endpoint with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *Endpoint) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return EndpointValidationError{
				Field:  "Address",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetHealthCheckConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return EndpointValidationError{
				Field:  "HealthCheckConfig",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// EndpointValidationError is the validation error returned by
// Endpoint.Validate if the designated constraints aren't met.
type EndpointValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e EndpointValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndpoint.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = EndpointValidationError{}

// Validate checks the field values on LbEndpoint with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *LbEndpoint) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetEndpoint()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LbEndpointValidationError{
				Field:  "Endpoint",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for HealthStatus

	if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LbEndpointValidationError{
				Field:  "Metadata",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if wrapper := m.GetLoadBalancingWeight(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 128 {
			return LbEndpointValidationError{
				Field:  "LoadBalancingWeight",
				Reason: "value must be inside range [1, 128]",
			}
		}

	}

	return nil
}

// LbEndpointValidationError is the validation error returned by
// LbEndpoint.Validate if the designated constraints aren't met.
type LbEndpointValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e LbEndpointValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLbEndpoint.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = LbEndpointValidationError{}

// Validate checks the field values on LocalityLbEndpoints with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *LocalityLbEndpoints) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetLocality()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LocalityLbEndpointsValidationError{
				Field:  "Locality",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	for idx, item := range m.GetLbEndpoints() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LocalityLbEndpointsValidationError{
					Field:  fmt.Sprintf("LbEndpoints[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	if wrapper := m.GetLoadBalancingWeight(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 128 {
			return LocalityLbEndpointsValidationError{
				Field:  "LoadBalancingWeight",
				Reason: "value must be inside range [1, 128]",
			}
		}

	}

	// no validation rules for Priority

	return nil
}

// LocalityLbEndpointsValidationError is the validation error returned by
// LocalityLbEndpoints.Validate if the designated constraints aren't met.
type LocalityLbEndpointsValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e LocalityLbEndpointsValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLocalityLbEndpoints.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = LocalityLbEndpointsValidationError{}

// Validate checks the field values on Endpoint_HealthCheckConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Endpoint_HealthCheckConfig) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for PortValue

	return nil
}

// Endpoint_HealthCheckConfigValidationError is the validation error returned
// by Endpoint_HealthCheckConfig.Validate if the designated constraints aren't met.
type Endpoint_HealthCheckConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Endpoint_HealthCheckConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndpoint_HealthCheckConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Endpoint_HealthCheckConfigValidationError{}
