/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	"encoding/json"
	"time"
)

// Task struct for Task
type Task struct {
	Id string `json:"id" yaml:"id"`
	// The ID of the organization that owns the task.
	OrgID string `json:"orgID" yaml:"orgID"`
	// The name of the organization that owns the task.
	Org *string `json:"org,omitempty" yaml:"org,omitempty"`
	// The name of the task.
	Name string `json:"name" yaml:"name"`
	// The ID of the user who owns the task.
	OwnerID *string `json:"ownerID,omitempty" yaml:"ownerID,omitempty"`
	// The description of the task.
	Description *string         `json:"description,omitempty" yaml:"description,omitempty"`
	Status      *TaskStatusType `json:"status,omitempty" yaml:"status,omitempty"`
	Labels      *[]Label        `json:"labels,omitempty" yaml:"labels,omitempty"`
	// The ID of the authorization used when the task communicates with the query engine.
	AuthorizationID *string `json:"authorizationID,omitempty" yaml:"authorizationID,omitempty"`
	// The Flux script that the task runs.  #### Limitations  - If you use the `flux` property, you can't use the `scriptID` and `scriptParameters` properties.
	Flux *string `json:"flux,omitempty" yaml:"flux,omitempty"`
	// The interval ([duration literal]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#rfc3339-timestamp)) at which the task runs. `every` also determines when the task first runs, depending on the specified time.
	Every *string `json:"every,omitempty" yaml:"every,omitempty"`
	// A [Cron expression](https://en.wikipedia.org/wiki/Cron#Overview) that defines the schedule on which the task runs. InfluxDB uses the system time when evaluating Cron expressions.
	Cron *string `json:"cron,omitempty" yaml:"cron,omitempty"`
	// A [duration](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals) to delay execution of the task after the scheduled time has elapsed. `0` removes the offset.
	Offset *string `json:"offset,omitempty" yaml:"offset,omitempty"`
	// A timestamp ([RFC3339 date/time format]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#rfc3339-timestamp)) of the latest scheduled and completed run.
	LatestCompleted *time.Time `json:"latestCompleted,omitempty" yaml:"latestCompleted,omitempty"`
	LastRunStatus   *string    `json:"lastRunStatus,omitempty" yaml:"lastRunStatus,omitempty"`
	LastRunError    *string    `json:"lastRunError,omitempty" yaml:"lastRunError,omitempty"`
	CreatedAt       *time.Time `json:"createdAt,omitempty" yaml:"createdAt,omitempty"`
	UpdatedAt       *time.Time `json:"updatedAt,omitempty" yaml:"updatedAt,omitempty"`
	Links           *TaskLinks `json:"links,omitempty" yaml:"links,omitempty"`
	// The ID of the script that the task runs.  #### Limitations  - If you use the `scriptID` property, you can't use the `flux` property.
	ScriptID *string `json:"scriptID,omitempty" yaml:"scriptID,omitempty"`
	// The parameter key-value pairs passed to the script (referenced by `scriptID`) during the task run.  #### Limitations  - `scriptParameters` requires `scriptID`. - If you use the `scriptID` and `scriptParameters` properties, you can't use the `flux` property.
	ScriptParameters *map[string]interface{} `json:"scriptParameters,omitempty" yaml:"scriptParameters,omitempty"`
}

// NewTask instantiates a new Task object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTask(id string, orgID string, name string) *Task {
	this := Task{}
	this.Id = id
	this.OrgID = orgID
	this.Name = name
	return &this
}

// NewTaskWithDefaults instantiates a new Task object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTaskWithDefaults() *Task {
	this := Task{}
	return &this
}

// GetId returns the Id field value
func (o *Task) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *Task) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *Task) SetId(v string) {
	o.Id = v
}

// GetOrgID returns the OrgID field value
func (o *Task) GetOrgID() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.OrgID
}

// GetOrgIDOk returns a tuple with the OrgID field value
// and a boolean to check if the value has been set.
func (o *Task) GetOrgIDOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.OrgID, true
}

// SetOrgID sets field value
func (o *Task) SetOrgID(v string) {
	o.OrgID = v
}

// GetOrg returns the Org field value if set, zero value otherwise.
func (o *Task) GetOrg() string {
	if o == nil || o.Org == nil {
		var ret string
		return ret
	}
	return *o.Org
}

// GetOrgOk returns a tuple with the Org field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetOrgOk() (*string, bool) {
	if o == nil || o.Org == nil {
		return nil, false
	}
	return o.Org, true
}

// HasOrg returns a boolean if a field has been set.
func (o *Task) HasOrg() bool {
	if o != nil && o.Org != nil {
		return true
	}

	return false
}

// SetOrg gets a reference to the given string and assigns it to the Org field.
func (o *Task) SetOrg(v string) {
	o.Org = &v
}

// GetName returns the Name field value
func (o *Task) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *Task) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *Task) SetName(v string) {
	o.Name = v
}

// GetOwnerID returns the OwnerID field value if set, zero value otherwise.
func (o *Task) GetOwnerID() string {
	if o == nil || o.OwnerID == nil {
		var ret string
		return ret
	}
	return *o.OwnerID
}

// GetOwnerIDOk returns a tuple with the OwnerID field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetOwnerIDOk() (*string, bool) {
	if o == nil || o.OwnerID == nil {
		return nil, false
	}
	return o.OwnerID, true
}

// HasOwnerID returns a boolean if a field has been set.
func (o *Task) HasOwnerID() bool {
	if o != nil && o.OwnerID != nil {
		return true
	}

	return false
}

// SetOwnerID gets a reference to the given string and assigns it to the OwnerID field.
func (o *Task) SetOwnerID(v string) {
	o.OwnerID = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *Task) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *Task) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *Task) SetDescription(v string) {
	o.Description = &v
}

// GetStatus returns the Status field value if set, zero value otherwise.
func (o *Task) GetStatus() TaskStatusType {
	if o == nil || o.Status == nil {
		var ret TaskStatusType
		return ret
	}
	return *o.Status
}

// GetStatusOk returns a tuple with the Status field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetStatusOk() (*TaskStatusType, bool) {
	if o == nil || o.Status == nil {
		return nil, false
	}
	return o.Status, true
}

// HasStatus returns a boolean if a field has been set.
func (o *Task) HasStatus() bool {
	if o != nil && o.Status != nil {
		return true
	}

	return false
}

// SetStatus gets a reference to the given TaskStatusType and assigns it to the Status field.
func (o *Task) SetStatus(v TaskStatusType) {
	o.Status = &v
}

// GetLabels returns the Labels field value if set, zero value otherwise.
func (o *Task) GetLabels() []Label {
	if o == nil || o.Labels == nil {
		var ret []Label
		return ret
	}
	return *o.Labels
}

// GetLabelsOk returns a tuple with the Labels field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetLabelsOk() (*[]Label, bool) {
	if o == nil || o.Labels == nil {
		return nil, false
	}
	return o.Labels, true
}

// HasLabels returns a boolean if a field has been set.
func (o *Task) HasLabels() bool {
	if o != nil && o.Labels != nil {
		return true
	}

	return false
}

// SetLabels gets a reference to the given []Label and assigns it to the Labels field.
func (o *Task) SetLabels(v []Label) {
	o.Labels = &v
}

// GetAuthorizationID returns the AuthorizationID field value if set, zero value otherwise.
func (o *Task) GetAuthorizationID() string {
	if o == nil || o.AuthorizationID == nil {
		var ret string
		return ret
	}
	return *o.AuthorizationID
}

// GetAuthorizationIDOk returns a tuple with the AuthorizationID field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetAuthorizationIDOk() (*string, bool) {
	if o == nil || o.AuthorizationID == nil {
		return nil, false
	}
	return o.AuthorizationID, true
}

// HasAuthorizationID returns a boolean if a field has been set.
func (o *Task) HasAuthorizationID() bool {
	if o != nil && o.AuthorizationID != nil {
		return true
	}

	return false
}

// SetAuthorizationID gets a reference to the given string and assigns it to the AuthorizationID field.
func (o *Task) SetAuthorizationID(v string) {
	o.AuthorizationID = &v
}

// GetFlux returns the Flux field value if set, zero value otherwise.
func (o *Task) GetFlux() string {
	if o == nil || o.Flux == nil {
		var ret string
		return ret
	}
	return *o.Flux
}

// GetFluxOk returns a tuple with the Flux field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetFluxOk() (*string, bool) {
	if o == nil || o.Flux == nil {
		return nil, false
	}
	return o.Flux, true
}

// HasFlux returns a boolean if a field has been set.
func (o *Task) HasFlux() bool {
	if o != nil && o.Flux != nil {
		return true
	}

	return false
}

// SetFlux gets a reference to the given string and assigns it to the Flux field.
func (o *Task) SetFlux(v string) {
	o.Flux = &v
}

// GetEvery returns the Every field value if set, zero value otherwise.
func (o *Task) GetEvery() string {
	if o == nil || o.Every == nil {
		var ret string
		return ret
	}
	return *o.Every
}

// GetEveryOk returns a tuple with the Every field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetEveryOk() (*string, bool) {
	if o == nil || o.Every == nil {
		return nil, false
	}
	return o.Every, true
}

// HasEvery returns a boolean if a field has been set.
func (o *Task) HasEvery() bool {
	if o != nil && o.Every != nil {
		return true
	}

	return false
}

// SetEvery gets a reference to the given string and assigns it to the Every field.
func (o *Task) SetEvery(v string) {
	o.Every = &v
}

// GetCron returns the Cron field value if set, zero value otherwise.
func (o *Task) GetCron() string {
	if o == nil || o.Cron == nil {
		var ret string
		return ret
	}
	return *o.Cron
}

// GetCronOk returns a tuple with the Cron field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetCronOk() (*string, bool) {
	if o == nil || o.Cron == nil {
		return nil, false
	}
	return o.Cron, true
}

// HasCron returns a boolean if a field has been set.
func (o *Task) HasCron() bool {
	if o != nil && o.Cron != nil {
		return true
	}

	return false
}

// SetCron gets a reference to the given string and assigns it to the Cron field.
func (o *Task) SetCron(v string) {
	o.Cron = &v
}

// GetOffset returns the Offset field value if set, zero value otherwise.
func (o *Task) GetOffset() string {
	if o == nil || o.Offset == nil {
		var ret string
		return ret
	}
	return *o.Offset
}

// GetOffsetOk returns a tuple with the Offset field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetOffsetOk() (*string, bool) {
	if o == nil || o.Offset == nil {
		return nil, false
	}
	return o.Offset, true
}

// HasOffset returns a boolean if a field has been set.
func (o *Task) HasOffset() bool {
	if o != nil && o.Offset != nil {
		return true
	}

	return false
}

// SetOffset gets a reference to the given string and assigns it to the Offset field.
func (o *Task) SetOffset(v string) {
	o.Offset = &v
}

// GetLatestCompleted returns the LatestCompleted field value if set, zero value otherwise.
func (o *Task) GetLatestCompleted() time.Time {
	if o == nil || o.LatestCompleted == nil {
		var ret time.Time
		return ret
	}
	return *o.LatestCompleted
}

// GetLatestCompletedOk returns a tuple with the LatestCompleted field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetLatestCompletedOk() (*time.Time, bool) {
	if o == nil || o.LatestCompleted == nil {
		return nil, false
	}
	return o.LatestCompleted, true
}

// HasLatestCompleted returns a boolean if a field has been set.
func (o *Task) HasLatestCompleted() bool {
	if o != nil && o.LatestCompleted != nil {
		return true
	}

	return false
}

// SetLatestCompleted gets a reference to the given time.Time and assigns it to the LatestCompleted field.
func (o *Task) SetLatestCompleted(v time.Time) {
	o.LatestCompleted = &v
}

// GetLastRunStatus returns the LastRunStatus field value if set, zero value otherwise.
func (o *Task) GetLastRunStatus() string {
	if o == nil || o.LastRunStatus == nil {
		var ret string
		return ret
	}
	return *o.LastRunStatus
}

// GetLastRunStatusOk returns a tuple with the LastRunStatus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetLastRunStatusOk() (*string, bool) {
	if o == nil || o.LastRunStatus == nil {
		return nil, false
	}
	return o.LastRunStatus, true
}

// HasLastRunStatus returns a boolean if a field has been set.
func (o *Task) HasLastRunStatus() bool {
	if o != nil && o.LastRunStatus != nil {
		return true
	}

	return false
}

// SetLastRunStatus gets a reference to the given string and assigns it to the LastRunStatus field.
func (o *Task) SetLastRunStatus(v string) {
	o.LastRunStatus = &v
}

// GetLastRunError returns the LastRunError field value if set, zero value otherwise.
func (o *Task) GetLastRunError() string {
	if o == nil || o.LastRunError == nil {
		var ret string
		return ret
	}
	return *o.LastRunError
}

// GetLastRunErrorOk returns a tuple with the LastRunError field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetLastRunErrorOk() (*string, bool) {
	if o == nil || o.LastRunError == nil {
		return nil, false
	}
	return o.LastRunError, true
}

// HasLastRunError returns a boolean if a field has been set.
func (o *Task) HasLastRunError() bool {
	if o != nil && o.LastRunError != nil {
		return true
	}

	return false
}

// SetLastRunError gets a reference to the given string and assigns it to the LastRunError field.
func (o *Task) SetLastRunError(v string) {
	o.LastRunError = &v
}

// GetCreatedAt returns the CreatedAt field value if set, zero value otherwise.
func (o *Task) GetCreatedAt() time.Time {
	if o == nil || o.CreatedAt == nil {
		var ret time.Time
		return ret
	}
	return *o.CreatedAt
}

// GetCreatedAtOk returns a tuple with the CreatedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetCreatedAtOk() (*time.Time, bool) {
	if o == nil || o.CreatedAt == nil {
		return nil, false
	}
	return o.CreatedAt, true
}

// HasCreatedAt returns a boolean if a field has been set.
func (o *Task) HasCreatedAt() bool {
	if o != nil && o.CreatedAt != nil {
		return true
	}

	return false
}

// SetCreatedAt gets a reference to the given time.Time and assigns it to the CreatedAt field.
func (o *Task) SetCreatedAt(v time.Time) {
	o.CreatedAt = &v
}

// GetUpdatedAt returns the UpdatedAt field value if set, zero value otherwise.
func (o *Task) GetUpdatedAt() time.Time {
	if o == nil || o.UpdatedAt == nil {
		var ret time.Time
		return ret
	}
	return *o.UpdatedAt
}

// GetUpdatedAtOk returns a tuple with the UpdatedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetUpdatedAtOk() (*time.Time, bool) {
	if o == nil || o.UpdatedAt == nil {
		return nil, false
	}
	return o.UpdatedAt, true
}

// HasUpdatedAt returns a boolean if a field has been set.
func (o *Task) HasUpdatedAt() bool {
	if o != nil && o.UpdatedAt != nil {
		return true
	}

	return false
}

// SetUpdatedAt gets a reference to the given time.Time and assigns it to the UpdatedAt field.
func (o *Task) SetUpdatedAt(v time.Time) {
	o.UpdatedAt = &v
}

// GetLinks returns the Links field value if set, zero value otherwise.
func (o *Task) GetLinks() TaskLinks {
	if o == nil || o.Links == nil {
		var ret TaskLinks
		return ret
	}
	return *o.Links
}

// GetLinksOk returns a tuple with the Links field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetLinksOk() (*TaskLinks, bool) {
	if o == nil || o.Links == nil {
		return nil, false
	}
	return o.Links, true
}

// HasLinks returns a boolean if a field has been set.
func (o *Task) HasLinks() bool {
	if o != nil && o.Links != nil {
		return true
	}

	return false
}

// SetLinks gets a reference to the given TaskLinks and assigns it to the Links field.
func (o *Task) SetLinks(v TaskLinks) {
	o.Links = &v
}

// GetScriptID returns the ScriptID field value if set, zero value otherwise.
func (o *Task) GetScriptID() string {
	if o == nil || o.ScriptID == nil {
		var ret string
		return ret
	}
	return *o.ScriptID
}

// GetScriptIDOk returns a tuple with the ScriptID field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetScriptIDOk() (*string, bool) {
	if o == nil || o.ScriptID == nil {
		return nil, false
	}
	return o.ScriptID, true
}

// HasScriptID returns a boolean if a field has been set.
func (o *Task) HasScriptID() bool {
	if o != nil && o.ScriptID != nil {
		return true
	}

	return false
}

// SetScriptID gets a reference to the given string and assigns it to the ScriptID field.
func (o *Task) SetScriptID(v string) {
	o.ScriptID = &v
}

// GetScriptParameters returns the ScriptParameters field value if set, zero value otherwise.
func (o *Task) GetScriptParameters() map[string]interface{} {
	if o == nil || o.ScriptParameters == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.ScriptParameters
}

// GetScriptParametersOk returns a tuple with the ScriptParameters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Task) GetScriptParametersOk() (*map[string]interface{}, bool) {
	if o == nil || o.ScriptParameters == nil {
		return nil, false
	}
	return o.ScriptParameters, true
}

// HasScriptParameters returns a boolean if a field has been set.
func (o *Task) HasScriptParameters() bool {
	if o != nil && o.ScriptParameters != nil {
		return true
	}

	return false
}

// SetScriptParameters gets a reference to the given map[string]interface{} and assigns it to the ScriptParameters field.
func (o *Task) SetScriptParameters(v map[string]interface{}) {
	o.ScriptParameters = &v
}

func (o Task) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["id"] = o.Id
	}
	if true {
		toSerialize["orgID"] = o.OrgID
	}
	if o.Org != nil {
		toSerialize["org"] = o.Org
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.OwnerID != nil {
		toSerialize["ownerID"] = o.OwnerID
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Status != nil {
		toSerialize["status"] = o.Status
	}
	if o.Labels != nil {
		toSerialize["labels"] = o.Labels
	}
	if o.AuthorizationID != nil {
		toSerialize["authorizationID"] = o.AuthorizationID
	}
	if o.Flux != nil {
		toSerialize["flux"] = o.Flux
	}
	if o.Every != nil {
		toSerialize["every"] = o.Every
	}
	if o.Cron != nil {
		toSerialize["cron"] = o.Cron
	}
	if o.Offset != nil {
		toSerialize["offset"] = o.Offset
	}
	if o.LatestCompleted != nil {
		toSerialize["latestCompleted"] = o.LatestCompleted
	}
	if o.LastRunStatus != nil {
		toSerialize["lastRunStatus"] = o.LastRunStatus
	}
	if o.LastRunError != nil {
		toSerialize["lastRunError"] = o.LastRunError
	}
	if o.CreatedAt != nil {
		toSerialize["createdAt"] = o.CreatedAt
	}
	if o.UpdatedAt != nil {
		toSerialize["updatedAt"] = o.UpdatedAt
	}
	if o.Links != nil {
		toSerialize["links"] = o.Links
	}
	if o.ScriptID != nil {
		toSerialize["scriptID"] = o.ScriptID
	}
	if o.ScriptParameters != nil {
		toSerialize["scriptParameters"] = o.ScriptParameters
	}
	return json.Marshal(toSerialize)
}

type NullableTask struct {
	value *Task
	isSet bool
}

func (v NullableTask) Get() *Task {
	return v.value
}

func (v *NullableTask) Set(val *Task) {
	v.value = val
	v.isSet = true
}

func (v NullableTask) IsSet() bool {
	return v.isSet
}

func (v *NullableTask) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTask(val *Task) *NullableTask {
	return &NullableTask{value: val, isSet: true}
}

func (v NullableTask) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTask) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
