// Copyright 2018 The go-python Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Test data generated by make_grammar_test.py - do not edit

package parser

import (
	"github.com/go-python/gpython/py"
)

var grammarTestData = []struct {
	in            string
	mode          string
	out           string
	exceptionType *py.Type
	errString     string
}{
	{"", "exec", "Module(body=[])", nil, ""},
	{"\n", "exec", "Module(body=[])", nil, ""},
	{"()", "eval", "Expression(body=Tuple(elts=[], ctx=Load()))", nil, ""},
	{"()", "exec", "Module(body=[Expr(value=Tuple(elts=[], ctx=Load()))])", nil, ""},
	{"[ ]", "exec", "Module(body=[Expr(value=List(elts=[], ctx=Load()))])", nil, ""},
	{"True\n", "eval", "Expression(body=NameConstant(value=True))", nil, ""},
	{"False\n", "eval", "Expression(body=NameConstant(value=False))", nil, ""},
	{"None\n", "eval", "Expression(body=NameConstant(value=None))", nil, ""},
	{"...", "eval", "Expression(body=Ellipsis())", nil, ""},
	{"abc123", "eval", "Expression(body=Name(id='abc123', ctx=Load()))", nil, ""},
	{"\"abc\"", "eval", "Expression(body=Str(s='abc'))", nil, ""},
	{"\"abc\" \"\"\"123\"\"\"", "eval", "Expression(body=Str(s='abc123'))", nil, ""},
	{"b'abc'", "eval", "Expression(body=Bytes(s=b'abc'))", nil, ""},
	{"b'abc' b'''123'''", "eval", "Expression(body=Bytes(s=b'abc123'))", nil, ""},
	{"1234", "eval", "Expression(body=Num(n=1234))", nil, ""},
	{"01234", "eval", "", py.SyntaxError, "illegal decimal with leading zero"},
	{"1234d", "eval", "", py.SyntaxError, "invalid syntax"},
	{"1234d", "exec", "", py.SyntaxError, "invalid syntax"},
	{"1234d", "single", "", py.SyntaxError, "unexpected EOF while parsing"},
	{"0x1234", "eval", "Expression(body=Num(n=4660))", nil, ""},
	{"12.34", "eval", "Expression(body=Num(n=12.34))", nil, ""},
	{"1,", "eval", "Expression(body=Tuple(elts=[Num(n=1)], ctx=Load()))", nil, ""},
	{"1,2", "eval", "Expression(body=Tuple(elts=[Num(n=1), Num(n=2)], ctx=Load()))", nil, ""},
	{"1,2,", "eval", "Expression(body=Tuple(elts=[Num(n=1), Num(n=2)], ctx=Load()))", nil, ""},
	{"{ }", "eval", "Expression(body=Dict(keys=[], values=[]))", nil, ""},
	{"{1}", "eval", "Expression(body=Set(elts=[Num(n=1)]))", nil, ""},
	{"{1,}", "eval", "Expression(body=Set(elts=[Num(n=1)]))", nil, ""},
	{"{1,2}", "eval", "Expression(body=Set(elts=[Num(n=1), Num(n=2)]))", nil, ""},
	{"{1,2,3,}", "eval", "Expression(body=Set(elts=[Num(n=1), Num(n=2), Num(n=3)]))", nil, ""},
	{"{ 'a':1 }", "eval", "Expression(body=Dict(keys=[Str(s='a')], values=[Num(n=1)]))", nil, ""},
	{"{ 'a':1, 'b':2 }", "eval", "Expression(body=Dict(keys=[Str(s='a'), Str(s='b')], values=[Num(n=1), Num(n=2)]))", nil, ""},
	{"{ 'a':{'aa':11, 'bb':{'aa':11, 'bb':22}}, 'b':{'aa':11, 'bb':22} }", "eval", "Expression(body=Dict(keys=[Str(s='a'), Str(s='b')], values=[Dict(keys=[Str(s='aa'), Str(s='bb')], values=[Num(n=11), Dict(keys=[Str(s='aa'), Str(s='bb')], values=[Num(n=11), Num(n=22)])]), Dict(keys=[Str(s='aa'), Str(s='bb')], values=[Num(n=11), Num(n=22)])]))", nil, ""},
	{"(1)", "eval", "Expression(body=Num(n=1))", nil, ""},
	{"(1,)", "eval", "Expression(body=Tuple(elts=[Num(n=1)], ctx=Load()))", nil, ""},
	{"(1,2)", "eval", "Expression(body=Tuple(elts=[Num(n=1), Num(n=2)], ctx=Load()))", nil, ""},
	{"(1,2,)", "eval", "Expression(body=Tuple(elts=[Num(n=1), Num(n=2)], ctx=Load()))", nil, ""},
	{"{(1,2)}", "eval", "Expression(body=Set(elts=[Tuple(elts=[Num(n=1), Num(n=2)], ctx=Load())]))", nil, ""},
	{"(((((1,),(2,),),(2,),),((1,),(2,),),),((1,),(2,),))", "eval", "Expression(body=Tuple(elts=[Tuple(elts=[Tuple(elts=[Tuple(elts=[Tuple(elts=[Num(n=1)], ctx=Load()), Tuple(elts=[Num(n=2)], ctx=Load())], ctx=Load()), Tuple(elts=[Num(n=2)], ctx=Load())], ctx=Load()), Tuple(elts=[Tuple(elts=[Num(n=1)], ctx=Load()), Tuple(elts=[Num(n=2)], ctx=Load())], ctx=Load())], ctx=Load()), Tuple(elts=[Tuple(elts=[Num(n=1)], ctx=Load()), Tuple(elts=[Num(n=2)], ctx=Load())], ctx=Load())], ctx=Load()))", nil, ""},
	{"(((1)))", "eval", "Expression(body=Num(n=1))", nil, ""},
	{"[1]", "eval", "Expression(body=List(elts=[Num(n=1)], ctx=Load()))", nil, ""},
	{"[1,]", "eval", "Expression(body=List(elts=[Num(n=1)], ctx=Load()))", nil, ""},
	{"[1,2]", "eval", "Expression(body=List(elts=[Num(n=1), Num(n=2)], ctx=Load()))", nil, ""},
	{"[1,2,]", "eval", "Expression(body=List(elts=[Num(n=1), Num(n=2)], ctx=Load()))", nil, ""},
	{"[e for e in (1,2,3)]", "eval", "Expression(body=ListComp(elt=Name(id='e', ctx=Load()), generators=[comprehension(target=Name(id='e', ctx=Store()), iter=Tuple(elts=[Num(n=1), Num(n=2), Num(n=3)], ctx=Load()), ifs=[])]))", nil, ""},
	{"( a for a in ab )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"( a for a, in ab )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Tuple(elts=[Name(id='a', ctx=Store())], ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"( a for a, b in ab )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"( a for a in ab if a )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load())])]))", nil, ""},
	{"( a for a in ab if a if b if c )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load()), Name(id='c', ctx=Load())])]))", nil, ""},
	{"( a for a in ab for A in AB )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[]), comprehension(target=Name(id='A', ctx=Store()), iter=Name(id='AB', ctx=Load()), ifs=[])]))", nil, ""},
	{"( a for a in ab if a if b for A in AB if c )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())]), comprehension(target=Name(id='A', ctx=Store()), iter=Name(id='AB', ctx=Load()), ifs=[Name(id='c', ctx=Load())])]))", nil, ""},
	{"( a for a in ab if lambda: None )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Lambda(args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=NameConstant(value=None))])]))", nil, ""},
	{"( a for a in ab if lambda x,y: x+y )", "eval", "Expression(body=GeneratorExp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Lambda(args=arguments(args=[arg(arg='x', annotation=None), arg(arg='y', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=BinOp(left=Name(id='x', ctx=Load()), op=Add(), right=Name(id='y', ctx=Load())))])]))", nil, ""},
	{"[ a for a in ab ]", "eval", "Expression(body=ListComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"[ a for a, in ab ]", "eval", "Expression(body=ListComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Tuple(elts=[Name(id='a', ctx=Store())], ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"[ a for a, b in ab ]", "eval", "Expression(body=ListComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"[ a for a in ab if a ]", "eval", "Expression(body=ListComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load())])]))", nil, ""},
	{"[ a for a in ab if a if b if c ]", "eval", "Expression(body=ListComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load()), Name(id='c', ctx=Load())])]))", nil, ""},
	{"[ a for a in ab for A in AB ]", "eval", "Expression(body=ListComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[]), comprehension(target=Name(id='A', ctx=Store()), iter=Name(id='AB', ctx=Load()), ifs=[])]))", nil, ""},
	{"[ a for a in ab if a if b for A in AB if c ]", "eval", "Expression(body=ListComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())]), comprehension(target=Name(id='A', ctx=Store()), iter=Name(id='AB', ctx=Load()), ifs=[Name(id='c', ctx=Load())])]))", nil, ""},
	{"{ a for a in ab }", "eval", "Expression(body=SetComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"{ a for a, in ab }", "eval", "Expression(body=SetComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Tuple(elts=[Name(id='a', ctx=Store())], ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"{ a for a, b in ab }", "eval", "Expression(body=SetComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"{ a for a in ab if a }", "eval", "Expression(body=SetComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load())])]))", nil, ""},
	{"{ a for a in ab if a if b if c }", "eval", "Expression(body=SetComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load()), Name(id='c', ctx=Load())])]))", nil, ""},
	{"{ a for a in ab for A in AB }", "eval", "Expression(body=SetComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[]), comprehension(target=Name(id='A', ctx=Store()), iter=Name(id='AB', ctx=Load()), ifs=[])]))", nil, ""},
	{"{ a for a in ab if a if b for A in AB if c }", "eval", "Expression(body=SetComp(elt=Name(id='a', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())]), comprehension(target=Name(id='A', ctx=Store()), iter=Name(id='AB', ctx=Load()), ifs=[Name(id='c', ctx=Load())])]))", nil, ""},
	{"{ a:b for a in ab }", "eval", "Expression(body=DictComp(key=Name(id='a', ctx=Load()), value=Name(id='b', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"{ a:b for a, in ab }", "eval", "Expression(body=DictComp(key=Name(id='a', ctx=Load()), value=Name(id='b', ctx=Load()), generators=[comprehension(target=Tuple(elts=[Name(id='a', ctx=Store())], ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"{ a:b for a, b in ab }", "eval", "Expression(body=DictComp(key=Name(id='a', ctx=Load()), value=Name(id='b', ctx=Load()), generators=[comprehension(target=Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[])]))", nil, ""},
	{"{ a:b for a in ab if a }", "eval", "Expression(body=DictComp(key=Name(id='a', ctx=Load()), value=Name(id='b', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load())])]))", nil, ""},
	{"{ a:b for a in ab if a if b if c }", "eval", "Expression(body=DictComp(key=Name(id='a', ctx=Load()), value=Name(id='b', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load()), Name(id='c', ctx=Load())])]))", nil, ""},
	{"{ a:b for a in ab for A in AB }", "eval", "Expression(body=DictComp(key=Name(id='a', ctx=Load()), value=Name(id='b', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[]), comprehension(target=Name(id='A', ctx=Store()), iter=Name(id='AB', ctx=Load()), ifs=[])]))", nil, ""},
	{"{ a:b for a in ab if a if b for A in AB if c }", "eval", "Expression(body=DictComp(key=Name(id='a', ctx=Load()), value=Name(id='b', ctx=Load()), generators=[comprehension(target=Name(id='a', ctx=Store()), iter=Name(id='ab', ctx=Load()), ifs=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())]), comprehension(target=Name(id='A', ctx=Store()), iter=Name(id='AB', ctx=Load()), ifs=[Name(id='c', ctx=Load())])]))", nil, ""},
	{"a|b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=BitOr(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a^b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=BitXor(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a&b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=BitAnd(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a<<b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=LShift(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a>>b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=RShift(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a+b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=Add(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a-b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=Sub(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a*b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=Mult(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a/b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=Div(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a//b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=FloorDiv(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"a**b", "eval", "Expression(body=BinOp(left=Name(id='a', ctx=Load()), op=Pow(), right=Name(id='b', ctx=Load())))", nil, ""},
	{"not a", "eval", "Expression(body=UnaryOp(op=Not(), operand=Name(id='a', ctx=Load())))", nil, ""},
	{"+a", "eval", "Expression(body=UnaryOp(op=UAdd(), operand=Name(id='a', ctx=Load())))", nil, ""},
	{"-a", "eval", "Expression(body=UnaryOp(op=USub(), operand=Name(id='a', ctx=Load())))", nil, ""},
	{"~a", "eval", "Expression(body=UnaryOp(op=Invert(), operand=Name(id='a', ctx=Load())))", nil, ""},
	{"a and b", "eval", "Expression(body=BoolOp(op=And(), values=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())]))", nil, ""},
	{"a or b", "eval", "Expression(body=BoolOp(op=Or(), values=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())]))", nil, ""},
	{"a or b or c", "eval", "Expression(body=BoolOp(op=Or(), values=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load()), Name(id='c', ctx=Load())]))", nil, ""},
	{"(a or b) or c", "eval", "Expression(body=BoolOp(op=Or(), values=[BoolOp(op=Or(), values=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())]), Name(id='c', ctx=Load())]))", nil, ""},
	{"a or (b or c)", "eval", "Expression(body=BoolOp(op=Or(), values=[Name(id='a', ctx=Load()), BoolOp(op=Or(), values=[Name(id='b', ctx=Load()), Name(id='c', ctx=Load())])]))", nil, ""},
	{"a and b and c", "eval", "Expression(body=BoolOp(op=And(), values=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load()), Name(id='c', ctx=Load())]))", nil, ""},
	{"(a and b) and c", "eval", "Expression(body=BoolOp(op=And(), values=[BoolOp(op=And(), values=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())]), Name(id='c', ctx=Load())]))", nil, ""},
	{"a and (b and c)", "eval", "Expression(body=BoolOp(op=And(), values=[Name(id='a', ctx=Load()), BoolOp(op=And(), values=[Name(id='b', ctx=Load()), Name(id='c', ctx=Load())])]))", nil, ""},
	{"a+b-c/d", "eval", "Expression(body=BinOp(left=BinOp(left=Name(id='a', ctx=Load()), op=Add(), right=Name(id='b', ctx=Load())), op=Sub(), right=BinOp(left=Name(id='c', ctx=Load()), op=Div(), right=Name(id='d', ctx=Load()))))", nil, ""},
	{"a+b-c/d//e", "eval", "Expression(body=BinOp(left=BinOp(left=Name(id='a', ctx=Load()), op=Add(), right=Name(id='b', ctx=Load())), op=Sub(), right=BinOp(left=BinOp(left=Name(id='c', ctx=Load()), op=Div(), right=Name(id='d', ctx=Load())), op=FloorDiv(), right=Name(id='e', ctx=Load()))))", nil, ""},
	{"a+b-c/d//e%f", "eval", "Expression(body=BinOp(left=BinOp(left=Name(id='a', ctx=Load()), op=Add(), right=Name(id='b', ctx=Load())), op=Sub(), right=BinOp(left=BinOp(left=BinOp(left=Name(id='c', ctx=Load()), op=Div(), right=Name(id='d', ctx=Load())), op=FloorDiv(), right=Name(id='e', ctx=Load())), op=Mod(), right=Name(id='f', ctx=Load()))))", nil, ""},
	{"a+b-c/d//e%f**g", "eval", "Expression(body=BinOp(left=BinOp(left=Name(id='a', ctx=Load()), op=Add(), right=Name(id='b', ctx=Load())), op=Sub(), right=BinOp(left=BinOp(left=BinOp(left=Name(id='c', ctx=Load()), op=Div(), right=Name(id='d', ctx=Load())), op=FloorDiv(), right=Name(id='e', ctx=Load())), op=Mod(), right=BinOp(left=Name(id='f', ctx=Load()), op=Pow(), right=Name(id='g', ctx=Load())))))", nil, ""},
	{"a+b-c/d//e%f**g|h&i^k<<l>>m", "eval", "Expression(body=BinOp(left=BinOp(left=BinOp(left=Name(id='a', ctx=Load()), op=Add(), right=Name(id='b', ctx=Load())), op=Sub(), right=BinOp(left=BinOp(left=BinOp(left=Name(id='c', ctx=Load()), op=Div(), right=Name(id='d', ctx=Load())), op=FloorDiv(), right=Name(id='e', ctx=Load())), op=Mod(), right=BinOp(left=Name(id='f', ctx=Load()), op=Pow(), right=Name(id='g', ctx=Load())))), op=BitOr(), right=BinOp(left=BinOp(left=Name(id='h', ctx=Load()), op=BitAnd(), right=Name(id='i', ctx=Load())), op=BitXor(), right=BinOp(left=BinOp(left=Name(id='k', ctx=Load()), op=LShift(), right=Name(id='l', ctx=Load())), op=RShift(), right=Name(id='m', ctx=Load())))))", nil, ""},
	{"a if b else c", "eval", "Expression(body=IfExp(test=Name(id='b', ctx=Load()), body=Name(id='a', ctx=Load()), orelse=Name(id='c', ctx=Load())))", nil, ""},
	{"a==b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[Eq()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a!=b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[NotEq()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a<b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[Lt()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a<=b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[LtE()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a>b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[Gt()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a>=b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[GtE()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a is b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[Is()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a is not b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[IsNot()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a in b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[In()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a not in b", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[NotIn()], comparators=[Name(id='b', ctx=Load())]))", nil, ""},
	{"a<b<c<d", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[Lt(), Lt(), Lt()], comparators=[Name(id='b', ctx=Load()), Name(id='c', ctx=Load()), Name(id='d', ctx=Load())]))", nil, ""},
	{"a==b<c>d", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[Eq(), Lt(), Gt()], comparators=[Name(id='b', ctx=Load()), Name(id='c', ctx=Load()), Name(id='d', ctx=Load())]))", nil, ""},
	{"(a==b)<c", "eval", "Expression(body=Compare(left=Compare(left=Name(id='a', ctx=Load()), ops=[Eq()], comparators=[Name(id='b', ctx=Load())]), ops=[Lt()], comparators=[Name(id='c', ctx=Load())]))", nil, ""},
	{"a==(b<c)", "eval", "Expression(body=Compare(left=Name(id='a', ctx=Load()), ops=[Eq()], comparators=[Compare(left=Name(id='b', ctx=Load()), ops=[Lt()], comparators=[Name(id='c', ctx=Load())])]))", nil, ""},
	{"(a==b)<(c>d)>e", "eval", "Expression(body=Compare(left=Compare(left=Name(id='a', ctx=Load()), ops=[Eq()], comparators=[Name(id='b', ctx=Load())]), ops=[Lt(), Gt()], comparators=[Compare(left=Name(id='c', ctx=Load()), ops=[Gt()], comparators=[Name(id='d', ctx=Load())]), Name(id='e', ctx=Load())]))", nil, ""},
	{"a()", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[], keywords=[], starargs=None, kwargs=None))", nil, ""},
	{"a(b)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[Name(id='b', ctx=Load())], keywords=[], starargs=None, kwargs=None))", nil, ""},
	{"a(b,)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[Name(id='b', ctx=Load())], keywords=[], starargs=None, kwargs=None))", nil, ""},
	{"a(b,c)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[Name(id='b', ctx=Load()), Name(id='c', ctx=Load())], keywords=[], starargs=None, kwargs=None))", nil, ""},
	{"a(b,*c)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[Name(id='b', ctx=Load())], keywords=[], starargs=Name(id='c', ctx=Load()), kwargs=None))", nil, ""},
	{"a(*b)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[], keywords=[], starargs=Name(id='b', ctx=Load()), kwargs=None))", nil, ""},
	{"a(*b,c)", "eval", "", py.SyntaxError, "only named arguments may follow *expression"},
	{"a(b,*c,**d)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[Name(id='b', ctx=Load())], keywords=[], starargs=Name(id='c', ctx=Load()), kwargs=Name(id='d', ctx=Load())))", nil, ""},
	{"a(b,**c)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[Name(id='b', ctx=Load())], keywords=[], starargs=None, kwargs=Name(id='c', ctx=Load())))", nil, ""},
	{"a(a=b)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[], keywords=[keyword(arg='a', value=Name(id='b', ctx=Load()))], starargs=None, kwargs=None))", nil, ""},
	{"a(a,a=b,*args,**kwargs)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[Name(id='a', ctx=Load())], keywords=[keyword(arg='a', value=Name(id='b', ctx=Load()))], starargs=Name(id='args', ctx=Load()), kwargs=Name(id='kwargs', ctx=Load())))", nil, ""},
	{"a(a,a=b,*args,e=f,**kwargs)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[Name(id='a', ctx=Load())], keywords=[keyword(arg='a', value=Name(id='b', ctx=Load())), keyword(arg='e', value=Name(id='f', ctx=Load()))], starargs=Name(id='args', ctx=Load()), kwargs=Name(id='kwargs', ctx=Load())))", nil, ""},
	{"a(b for c in d)", "eval", "Expression(body=Call(func=Name(id='a', ctx=Load()), args=[GeneratorExp(elt=Name(id='b', ctx=Load()), generators=[comprehension(target=Name(id='c', ctx=Store()), iter=Name(id='d', ctx=Load()), ifs=[])])], keywords=[], starargs=None, kwargs=None))", nil, ""},
	{"a.b", "eval", "Expression(body=Attribute(value=Name(id='a', ctx=Load()), attr='b', ctx=Load()))", nil, ""},
	{"a.b.c.d", "eval", "Expression(body=Attribute(value=Attribute(value=Attribute(value=Name(id='a', ctx=Load()), attr='b', ctx=Load()), attr='c', ctx=Load()), attr='d', ctx=Load()))", nil, ""},
	{"a.b().c.d()()", "eval", "Expression(body=Call(func=Call(func=Attribute(value=Attribute(value=Call(func=Attribute(value=Name(id='a', ctx=Load()), attr='b', ctx=Load()), args=[], keywords=[], starargs=None, kwargs=None), attr='c', ctx=Load()), attr='d', ctx=Load()), args=[], keywords=[], starargs=None, kwargs=None), args=[], keywords=[], starargs=None, kwargs=None))", nil, ""},
	{"x[a]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Index(value=Name(id='a', ctx=Load())), ctx=Load()))", nil, ""},
	{"x[a,]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Index(value=Tuple(elts=[Name(id='a', ctx=Load())], ctx=Load())), ctx=Load()))", nil, ""},
	{"x[a:b]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=Name(id='a', ctx=Load()), upper=Name(id='b', ctx=Load()), step=None), ctx=Load()))", nil, ""},
	{"x[:b]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=None, upper=Name(id='b', ctx=Load()), step=None), ctx=Load()))", nil, ""},
	{"x[b:]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=Name(id='b', ctx=Load()), upper=None, step=None), ctx=Load()))", nil, ""},
	{"x[:]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=None, upper=None, step=None), ctx=Load()))", nil, ""},
	{"x[a:b:c]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=Name(id='a', ctx=Load()), upper=Name(id='b', ctx=Load()), step=Name(id='c', ctx=Load())), ctx=Load()))", nil, ""},
	{"x[:b:c]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=None, upper=Name(id='b', ctx=Load()), step=Name(id='c', ctx=Load())), ctx=Load()))", nil, ""},
	{"x[a::c]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=Name(id='a', ctx=Load()), upper=None, step=Name(id='c', ctx=Load())), ctx=Load()))", nil, ""},
	{"x[a:b:]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=Name(id='a', ctx=Load()), upper=Name(id='b', ctx=Load()), step=None), ctx=Load()))", nil, ""},
	{"x[::c]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=None, upper=None, step=Name(id='c', ctx=Load())), ctx=Load()))", nil, ""},
	{"x[:b:]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=None, upper=Name(id='b', ctx=Load()), step=None), ctx=Load()))", nil, ""},
	{"x[::c]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=None, upper=None, step=Name(id='c', ctx=Load())), ctx=Load()))", nil, ""},
	{"x[::]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Slice(lower=None, upper=None, step=None), ctx=Load()))", nil, ""},
	{"x[a,p]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Index(value=Tuple(elts=[Name(id='a', ctx=Load()), Name(id='p', ctx=Load())], ctx=Load())), ctx=Load()))", nil, ""},
	{"x[a, b]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Index(value=Tuple(elts=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())], ctx=Load())), ctx=Load()))", nil, ""},
	{"x[a, b, c]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=Index(value=Tuple(elts=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load()), Name(id='c', ctx=Load())], ctx=Load())), ctx=Load()))", nil, ""},
	{"x[a, b:c, ::d]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=ExtSlice(dims=[Index(value=Name(id='a', ctx=Load())), Slice(lower=Name(id='b', ctx=Load()), upper=Name(id='c', ctx=Load()), step=None), Slice(lower=None, upper=None, step=Name(id='d', ctx=Load()))]), ctx=Load()))", nil, ""},
	{"x[a, b:c, ::d]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=ExtSlice(dims=[Index(value=Name(id='a', ctx=Load())), Slice(lower=Name(id='b', ctx=Load()), upper=Name(id='c', ctx=Load()), step=None), Slice(lower=None, upper=None, step=Name(id='d', ctx=Load()))]), ctx=Load()))", nil, ""},
	{"x[0, 1:2, ::5, ...]", "eval", "Expression(body=Subscript(value=Name(id='x', ctx=Load()), slice=ExtSlice(dims=[Index(value=Num(n=0)), Slice(lower=Num(n=1), upper=Num(n=2), step=None), Slice(lower=None, upper=None, step=Num(n=5)), Index(value=Ellipsis())]), ctx=Load()))", nil, ""},
	{"(yield a,b)", "eval", "Expression(body=Yield(value=Tuple(elts=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())], ctx=Load())))", nil, ""},
	{"(yield from a)", "eval", "Expression(body=YieldFrom(value=Name(id='a', ctx=Load())))", nil, ""},
	{"del a,b", "exec", "Module(body=[Delete(targets=[Name(id='a', ctx=Del()), Name(id='b', ctx=Del())])])", nil, ""},
	{"del *a,*b", "exec", "Module(body=[Delete(targets=[Starred(value=Name(id='a', ctx=Del()), ctx=Del()), Starred(value=Name(id='b', ctx=Del()), ctx=Del())])])", nil, ""},
	{"pass", "exec", "Module(body=[Pass()])", nil, ""},
	{"break", "exec", "Module(body=[Break()])", nil, ""},
	{"continue", "exec", "Module(body=[Continue()])", nil, ""},
	{"return", "exec", "Module(body=[Return(value=None)])", nil, ""},
	{"return a", "exec", "Module(body=[Return(value=Name(id='a', ctx=Load()))])", nil, ""},
	{"return a,", "exec", "Module(body=[Return(value=Tuple(elts=[Name(id='a', ctx=Load())], ctx=Load()))])", nil, ""},
	{"return a,b", "exec", "Module(body=[Return(value=Tuple(elts=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())], ctx=Load()))])", nil, ""},
	{"raise", "exec", "Module(body=[Raise(exc=None, cause=None)])", nil, ""},
	{"raise a", "exec", "Module(body=[Raise(exc=Name(id='a', ctx=Load()), cause=None)])", nil, ""},
	{"raise a from b", "exec", "Module(body=[Raise(exc=Name(id='a', ctx=Load()), cause=Name(id='b', ctx=Load()))])", nil, ""},
	{"yield", "exec", "Module(body=[Expr(value=Yield(value=None))])", nil, ""},
	{"yield a", "exec", "Module(body=[Expr(value=Yield(value=Name(id='a', ctx=Load())))])", nil, ""},
	{"yield a, b", "exec", "Module(body=[Expr(value=Yield(value=Tuple(elts=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())], ctx=Load())))])", nil, ""},
	{"import a", "exec", "Module(body=[Import(names=[alias(name='a', asname=None)])])", nil, ""},
	{"import a as b, c as d", "exec", "Module(body=[Import(names=[alias(name='a', asname='b'), alias(name='c', asname='d')])])", nil, ""},
	{"import a . b,c .d.e", "exec", "Module(body=[Import(names=[alias(name='a.b', asname=None), alias(name='c.d.e', asname=None)])])", nil, ""},
	{"from a import b", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None)], level=0)])", nil, ""},
	{"from a import b as c, d as e", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname='c'), alias(name='d', asname='e')], level=0)])", nil, ""},
	{"from a import b, c", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None), alias(name='c', asname=None)], level=0)])", nil, ""},
	{"from a import (b, c)", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None), alias(name='c', asname=None)], level=0)])", nil, ""},
	{"from a import *", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='*', asname=None)], level=0)])", nil, ""},
	{"from . import b", "exec", "Module(body=[ImportFrom(module=None, names=[alias(name='b', asname=None)], level=1)])", nil, ""},
	{"from .. import b", "exec", "Module(body=[ImportFrom(module=None, names=[alias(name='b', asname=None)], level=2)])", nil, ""},
	{"from .a import (b, c,)", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None), alias(name='c', asname=None)], level=1)])", nil, ""},
	{"from ..a import b", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None)], level=2)])", nil, ""},
	{"from ...a import b", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None)], level=3)])", nil, ""},
	{"from ....a import b", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None)], level=4)])", nil, ""},
	{"from .....a import b", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None)], level=5)])", nil, ""},
	{"from ......a import b", "exec", "Module(body=[ImportFrom(module='a', names=[alias(name='b', asname=None)], level=6)])", nil, ""},
	{"global a", "exec", "Module(body=[Global(names=['a'])])", nil, ""},
	{"global a, b", "exec", "Module(body=[Global(names=['a', 'b'])])", nil, ""},
	{"global a, b, c", "exec", "Module(body=[Global(names=['a', 'b', 'c'])])", nil, ""},
	{"nonlocal a", "exec", "Module(body=[Nonlocal(names=['a'])])", nil, ""},
	{"nonlocal a, b", "exec", "Module(body=[Nonlocal(names=['a', 'b'])])", nil, ""},
	{"nonlocal a, b, c", "exec", "Module(body=[Nonlocal(names=['a', 'b', 'c'])])", nil, ""},
	{"assert True", "exec", "Module(body=[Assert(test=NameConstant(value=True), msg=None)])", nil, ""},
	{"assert True, 'Bang'", "exec", "Module(body=[Assert(test=NameConstant(value=True), msg=Str(s='Bang'))])", nil, ""},
	{"assert a == b, 'Bang'", "exec", "Module(body=[Assert(test=Compare(left=Name(id='a', ctx=Load()), ops=[Eq()], comparators=[Name(id='b', ctx=Load())]), msg=Str(s='Bang'))])", nil, ""},
	{"pass ; break ; continue", "exec", "Module(body=[Pass(), Break(), Continue()])", nil, ""},
	{"while True: pass", "exec", "Module(body=[While(test=NameConstant(value=True), body=[Pass()], orelse=[])])", nil, ""},
	{"while True:\n pass\n", "exec", "Module(body=[While(test=NameConstant(value=True), body=[Pass()], orelse=[])])", nil, ""},
	{"while True:\n pass\nelse:\n return\n", "exec", "Module(body=[While(test=NameConstant(value=True), body=[Pass()], orelse=[Return(value=None)])])", nil, ""},
	{"if True: pass", "exec", "Module(body=[If(test=NameConstant(value=True), body=[Pass()], orelse=[])])", nil, ""},
	{"if True:\n pass\n", "exec", "Module(body=[If(test=NameConstant(value=True), body=[Pass()], orelse=[])])", nil, ""},
	{"if True:\n pass\n\n", "exec", "Module(body=[If(test=NameConstant(value=True), body=[Pass()], orelse=[])])", nil, ""},
	{"if True:\n    pass\n    continue\nelse:\n    break\n    pass\n", "exec", "Module(body=[If(test=NameConstant(value=True), body=[Pass(), Continue()], orelse=[Break(), Pass()])])", nil, ""},
	{"if a:\n    continue\nelif b:\n    break\nelif c:\n    pass\nelif c:\n    continue\n    pass\n", "exec", "Module(body=[If(test=Name(id='a', ctx=Load()), body=[Continue()], orelse=[If(test=Name(id='b', ctx=Load()), body=[Break()], orelse=[If(test=Name(id='c', ctx=Load()), body=[Pass()], orelse=[If(test=Name(id='c', ctx=Load()), body=[Continue(), Pass()], orelse=[])])])])])", nil, ""},
	{"if a:\n    continue\nelif b:\n    break\nelse:\n    continue\n    pass\n", "exec", "Module(body=[If(test=Name(id='a', ctx=Load()), body=[Continue()], orelse=[If(test=Name(id='b', ctx=Load()), body=[Break()], orelse=[Continue(), Pass()])])])", nil, ""},
	{"if a:\n    continue\nelif b:\n    break\nelif c:\n    pass\nelse:\n    continue\n    pass\n", "exec", "Module(body=[If(test=Name(id='a', ctx=Load()), body=[Continue()], orelse=[If(test=Name(id='b', ctx=Load()), body=[Break()], orelse=[If(test=Name(id='c', ctx=Load()), body=[Pass()], orelse=[Continue(), Pass()])])])])", nil, ""},
	{"if lambda: None:\n pass\n", "exec", "Module(body=[If(test=Lambda(args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=NameConstant(value=None)), body=[Pass()], orelse=[])])", nil, ""},
	{"for a in b: pass", "exec", "Module(body=[For(target=Name(id='a', ctx=Store()), iter=Name(id='b', ctx=Load()), body=[Pass()], orelse=[])])", nil, ""},
	{"for a, b in b: pass", "exec", "Module(body=[For(target=Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store()), iter=Name(id='b', ctx=Load()), body=[Pass()], orelse=[])])", nil, ""},
	{"for a, b in b:\n pass\nelse: break\n", "exec", "Module(body=[For(target=Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store()), iter=Name(id='b', ctx=Load()), body=[Pass()], orelse=[Break()])])", nil, ""},
	{"try:\n    pass\nexcept:\n    break\n", "exec", "Module(body=[Try(body=[Pass()], handlers=[ExceptHandler(type=None, name=None, body=[Break()])], orelse=[], finalbody=[])])", nil, ""},
	{"try:\n    pass\nexcept a:\n    break\n", "exec", "Module(body=[Try(body=[Pass()], handlers=[ExceptHandler(type=Name(id='a', ctx=Load()), name=None, body=[Break()])], orelse=[], finalbody=[])])", nil, ""},
	{"try:\n    pass\nexcept a as b:\n    break\n", "exec", "Module(body=[Try(body=[Pass()], handlers=[ExceptHandler(type=Name(id='a', ctx=Load()), name='b', body=[Break()])], orelse=[], finalbody=[])])", nil, ""},
	{"try:\n    pass\nexcept a:\n    break\nexcept:\n    continue\nexcept b as c:\n    break\nelse:\n    pass\n", "exec", "Module(body=[Try(body=[Pass()], handlers=[ExceptHandler(type=Name(id='a', ctx=Load()), name=None, body=[Break()]), ExceptHandler(type=None, name=None, body=[Continue()]), ExceptHandler(type=Name(id='b', ctx=Load()), name='c', body=[Break()])], orelse=[Pass()], finalbody=[])])", nil, ""},
	{"try:\n    pass\nexcept:\n    continue\nfinally:\n    pass\n", "exec", "Module(body=[Try(body=[Pass()], handlers=[ExceptHandler(type=None, name=None, body=[Continue()])], orelse=[], finalbody=[Pass()])])", nil, ""},
	{"try:\n    pass\nexcept:\n    continue\nelse:\n    break\nfinally:\n    pass\n", "exec", "Module(body=[Try(body=[Pass()], handlers=[ExceptHandler(type=None, name=None, body=[Continue()])], orelse=[Break()], finalbody=[Pass()])])", nil, ""},
	{"with x:\n    pass\n", "exec", "Module(body=[With(items=[withitem(context_expr=Name(id='x', ctx=Load()), optional_vars=None)], body=[Pass()])])", nil, ""},
	{"with x as y:\n    pass\n", "exec", "Module(body=[With(items=[withitem(context_expr=Name(id='x', ctx=Load()), optional_vars=Name(id='y', ctx=Store()))], body=[Pass()])])", nil, ""},
	{"with x as y, a as b, c, d as e:\n    pass\n    continue\n", "exec", "Module(body=[With(items=[withitem(context_expr=Name(id='x', ctx=Load()), optional_vars=Name(id='y', ctx=Store())), withitem(context_expr=Name(id='a', ctx=Load()), optional_vars=Name(id='b', ctx=Store())), withitem(context_expr=Name(id='c', ctx=Load()), optional_vars=None), withitem(context_expr=Name(id='d', ctx=Load()), optional_vars=Name(id='e', ctx=Store()))], body=[Pass(), Continue()])])", nil, ""},
	{"a += b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=Add(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a -= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=Sub(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a *= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=Mult(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a /= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=Div(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a -= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=Sub(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a %= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=Mod(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a &= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=BitAnd(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a |= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=BitOr(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a ^= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=BitXor(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a <<= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=LShift(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a >>= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=RShift(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a **= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=Pow(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a //= b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=FloorDiv(), value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a //= yield b", "exec", "Module(body=[AugAssign(target=Name(id='a', ctx=Store()), op=FloorDiv(), value=Yield(value=Name(id='b', ctx=Load())))])", nil, ""},
	{"a <> b", "exec", "", py.SyntaxError, "invalid syntax"},
	{"a.b += 1", "exec", "Module(body=[AugAssign(target=Attribute(value=Name(id='a', ctx=Load()), attr='b', ctx=Store()), op=Add(), value=Num(n=1))])", nil, ""},
	{"a = b", "exec", "Module(body=[Assign(targets=[Name(id='a', ctx=Store())], value=Name(id='b', ctx=Load()))])", nil, ""},
	{"a = 007", "exec", "", py.SyntaxError, "illegal decimal with leading zero"},
	{"a = b = c", "exec", "Module(body=[Assign(targets=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], value=Name(id='c', ctx=Load()))])", nil, ""},
	{"a, b = 1, 2", "exec", "Module(body=[Assign(targets=[Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store())], value=Tuple(elts=[Num(n=1), Num(n=2)], ctx=Load()))])", nil, ""},
	{"a, b = c, d = 1, 2", "exec", "Module(body=[Assign(targets=[Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store()), Tuple(elts=[Name(id='c', ctx=Store()), Name(id='d', ctx=Store())], ctx=Store())], value=Tuple(elts=[Num(n=1), Num(n=2)], ctx=Load()))])", nil, ""},
	{"a, b = *a", "exec", "Module(body=[Assign(targets=[Tuple(elts=[Name(id='a', ctx=Store()), Name(id='b', ctx=Store())], ctx=Store())], value=Starred(value=Name(id='a', ctx=Load()), ctx=Load()))])", nil, ""},
	{"a = yield a", "exec", "Module(body=[Assign(targets=[Name(id='a', ctx=Store())], value=Yield(value=Name(id='a', ctx=Load())))])", nil, ""},
	{"a.b = 1", "exec", "Module(body=[Assign(targets=[Attribute(value=Name(id='a', ctx=Load()), attr='b', ctx=Store())], value=Num(n=1))])", nil, ""},
	{"[e for e in [1, 2, 3]] = 3", "exec", "", py.SyntaxError, "can't assign to list comprehension"},
	{"{e for e in [1, 2, 3]} = 3", "exec", "", py.SyntaxError, "can't assign to set comprehension"},
	{"{e: e**2 for e in [1, 2, 3]} = 3", "exec", "", py.SyntaxError, "can't assign to dict comprehension"},
	{"f() = 1", "exec", "", py.SyntaxError, "can't assign to function call"},
	{"lambda: x = 1", "exec", "", py.SyntaxError, "can't assign to lambda"},
	{"(a + b) = 1", "exec", "", py.SyntaxError, "can't assign to operator"},
	{"(x for x in xs) = 1", "exec", "", py.SyntaxError, "can't assign to generator expression"},
	{"(yield x) = 1", "exec", "", py.SyntaxError, "can't assign to yield expression"},
	{"[x for x in xs] = 1", "exec", "", py.SyntaxError, "can't assign to list comprehension"},
	{"{x for x in xs} = 1", "exec", "", py.SyntaxError, "can't assign to set comprehension"},
	{"{x:x for x in xs} = 1", "exec", "", py.SyntaxError, "can't assign to dict comprehension"},
	{"{} = 1", "exec", "", py.SyntaxError, "can't assign to literal"},
	{"None = 1", "exec", "", py.SyntaxError, "can't assign to keyword"},
	{"... = 1", "exec", "", py.SyntaxError, "can't assign to Ellipsis"},
	{"(a < b) = 1", "exec", "", py.SyntaxError, "can't assign to comparison"},
	{"(a if b else c) = 1", "exec", "", py.SyntaxError, "can't assign to conditional expression"},
	{"lambda: a", "eval", "Expression(body=Lambda(args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda: lambda: a", "eval", "Expression(body=Lambda(args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=Lambda(args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load()))))", nil, ""},
	{"lambda a: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a, b: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None), arg(arg='b', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a, b,: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None), arg(arg='b', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a = b: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[Name(id='b', ctx=Load())]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a, b=c: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None), arg(arg='b', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[Name(id='c', ctx=Load())]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a, *b: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None)], vararg=arg(arg='b', annotation=None), kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a, *b, c=d: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None)], vararg=arg(arg='b', annotation=None), kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a, *, c=d: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None)], vararg=None, kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a, *b, c=d, **kws: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None)], vararg=arg(arg='b', annotation=None), kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=arg(arg='kws', annotation=None), defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda a, c=d, **kws: a", "eval", "Expression(body=Lambda(args=arguments(args=[arg(arg='a', annotation=None), arg(arg='c', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=arg(arg='kws', annotation=None), defaults=[Name(id='d', ctx=Load())]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda *args, c=d: a", "eval", "Expression(body=Lambda(args=arguments(args=[], vararg=arg(arg='args', annotation=None), kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=None, defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda *args, c=d, **kws: a", "eval", "Expression(body=Lambda(args=arguments(args=[], vararg=arg(arg='args', annotation=None), kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=arg(arg='kws', annotation=None), defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"lambda **kws: a", "eval", "Expression(body=Lambda(args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=arg(arg='kws', annotation=None), defaults=[]), body=Name(id='a', ctx=Load())))", nil, ""},
	{"def fn(): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a, b): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None), arg(arg='b', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a, b,): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None), arg(arg='b', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a = b): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[Name(id='b', ctx=Load())]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a, b=c): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None), arg(arg='b', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[Name(id='c', ctx=Load())]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a, *b): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None)], vararg=arg(arg='b', annotation=None), kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a, *b, c=d): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None)], vararg=arg(arg='b', annotation=None), kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a, *b, c=d, **kws): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None)], vararg=arg(arg='b', annotation=None), kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=arg(arg='kws', annotation=None), defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a, c=d, **kws): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None), arg(arg='c', annotation=None)], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=arg(arg='kws', annotation=None), defaults=[Name(id='d', ctx=Load())]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(*args, c=d): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=arg(arg='args', annotation=None), kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(a, *, c=d): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=None)], vararg=None, kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(*args, c=d, **kws): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=arg(arg='args', annotation=None), kwonlyargs=[arg(arg='c', annotation=None)], kw_defaults=[Name(id='d', ctx=Load())], kwarg=arg(arg='kws', annotation=None), defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn(**kws): pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=arg(arg='kws', annotation=None), defaults=[]), body=[Pass()], decorator_list=[], returns=None)])", nil, ""},
	{"def fn() -> None: pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=NameConstant(value=None))])", nil, ""},
	{"def fn(a:'potato') -> 'sausage': pass", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[arg(arg='a', annotation=Str(s='potato'))], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[], returns=Str(s='sausage'))])", nil, ""},
	{"del f()", "exec", "", py.SyntaxError, "can't delete function call"},
	{"class A: pass", "exec", "Module(body=[ClassDef(name='A', bases=[], keywords=[], starargs=None, kwargs=None, body=[Pass()], decorator_list=[])])", nil, ""},
	{"class A(): pass", "exec", "Module(body=[ClassDef(name='A', bases=[], keywords=[], starargs=None, kwargs=None, body=[Pass()], decorator_list=[])])", nil, ""},
	{"class A(B): pass", "exec", "Module(body=[ClassDef(name='A', bases=[Name(id='B', ctx=Load())], keywords=[], starargs=None, kwargs=None, body=[Pass()], decorator_list=[])])", nil, ""},
	{"class A(B,C): pass", "exec", "Module(body=[ClassDef(name='A', bases=[Name(id='B', ctx=Load()), Name(id='C', ctx=Load())], keywords=[], starargs=None, kwargs=None, body=[Pass()], decorator_list=[])])", nil, ""},
	{"class A(B,C,D=F): pass", "exec", "Module(body=[ClassDef(name='A', bases=[Name(id='B', ctx=Load()), Name(id='C', ctx=Load())], keywords=[keyword(arg='D', value=Name(id='F', ctx=Load()))], starargs=None, kwargs=None, body=[Pass()], decorator_list=[])])", nil, ""},
	{"class A(B,C,D=F,*AS,**KWS): pass", "exec", "Module(body=[ClassDef(name='A', bases=[Name(id='B', ctx=Load()), Name(id='C', ctx=Load())], keywords=[keyword(arg='D', value=Name(id='F', ctx=Load()))], starargs=Name(id='AS', ctx=Load()), kwargs=Name(id='KWS', ctx=Load()), body=[Pass()], decorator_list=[])])", nil, ""},
	{"@dec\ndef fn():\n    pass\n", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[Name(id='dec', ctx=Load())], returns=None)])", nil, ""},
	{"@dec()\ndef fn():\n    pass\n", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[Call(func=Name(id='dec', ctx=Load()), args=[], keywords=[], starargs=None, kwargs=None)], returns=None)])", nil, ""},
	{"@dec(a,b,c=d,*args,**kwargs)\ndef fn():\n    pass\n", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[Call(func=Name(id='dec', ctx=Load()), args=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())], keywords=[keyword(arg='c', value=Name(id='d', ctx=Load()))], starargs=Name(id='args', ctx=Load()), kwargs=Name(id='kwargs', ctx=Load()))], returns=None)])", nil, ""},
	{"@dec1\n@dec2()\n@dec3(a)\n@dec4(a,b)\ndef fn():\n    pass\n", "exec", "Module(body=[FunctionDef(name='fn', args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Pass()], decorator_list=[Name(id='dec1', ctx=Load()), Call(func=Name(id='dec2', ctx=Load()), args=[], keywords=[], starargs=None, kwargs=None), Call(func=Name(id='dec3', ctx=Load()), args=[Name(id='a', ctx=Load())], keywords=[], starargs=None, kwargs=None), Call(func=Name(id='dec4', ctx=Load()), args=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())], keywords=[], starargs=None, kwargs=None)], returns=None)])", nil, ""},
	{"@dec1\n@dec2()\n@dec3(a)\n@dec4(a,b)\nclass A(B):\n    pass\n", "exec", "Module(body=[ClassDef(name='A', bases=[Name(id='B', ctx=Load())], keywords=[], starargs=None, kwargs=None, body=[Pass()], decorator_list=[Name(id='dec1', ctx=Load()), Call(func=Name(id='dec2', ctx=Load()), args=[], keywords=[], starargs=None, kwargs=None), Call(func=Name(id='dec3', ctx=Load()), args=[Name(id='a', ctx=Load())], keywords=[], starargs=None, kwargs=None), Call(func=Name(id='dec4', ctx=Load()), args=[Name(id='a', ctx=Load()), Name(id='b', ctx=Load())], keywords=[], starargs=None, kwargs=None)])])", nil, ""},
	{"", "single", "", py.SyntaxError, "unexpected EOF while parsing"},
	{"\n", "single", "", py.SyntaxError, "unexpected EOF while parsing"},
	{"pass\n", "single", "Interactive(body=[Pass()])", nil, ""},
	{"if True:\n   pass\n\n", "single", "Interactive(body=[If(test=NameConstant(value=True), body=[Pass()], orelse=[])])", nil, ""},
	{"while True:\n pass\nelse:\n return\n", "single", "Interactive(body=[While(test=NameConstant(value=True), body=[Pass()], orelse=[Return(value=None)])])", nil, ""},
	{"a='potato", "eval", "", py.SyntaxError, "invalid syntax"},
	{"a='potato", "exec", "", py.SyntaxError, "EOL while scanning string literal"},
	{"a='potato", "single", "", py.SyntaxError, "EOL while scanning string literal"},
	{"a='''potato", "eval", "", py.SyntaxError, "invalid syntax"},
	{"a='''potato", "exec", "", py.SyntaxError, "EOF while scanning triple-quoted string literal"},
	{"a='''potato", "single", "", py.SyntaxError, "EOF while scanning triple-quoted string literal"},
}
