// Copyright 2018 The go-python Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Test data generated by make_compile_test.py - do not edit

package compile

import (
	"github.com/go-python/gpython/py"
)

var compileTestData = []struct {
	in            string
	mode          py.CompileMode
	out           *py.Code
	exceptionType *py.Type
	errString     string
}{
	{"1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"hello\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.String("hello")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"b\"hello\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.Bytes("hello")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"+1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x17\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"-1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x18\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"*\"b\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x14\x53",
		Consts:         []py.Object{py.String("a"), py.String("b")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"/1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x1b\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"%1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x16\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"**1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x13\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"<<1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x3e\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\">>1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x3f\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"|1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x42\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"^1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x41\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"&1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x40\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"//1", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x1a\x53",
		Consts:         []py.Object{py.String("a"), py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a+a", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x00\x00\x17\x53",
		Consts:         []py.Object{},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"a\"*\"a\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x00\x00\x14\x53",
		Consts:         []py.Object{py.String("a")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"1\n\"hello\"", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x00\x01",
	}, nil, ""},
	{"a+a", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x00\x00\x17\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"~ \"a\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x0f\x53",
		Consts:         []py.Object{py.String("a")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"not \"a\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x0c\x53",
		Consts:         []py.Object{py.String("a")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"+\"a\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x0a\x53",
		Consts:         []py.Object{py.String("a")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"-\"a\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x0b\x53",
		Consts:         []py.Object{py.String("a")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"1 and 2", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x6f\x09\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.Int(2)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"1 and 2 and 3 and 4", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x64\x00\x00\x6f\x15\x00\x64\x01\x00\x6f\x15\x00\x64\x02\x00\x6f\x15\x00\x64\x03\x00\x53",
		Consts:         []py.Object{py.Int(1), py.Int(2), py.Int(3), py.Int(4)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"1 and 2", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x6f\x09\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.Int(2)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"1 or 2", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x70\x09\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.Int(2)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"1 or 2 or 3 or 4", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x64\x00\x00\x70\x15\x00\x64\x01\x00\x70\x15\x00\x64\x02\x00\x70\x15\x00\x64\x03\x00\x53",
		Consts:         []py.Object{py.Int(1), py.Int(2), py.Int(3), py.Int(4)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"1\"+\"2\"*\"3\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x64\x02\x00\x14\x17\x53",
		Consts:         []py.Object{py.String("1"), py.String("2"), py.String("3")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"\"1\"+(\"2\"*\"3\")", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x64\x02\x00\x14\x17\x53",
		Consts:         []py.Object{py.String("1"), py.String("2"), py.String("3")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(1+\"2\")*\"3\"", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x17\x64\x02\x00\x14\x53",
		Consts:         []py.Object{py.Int(1), py.String("2"), py.String("3")},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a if b else c)+0", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x72\x0c\x00\x65\x01\x00\x6e\x03\x00\x65\x02\x00\x64\x00\x00\x17\x53",
		Consts:         []py.Object{py.Int(0)},
		Names:          []string{"b", "a", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a == b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x02\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a != b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x03\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a < b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a <= b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x01\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a > b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x04\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a >= b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x05\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a is b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x08\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a is not b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x09\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a in b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x06\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a not in b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x6b\x07\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a < b < c)+0", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x04\x03\x6b\x00\x00\x6f\x17\x00\x65\x02\x00\x6b\x00\x00\x6e\x02\x00\x02\x01\x64\x00\x00\x17\x53",
		Consts:         []py.Object{py.Int(0)},
		Names:          []string{"a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a < b < c < d)+0", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x04\x03\x6b\x00\x00\x6f\x22\x00\x65\x02\x00\x04\x03\x6b\x00\x00\x6f\x22\x00\x65\x03\x00\x6b\x00\x00\x6e\x02\x00\x02\x01\x64\x00\x00\x17\x53",
		Consts:         []py.Object{py.Int(0)},
		Names:          []string{"a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a < b < c < d < e)+0", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x04\x03\x6b\x00\x00\x6f\x2d\x00\x65\x02\x00\x04\x03\x6b\x00\x00\x6f\x2d\x00\x65\x03\x00\x04\x03\x6b\x00\x00\x6f\x2d\x00\x65\x04\x00\x6b\x00\x00\x6e\x02\x00\x02\x01\x64\x00\x00\x17\x53",
		Consts:         []py.Object{py.Int(0)},
		Names:          []string{"a", "b", "c", "d", "e"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"()", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x66\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a,)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x66\x01\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a,b)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x66\x02\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a,b,c,d)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x66\x04\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"[]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x67\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"[1]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x67\x01\x00\x53",
		Consts:         []py.Object{py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"[1,1]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x00\x00\x67\x02\x00\x53",
		Consts:         []py.Object{py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"[1,1,3,1]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x00\x00\x64\x01\x00\x64\x00\x00\x67\x04\x00\x53",
		Consts:         []py.Object{py.Int(1), py.Int(3)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"[a]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x67\x01\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"[a,b]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x67\x02\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"[a,b,c,d]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x67\x04\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"True", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.True},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"False", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.False},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"None", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a.b", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x6a\x01\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a.b.c", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x6a\x01\x00\x6a\x02\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a.b.c.d", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x6a\x01\x00\x6a\x02\x00\x6a\x03\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a.b = 1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x65\x00\x00\x5f\x01\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a.b.c.d = 1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x65\x00\x00\x6a\x01\x00\x6a\x02\x00\x5f\x03\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a.b += 1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x04\x6a\x01\x00\x64\x00\x00\x37\x02\x5f\x01\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a.b.c.d += 1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x6a\x01\x00\x6a\x02\x00\x04\x6a\x03\x00\x64\x00\x00\x37\x02\x5f\x03\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del a.b", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x60\x01\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del a.b.c.d", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x6a\x01\x00\x6a\x02\x00\x60\x03\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"{}", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x69\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"{1:2,a:b}", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x69\x02\x00\x64\x00\x00\x64\x01\x00\x36\x65\x00\x00\x65\x01\x00\x36\x53",
		Consts:         []py.Object{py.Int(2), py.Int(1)},
		Names:          []string{"b", "a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"{1}", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x68\x01\x00\x53",
		Consts:         []py.Object{py.Int(1)},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"{1,2,a,b}", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x65\x00\x00\x65\x01\x00\x68\x04\x00\x53",
		Consts:         []py.Object{py.Int(1), py.Int(2)},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"lambda: 0", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x64\x01\x00\x53",
			Consts:         []py.Object{py.None, py.Int(0)},
			Names:          []string{},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<lambda>",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("<lambda>")},
		Names:       []string{},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"lambda x: 2*x", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        1,
			Stacksize:      2,
			Flags:          67,
			Code:           "\x64\x01\x00\x7c\x00\x00\x14\x53",
			Consts:         []py.Object{py.None, py.Int(2)},
			Names:          []string{},
			Varnames:       []string{"x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<lambda>",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("<lambda>")},
		Names:       []string{},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"lambda a,b=42,*args,**kw: a*b*args*kw", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x64\x02\x00\x84\x01\x00\x53",
		Consts: []py.Object{py.Int(42), &py.Code{
			Argcount:       2,
			Kwonlyargcount: 0,
			Nlocals:        4,
			Stacksize:      2,
			Flags:          79,
			Code:           "\x7c\x00\x00\x7c\x01\x00\x14\x7c\x02\x00\x14\x7c\x03\x00\x14\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"a", "b", "args", "kw"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<lambda>",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("<lambda>")},
		Names:       []string{},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a+b)", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x17\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a+\nb+\nc)\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x17\x65\x02\x00\x17\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    2,
		Lnotab:         "\x07\x01",
	}, nil, ""},
	{"assert a, \"hello\"", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x73\x12\x00\x74\x01\x00\x64\x00\x00\x83\x01\x00\x82\x01\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.String("hello"), py.None},
		Names:          []string{"a", "AssertionError"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"assert 1, 2", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x73\x12\x00\x74\x00\x00\x64\x01\x00\x83\x01\x00\x82\x01\x00\x64\x02\x00\x53",
		Consts:         []py.Object{py.Int(1), py.Int(2), py.None},
		Names:          []string{"AssertionError"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"assert a", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x73\x0c\x00\x74\x01\x00\x82\x01\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "AssertionError"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"assert 1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x73\x0c\x00\x74\x00\x00\x82\x01\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"AssertionError"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a = 1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a = b = c = 1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x04\x5a\x00\x00\x04\x5a\x01\x00\x5a\x02\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a[1] = 1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x64\x00\x00\x65\x00\x00\x64\x00\x00\x3c\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f() = 1", "exec", nil, py.SyntaxError, "can't assign to function call"},
	{"a+=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x37\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a-=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x38\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a*=b", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x39\x5a\x00\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a/=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x1d\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a%=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x3b\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a**=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x43\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a<<=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x4b\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a>>=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x4c\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a|=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x4f\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a^=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x4e\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a&=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x4d\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a//=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x1c\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a[1]+=1", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x05\x19\x64\x00\x00\x37\x03\x3c\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f() += 1", "exec", nil, py.SyntaxError, "can't assign to function call"},
	{"del a", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x5b\x00\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del a, b", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x5b\x00\x00\x5b\x01\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del a[1]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x3d\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(1), py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del f()", "exec", nil, py.SyntaxError, "can't delete function call"},
	{"def fn(b):\n global a\n del a\n c = 1\n def nested(d):\n   nonlocal b\n   e = b+c+d+e\n   f(e)\n   del b,c,d,e\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        3,
			Stacksize:      3,
			Flags:          3,
			Code:           "\x62\x00\x00\x64\x01\x00\x7d\x01\x00\x87\x00\x00\x66\x01\x00\x64\x02\x00\x64\x03\x00\x86\x00\x00\x7d\x02\x00\x64\x00\x00\x53",
			Consts: []py.Object{py.None, py.Int(1), &py.Code{
				Argcount:       1,
				Kwonlyargcount: 0,
				Nlocals:        3,
				Stacksize:      2,
				Flags:          19,
				Code:           "\x88\x00\x00\x7c\x01\x00\x17\x7c\x00\x00\x17\x7c\x02\x00\x17\x7d\x02\x00\x74\x00\x00\x7c\x02\x00\x83\x01\x00\x01\x8a\x00\x00\x7e\x01\x00\x7e\x00\x00\x7e\x02\x00\x64\x00\x00\x53",
				Consts:         []py.Object{py.None},
				Names:          []string{"f"},
				Varnames:       []string{"d", "c", "e"},
				Freevars:       []string{"b"},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "nested",
				Firstlineno:    5,
				Lnotab:         "\x00\x02\x12\x01\x0a\x01",
			}, py.String("fn.<locals>.nested")},
			Names:       []string{"a"},
			Varnames:    []string{"b", "c", "nested"},
			Freevars:    []string{},
			Cellvars:    []string{"b"},
			Filename:    "<string>",
			Name:        "fn",
			Firstlineno: 1,
			Lnotab:      "\x00\x02\x03\x01\x06\x01",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"raise", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x82\x00\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"raise a", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x82\x01\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"raise a from b", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x82\x02\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"if a: b = c", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x72\x0f\x00\x65\x01\x00\x5a\x02\x00\x6e\x00\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "c", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x06\x00",
	}, nil, ""},
	{"if a:\n b = c\nelse:\n c = d\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x72\x0f\x00\x65\x01\x00\x5a\x02\x00\x6e\x06\x00\x65\x03\x00\x5a\x01\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "c", "b", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x06\x01\x09\x02",
	}, nil, ""},
	{"while a:\n b = c", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x78\x10\x00\x65\x00\x00\x72\x12\x00\x65\x01\x00\x5a\x02\x00\x71\x03\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "c", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x09\x01",
	}, nil, ""},
	{"while a:\n b = c\nelse:\n b = d\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x78\x16\x00\x65\x00\x00\x72\x12\x00\x65\x01\x00\x5a\x02\x00\x71\x03\x00\x57\x65\x03\x00\x5a\x02\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "c", "b", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x09\x01\x0a\x02",
	}, nil, ""},
	{"while a:\n if b: break\n b = c\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x78\x1a\x00\x65\x00\x00\x72\x1c\x00\x65\x01\x00\x72\x13\x00\x50\x6e\x00\x00\x65\x02\x00\x5a\x01\x00\x71\x03\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x09\x01\x06\x00\x04\x01",
	}, nil, ""},
	{"while a:\n if b: continue\n b = c\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x78\x1c\x00\x65\x00\x00\x72\x1e\x00\x65\x01\x00\x72\x15\x00\x71\x03\x00\x6e\x00\x00\x65\x02\x00\x5a\x01\x00\x71\x03\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x09\x01\x06\x00\x06\x01",
	}, nil, ""},
	{"continue", "exec", nil, py.SyntaxError, "'continue' not properly in loop"},
	{"break", "exec", nil, py.SyntaxError, "'break' outside loop"},
	{"for a in b: pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x78\x0e\x00\x65\x00\x00\x44\x5d\x06\x00\x5a\x01\x00\x71\x07\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"b", "a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0d\x00",
	}, nil, ""},
	{"for a in b:\n if a:\n  break\n c = e\nelse: c = d\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x78\x24\x00\x65\x00\x00\x44\x5d\x16\x00\x5a\x01\x00\x65\x01\x00\x72\x17\x00\x50\x6e\x00\x00\x65\x02\x00\x5a\x03\x00\x71\x07\x00\x57\x65\x04\x00\x5a\x03\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"b", "a", "e", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0d\x01\x06\x01\x04\x01\x0a\x01",
	}, nil, ""},
	{"for a in b:\n if a:\n  continue\n c = e\nelse: c = d\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x78\x26\x00\x65\x00\x00\x44\x5d\x18\x00\x5a\x01\x00\x65\x01\x00\x72\x19\x00\x71\x07\x00\x6e\x00\x00\x65\x02\x00\x5a\x03\x00\x71\x07\x00\x57\x65\x04\x00\x5a\x03\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"b", "a", "e", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0d\x01\x06\x01\x06\x01\x0a\x01",
	}, nil, ""},
	{"f()", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x65\x00\x00\x83\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(a)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x83\x01\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"f", "a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(a,b,c)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x83\x03\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"f", "a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(A=a)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x83\x00\x01\x53",
		Consts:         []py.Object{py.String("A")},
		Names:          []string{"f", "a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(a, b, C=d, D=d)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      7,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x64\x00\x00\x65\x03\x00\x64\x01\x00\x65\x03\x00\x83\x02\x02\x53",
		Consts:         []py.Object{py.String("C"), py.String("D")},
		Names:          []string{"f", "a", "b", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(*args)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x8c\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"f", "args"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(*args, **kwargs)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x8e\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"f", "args", "kwargs"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(**kwargs)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x8d\x00\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"f", "kwargs"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(a, b, *args)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x8c\x02\x00\x53",
		Consts:         []py.Object{},
		Names:          []string{"f", "a", "b", "args"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(a, b, *args, d=e, **kwargs)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      7,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x64\x00\x00\x65\x03\x00\x65\x04\x00\x65\x05\x00\x8e\x02\x01\x53",
		Consts:         []py.Object{py.String("d")},
		Names:          []string{"f", "a", "b", "e", "args", "kwargs"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(a, d=e, **kwargs)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x65\x02\x00\x65\x03\x00\x8d\x01\x01\x53",
		Consts:         []py.Object{py.String("d")},
		Names:          []string{"f", "a", "e", "kwargs"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"f(a=1,a=2)", "eval", nil, py.SyntaxError, "keyword argument repeated"},
	{"return", "exec", nil, py.SyntaxError, "'return' outside function"},
	{"def fn(): pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(a): pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        1,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"a"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(a,b,c): pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       3,
			Kwonlyargcount: 0,
			Nlocals:        3,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"a", "b", "c"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(a,b=1,c=2): pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x64\x02\x00\x64\x03\x00\x84\x02\x00\x5a\x00\x00\x64\x04\x00\x53",
		Consts: []py.Object{py.Int(1), py.Int(2), &py.Code{
			Argcount:       3,
			Kwonlyargcount: 0,
			Nlocals:        3,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"a", "b", "c"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(a,*arg,b=1,c=2): pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x64\x02\x00\x64\x03\x00\x64\x04\x00\x64\x05\x00\x84\x00\x02\x5a\x00\x00\x64\x06\x00\x53",
		Consts: []py.Object{py.String("b"), py.Int(1), py.String("c"), py.Int(2), &py.Code{
			Argcount:       1,
			Kwonlyargcount: 2,
			Nlocals:        4,
			Stacksize:      1,
			Flags:          71,
			Code:           "\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"a", "b", "c", "arg"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(a,*arg,b=1,c=2,**kwargs): pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x64\x02\x00\x64\x03\x00\x64\x04\x00\x64\x05\x00\x84\x00\x02\x5a\x00\x00\x64\x06\x00\x53",
		Consts: []py.Object{py.String("b"), py.Int(1), py.String("c"), py.Int(2), &py.Code{
			Argcount:       1,
			Kwonlyargcount: 2,
			Nlocals:        5,
			Stacksize:      1,
			Flags:          79,
			Code:           "\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"a", "b", "c", "arg", "kwargs"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(a:\"a\",*arg:\"arg\",b:\"b\"=1,c:\"c\"=2,**kwargs:\"kw\") -> \"ret\": pass", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      13,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x64\x02\x00\x64\x03\x00\x64\x04\x00\x64\x05\x00\x64\x00\x00\x64\x02\x00\x64\x06\x00\x64\x07\x00\x64\x08\x00\x64\x09\x00\x64\x0a\x00\x90\x07\x00\x84\x00\x02\x5a\x00\x00\x64\x0b\x00\x53",
		Consts: []py.Object{py.String("b"), py.Int(1), py.String("c"), py.Int(2), py.String("a"), py.String("arg"), py.String("kw"), py.String("ret"), py.Tuple{py.String("a"), py.String("arg"), py.String("b"), py.String("c"), py.String("kwargs"), py.String("return")}, &py.Code{
			Argcount:       1,
			Kwonlyargcount: 2,
			Nlocals:        5,
			Stacksize:      1,
			Flags:          79,
			Code:           "\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"a", "b", "c", "arg", "kwargs"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(): a+b", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      2,
			Flags:          67,
			Code:           "\x74\x00\x00\x74\x01\x00\x17\x01\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{"a", "b"},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(a,b): a+b+c+d", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       2,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      2,
			Flags:          67,
			Code:           "\x7c\x00\x00\x7c\x01\x00\x17\x74\x00\x00\x17\x74\x01\x00\x17\x01\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{"c", "d"},
			Varnames:       []string{"a", "b"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(x,*,a,b): x+a+b", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 2,
			Nlocals:        3,
			Stacksize:      2,
			Flags:          67,
			Code:           "\x7c\x00\x00\x7c\x01\x00\x17\x7c\x02\x00\x17\x01\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"x", "a", "b"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(a):\n    global b\n    b = a", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        1,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x7c\x00\x00\x61\x00\x00\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{"b"},
			Varnames:       []string{"a"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "\x00\x02",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(): return", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn(): return a", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x74\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{"a"},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def fn():\n \"docstring\"\n return True", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x64\x01\x00\x53",
			Consts:         []py.Object{py.String("docstring"), py.True},
			Names:          []string{},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "\x00\x02",
		}, py.String("fn"), py.None},
		Names:       []string{"fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def outer(o):\n    def inner(i):\n       x = 2", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      2,
			Flags:          67,
			Code:           "\x64\x01\x00\x64\x02\x00\x84\x00\x00\x7d\x01\x00\x64\x00\x00\x53",
			Consts: []py.Object{py.None, &py.Code{
				Argcount:       1,
				Kwonlyargcount: 0,
				Nlocals:        2,
				Stacksize:      1,
				Flags:          83,
				Code:           "\x64\x01\x00\x7d\x01\x00\x64\x00\x00\x53",
				Consts:         []py.Object{py.None, py.Int(2)},
				Names:          []string{},
				Varnames:       []string{"i", "x"},
				Freevars:       []string{},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "inner",
				Firstlineno:    2,
				Lnotab:         "\x00\x01",
			}, py.String("outer.<locals>.inner")},
			Names:       []string{},
			Varnames:    []string{"o", "inner"},
			Freevars:    []string{},
			Cellvars:    []string{},
			Filename:    "<string>",
			Name:        "outer",
			Firstlineno: 1,
			Lnotab:      "\x00\x01",
		}, py.String("outer"), py.None},
		Names:       []string{"outer"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def outer(o1,o2):\n    x = 1\n    def inner(i1,i2):\n       nonlocal x\n       x = 2\n       def inner2(s):\n           return 2*s\n       f = inner2(x)\n       l = o1+o2+i1+i2+f\n       return l\n    return inner", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       2,
			Kwonlyargcount: 0,
			Nlocals:        3,
			Stacksize:      3,
			Flags:          3,
			Code:           "\x64\x01\x00\x89\x02\x00\x87\x00\x00\x87\x01\x00\x87\x02\x00\x66\x03\x00\x64\x02\x00\x64\x03\x00\x86\x00\x00\x7d\x02\x00\x7c\x02\x00\x53",
			Consts: []py.Object{py.None, py.Int(1), &py.Code{
				Argcount:       2,
				Kwonlyargcount: 0,
				Nlocals:        5,
				Stacksize:      2,
				Flags:          19,
				Code:           "\x64\x01\x00\x89\x02\x00\x64\x02\x00\x64\x03\x00\x84\x00\x00\x7d\x02\x00\x7c\x02\x00\x88\x02\x00\x83\x01\x00\x7d\x03\x00\x88\x00\x00\x88\x01\x00\x17\x7c\x00\x00\x17\x7c\x01\x00\x17\x7c\x03\x00\x17\x7d\x04\x00\x7c\x04\x00\x53",
				Consts: []py.Object{py.None, py.Int(2), &py.Code{
					Argcount:       1,
					Kwonlyargcount: 0,
					Nlocals:        1,
					Stacksize:      2,
					Flags:          83,
					Code:           "\x64\x01\x00\x7c\x00\x00\x14\x53",
					Consts:         []py.Object{py.None, py.Int(2)},
					Names:          []string{},
					Varnames:       []string{"s"},
					Freevars:       []string{},
					Cellvars:       []string{},
					Filename:       "<string>",
					Name:           "inner2",
					Firstlineno:    6,
					Lnotab:         "\x00\x01",
				}, py.String("outer.<locals>.inner.<locals>.inner2")},
				Names:       []string{},
				Varnames:    []string{"i1", "i2", "inner2", "f", "l"},
				Freevars:    []string{"o1", "o2", "x"},
				Cellvars:    []string{},
				Filename:    "<string>",
				Name:        "inner",
				Firstlineno: 3,
				Lnotab:      "\x00\x02\x06\x01\x0c\x02\x0c\x01\x16\x01",
			}, py.String("outer.<locals>.inner")},
			Names:       []string{},
			Varnames:    []string{"o1", "o2", "inner"},
			Freevars:    []string{},
			Cellvars:    []string{"o1", "o2", "x"},
			Filename:    "<string>",
			Name:        "outer",
			Firstlineno: 1,
			Lnotab:      "\x00\x01\x06\x01\x18\x08",
		}, py.String("outer"), py.None},
		Names:       []string{"outer"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def outer(o):\n    x = 17\n    return lambda a,b=42,*args,**kw: a*b*args*kw*x*o", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        1,
			Stacksize:      4,
			Flags:          3,
			Code:           "\x64\x01\x00\x89\x01\x00\x64\x02\x00\x87\x00\x00\x87\x01\x00\x66\x02\x00\x64\x03\x00\x64\x04\x00\x86\x01\x00\x53",
			Consts: []py.Object{py.None, py.Int(17), py.Int(42), &py.Code{
				Argcount:       2,
				Kwonlyargcount: 0,
				Nlocals:        4,
				Stacksize:      2,
				Flags:          31,
				Code:           "\x7c\x00\x00\x7c\x01\x00\x14\x7c\x02\x00\x14\x7c\x03\x00\x14\x88\x01\x00\x14\x88\x00\x00\x14\x53",
				Consts:         []py.Object{py.None},
				Names:          []string{},
				Varnames:       []string{"a", "b", "args", "kw"},
				Freevars:       []string{"o", "x"},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "<lambda>",
				Firstlineno:    3,
				Lnotab:         "",
			}, py.String("outer.<locals>.<lambda>")},
			Names:       []string{},
			Varnames:    []string{"o"},
			Freevars:    []string{},
			Cellvars:    []string{"o", "x"},
			Filename:    "<string>",
			Name:        "outer",
			Firstlineno: 1,
			Lnotab:      "\x00\x01\x06\x01",
		}, py.String("outer"), py.None},
		Names:       []string{"outer"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"@wrap\ndef fn(o):\n    return o", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x01\x00\x84\x00\x00\x83\x01\x00\x5a\x01\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        1,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x7c\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"o"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "\x00\x02",
		}, py.String("fn"), py.None},
		Names:       []string{"wrap", "fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"@wrap1\n@wrap2(\"potato\", 2)\n@wrap3(\"sausage\")\n@wrap4\ndef fn(o):\n    return o", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x64\x01\x00\x83\x02\x00\x65\x02\x00\x64\x02\x00\x83\x01\x00\x65\x03\x00\x64\x03\x00\x64\x04\x00\x84\x00\x00\x83\x01\x00\x83\x01\x00\x83\x01\x00\x83\x01\x00\x5a\x04\x00\x64\x05\x00\x53",
		Consts: []py.Object{py.String("potato"), py.Int(2), py.String("sausage"), &py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        1,
			Stacksize:      1,
			Flags:          67,
			Code:           "\x7c\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{"o"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "fn",
			Firstlineno:    1,
			Lnotab:         "\x00\x05",
		}, py.String("fn"), py.None},
		Names:       []string{"wrap1", "wrap2", "wrap3", "wrap4", "fn"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "\x03\x01\x0c\x01\x09\x01",
	}, nil, ""},
	{"def outer(o):\n    @wrap1\n    @wrap2(\"potato\", o)\n    def inner(i):\n        return o+i", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      5,
			Flags:          3,
			Code:           "\x74\x00\x00\x74\x01\x00\x64\x01\x00\x88\x00\x00\x83\x02\x00\x87\x00\x00\x66\x01\x00\x64\x02\x00\x64\x03\x00\x86\x00\x00\x83\x01\x00\x83\x01\x00\x7d\x01\x00\x64\x00\x00\x53",
			Consts: []py.Object{py.None, py.String("potato"), &py.Code{
				Argcount:       1,
				Kwonlyargcount: 0,
				Nlocals:        1,
				Stacksize:      2,
				Flags:          19,
				Code:           "\x88\x00\x00\x7c\x00\x00\x17\x53",
				Consts:         []py.Object{py.None},
				Names:          []string{},
				Varnames:       []string{"i"},
				Freevars:       []string{"o"},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "inner",
				Firstlineno:    2,
				Lnotab:         "\x00\x03",
			}, py.String("outer.<locals>.inner")},
			Names:       []string{"wrap1", "wrap2"},
			Varnames:    []string{"o", "inner"},
			Freevars:    []string{},
			Cellvars:    []string{"o"},
			Filename:    "<string>",
			Name:        "outer",
			Firstlineno: 1,
			Lnotab:      "\x00\x01\x03\x01",
		}, py.String("outer"), py.None},
		Names:       []string{"outer"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"# Module\n\"\"\"\nA module docstring\n\"\"\"\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.String("\nA module docstring\n"), py.None},
		Names:          []string{"__doc__"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    4,
		Lnotab:         "",
	}, nil, ""},
	{"# Empty docstring\n\"\"\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.String(""), py.None},
		Names:          []string{"__doc__"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    2,
		Lnotab:         "",
	}, nil, ""},
	{"class Dummy:\n    pass\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x47\x64\x00\x00\x64\x01\x00\x84\x00\x00\x64\x01\x00\x83\x02\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          64,
			Code:           "\x65\x00\x00\x5a\x01\x00\x64\x00\x00\x5a\x02\x00\x64\x01\x00\x53",
			Consts:         []py.Object{py.String("Dummy"), py.None},
			Names:          []string{"__name__", "__module__", "__qualname__"},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "Dummy",
			Firstlineno:    1,
			Lnotab:         "\x0c\x01",
		}, py.String("Dummy"), py.None},
		Names:       []string{"Dummy"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"@d1\n@d2\nclass Dummy(a,b,c=d):\n    \"A class\"\n    pass\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      9,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x47\x64\x00\x00\x64\x01\x00\x84\x00\x00\x64\x01\x00\x65\x02\x00\x65\x03\x00\x64\x02\x00\x65\x04\x00\x83\x04\x01\x83\x01\x00\x83\x01\x00\x5a\x05\x00\x64\x03\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          64,
			Code:           "\x65\x00\x00\x5a\x01\x00\x64\x00\x00\x5a\x02\x00\x64\x01\x00\x5a\x03\x00\x64\x02\x00\x53",
			Consts:         []py.Object{py.String("Dummy"), py.String("A class"), py.None},
			Names:          []string{"__name__", "__module__", "__qualname__", "__doc__"},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "Dummy",
			Firstlineno:    1,
			Lnotab:         "\x0c\x03\x06\x01",
		}, py.String("Dummy"), py.String("c"), py.None},
		Names:       []string{"d1", "d2", "a", "b", "d", "Dummy"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "\x03\x01\x10\x01",
	}, nil, ""},
	{"class Dummy:\n    def method(self):\n        return self+1\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x47\x64\x00\x00\x64\x01\x00\x84\x00\x00\x64\x01\x00\x83\x02\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      2,
			Flags:          64,
			Code:           "\x65\x00\x00\x5a\x01\x00\x64\x00\x00\x5a\x02\x00\x64\x01\x00\x64\x02\x00\x84\x00\x00\x5a\x03\x00\x64\x03\x00\x53",
			Consts: []py.Object{py.String("Dummy"), &py.Code{
				Argcount:       1,
				Kwonlyargcount: 0,
				Nlocals:        1,
				Stacksize:      2,
				Flags:          67,
				Code:           "\x7c\x00\x00\x64\x01\x00\x17\x53",
				Consts:         []py.Object{py.None, py.Int(1)},
				Names:          []string{},
				Varnames:       []string{"self"},
				Freevars:       []string{},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "method",
				Firstlineno:    2,
				Lnotab:         "\x00\x01",
			}, py.String("Dummy.method"), py.None},
			Names:       []string{"__name__", "__module__", "__qualname__", "method"},
			Varnames:    []string{},
			Freevars:    []string{},
			Cellvars:    []string{},
			Filename:    "<string>",
			Name:        "Dummy",
			Firstlineno: 1,
			Lnotab:      "\x0c\x01",
		}, py.String("Dummy"), py.None},
		Names:       []string{"Dummy"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"@class1\n@class2(arg2)\nclass Dummy:\n    \"Dummy\"\n    @fn1\n    @fn2(arg2)\n    def method(self):\n        \"method\"\n        return self+1\n    def method2(self, m2):\n        \"method2\"\n        return self.method()+m2\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x83\x01\x00\x47\x64\x00\x00\x64\x01\x00\x84\x00\x00\x64\x01\x00\x83\x02\x00\x83\x01\x00\x83\x01\x00\x5a\x03\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      4,
			Flags:          64,
			Code:           "\x65\x00\x00\x5a\x01\x00\x64\x00\x00\x5a\x02\x00\x64\x00\x00\x5a\x03\x00\x65\x04\x00\x65\x05\x00\x65\x06\x00\x83\x01\x00\x64\x01\x00\x64\x02\x00\x84\x00\x00\x83\x01\x00\x83\x01\x00\x5a\x07\x00\x64\x03\x00\x64\x04\x00\x84\x00\x00\x5a\x08\x00\x64\x05\x00\x53",
			Consts: []py.Object{py.String("Dummy"), &py.Code{
				Argcount:       1,
				Kwonlyargcount: 0,
				Nlocals:        1,
				Stacksize:      2,
				Flags:          67,
				Code:           "\x7c\x00\x00\x64\x01\x00\x17\x53",
				Consts:         []py.Object{py.String("method"), py.Int(1)},
				Names:          []string{},
				Varnames:       []string{"self"},
				Freevars:       []string{},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "method",
				Firstlineno:    5,
				Lnotab:         "\x00\x04",
			}, py.String("Dummy.method"), &py.Code{
				Argcount:       2,
				Kwonlyargcount: 0,
				Nlocals:        2,
				Stacksize:      2,
				Flags:          67,
				Code:           "\x7c\x00\x00\x6a\x00\x00\x83\x00\x00\x7c\x01\x00\x17\x53",
				Consts:         []py.Object{py.String("method2")},
				Names:          []string{"method"},
				Varnames:       []string{"self", "m2"},
				Freevars:       []string{},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "method2",
				Firstlineno:    10,
				Lnotab:         "\x00\x02",
			}, py.String("Dummy.method2"), py.None},
			Names:       []string{"__name__", "__module__", "__qualname__", "__doc__", "fn1", "fn2", "arg2", "method", "method2"},
			Varnames:    []string{},
			Freevars:    []string{},
			Cellvars:    []string{},
			Filename:    "<string>",
			Name:        "Dummy",
			Firstlineno: 1,
			Lnotab:      "\x0c\x03\x06\x01\x03\x01\x1b\x04",
		}, py.String("Dummy"), py.None},
		Names:       []string{"class1", "class2", "arg2", "Dummy"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "\x03\x01",
	}, nil, ""},
	{"def closure_class(a):\n    b = 42\n    class AClass:\n        def method(self, c):\n            return a+b+c\n    return AClass\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      4,
			Flags:          3,
			Code:           "\x64\x01\x00\x89\x01\x00\x47\x87\x00\x00\x87\x01\x00\x66\x02\x00\x64\x02\x00\x64\x03\x00\x86\x00\x00\x64\x03\x00\x83\x02\x00\x7d\x01\x00\x7c\x01\x00\x53",
			Consts: []py.Object{py.None, py.Int(42), &py.Code{
				Argcount:       0,
				Kwonlyargcount: 0,
				Nlocals:        0,
				Stacksize:      3,
				Flags:          0,
				Code:           "\x65\x00\x00\x5a\x01\x00\x64\x00\x00\x5a\x02\x00\x87\x00\x00\x87\x01\x00\x66\x02\x00\x64\x01\x00\x64\x02\x00\x86\x00\x00\x5a\x03\x00\x64\x03\x00\x53",
				Consts: []py.Object{py.String("closure_class.<locals>.AClass"), &py.Code{
					Argcount:       2,
					Kwonlyargcount: 0,
					Nlocals:        2,
					Stacksize:      2,
					Flags:          19,
					Code:           "\x88\x00\x00\x88\x01\x00\x17\x7c\x01\x00\x17\x53",
					Consts:         []py.Object{py.None},
					Names:          []string{},
					Varnames:       []string{"self", "c"},
					Freevars:       []string{"a", "b"},
					Cellvars:       []string{},
					Filename:       "<string>",
					Name:           "method",
					Firstlineno:    4,
					Lnotab:         "\x00\x01",
				}, py.String("closure_class.<locals>.AClass.method"), py.None},
				Names:       []string{"__name__", "__module__", "__qualname__", "method"},
				Varnames:    []string{},
				Freevars:    []string{"a", "b"},
				Cellvars:    []string{},
				Filename:    "<string>",
				Name:        "AClass",
				Firstlineno: 3,
				Lnotab:      "\x0c\x01",
			}, py.String("AClass")},
			Names:       []string{},
			Varnames:    []string{"a", "AClass"},
			Freevars:    []string{},
			Cellvars:    []string{"a", "b"},
			Filename:    "<string>",
			Name:        "closure_class",
			Firstlineno: 1,
			Lnotab:      "\x00\x01\x06\x01\x1c\x03",
		}, py.String("closure_class"), py.None},
		Names:       []string{"closure_class"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"@potato\n@sausage()\nclass A(a,b,c=\"1\",d=\"2\",*args,**kwargs):\n    VAR = x\n    def method(self):\n        super().method()\n        return VAR\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      13,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x83\x00\x00\x47\x64\x00\x00\x64\x01\x00\x84\x00\x00\x64\x01\x00\x65\x02\x00\x65\x03\x00\x64\x02\x00\x64\x03\x00\x64\x04\x00\x64\x05\x00\x65\x04\x00\x65\x05\x00\x8e\x04\x02\x83\x01\x00\x83\x01\x00\x5a\x06\x00\x64\x06\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      3,
			Flags:          0,
			Code:           "\x65\x00\x00\x5a\x01\x00\x64\x00\x00\x5a\x02\x00\x65\x03\x00\x5a\x04\x00\x87\x00\x00\x66\x01\x00\x64\x01\x00\x64\x02\x00\x86\x00\x00\x5a\x05\x00\x87\x00\x00\x53",
			Consts: []py.Object{py.String("A"), &py.Code{
				Argcount:       1,
				Kwonlyargcount: 0,
				Nlocals:        1,
				Stacksize:      1,
				Flags:          3,
				Code:           "\x74\x00\x00\x83\x00\x00\x6a\x01\x00\x83\x00\x00\x01\x74\x02\x00\x53",
				Consts:         []py.Object{py.None},
				Names:          []string{"super", "method", "VAR"},
				Varnames:       []string{"self"},
				Freevars:       []string{"__class__"},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "method",
				Firstlineno:    5,
				Lnotab:         "\x00\x01\x0d\x01",
			}, py.String("A.method")},
			Names:       []string{"__name__", "__module__", "__qualname__", "x", "VAR", "method"},
			Varnames:    []string{},
			Freevars:    []string{},
			Cellvars:    []string{"__class__"},
			Filename:    "<string>",
			Name:        "A",
			Firstlineno: 1,
			Lnotab:      "\x0c\x03\x06\x01",
		}, py.String("A"), py.String("c"), py.String("1"), py.String("d"), py.String("2"), py.None},
		Names:       []string{"potato", "sausage", "a", "b", "args", "kwargs", "A"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "\x03\x01\x13\x01",
	}, nil, ""},
	{"def outer(x):\n    class DeRefTest:\n        VAR = x\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      4,
			Flags:          3,
			Code:           "\x47\x87\x00\x00\x66\x01\x00\x64\x01\x00\x64\x02\x00\x86\x00\x00\x64\x02\x00\x83\x02\x00\x7d\x01\x00\x64\x00\x00\x53",
			Consts: []py.Object{py.None, &py.Code{
				Argcount:       0,
				Kwonlyargcount: 0,
				Nlocals:        0,
				Stacksize:      1,
				Flags:          0,
				Code:           "\x65\x00\x00\x5a\x01\x00\x64\x00\x00\x5a\x02\x00\x94\x00\x00\x5a\x03\x00\x64\x01\x00\x53",
				Consts:         []py.Object{py.String("outer.<locals>.DeRefTest"), py.None},
				Names:          []string{"__name__", "__module__", "__qualname__", "VAR"},
				Varnames:       []string{},
				Freevars:       []string{"x"},
				Cellvars:       []string{},
				Filename:       "<string>",
				Name:           "DeRefTest",
				Firstlineno:    2,
				Lnotab:         "\x0c\x01",
			}, py.String("DeRefTest")},
			Names:       []string{},
			Varnames:    []string{"x", "DeRefTest"},
			Freevars:    []string{},
			Cellvars:    []string{"x"},
			Filename:    "<string>",
			Name:        "outer",
			Firstlineno: 1,
			Lnotab:      "\x00\x01",
		}, py.String("outer"), py.None},
		Names:       []string{"outer"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"[ x for x in xs ]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      3,
			Flags:          67,
			Code:           "\x67\x00\x00\x7c\x00\x00\x5d\x0c\x00\x7d\x01\x00\x7c\x01\x00\x91\x02\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<listcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<listcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"{ x: y for x in xs }", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      4,
			Flags:          67,
			Code:           "\x69\x00\x00\x7c\x00\x00\x5d\x0f\x00\x7d\x01\x00\x74\x00\x00\x7c\x01\x00\x93\x02\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"y"},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<dictcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<dictcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"{ x for x in xs }", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      3,
			Flags:          67,
			Code:           "\x68\x00\x00\x7c\x00\x00\x5d\x0c\x00\x7d\x01\x00\x7c\x01\x00\x92\x02\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<setcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<setcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"( x for x in xs )", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      2,
			Flags:          99,
			Code:           "\x7c\x00\x00\x5d\x0b\x00\x7d\x01\x00\x7c\x01\x00\x56\x01\x71\x03\x00\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<genexpr>",
			Firstlineno:    1,
			Lnotab:         "\x06\x00",
		}, py.String("<genexpr>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"[ x for x in xs if a ]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      3,
			Flags:          67,
			Code:           "\x67\x00\x00\x7c\x00\x00\x5d\x12\x00\x7d\x01\x00\x74\x00\x00\x72\x06\x00\x7c\x01\x00\x91\x02\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"a"},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<listcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<listcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"{ x: y for x in xs if a if b }", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      4,
			Flags:          67,
			Code:           "\x69\x00\x00\x7c\x00\x00\x5d\x1b\x00\x7d\x01\x00\x74\x00\x00\x72\x06\x00\x74\x01\x00\x72\x06\x00\x74\x02\x00\x7c\x01\x00\x93\x02\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"a", "b", "y"},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<dictcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<dictcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"{ x for x in xs if a}", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      3,
			Flags:          67,
			Code:           "\x68\x00\x00\x7c\x00\x00\x5d\x12\x00\x7d\x01\x00\x74\x00\x00\x72\x06\x00\x7c\x01\x00\x92\x02\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"a"},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<setcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<setcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"( x for x in xs if a if b if c)", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      2,
			Flags:          99,
			Code:           "\x7c\x00\x00\x5d\x1d\x00\x7d\x01\x00\x74\x00\x00\x72\x03\x00\x74\x01\x00\x72\x03\x00\x74\x02\x00\x72\x03\x00\x7c\x01\x00\x56\x01\x71\x03\x00\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{"a", "b", "c"},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<genexpr>",
			Firstlineno:    1,
			Lnotab:         "\x06\x00",
		}, py.String("<genexpr>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"{ x for x in [ x for x in xs if c if d ] if a if b}", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x64\x02\x00\x64\x03\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      3,
			Flags:          67,
			Code:           "\x68\x00\x00\x7c\x00\x00\x5d\x18\x00\x7d\x01\x00\x74\x00\x00\x72\x06\x00\x74\x01\x00\x72\x06\x00\x7c\x01\x00\x92\x02\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"a", "b"},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<setcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<setcomp>"), &py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        2,
			Stacksize:      3,
			Flags:          67,
			Code:           "\x67\x00\x00\x7c\x00\x00\x5d\x18\x00\x7d\x01\x00\x74\x00\x00\x72\x06\x00\x74\x01\x00\x72\x06\x00\x7c\x01\x00\x91\x02\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"c", "d"},
			Varnames:       []string{".0", "x"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<listcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<listcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"[ (x,y,z) for x in xs for y in ys for z in zs ]", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        4,
			Stacksize:      7,
			Flags:          67,
			Code:           "\x67\x00\x00\x7c\x00\x00\x5d\x2f\x00\x7d\x01\x00\x74\x00\x00\x44\x5d\x22\x00\x7d\x02\x00\x74\x01\x00\x44\x5d\x15\x00\x7d\x03\x00\x7c\x01\x00\x7c\x02\x00\x7c\x03\x00\x66\x03\x00\x91\x04\x00\x71\x1a\x00\x71\x10\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"ys", "zs"},
			Varnames:       []string{".0", "x", "y", "z"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<listcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<listcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"{ (x,y,z) for x in xs for y in ys if a if b for z in zs if c if d }", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        4,
			Stacksize:      7,
			Flags:          67,
			Code:           "\x68\x00\x00\x7c\x00\x00\x5d\x47\x00\x7d\x01\x00\x74\x00\x00\x44\x5d\x3a\x00\x7d\x02\x00\x74\x01\x00\x72\x10\x00\x74\x02\x00\x72\x10\x00\x74\x03\x00\x44\x5d\x21\x00\x7d\x03\x00\x74\x04\x00\x72\x26\x00\x74\x05\x00\x72\x26\x00\x7c\x01\x00\x7c\x02\x00\x7c\x03\x00\x66\x03\x00\x92\x04\x00\x71\x26\x00\x71\x10\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"ys", "a", "b", "zs", "c", "d"},
			Varnames:       []string{".0", "x", "y", "z"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<setcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<setcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"{ x:(y,z) for x in xs for y in ys for z in zs }", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        4,
			Stacksize:      6,
			Flags:          67,
			Code:           "\x69\x00\x00\x7c\x00\x00\x5d\x2f\x00\x7d\x01\x00\x74\x00\x00\x44\x5d\x22\x00\x7d\x02\x00\x74\x01\x00\x44\x5d\x15\x00\x7d\x03\x00\x7c\x02\x00\x7c\x03\x00\x66\x02\x00\x7c\x01\x00\x93\x04\x00\x71\x1a\x00\x71\x10\x00\x71\x06\x00\x53",
			Consts:         []py.Object{},
			Names:          []string{"ys", "zs"},
			Varnames:       []string{".0", "x", "y", "z"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<dictcomp>",
			Firstlineno:    1,
			Lnotab:         "\x09\x00",
		}, py.String("<dictcomp>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"( (x,y,z) for x in xs for y in ys if a if b for z in zs if c if d )", "eval", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x65\x00\x00\x44\x83\x01\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       1,
			Kwonlyargcount: 0,
			Nlocals:        4,
			Stacksize:      6,
			Flags:          99,
			Code:           "\x7c\x00\x00\x5d\x46\x00\x7d\x01\x00\x74\x00\x00\x44\x5d\x39\x00\x7d\x02\x00\x74\x01\x00\x72\x0d\x00\x74\x02\x00\x72\x0d\x00\x74\x03\x00\x44\x5d\x20\x00\x7d\x03\x00\x74\x04\x00\x72\x23\x00\x74\x05\x00\x72\x23\x00\x7c\x01\x00\x7c\x02\x00\x7c\x03\x00\x66\x03\x00\x56\x01\x71\x23\x00\x71\x0d\x00\x71\x03\x00\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{"ys", "a", "b", "zs", "c", "d"},
			Varnames:       []string{".0", "x", "y", "z"},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "<genexpr>",
			Firstlineno:    1,
			Lnotab:         "\x06\x00",
		}, py.String("<genexpr>")},
		Names:       []string{"xs"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"with a:\n    f()\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      8,
		Flags:          64,
		Code:           "\x65\x00\x00\x8f\x0c\x00\x01\x65\x01\x00\x83\x00\x00\x01\x57\x64\x00\x00\x51\x58\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x07\x01",
	}, nil, ""},
	{"with a() as b:\n    f(b)\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      9,
		Flags:          64,
		Code:           "\x65\x00\x00\x83\x00\x00\x8f\x11\x00\x5a\x01\x00\x65\x02\x00\x65\x01\x00\x83\x01\x00\x01\x57\x64\x00\x00\x51\x58\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"a", "b", "f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0c\x01",
	}, nil, ""},
	{"with A() as a, B() as b:\n    f(a,b)\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      17,
		Flags:          64,
		Code:           "\x65\x00\x00\x83\x00\x00\x8f\x26\x00\x5a\x01\x00\x65\x02\x00\x83\x00\x00\x8f\x14\x00\x5a\x03\x00\x65\x04\x00\x65\x01\x00\x65\x03\x00\x83\x02\x00\x01\x57\x64\x00\x00\x51\x58\x57\x64\x00\x00\x51\x58\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"A", "a", "B", "b", "f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x18\x01",
	}, nil, ""},
	{"with A() as a:\n    with B() as b:\n        f(a,b)\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      17,
		Flags:          64,
		Code:           "\x65\x00\x00\x83\x00\x00\x8f\x26\x00\x5a\x01\x00\x65\x02\x00\x83\x00\x00\x8f\x14\x00\x5a\x03\x00\x65\x04\x00\x65\x01\x00\x65\x03\x00\x83\x02\x00\x01\x57\x64\x00\x00\x51\x58\x57\x64\x00\x00\x51\x58\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"A", "a", "B", "b", "f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0c\x01\x0c\x01",
	}, nil, ""},
	{"ok = False\ntry:\n    raise SyntaxError\nexcept SyntaxError:\n    ok = True\nassert ok\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      11,
		Flags:          64,
		Code:           "\x64\x00\x00\x5a\x00\x00\x79\x0a\x00\x65\x01\x00\x82\x01\x00\x57\x6e\x18\x00\x04\x65\x01\x00\x6b\x0a\x00\x72\x2a\x00\x01\x01\x01\x64\x01\x00\x5a\x00\x00\x59\x6e\x01\x00\x58\x65\x00\x00\x73\x37\x00\x74\x02\x00\x82\x01\x00\x64\x02\x00\x53",
		Consts:         []py.Object{py.False, py.True, py.None},
		Names:          []string{"ok", "SyntaxError", "AssertionError"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x06\x01\x03\x01\x0a\x01\x0d\x01\x0b\x01",
	}, nil, ""},
	{"ok = False\ntry:\n    raise SyntaxError\nexcept SyntaxError as e:\n    ok = True\nassert ok\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      16,
		Flags:          64,
		Code:           "\x64\x00\x00\x5a\x00\x00\x79\x0a\x00\x65\x01\x00\x82\x01\x00\x57\x6e\x2b\x00\x04\x65\x01\x00\x6b\x0a\x00\x72\x3d\x00\x01\x5a\x02\x00\x01\x7a\x0b\x00\x64\x01\x00\x5a\x00\x00\x57\x59\x64\x02\x00\x64\x02\x00\x5a\x02\x00\x5b\x02\x00\x58\x6e\x01\x00\x58\x65\x00\x00\x73\x4a\x00\x74\x03\x00\x82\x01\x00\x64\x02\x00\x53",
		Consts:         []py.Object{py.False, py.True, py.None},
		Names:          []string{"ok", "SyntaxError", "e", "AssertionError"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x06\x01\x03\x01\x0a\x01\x12\x01\x19\x01",
	}, nil, ""},
	{"try:\n    f()\nexcept Exception:\n    h()\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      11,
		Flags:          64,
		Code:           "\x79\x0b\x00\x65\x00\x00\x83\x00\x00\x01\x57\x6e\x19\x00\x04\x65\x01\x00\x6b\x0a\x00\x72\x26\x00\x01\x01\x01\x65\x02\x00\x83\x00\x00\x01\x59\x6e\x01\x00\x58\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"f", "Exception", "h"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x03\x01\x0b\x01\x0d\x01",
	}, nil, ""},
	{"try:\n    f()\nexcept Exception as e:\n    h(e)\nexcept (Exception1, Exception2) as e:\n    i(e)\nexcept:\n    j()\nelse:\n    potato()\n", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      16,
		Flags:          64,
		Code:           "\x79\x0b\x00\x65\x00\x00\x83\x00\x00\x01\x57\x6e\x71\x00\x04\x65\x01\x00\x6b\x0a\x00\x72\x3c\x00\x01\x5a\x02\x00\x01\x7a\x0f\x00\x65\x03\x00\x65\x02\x00\x83\x01\x00\x01\x57\x59\x64\x00\x00\x64\x00\x00\x5a\x02\x00\x5b\x02\x00\x58\x6e\x4a\x00\x04\x65\x04\x00\x65\x05\x00\x66\x02\x00\x6b\x0a\x00\x72\x70\x00\x01\x5a\x02\x00\x01\x7a\x0f\x00\x65\x06\x00\x65\x02\x00\x83\x01\x00\x01\x57\x59\x64\x00\x00\x64\x00\x00\x5a\x02\x00\x5b\x02\x00\x58\x6e\x16\x00\x01\x01\x01\x65\x07\x00\x83\x00\x00\x01\x59\x6e\x08\x00\x58\x65\x08\x00\x83\x00\x00\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"f", "Exception", "e", "h", "Exception1", "Exception2", "i", "j", "potato"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x03\x01\x0b\x01\x12\x01\x1c\x01\x18\x01\x1c\x01\x03\x01\x0c\x02",
	}, nil, ""},
	{"try:\n    f()\nexcept:\n    j()\nexcept Exception as e:\n    h(e)\n    ", "exec", nil, py.SyntaxError, "default 'except:' must be last"},
	{"try:\n    f()\nfinally:\n    j()\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      10,
		Flags:          64,
		Code:           "\x7a\x0b\x00\x65\x00\x00\x83\x00\x00\x01\x57\x64\x00\x00\x65\x01\x00\x83\x00\x00\x01\x58\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"f", "j"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x03\x01\x0b\x02",
	}, nil, ""},
	{"try:\n    f()\nexcept Exception as e:\n    h(e)\nfinally:\n    j()\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      22,
		Flags:          64,
		Code:           "\x7a\x41\x00\x79\x0b\x00\x65\x00\x00\x83\x00\x00\x01\x57\x6e\x2f\x00\x04\x65\x01\x00\x6b\x0a\x00\x72\x3f\x00\x01\x5a\x02\x00\x01\x7a\x0f\x00\x65\x03\x00\x65\x02\x00\x83\x01\x00\x01\x57\x59\x64\x00\x00\x64\x00\x00\x5a\x02\x00\x5b\x02\x00\x58\x6e\x01\x00\x58\x57\x64\x00\x00\x65\x04\x00\x83\x00\x00\x01\x58\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"f", "Exception", "e", "h", "j"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x06\x01\x0b\x01\x12\x01\x21\x02",
	}, nil, ""},
	{"import mod", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x5a\x00\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(0), py.None},
		Names:          []string{"mod"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"import mod1, mod2, mod3", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x5a\x00\x00\x64\x00\x00\x64\x01\x00\x6c\x01\x00\x5a\x01\x00\x64\x00\x00\x64\x01\x00\x6c\x02\x00\x5a\x02\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(0), py.None},
		Names:          []string{"mod1", "mod2", "mod3"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"import mod as pod, mod2 as pod2", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x5a\x01\x00\x64\x00\x00\x64\x01\x00\x6c\x02\x00\x5a\x03\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(0), py.None},
		Names:          []string{"mod", "pod", "mod2", "pod2"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"import mod1.mod2", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x5a\x01\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(0), py.None},
		Names:          []string{"mod1.mod2", "mod1"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"import mod1.mod2.mod3", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x5a\x01\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(0), py.None},
		Names:          []string{"mod1.mod2.mod3", "mod1"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"import mod1.mod2.mod3.mod4", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x5a\x01\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(0), py.None},
		Names:          []string{"mod1.mod2.mod3.mod4", "mod1"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"import mod1.mod2.mod3.mod4 as potato", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x6a\x01\x00\x6a\x02\x00\x6a\x03\x00\x5a\x04\x00\x64\x01\x00\x53",
		Consts:         []py.Object{py.Int(0), py.None},
		Names:          []string{"mod1.mod2.mod3.mod4", "mod2", "mod3", "mod4", "potato"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"from mod import a", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x6d\x01\x00\x5a\x01\x00\x01\x64\x02\x00\x53",
		Consts:         []py.Object{py.Int(0), py.Tuple{py.String("a")}, py.None},
		Names:          []string{"mod", "a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"from mod1.mod2.mod3 import *", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x54\x64\x02\x00\x53",
		Consts:         []py.Object{py.Int(0), py.Tuple{py.String("*")}, py.None},
		Names:          []string{"mod1.mod2.mod3"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"from mod1.mod2.mod3 import a as aa, b as bb, c", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x6c\x00\x00\x6d\x01\x00\x5a\x02\x00\x6d\x03\x00\x5a\x04\x00\x6d\x05\x00\x5a\x05\x00\x01\x64\x02\x00\x53",
		Consts:         []py.Object{py.Int(0), py.Tuple{py.String("a"), py.String("b"), py.String("c")}, py.None},
		Names:          []string{"mod1.mod2.mod3", "a", "aa", "b", "bb", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"yield", "exec", nil, py.SyntaxError, "'yield' outside function"},
	{"yield potato", "exec", nil, py.SyntaxError, "'yield' outside function"},
	{"def f():\n    yield\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          99,
			Code:           "\x64\x00\x00\x56\x01\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "f",
			Firstlineno:    1,
			Lnotab:         "\x00\x01",
		}, py.String("f"), py.None},
		Names:       []string{"f"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"def f():\n    yield potato\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      1,
			Flags:          99,
			Code:           "\x74\x00\x00\x56\x01\x64\x00\x00\x53",
			Consts:         []py.Object{py.None},
			Names:          []string{"potato"},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "f",
			Firstlineno:    1,
			Lnotab:         "\x00\x01",
		}, py.String("f"), py.None},
		Names:       []string{"f"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"yield from range(10)", "exec", nil, py.SyntaxError, "'yield' outside function"},
	{"def f():\n    yield from range(10)\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x64\x00\x00\x64\x01\x00\x84\x00\x00\x5a\x00\x00\x64\x02\x00\x53",
		Consts: []py.Object{&py.Code{
			Argcount:       0,
			Kwonlyargcount: 0,
			Nlocals:        0,
			Stacksize:      2,
			Flags:          99,
			Code:           "\x74\x00\x00\x64\x01\x00\x83\x01\x00\x44\x64\x00\x00\x48\x01\x64\x00\x00\x53",
			Consts:         []py.Object{py.None, py.Int(10)},
			Names:          []string{"range"},
			Varnames:       []string{},
			Freevars:       []string{},
			Cellvars:       []string{},
			Filename:       "<string>",
			Name:           "f",
			Firstlineno:    1,
			Lnotab:         "\x00\x01",
		}, py.String("f"), py.None},
		Names:       []string{"f"},
		Varnames:    []string{},
		Freevars:    []string{},
		Cellvars:    []string{},
		Filename:    "<string>",
		Name:        "<module>",
		Firstlineno: 1,
		Lnotab:      "",
	}, nil, ""},
	{"...", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      1,
		Flags:          64,
		Code:           "\x64\x00\x00\x01\x64\x01\x00\x53",
		Consts:         []py.Object{py.Ellipsis, py.None},
		Names:          []string{},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"*a = t", "exec", nil, py.SyntaxError, "starred assignment target must be in a list or tuple"},
	{"a, *b = t", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x5e\x01\x00\x5a\x01\x00\x5a\x02\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"t", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"(a, *b) = t", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x5e\x01\x00\x5a\x01\x00\x5a\x02\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"t", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"[a, *b] = t", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x5e\x01\x00\x5a\x01\x00\x5a\x02\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"t", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a, *b, c = t", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x5e\x01\x01\x5a\x01\x00\x5a\x02\x00\x5a\x03\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"t", "a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"a, *b, *c = t", "exec", nil, py.SyntaxError, "two starred expressions in assignment"},
	{"a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,*a = t", "exec", nil, py.SyntaxError, "too many expressions in star-unpacking assignment"},
	{"a, b, *c", "exec", nil, py.SyntaxError, "can use starred expression only as assignment target"},
	{"a, (b, c), d = t", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x5c\x03\x00\x5a\x01\x00\x5c\x02\x00\x5a\x02\x00\x5a\x03\x00\x5a\x04\x00\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"t", "a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x85\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x85\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[b:]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x85\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x85\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b:c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x85\x03\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b:c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x65\x02\x00\x85\x03\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a::c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x65\x02\x00\x85\x03\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b:]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x85\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x65\x01\x00\x85\x03\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b:]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x85\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x65\x01\x00\x85\x03\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x85\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a,p]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x66\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "p"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x66\x02\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b, c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x66\x03\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b:c, ::d]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x85\x02\x00\x64\x00\x00\x64\x00\x00\x65\x04\x00\x85\x03\x00\x66\x03\x00\x19\x01\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[0, 1:2, ::5, ...]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x01\x00\x64\x02\x00\x85\x02\x00\x64\x03\x00\x64\x03\x00\x64\x04\x00\x85\x03\x00\x64\x05\x00\x66\x04\x00\x19\x01\x64\x03\x00\x53",
		Consts:         []py.Object{py.Int(0), py.Int(1), py.Int(2), py.None, py.Int(5), py.Ellipsis},
		Names:          []string{"x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x85\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x65\x02\x00\x85\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[b:] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x64\x00\x00\x85\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x64\x00\x00\x85\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b:c] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x65\x04\x00\x85\x03\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b:c] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x65\x02\x00\x65\x03\x00\x85\x03\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a::c] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x64\x00\x00\x65\x03\x00\x85\x03\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b:] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x85\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::c] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x64\x00\x00\x65\x02\x00\x85\x03\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b:] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x65\x02\x00\x85\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::c] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x64\x00\x00\x65\x02\x00\x85\x03\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x64\x00\x00\x85\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a,p] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x66\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a", "p"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x66\x02\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b, c] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      5,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x65\x04\x00\x66\x03\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b:c, ::d] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      7,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x65\x04\x00\x85\x02\x00\x64\x00\x00\x64\x00\x00\x65\x05\x00\x85\x03\x00\x66\x03\x00\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"y", "x", "a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[0, 1:2, ::5, ...] = y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      7,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x64\x01\x00\x64\x02\x00\x85\x02\x00\x64\x03\x00\x64\x03\x00\x64\x04\x00\x85\x03\x00\x64\x05\x00\x66\x04\x00\x3c\x64\x03\x00\x53",
		Consts:         []py.Object{py.Int(0), py.Int(1), py.Int(2), py.None, py.Int(5), py.Ellipsis},
		Names:          []string{"y", "x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x05\x19\x65\x02\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x85\x02\x00\x05\x19\x65\x03\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x85\x02\x00\x05\x19\x65\x02\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[b:] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x85\x02\x00\x05\x19\x65\x02\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x85\x02\x00\x05\x19\x65\x01\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b:c] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x85\x03\x00\x05\x19\x65\x04\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b:c] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x65\x02\x00\x85\x03\x00\x05\x19\x65\x03\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b", "c", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a::c] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x65\x02\x00\x85\x03\x00\x05\x19\x65\x03\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "c", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a:b:] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x85\x02\x00\x05\x19\x65\x03\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::c] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x65\x01\x00\x85\x03\x00\x05\x19\x65\x02\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "c", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[:b:] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x85\x02\x00\x05\x19\x65\x02\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::c] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x65\x01\x00\x85\x03\x00\x05\x19\x65\x02\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "c", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[::] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x85\x02\x00\x05\x19\x65\x01\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a,p] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x66\x02\x00\x05\x19\x65\x03\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "p", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x66\x02\x00\x05\x19\x65\x03\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b, c] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x66\x03\x00\x05\x19\x65\x04\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[a, b:c, ::d] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x85\x02\x00\x64\x00\x00\x64\x00\x00\x65\x04\x00\x85\x03\x00\x66\x03\x00\x05\x19\x65\x05\x00\x37\x03\x3c\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c", "d", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"x[0, 1:2, ::5, ...] += y", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x01\x00\x64\x02\x00\x85\x02\x00\x64\x03\x00\x64\x03\x00\x64\x04\x00\x85\x03\x00\x64\x05\x00\x66\x04\x00\x05\x19\x65\x01\x00\x37\x03\x3c\x64\x03\x00\x53",
		Consts:         []py.Object{py.Int(0), py.Int(1), py.Int(2), py.None, py.Int(5), py.Ellipsis},
		Names:          []string{"x", "y"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a:b]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x85\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[:b]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x85\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[b:]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x85\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[:]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x85\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a:b:c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x85\x03\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[:b:c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x65\x02\x00\x85\x03\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a::c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x64\x00\x00\x65\x02\x00\x85\x03\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a:b:]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x85\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[::c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x65\x01\x00\x85\x03\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[:b:]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x65\x01\x00\x85\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[::c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x65\x01\x00\x85\x03\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[::]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x00\x00\x85\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a,p]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x66\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "p"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a, b]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      3,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x66\x02\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a, b, c]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      4,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x66\x03\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[a, b:c, ::d]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x65\x00\x00\x65\x01\x00\x65\x02\x00\x65\x03\x00\x85\x02\x00\x64\x00\x00\x64\x00\x00\x65\x04\x00\x85\x03\x00\x66\x03\x00\x3d\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "a", "b", "c", "d"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"del x[0, 1:2, ::5, ...]", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      6,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x64\x01\x00\x64\x02\x00\x85\x02\x00\x64\x03\x00\x64\x03\x00\x64\x04\x00\x85\x03\x00\x64\x05\x00\x66\x04\x00\x3d\x64\x03\x00\x53",
		Consts:         []py.Object{py.Int(0), py.Int(1), py.Int(2), py.None, py.Int(5), py.Ellipsis},
		Names:          []string{"x"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
	{"try:\n    continue\nexcept:\n    pass\n    ", "exec", nil, py.SyntaxError, "'continue' not properly in loop"},
	{"try:\n    pass\nexcept:\n    continue\n    ", "exec", nil, py.SyntaxError, "'continue' not properly in loop"},
	{"for x in xs:\n    try:\n        f()\n    except:\n        continue\n    f()\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      10,
		Flags:          64,
		Code:           "\x78\x2e\x00\x65\x00\x00\x44\x5d\x26\x00\x5a\x01\x00\x79\x0b\x00\x65\x02\x00\x83\x00\x00\x01\x57\x6e\x0b\x00\x01\x01\x01\x77\x07\x00\x59\x6e\x01\x00\x58\x65\x02\x00\x83\x00\x00\x01\x71\x07\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"xs", "x", "f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0d\x01\x03\x01\x0b\x01\x03\x01\x08\x01",
	}, nil, ""},
	{"for x in xs:\n    try:\n        f()\n        continue\n    finally:\n        f()\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      11,
		Flags:          64,
		Code:           "\x78\x27\x00\x65\x00\x00\x44\x5d\x1f\x00\x5a\x01\x00\x7a\x0e\x00\x65\x02\x00\x83\x00\x00\x01\x77\x07\x00\x57\x64\x00\x00\x65\x02\x00\x83\x00\x00\x01\x58\x71\x07\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"xs", "x", "f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0d\x01\x03\x01\x07\x01\x07\x02",
	}, nil, ""},
	{"for x in xs:\n    try:\n        f()\n    finally:\n        continue\n    ", "exec", nil, py.SyntaxError, "'continue' not supported inside 'finally' clause"},
	{"for x in xs:\n    try:\n        f()\n    finally:\n        try:\n            continue\n        except:\n             pass\n    ", "exec", nil, py.SyntaxError, "'continue' not supported inside 'finally' clause"},
	{"try:\n    continue\nexcept:\n    pass\n    ", "exec", nil, py.SyntaxError, "'continue' not properly in loop"},
	{"try:\n    pass\nexcept:\n    continue\n    ", "exec", nil, py.SyntaxError, "'continue' not properly in loop"},
	{"while truth():\n    try:\n        f()\n    except:\n        continue\n    f()\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      9,
		Flags:          64,
		Code:           "\x78\x2d\x00\x65\x00\x00\x83\x00\x00\x72\x2f\x00\x79\x0b\x00\x65\x01\x00\x83\x00\x00\x01\x57\x6e\x0b\x00\x01\x01\x01\x77\x03\x00\x59\x6e\x01\x00\x58\x65\x01\x00\x83\x00\x00\x01\x71\x03\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"truth", "f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0c\x01\x03\x01\x0b\x01\x03\x01\x08\x01",
	}, nil, ""},
	{"while truth():\n    try:\n        f()\n        continue\n    finally:\n        f()\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      10,
		Flags:          64,
		Code:           "\x78\x26\x00\x65\x00\x00\x83\x00\x00\x72\x28\x00\x7a\x0e\x00\x65\x01\x00\x83\x00\x00\x01\x77\x03\x00\x57\x64\x00\x00\x65\x01\x00\x83\x00\x00\x01\x58\x71\x03\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"truth", "f"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x0c\x01\x03\x01\x07\x01\x07\x02",
	}, nil, ""},
	{"while truth():\n    try:\n        f()\n    finally:\n        continue\n    ", "exec", nil, py.SyntaxError, "'continue' not supported inside 'finally' clause"},
	{"while truth():\n    try:\n        f()\n    finally:\n        try:\n            continue\n        except:\n             pass\n    ", "exec", nil, py.SyntaxError, "'continue' not supported inside 'finally' clause"},
	{"while x:\n    with c:\n        continue\n    ", "exec", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      8,
		Flags:          64,
		Code:           "\x78\x1a\x00\x65\x00\x00\x72\x1c\x00\x65\x01\x00\x8f\x08\x00\x01\x77\x03\x00\x57\x64\x00\x00\x51\x58\x71\x03\x00\x57\x64\x00\x00\x53",
		Consts:         []py.Object{py.None},
		Names:          []string{"x", "c"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "\x09\x01\x07\x01",
	}, nil, ""},
	{"print(\"hello world!\")\n", "single", &py.Code{
		Argcount:       0,
		Kwonlyargcount: 0,
		Nlocals:        0,
		Stacksize:      2,
		Flags:          64,
		Code:           "\x65\x00\x00\x64\x00\x00\x83\x01\x00\x46\x64\x01\x00\x53",
		Consts:         []py.Object{py.String("hello world!"), py.None},
		Names:          []string{"print"},
		Varnames:       []string{},
		Freevars:       []string{},
		Cellvars:       []string{},
		Filename:       "<string>",
		Name:           "<module>",
		Firstlineno:    1,
		Lnotab:         "",
	}, nil, ""},
}
