// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/spanner/v1/spanner.proto

package spanner // import "google.golang.org/genproto/googleapis/spanner/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import _struct "github.com/golang/protobuf/ptypes/struct"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Mode in which the query must be processed.
type ExecuteSqlRequest_QueryMode int32

const (
	// The default mode where only the query result, without any information
	// about the query plan is returned.
	ExecuteSqlRequest_NORMAL ExecuteSqlRequest_QueryMode = 0
	// This mode returns only the query plan, without any result rows or
	// execution statistics information.
	ExecuteSqlRequest_PLAN ExecuteSqlRequest_QueryMode = 1
	// This mode returns both the query plan and the execution statistics along
	// with the result rows.
	ExecuteSqlRequest_PROFILE ExecuteSqlRequest_QueryMode = 2
)

var ExecuteSqlRequest_QueryMode_name = map[int32]string{
	0: "NORMAL",
	1: "PLAN",
	2: "PROFILE",
}
var ExecuteSqlRequest_QueryMode_value = map[string]int32{
	"NORMAL":  0,
	"PLAN":    1,
	"PROFILE": 2,
}

func (x ExecuteSqlRequest_QueryMode) String() string {
	return proto.EnumName(ExecuteSqlRequest_QueryMode_name, int32(x))
}
func (ExecuteSqlRequest_QueryMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{6, 0}
}

// The request for [CreateSession][google.spanner.v1.Spanner.CreateSession].
type CreateSessionRequest struct {
	// Required. The database in which the new session is created.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The session to create.
	Session              *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSessionRequest) Reset()         { *m = CreateSessionRequest{} }
func (m *CreateSessionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSessionRequest) ProtoMessage()    {}
func (*CreateSessionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{0}
}
func (m *CreateSessionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSessionRequest.Unmarshal(m, b)
}
func (m *CreateSessionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSessionRequest.Marshal(b, m, deterministic)
}
func (dst *CreateSessionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSessionRequest.Merge(dst, src)
}
func (m *CreateSessionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSessionRequest.Size(m)
}
func (m *CreateSessionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSessionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSessionRequest proto.InternalMessageInfo

func (m *CreateSessionRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *CreateSessionRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

// A session in the Cloud Spanner API.
type Session struct {
	// The name of the session. This is always system-assigned; values provided
	// when creating a session are ignored.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The labels for the session.
	//
	//  * Label keys must be between 1 and 63 characters long and must conform to
	//    the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//  * Label values must be between 0 and 63 characters long and must conform
	//    to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//  * No more than 64 labels can be associated with a given session.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The timestamp when the session is created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The approximate timestamp when the session is last used. It is
	// typically earlier than the actual last use time.
	ApproximateLastUseTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=approximate_last_use_time,json=approximateLastUseTime,proto3" json:"approximate_last_use_time,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}             `json:"-"`
	XXX_unrecognized       []byte               `json:"-"`
	XXX_sizecache          int32                `json:"-"`
}

func (m *Session) Reset()         { *m = Session{} }
func (m *Session) String() string { return proto.CompactTextString(m) }
func (*Session) ProtoMessage()    {}
func (*Session) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{1}
}
func (m *Session) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Session.Unmarshal(m, b)
}
func (m *Session) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Session.Marshal(b, m, deterministic)
}
func (dst *Session) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Session.Merge(dst, src)
}
func (m *Session) XXX_Size() int {
	return xxx_messageInfo_Session.Size(m)
}
func (m *Session) XXX_DiscardUnknown() {
	xxx_messageInfo_Session.DiscardUnknown(m)
}

var xxx_messageInfo_Session proto.InternalMessageInfo

func (m *Session) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Session) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Session) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Session) GetApproximateLastUseTime() *timestamp.Timestamp {
	if m != nil {
		return m.ApproximateLastUseTime
	}
	return nil
}

// The request for [GetSession][google.spanner.v1.Spanner.GetSession].
type GetSessionRequest struct {
	// Required. The name of the session to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSessionRequest) Reset()         { *m = GetSessionRequest{} }
func (m *GetSessionRequest) String() string { return proto.CompactTextString(m) }
func (*GetSessionRequest) ProtoMessage()    {}
func (*GetSessionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{2}
}
func (m *GetSessionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSessionRequest.Unmarshal(m, b)
}
func (m *GetSessionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSessionRequest.Marshal(b, m, deterministic)
}
func (dst *GetSessionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSessionRequest.Merge(dst, src)
}
func (m *GetSessionRequest) XXX_Size() int {
	return xxx_messageInfo_GetSessionRequest.Size(m)
}
func (m *GetSessionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSessionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSessionRequest proto.InternalMessageInfo

func (m *GetSessionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [ListSessions][google.spanner.v1.Spanner.ListSessions].
type ListSessionsRequest struct {
	// Required. The database in which to list sessions.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Number of sessions to be returned in the response. If 0 or less, defaults
	// to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.v1.ListSessionsResponse.next_page_token] from a previous
	// [ListSessionsResponse][google.spanner.v1.ListSessionsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression for filtering the results of the request. Filter rules are
	// case insensitive. The fields eligible for filtering are:
	//
	//   * `labels.key` where key is the name of a label
	//
	// Some examples of using filters are:
	//
	//   * `labels.env:*` --> The session has the label "env".
	//   * `labels.env:dev` --> The session has the label "env" and the value of
	//                        the label contains the string "dev".
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSessionsRequest) Reset()         { *m = ListSessionsRequest{} }
func (m *ListSessionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSessionsRequest) ProtoMessage()    {}
func (*ListSessionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{3}
}
func (m *ListSessionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSessionsRequest.Unmarshal(m, b)
}
func (m *ListSessionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSessionsRequest.Marshal(b, m, deterministic)
}
func (dst *ListSessionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSessionsRequest.Merge(dst, src)
}
func (m *ListSessionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSessionsRequest.Size(m)
}
func (m *ListSessionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSessionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSessionsRequest proto.InternalMessageInfo

func (m *ListSessionsRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *ListSessionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSessionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListSessionsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// The response for [ListSessions][google.spanner.v1.Spanner.ListSessions].
type ListSessionsResponse struct {
	// The list of requested sessions.
	Sessions []*Session `protobuf:"bytes,1,rep,name=sessions,proto3" json:"sessions,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListSessions][google.spanner.v1.Spanner.ListSessions] call to fetch more of the matching
	// sessions.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSessionsResponse) Reset()         { *m = ListSessionsResponse{} }
func (m *ListSessionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSessionsResponse) ProtoMessage()    {}
func (*ListSessionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{4}
}
func (m *ListSessionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSessionsResponse.Unmarshal(m, b)
}
func (m *ListSessionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSessionsResponse.Marshal(b, m, deterministic)
}
func (dst *ListSessionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSessionsResponse.Merge(dst, src)
}
func (m *ListSessionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSessionsResponse.Size(m)
}
func (m *ListSessionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSessionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSessionsResponse proto.InternalMessageInfo

func (m *ListSessionsResponse) GetSessions() []*Session {
	if m != nil {
		return m.Sessions
	}
	return nil
}

func (m *ListSessionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [DeleteSession][google.spanner.v1.Spanner.DeleteSession].
type DeleteSessionRequest struct {
	// Required. The name of the session to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSessionRequest) Reset()         { *m = DeleteSessionRequest{} }
func (m *DeleteSessionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSessionRequest) ProtoMessage()    {}
func (*DeleteSessionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{5}
}
func (m *DeleteSessionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSessionRequest.Unmarshal(m, b)
}
func (m *DeleteSessionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSessionRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteSessionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSessionRequest.Merge(dst, src)
}
func (m *DeleteSessionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSessionRequest.Size(m)
}
func (m *DeleteSessionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSessionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSessionRequest proto.InternalMessageInfo

func (m *DeleteSessionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
type ExecuteSqlRequest struct {
	// Required. The session in which the SQL query should be performed.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The transaction to use. If none is provided, the default is a
	// temporary read-only transaction with strong concurrency.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The SQL query string.
	Sql string `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	// The SQL query string can contain parameter placeholders. A parameter
	// placeholder consists of `'@'` followed by the parameter
	// name. Parameter names consist of any combination of letters,
	// numbers, and underscores.
	//
	// Parameters can appear anywhere that a literal value is expected.  The same
	// parameter name can be used more than once, for example:
	//   `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute an SQL query with unbound parameters.
	//
	// Parameter values are specified using `params`, which is a JSON
	// object whose keys are parameter names, and whose values are the
	// corresponding parameter values.
	Params *_struct.Struct `protobuf:"bytes,4,opt,name=params,proto3" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL query parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,5,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If this request is resuming a previously interrupted SQL query
	// execution, `resume_token` should be copied from the last
	// [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
	// enables the new SQL query execution to resume where the last one left
	// off. The rest of the request parameters must exactly match the
	// request that yielded this token.
	ResumeToken []byte `protobuf:"bytes,6,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// Used to control the amount of debugging information returned in
	// [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
	// be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
	QueryMode ExecuteSqlRequest_QueryMode `protobuf:"varint,7,opt,name=query_mode,json=queryMode,proto3,enum=google.spanner.v1.ExecuteSqlRequest_QueryMode" json:"query_mode,omitempty"`
	// If present, results will be restricted to the specified partition
	// previously created using PartitionQuery().  There must be an exact
	// match for the values of fields common to this message and the
	// PartitionQueryRequest message used to create this partition_token.
	PartitionToken       []byte   `protobuf:"bytes,8,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecuteSqlRequest) Reset()         { *m = ExecuteSqlRequest{} }
func (m *ExecuteSqlRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteSqlRequest) ProtoMessage()    {}
func (*ExecuteSqlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{6}
}
func (m *ExecuteSqlRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteSqlRequest.Unmarshal(m, b)
}
func (m *ExecuteSqlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteSqlRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteSqlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteSqlRequest.Merge(dst, src)
}
func (m *ExecuteSqlRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteSqlRequest.Size(m)
}
func (m *ExecuteSqlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteSqlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteSqlRequest proto.InternalMessageInfo

func (m *ExecuteSqlRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *ExecuteSqlRequest) GetTransaction() *TransactionSelector {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *ExecuteSqlRequest) GetSql() string {
	if m != nil {
		return m.Sql
	}
	return ""
}

func (m *ExecuteSqlRequest) GetParams() *_struct.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *ExecuteSqlRequest) GetParamTypes() map[string]*Type {
	if m != nil {
		return m.ParamTypes
	}
	return nil
}

func (m *ExecuteSqlRequest) GetResumeToken() []byte {
	if m != nil {
		return m.ResumeToken
	}
	return nil
}

func (m *ExecuteSqlRequest) GetQueryMode() ExecuteSqlRequest_QueryMode {
	if m != nil {
		return m.QueryMode
	}
	return ExecuteSqlRequest_NORMAL
}

func (m *ExecuteSqlRequest) GetPartitionToken() []byte {
	if m != nil {
		return m.PartitionToken
	}
	return nil
}

// Options for a PartitionQueryRequest and
// PartitionReadRequest.
type PartitionOptions struct {
	// **Note:** This hint is currently ignored by PartitionQuery and
	// PartitionRead requests.
	//
	// The desired data size for each partition generated.  The default for this
	// option is currently 1 GiB.  This is only a hint. The actual size of each
	// partition may be smaller or larger than this size request.
	PartitionSizeBytes int64 `protobuf:"varint,1,opt,name=partition_size_bytes,json=partitionSizeBytes,proto3" json:"partition_size_bytes,omitempty"`
	// **Note:** This hint is currently ignored by PartitionQuery and
	// PartitionRead requests.
	//
	// The desired maximum number of partitions to return.  For example, this may
	// be set to the number of workers available.  The default for this option
	// is currently 10,000. The maximum value is currently 200,000.  This is only
	// a hint.  The actual number of partitions returned may be smaller or larger
	// than this maximum count request.
	MaxPartitions        int64    `protobuf:"varint,2,opt,name=max_partitions,json=maxPartitions,proto3" json:"max_partitions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PartitionOptions) Reset()         { *m = PartitionOptions{} }
func (m *PartitionOptions) String() string { return proto.CompactTextString(m) }
func (*PartitionOptions) ProtoMessage()    {}
func (*PartitionOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{7}
}
func (m *PartitionOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PartitionOptions.Unmarshal(m, b)
}
func (m *PartitionOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PartitionOptions.Marshal(b, m, deterministic)
}
func (dst *PartitionOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionOptions.Merge(dst, src)
}
func (m *PartitionOptions) XXX_Size() int {
	return xxx_messageInfo_PartitionOptions.Size(m)
}
func (m *PartitionOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionOptions.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionOptions proto.InternalMessageInfo

func (m *PartitionOptions) GetPartitionSizeBytes() int64 {
	if m != nil {
		return m.PartitionSizeBytes
	}
	return 0
}

func (m *PartitionOptions) GetMaxPartitions() int64 {
	if m != nil {
		return m.MaxPartitions
	}
	return 0
}

// The request for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
type PartitionQueryRequest struct {
	// Required. The session used to create the partitions.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Read only snapshot transactions are supported, read/write and single use
	// transactions are not.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// The query request to generate partitions for. The request will fail if
	// the query is not root partitionable. The query plan of a root
	// partitionable query has a single distributed union operator. A distributed
	// union operator conceptually divides one or more tables into multiple
	// splits, remotely evaluates a subquery independently on each split, and
	// then unions all results.
	Sql string `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	// The SQL query string can contain parameter placeholders. A parameter
	// placeholder consists of `'@'` followed by the parameter
	// name. Parameter names consist of any combination of letters,
	// numbers, and underscores.
	//
	// Parameters can appear anywhere that a literal value is expected.  The same
	// parameter name can be used more than once, for example:
	//   `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute an SQL query with unbound parameters.
	//
	// Parameter values are specified using `params`, which is a JSON
	// object whose keys are parameter names, and whose values are the
	// corresponding parameter values.
	Params *_struct.Struct `protobuf:"bytes,4,opt,name=params,proto3" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL query parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,5,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional options that affect how many partitions are created.
	PartitionOptions     *PartitionOptions `protobuf:"bytes,6,opt,name=partition_options,json=partitionOptions,proto3" json:"partition_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PartitionQueryRequest) Reset()         { *m = PartitionQueryRequest{} }
func (m *PartitionQueryRequest) String() string { return proto.CompactTextString(m) }
func (*PartitionQueryRequest) ProtoMessage()    {}
func (*PartitionQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{8}
}
func (m *PartitionQueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PartitionQueryRequest.Unmarshal(m, b)
}
func (m *PartitionQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PartitionQueryRequest.Marshal(b, m, deterministic)
}
func (dst *PartitionQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionQueryRequest.Merge(dst, src)
}
func (m *PartitionQueryRequest) XXX_Size() int {
	return xxx_messageInfo_PartitionQueryRequest.Size(m)
}
func (m *PartitionQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionQueryRequest proto.InternalMessageInfo

func (m *PartitionQueryRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *PartitionQueryRequest) GetTransaction() *TransactionSelector {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *PartitionQueryRequest) GetSql() string {
	if m != nil {
		return m.Sql
	}
	return ""
}

func (m *PartitionQueryRequest) GetParams() *_struct.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *PartitionQueryRequest) GetParamTypes() map[string]*Type {
	if m != nil {
		return m.ParamTypes
	}
	return nil
}

func (m *PartitionQueryRequest) GetPartitionOptions() *PartitionOptions {
	if m != nil {
		return m.PartitionOptions
	}
	return nil
}

// The request for [PartitionRead][google.spanner.v1.Spanner.PartitionRead]
type PartitionReadRequest struct {
	// Required. The session used to create the partitions.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Read only snapshot transactions are supported, read/write and single use
	// transactions are not.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The name of the table in the database to be read.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// If non-empty, the name of an index on [table][google.spanner.v1.PartitionReadRequest.table]. This index is
	// used instead of the table primary key when interpreting [key_set][google.spanner.v1.PartitionReadRequest.key_set]
	// and sorting result rows. See [key_set][google.spanner.v1.PartitionReadRequest.key_set] for further information.
	Index string `protobuf:"bytes,4,opt,name=index,proto3" json:"index,omitempty"`
	// The columns of [table][google.spanner.v1.PartitionReadRequest.table] to be returned for each row matching
	// this request.
	Columns []string `protobuf:"bytes,5,rep,name=columns,proto3" json:"columns,omitempty"`
	// Required. `key_set` identifies the rows to be yielded. `key_set` names the
	// primary keys of the rows in [table][google.spanner.v1.PartitionReadRequest.table] to be yielded, unless [index][google.spanner.v1.PartitionReadRequest.index]
	// is present. If [index][google.spanner.v1.PartitionReadRequest.index] is present, then [key_set][google.spanner.v1.PartitionReadRequest.key_set] instead names
	// index keys in [index][google.spanner.v1.PartitionReadRequest.index].
	//
	// It is not an error for the `key_set` to name rows that do not
	// exist in the database. Read yields nothing for nonexistent rows.
	KeySet *KeySet `protobuf:"bytes,6,opt,name=key_set,json=keySet,proto3" json:"key_set,omitempty"`
	// Additional options that affect how many partitions are created.
	PartitionOptions     *PartitionOptions `protobuf:"bytes,9,opt,name=partition_options,json=partitionOptions,proto3" json:"partition_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PartitionReadRequest) Reset()         { *m = PartitionReadRequest{} }
func (m *PartitionReadRequest) String() string { return proto.CompactTextString(m) }
func (*PartitionReadRequest) ProtoMessage()    {}
func (*PartitionReadRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{9}
}
func (m *PartitionReadRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PartitionReadRequest.Unmarshal(m, b)
}
func (m *PartitionReadRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PartitionReadRequest.Marshal(b, m, deterministic)
}
func (dst *PartitionReadRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionReadRequest.Merge(dst, src)
}
func (m *PartitionReadRequest) XXX_Size() int {
	return xxx_messageInfo_PartitionReadRequest.Size(m)
}
func (m *PartitionReadRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionReadRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionReadRequest proto.InternalMessageInfo

func (m *PartitionReadRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *PartitionReadRequest) GetTransaction() *TransactionSelector {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *PartitionReadRequest) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *PartitionReadRequest) GetIndex() string {
	if m != nil {
		return m.Index
	}
	return ""
}

func (m *PartitionReadRequest) GetColumns() []string {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *PartitionReadRequest) GetKeySet() *KeySet {
	if m != nil {
		return m.KeySet
	}
	return nil
}

func (m *PartitionReadRequest) GetPartitionOptions() *PartitionOptions {
	if m != nil {
		return m.PartitionOptions
	}
	return nil
}

// Information returned for each partition returned in a
// PartitionResponse.
type Partition struct {
	// This token can be passed to Read, StreamingRead, ExecuteSql, or
	// ExecuteStreamingSql requests to restrict the results to those identified by
	// this partition token.
	PartitionToken       []byte   `protobuf:"bytes,1,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Partition) Reset()         { *m = Partition{} }
func (m *Partition) String() string { return proto.CompactTextString(m) }
func (*Partition) ProtoMessage()    {}
func (*Partition) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{10}
}
func (m *Partition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Partition.Unmarshal(m, b)
}
func (m *Partition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Partition.Marshal(b, m, deterministic)
}
func (dst *Partition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Partition.Merge(dst, src)
}
func (m *Partition) XXX_Size() int {
	return xxx_messageInfo_Partition.Size(m)
}
func (m *Partition) XXX_DiscardUnknown() {
	xxx_messageInfo_Partition.DiscardUnknown(m)
}

var xxx_messageInfo_Partition proto.InternalMessageInfo

func (m *Partition) GetPartitionToken() []byte {
	if m != nil {
		return m.PartitionToken
	}
	return nil
}

// The response for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
// or [PartitionRead][google.spanner.v1.Spanner.PartitionRead]
type PartitionResponse struct {
	// Partitions created by this request.
	Partitions []*Partition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// Transaction created by this request.
	Transaction          *Transaction `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PartitionResponse) Reset()         { *m = PartitionResponse{} }
func (m *PartitionResponse) String() string { return proto.CompactTextString(m) }
func (*PartitionResponse) ProtoMessage()    {}
func (*PartitionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{11}
}
func (m *PartitionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PartitionResponse.Unmarshal(m, b)
}
func (m *PartitionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PartitionResponse.Marshal(b, m, deterministic)
}
func (dst *PartitionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionResponse.Merge(dst, src)
}
func (m *PartitionResponse) XXX_Size() int {
	return xxx_messageInfo_PartitionResponse.Size(m)
}
func (m *PartitionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionResponse proto.InternalMessageInfo

func (m *PartitionResponse) GetPartitions() []*Partition {
	if m != nil {
		return m.Partitions
	}
	return nil
}

func (m *PartitionResponse) GetTransaction() *Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for [Read][google.spanner.v1.Spanner.Read] and
// [StreamingRead][google.spanner.v1.Spanner.StreamingRead].
type ReadRequest struct {
	// Required. The session in which the read should be performed.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The transaction to use. If none is provided, the default is a
	// temporary read-only transaction with strong concurrency.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The name of the table in the database to be read.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
	// used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
	// and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
	Index string `protobuf:"bytes,4,opt,name=index,proto3" json:"index,omitempty"`
	// The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
	// this request.
	Columns []string `protobuf:"bytes,5,rep,name=columns,proto3" json:"columns,omitempty"`
	// Required. `key_set` identifies the rows to be yielded. `key_set` names the
	// primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
	// is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
	// index keys in [index][google.spanner.v1.ReadRequest.index].
	//
	// If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
	// in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
	// (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
	// empty, rows will be yielded in an unspecified order.
	//
	// It is not an error for the `key_set` to name rows that do not
	// exist in the database. Read yields nothing for nonexistent rows.
	KeySet *KeySet `protobuf:"bytes,6,opt,name=key_set,json=keySet,proto3" json:"key_set,omitempty"`
	// If greater than zero, only the first `limit` rows are yielded. If `limit`
	// is zero, the default is no limit. A limit cannot be specified if
	// `partition_token` is set.
	Limit int64 `protobuf:"varint,8,opt,name=limit,proto3" json:"limit,omitempty"`
	// If this request is resuming a previously interrupted read,
	// `resume_token` should be copied from the last
	// [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
	// enables the new read to resume where the last read left off. The
	// rest of the request parameters must exactly match the request
	// that yielded this token.
	ResumeToken []byte `protobuf:"bytes,9,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// If present, results will be restricted to the specified partition
	// previously created using PartitionRead().    There must be an exact
	// match for the values of fields common to this message and the
	// PartitionReadRequest message used to create this partition_token.
	PartitionToken       []byte   `protobuf:"bytes,10,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadRequest) Reset()         { *m = ReadRequest{} }
func (m *ReadRequest) String() string { return proto.CompactTextString(m) }
func (*ReadRequest) ProtoMessage()    {}
func (*ReadRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{12}
}
func (m *ReadRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadRequest.Unmarshal(m, b)
}
func (m *ReadRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadRequest.Marshal(b, m, deterministic)
}
func (dst *ReadRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadRequest.Merge(dst, src)
}
func (m *ReadRequest) XXX_Size() int {
	return xxx_messageInfo_ReadRequest.Size(m)
}
func (m *ReadRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadRequest proto.InternalMessageInfo

func (m *ReadRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *ReadRequest) GetTransaction() *TransactionSelector {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *ReadRequest) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *ReadRequest) GetIndex() string {
	if m != nil {
		return m.Index
	}
	return ""
}

func (m *ReadRequest) GetColumns() []string {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *ReadRequest) GetKeySet() *KeySet {
	if m != nil {
		return m.KeySet
	}
	return nil
}

func (m *ReadRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ReadRequest) GetResumeToken() []byte {
	if m != nil {
		return m.ResumeToken
	}
	return nil
}

func (m *ReadRequest) GetPartitionToken() []byte {
	if m != nil {
		return m.PartitionToken
	}
	return nil
}

// The request for [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction].
type BeginTransactionRequest struct {
	// Required. The session in which the transaction runs.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. Options for the new transaction.
	Options              *TransactionOptions `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *BeginTransactionRequest) Reset()         { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()    {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{13}
}
func (m *BeginTransactionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginTransactionRequest.Unmarshal(m, b)
}
func (m *BeginTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginTransactionRequest.Marshal(b, m, deterministic)
}
func (dst *BeginTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionRequest.Merge(dst, src)
}
func (m *BeginTransactionRequest) XXX_Size() int {
	return xxx_messageInfo_BeginTransactionRequest.Size(m)
}
func (m *BeginTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionRequest proto.InternalMessageInfo

func (m *BeginTransactionRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *BeginTransactionRequest) GetOptions() *TransactionOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// The request for [Commit][google.spanner.v1.Spanner.Commit].
type CommitRequest struct {
	// Required. The session in which the transaction to be committed is running.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. The transaction in which to commit.
	//
	// Types that are valid to be assigned to Transaction:
	//	*CommitRequest_TransactionId
	//	*CommitRequest_SingleUseTransaction
	Transaction isCommitRequest_Transaction `protobuf_oneof:"transaction"`
	// The mutations to be executed when this transaction commits. All
	// mutations are applied atomically, in the order they appear in
	// this list.
	Mutations            []*Mutation `protobuf:"bytes,4,rep,name=mutations,proto3" json:"mutations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{14}
}
func (m *CommitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitRequest.Unmarshal(m, b)
}
func (m *CommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitRequest.Marshal(b, m, deterministic)
}
func (dst *CommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitRequest.Merge(dst, src)
}
func (m *CommitRequest) XXX_Size() int {
	return xxx_messageInfo_CommitRequest.Size(m)
}
func (m *CommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitRequest proto.InternalMessageInfo

type isCommitRequest_Transaction interface {
	isCommitRequest_Transaction()
}

type CommitRequest_TransactionId struct {
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof"`
}
type CommitRequest_SingleUseTransaction struct {
	SingleUseTransaction *TransactionOptions `protobuf:"bytes,3,opt,name=single_use_transaction,json=singleUseTransaction,proto3,oneof"`
}

func (*CommitRequest_TransactionId) isCommitRequest_Transaction()        {}
func (*CommitRequest_SingleUseTransaction) isCommitRequest_Transaction() {}

func (m *CommitRequest) GetTransaction() isCommitRequest_Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *CommitRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *CommitRequest) GetTransactionId() []byte {
	if x, ok := m.GetTransaction().(*CommitRequest_TransactionId); ok {
		return x.TransactionId
	}
	return nil
}

func (m *CommitRequest) GetSingleUseTransaction() *TransactionOptions {
	if x, ok := m.GetTransaction().(*CommitRequest_SingleUseTransaction); ok {
		return x.SingleUseTransaction
	}
	return nil
}

func (m *CommitRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommitRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommitRequest_OneofMarshaler, _CommitRequest_OneofUnmarshaler, _CommitRequest_OneofSizer, []interface{}{
		(*CommitRequest_TransactionId)(nil),
		(*CommitRequest_SingleUseTransaction)(nil),
	}
}

func _CommitRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommitRequest)
	// transaction
	switch x := m.Transaction.(type) {
	case *CommitRequest_TransactionId:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.TransactionId)
	case *CommitRequest_SingleUseTransaction:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SingleUseTransaction); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CommitRequest.Transaction has unexpected type %T", x)
	}
	return nil
}

func _CommitRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommitRequest)
	switch tag {
	case 2: // transaction.transaction_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Transaction = &CommitRequest_TransactionId{x}
		return true, err
	case 3: // transaction.single_use_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionOptions)
		err := b.DecodeMessage(msg)
		m.Transaction = &CommitRequest_SingleUseTransaction{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CommitRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommitRequest)
	// transaction
	switch x := m.Transaction.(type) {
	case *CommitRequest_TransactionId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.TransactionId)))
		n += len(x.TransactionId)
	case *CommitRequest_SingleUseTransaction:
		s := proto.Size(x.SingleUseTransaction)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Commit][google.spanner.v1.Spanner.Commit].
type CommitResponse struct {
	// The Cloud Spanner timestamp at which the transaction committed.
	CommitTimestamp      *timestamp.Timestamp `protobuf:"bytes,1,opt,name=commit_timestamp,json=commitTimestamp,proto3" json:"commit_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{15}
}
func (m *CommitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitResponse.Unmarshal(m, b)
}
func (m *CommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitResponse.Marshal(b, m, deterministic)
}
func (dst *CommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResponse.Merge(dst, src)
}
func (m *CommitResponse) XXX_Size() int {
	return xxx_messageInfo_CommitResponse.Size(m)
}
func (m *CommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResponse proto.InternalMessageInfo

func (m *CommitResponse) GetCommitTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.CommitTimestamp
	}
	return nil
}

// The request for [Rollback][google.spanner.v1.Spanner.Rollback].
type RollbackRequest struct {
	// Required. The session in which the transaction to roll back is running.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. The transaction to roll back.
	TransactionId        []byte   `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackRequest) Reset()         { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()    {}
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_spanner_2868e2a3b5f0aa05, []int{16}
}
func (m *RollbackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackRequest.Unmarshal(m, b)
}
func (m *RollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackRequest.Marshal(b, m, deterministic)
}
func (dst *RollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackRequest.Merge(dst, src)
}
func (m *RollbackRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackRequest.Size(m)
}
func (m *RollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackRequest proto.InternalMessageInfo

func (m *RollbackRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *RollbackRequest) GetTransactionId() []byte {
	if m != nil {
		return m.TransactionId
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateSessionRequest)(nil), "google.spanner.v1.CreateSessionRequest")
	proto.RegisterType((*Session)(nil), "google.spanner.v1.Session")
	proto.RegisterMapType((map[string]string)(nil), "google.spanner.v1.Session.LabelsEntry")
	proto.RegisterType((*GetSessionRequest)(nil), "google.spanner.v1.GetSessionRequest")
	proto.RegisterType((*ListSessionsRequest)(nil), "google.spanner.v1.ListSessionsRequest")
	proto.RegisterType((*ListSessionsResponse)(nil), "google.spanner.v1.ListSessionsResponse")
	proto.RegisterType((*DeleteSessionRequest)(nil), "google.spanner.v1.DeleteSessionRequest")
	proto.RegisterType((*ExecuteSqlRequest)(nil), "google.spanner.v1.ExecuteSqlRequest")
	proto.RegisterMapType((map[string]*Type)(nil), "google.spanner.v1.ExecuteSqlRequest.ParamTypesEntry")
	proto.RegisterType((*PartitionOptions)(nil), "google.spanner.v1.PartitionOptions")
	proto.RegisterType((*PartitionQueryRequest)(nil), "google.spanner.v1.PartitionQueryRequest")
	proto.RegisterMapType((map[string]*Type)(nil), "google.spanner.v1.PartitionQueryRequest.ParamTypesEntry")
	proto.RegisterType((*PartitionReadRequest)(nil), "google.spanner.v1.PartitionReadRequest")
	proto.RegisterType((*Partition)(nil), "google.spanner.v1.Partition")
	proto.RegisterType((*PartitionResponse)(nil), "google.spanner.v1.PartitionResponse")
	proto.RegisterType((*ReadRequest)(nil), "google.spanner.v1.ReadRequest")
	proto.RegisterType((*BeginTransactionRequest)(nil), "google.spanner.v1.BeginTransactionRequest")
	proto.RegisterType((*CommitRequest)(nil), "google.spanner.v1.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "google.spanner.v1.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "google.spanner.v1.RollbackRequest")
	proto.RegisterEnum("google.spanner.v1.ExecuteSqlRequest_QueryMode", ExecuteSqlRequest_QueryMode_name, ExecuteSqlRequest_QueryMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SpannerClient is the client API for Spanner service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpannerClient interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Cloud Spanner limits the number of sessions that can exist at any given
	// time; thus, it is a good idea to delete idle and/or unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner can delete sessions for which no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, e.g., `"SELECT 1"`.
	CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Gets a session. Returns `NOT_FOUND` if the session does not exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Lists all sessions in a given database.
	ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	// Ends a session, releasing server resources associated with it.
	DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Executes an SQL query, returning all rows in a single reply. This
	// method cannot be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Queries inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
	ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
	// set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
	// is no limit on the size of the returned result set. However, no
	// individual row in the result set can exceed 100 MiB, and no
	// column value can exceed 10 MiB.
	ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error)
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
	// return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
	// stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
	// size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error)
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
	// the transaction from the beginning, re-using the same session.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It is a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
	// ultimately decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction is not
	// found. `Rollback` never returns `ABORTED`.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a set of partition tokens that can be used to execute a query
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to specify a subset
	// of the query result to read.  The same session and read-only transaction
	// must be used by the PartitionQueryRequest used to create the
	// partition tokens and the ExecuteSqlRequests that use the partition tokens.
	// Partition tokens become invalid when the session used to create them
	// is deleted or begins a new transaction.
	PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionResponse, error)
	// Creates a set of partition tokens that can be used to execute a read
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a subset of the read
	// result to read.  The same session and read-only transaction must be used by
	// the PartitionReadRequest used to create the partition tokens and the
	// ReadRequests that use the partition tokens.
	// Partition tokens become invalid when the session used to create them
	// is deleted or begins a new transaction.
	PartitionRead(ctx context.Context, in *PartitionReadRequest, opts ...grpc.CallOption) (*PartitionResponse, error)
}

type spannerClient struct {
	cc *grpc.ClientConn
}

func NewSpannerClient(cc *grpc.ClientConn) SpannerClient {
	return &spannerClient{cc}
}

func (c *spannerClient) CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/CreateSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/GetSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/ListSessions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/DeleteSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/ExecuteSql", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Spanner_serviceDesc.Streams[0], "/google.spanner.v1.Spanner/ExecuteStreamingSql", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerExecuteStreamingSqlClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_ExecuteStreamingSqlClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerExecuteStreamingSqlClient struct {
	grpc.ClientStream
}

func (x *spannerExecuteStreamingSqlClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Read", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Spanner_serviceDesc.Streams[1], "/google.spanner.v1.Spanner/StreamingRead", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerStreamingReadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_StreamingReadClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerStreamingReadClient struct {
	grpc.ClientStream
}

func (x *spannerStreamingReadClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error) {
	out := new(Transaction)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/BeginTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Rollback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionResponse, error) {
	out := new(PartitionResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/PartitionQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) PartitionRead(ctx context.Context, in *PartitionReadRequest, opts ...grpc.CallOption) (*PartitionResponse, error) {
	out := new(PartitionResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/PartitionRead", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SpannerServer is the server API for Spanner service.
type SpannerServer interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Cloud Spanner limits the number of sessions that can exist at any given
	// time; thus, it is a good idea to delete idle and/or unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner can delete sessions for which no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, e.g., `"SELECT 1"`.
	CreateSession(context.Context, *CreateSessionRequest) (*Session, error)
	// Gets a session. Returns `NOT_FOUND` if the session does not exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(context.Context, *GetSessionRequest) (*Session, error)
	// Lists all sessions in a given database.
	ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	// Ends a session, releasing server resources associated with it.
	DeleteSession(context.Context, *DeleteSessionRequest) (*empty.Empty, error)
	// Executes an SQL query, returning all rows in a single reply. This
	// method cannot be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Queries inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
	ExecuteSql(context.Context, *ExecuteSqlRequest) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
	// set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
	// is no limit on the size of the returned result set. However, no
	// individual row in the result set can exceed 100 MiB, and no
	// column value can exceed 10 MiB.
	ExecuteStreamingSql(*ExecuteSqlRequest, Spanner_ExecuteStreamingSqlServer) error
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
	// return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(context.Context, *ReadRequest) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
	// stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
	// size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(*ReadRequest, Spanner_StreamingReadServer) error
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
	// the transaction from the beginning, re-using the same session.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It is a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
	// ultimately decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction is not
	// found. `Rollback` never returns `ABORTED`.
	Rollback(context.Context, *RollbackRequest) (*empty.Empty, error)
	// Creates a set of partition tokens that can be used to execute a query
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to specify a subset
	// of the query result to read.  The same session and read-only transaction
	// must be used by the PartitionQueryRequest used to create the
	// partition tokens and the ExecuteSqlRequests that use the partition tokens.
	// Partition tokens become invalid when the session used to create them
	// is deleted or begins a new transaction.
	PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionResponse, error)
	// Creates a set of partition tokens that can be used to execute a read
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a subset of the read
	// result to read.  The same session and read-only transaction must be used by
	// the PartitionReadRequest used to create the partition tokens and the
	// ReadRequests that use the partition tokens.
	// Partition tokens become invalid when the session used to create them
	// is deleted or begins a new transaction.
	PartitionRead(context.Context, *PartitionReadRequest) (*PartitionResponse, error)
}

func RegisterSpannerServer(s *grpc.Server, srv SpannerServer) {
	s.RegisterService(&_Spanner_serviceDesc, srv)
}

func _Spanner_CreateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).CreateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/CreateSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).CreateSession(ctx, req.(*CreateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_GetSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).GetSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/GetSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).GetSession(ctx, req.(*GetSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ListSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ListSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ListSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ListSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_DeleteSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).DeleteSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/DeleteSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).DeleteSession(ctx, req.(*DeleteSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteSql_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteSqlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ExecuteSql(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ExecuteSql",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ExecuteSql(ctx, req.(*ExecuteSqlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteStreamingSql_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteSqlRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).ExecuteStreamingSql(m, &spannerExecuteStreamingSqlServer{stream})
}

type Spanner_ExecuteStreamingSqlServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerExecuteStreamingSqlServer struct {
	grpc.ServerStream
}

func (x *spannerExecuteStreamingSqlServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Read",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Read(ctx, req.(*ReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_StreamingRead_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).StreamingRead(m, &spannerStreamingReadServer{stream})
}

type Spanner_StreamingReadServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerStreamingReadServer struct {
	grpc.ServerStream
}

func (x *spannerStreamingReadServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_PartitionQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).PartitionQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/PartitionQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).PartitionQuery(ctx, req.(*PartitionQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_PartitionRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).PartitionRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/PartitionRead",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).PartitionRead(ctx, req.(*PartitionReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Spanner_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.v1.Spanner",
	HandlerType: (*SpannerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSession",
			Handler:    _Spanner_CreateSession_Handler,
		},
		{
			MethodName: "GetSession",
			Handler:    _Spanner_GetSession_Handler,
		},
		{
			MethodName: "ListSessions",
			Handler:    _Spanner_ListSessions_Handler,
		},
		{
			MethodName: "DeleteSession",
			Handler:    _Spanner_DeleteSession_Handler,
		},
		{
			MethodName: "ExecuteSql",
			Handler:    _Spanner_ExecuteSql_Handler,
		},
		{
			MethodName: "Read",
			Handler:    _Spanner_Read_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Spanner_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Spanner_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Spanner_Rollback_Handler,
		},
		{
			MethodName: "PartitionQuery",
			Handler:    _Spanner_PartitionQuery_Handler,
		},
		{
			MethodName: "PartitionRead",
			Handler:    _Spanner_PartitionRead_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ExecuteStreamingSql",
			Handler:       _Spanner_ExecuteStreamingSql_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingRead",
			Handler:       _Spanner_StreamingRead_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/spanner/v1/spanner.proto",
}

func init() {
	proto.RegisterFile("google/spanner/v1/spanner.proto", fileDescriptor_spanner_2868e2a3b5f0aa05)
}

var fileDescriptor_spanner_2868e2a3b5f0aa05 = []byte{
	// 1657 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x58, 0xdd, 0x6f, 0x53, 0xc9,
	0x15, 0xe7, 0xda, 0x89, 0x13, 0x1f, 0xc7, 0x89, 0x33, 0x98, 0x60, 0x0c, 0x85, 0x70, 0xf9, 0x48,
	0x64, 0xa9, 0x36, 0x49, 0x51, 0x15, 0x02, 0x2d, 0x10, 0x08, 0x90, 0x92, 0x10, 0x73, 0x9d, 0x80,
	0x8a, 0xa8, 0xac, 0xb1, 0x3d, 0xb8, 0xb7, 0xb9, 0x5f, 0xb9, 0x33, 0x8e, 0x62, 0x2a, 0x5e, 0x5a,
	0xf5, 0xbd, 0x2d, 0xaa, 0xfa, 0xd0, 0xbe, 0xed, 0xdb, 0x8a, 0x47, 0x24, 0xde, 0xf6, 0x65, 0xa5,
	0x7d, 0x58, 0x69, 0x9f, 0xf6, 0x5f, 0xd8, 0xff, 0x62, 0x5f, 0x56, 0x33, 0xf7, 0xc3, 0xd7, 0xf6,
	0xc4, 0x31, 0x32, 0xbb, 0xd2, 0x6a, 0x9f, 0x3c, 0x33, 0xe7, 0xcc, 0x9c, 0xdf, 0xfd, 0x9d, 0x33,
	0x73, 0xce, 0x31, 0x5c, 0x68, 0xda, 0x76, 0xd3, 0x20, 0x25, 0xea, 0x60, 0xcb, 0x22, 0x6e, 0xe9,
	0x60, 0x29, 0x18, 0x16, 0x1d, 0xd7, 0x66, 0x36, 0x9a, 0xf5, 0x14, 0x8a, 0xc1, 0xea, 0xc1, 0x52,
	0xfe, 0x9c, 0xbf, 0x07, 0x3b, 0x7a, 0x09, 0x5b, 0x96, 0xcd, 0x30, 0xd3, 0x6d, 0x8b, 0x7a, 0x1b,
	0xf2, 0x67, 0x7d, 0xa9, 0x98, 0xd5, 0x5a, 0xaf, 0x4a, 0xc4, 0x74, 0x58, 0xdb, 0x17, 0x9e, 0xeb,
	0x15, 0x52, 0xe6, 0xb6, 0xea, 0xcc, 0x97, 0x5e, 0xe8, 0x95, 0x32, 0xdd, 0x24, 0x94, 0x61, 0xd3,
	0xe9, 0xd9, 0x1e, 0x41, 0xbb, 0x47, 0xda, 0x81, 0xe5, 0xf9, 0x7e, 0xa9, 0xd9, 0xf2, 0xc0, 0xf9,
	0x1a, 0x6a, 0xbf, 0x86, 0x4b, 0x68, 0xcb, 0x60, 0x55, 0x4a, 0x02, 0x10, 0x97, 0xfa, 0x75, 0x98,
	0x8b, 0x2d, 0x8a, 0xeb, 0x91, 0x83, 0x24, 0x40, 0x58, 0xdb, 0x21, 0x9e, 0x54, 0xfd, 0x33, 0x64,
	0xef, 0xb9, 0x04, 0x33, 0x52, 0x21, 0x94, 0xea, 0xb6, 0xa5, 0x91, 0xfd, 0x16, 0xa1, 0x0c, 0xe5,
	0x61, 0xb2, 0x81, 0x19, 0xae, 0x61, 0x4a, 0x72, 0xca, 0xbc, 0xb2, 0x98, 0xd4, 0xc2, 0x39, 0xba,
	0x0e, 0x13, 0xd4, 0xd3, 0xce, 0xc5, 0xe6, 0x95, 0xc5, 0xd4, 0x72, 0xbe, 0xd8, 0xc7, 0x7c, 0x31,
	0x38, 0x2f, 0x50, 0x55, 0xdf, 0xc5, 0x60, 0xc2, 0x5f, 0x44, 0x08, 0xc6, 0x2c, 0x6c, 0x06, 0x27,
	0x8b, 0x31, 0xfa, 0x3d, 0x24, 0x0c, 0x5c, 0x23, 0x06, 0xcd, 0xc5, 0xe6, 0xe3, 0x8b, 0xa9, 0xe5,
	0xab, 0x47, 0x1f, 0x5a, 0xdc, 0x14, 0x8a, 0xeb, 0x16, 0x73, 0xdb, 0x9a, 0xbf, 0x0b, 0xdd, 0x84,
	0x54, 0x5d, 0x7c, 0x49, 0x95, 0xbb, 0x22, 0x17, 0xef, 0x46, 0x16, 0xf8, 0xa9, 0xb8, 0x13, 0xf8,
	0x49, 0x03, 0x4f, 0x9d, 0x2f, 0xa0, 0x5d, 0x38, 0x83, 0x1d, 0xc7, 0xb5, 0x0f, 0x75, 0x93, 0x9f,
	0x60, 0x60, 0xca, 0xaa, 0x2d, 0xea, 0x1f, 0x35, 0x76, 0xec, 0x51, 0x73, 0x91, 0xcd, 0x9b, 0x98,
	0xb2, 0x5d, 0x2a, 0x8e, 0xcd, 0xdf, 0x80, 0x54, 0x04, 0x2a, 0xca, 0x40, 0x7c, 0x8f, 0xb4, 0xfd,
	0xaf, 0xe6, 0x43, 0x94, 0x85, 0xf1, 0x03, 0x6c, 0xb4, 0x88, 0x20, 0x32, 0xa9, 0x79, 0x93, 0xd5,
	0xd8, 0x8a, 0xa2, 0x2e, 0xc0, 0xec, 0x43, 0xc2, 0x7a, 0xbc, 0x22, 0xe1, 0x4d, 0xfd, 0x87, 0x02,
	0x27, 0x37, 0x75, 0x1a, 0xa8, 0xd2, 0x61, 0x3c, 0x78, 0x16, 0x92, 0x0e, 0x6e, 0x92, 0x2a, 0xd5,
	0x5f, 0x7b, 0xa6, 0xc7, 0xb5, 0x49, 0xbe, 0x50, 0xd1, 0x5f, 0x13, 0xf4, 0x2b, 0x00, 0x21, 0x64,
	0xf6, 0x1e, 0xb1, 0x04, 0x8f, 0x49, 0x4d, 0xa8, 0xef, 0xf0, 0x05, 0x34, 0x07, 0x89, 0x57, 0xba,
	0xc1, 0x88, 0x2b, 0x78, 0x49, 0x6a, 0xfe, 0x4c, 0x3d, 0x80, 0x6c, 0x37, 0x0c, 0xea, 0xd8, 0x16,
	0x25, 0xe8, 0xb7, 0x30, 0xe9, 0x87, 0x00, 0xcd, 0x29, 0xc2, 0xb3, 0x83, 0xc2, 0x25, 0xd4, 0x45,
	0x57, 0x61, 0xc6, 0x22, 0x87, 0xac, 0x1a, 0xc1, 0xe2, 0x91, 0x94, 0xe6, 0xcb, 0xe5, 0x00, 0x8f,
	0x5a, 0x80, 0xec, 0x7d, 0x62, 0x90, 0xbe, 0x08, 0x96, 0x71, 0xf5, 0x7e, 0x0c, 0x66, 0xd7, 0x0f,
	0x49, 0xbd, 0xc5, 0x48, 0x65, 0xdf, 0x08, 0x34, 0x73, 0x9d, 0x78, 0xf6, 0x94, 0x83, 0x29, 0x7a,
	0x04, 0xa9, 0xc8, 0x85, 0xf2, 0xa3, 0x5d, 0x16, 0x98, 0x3b, 0x1d, 0xad, 0x0a, 0x31, 0x48, 0x9d,
	0xd9, 0xae, 0x16, 0xdd, 0xca, 0x5d, 0x4f, 0xf7, 0x0d, 0x9f, 0x4d, 0x3e, 0x44, 0x25, 0x48, 0x38,
	0xd8, 0xc5, 0x26, 0xf5, 0xe3, 0xeb, 0x74, 0x5f, 0x7c, 0x55, 0xc4, 0x83, 0xa3, 0xf9, 0x6a, 0x68,
	0x17, 0x52, 0x62, 0x54, 0xe5, 0xd7, 0x97, 0xe6, 0xc6, 0x05, 0x97, 0xd7, 0x25, 0x60, 0xfa, 0xbe,
	0xb0, 0x58, 0xe6, 0xfb, 0x76, 0xf8, 0x36, 0xef, 0xce, 0x80, 0x13, 0x2e, 0xa0, 0x8b, 0x30, 0xc5,
	0x1f, 0x16, 0x33, 0x20, 0x39, 0x31, 0xaf, 0x2c, 0x4e, 0x69, 0x29, 0x6f, 0xcd, 0x73, 0xf9, 0x16,
	0xc0, 0x7e, 0x8b, 0xb8, 0xed, 0xaa, 0x69, 0x37, 0x48, 0x6e, 0x62, 0x5e, 0x59, 0x9c, 0x5e, 0x2e,
	0x0e, 0x65, 0xf8, 0x29, 0xdf, 0xb6, 0x65, 0x37, 0x88, 0x96, 0xdc, 0x0f, 0x86, 0x68, 0x01, 0x66,
	0x1c, 0xec, 0x32, 0x9d, 0x13, 0xe3, 0x1b, 0x9d, 0x14, 0x46, 0xa7, 0xc3, 0x65, 0x61, 0x37, 0xff,
	0x0c, 0x66, 0x7a, 0x90, 0x4b, 0xae, 0xd0, 0xaf, 0xa3, 0x57, 0x28, 0x42, 0x63, 0xd4, 0x3b, 0x6d,
	0x87, 0x44, 0xef, 0x56, 0x11, 0x92, 0x21, 0x30, 0x04, 0x90, 0x78, 0xb2, 0xad, 0x6d, 0xdd, 0xdd,
	0xcc, 0x9c, 0x40, 0x93, 0x30, 0x56, 0xde, 0xbc, 0xfb, 0x24, 0xa3, 0xa0, 0x14, 0x4c, 0x94, 0xb5,
	0xed, 0x07, 0x1b, 0x9b, 0xeb, 0x99, 0x98, 0xba, 0x07, 0x99, 0x72, 0x80, 0x6c, 0xdb, 0x11, 0x19,
	0x04, 0x5d, 0x83, 0x6c, 0xe7, 0x23, 0xf8, 0x3d, 0xaa, 0xd6, 0xda, 0x8c, 0x50, 0x81, 0x2c, 0xae,
	0xa1, 0x50, 0xc6, 0xaf, 0xd4, 0x1a, 0x97, 0xa0, 0x2b, 0x30, 0x6d, 0xe2, 0xc3, 0x6a, 0x28, 0xa1,
	0x02, 0x71, 0x5c, 0x4b, 0x9b, 0xf8, 0x30, 0x3c, 0x9e, 0xaa, 0x5f, 0xc6, 0xe1, 0x54, 0x38, 0x15,
	0x30, 0x7f, 0x66, 0x71, 0xfa, 0x47, 0x59, 0x9c, 0xae, 0x48, 0xc0, 0x48, 0xbf, 0x72, 0x60, 0xac,
	0x96, 0x61, 0xb6, 0x43, 0xba, 0xed, 0x79, 0x42, 0x04, 0x6c, 0x6a, 0xf9, 0xd2, 0x20, 0x03, 0xbe,
	0xd3, 0xb4, 0x8c, 0xd3, 0xb3, 0xf2, 0xa3, 0x85, 0xd8, 0x57, 0x31, 0xc8, 0x86, 0xe6, 0x35, 0x82,
	0x1b, 0x3f, 0xa5, 0x13, 0xb3, 0x30, 0xce, 0x70, 0xcd, 0x20, 0xbe, 0x1b, 0xbd, 0x09, 0x5f, 0xd5,
	0xad, 0x06, 0x39, 0xf4, 0xdf, 0x6d, 0x6f, 0xc2, 0xf1, 0xd4, 0x6d, 0xa3, 0x65, 0x5a, 0x9e, 0xa7,
	0x92, 0x5a, 0x30, 0x45, 0xcb, 0x30, 0xb1, 0x47, 0xda, 0xbc, 0xdc, 0xf0, 0x29, 0x3e, 0x23, 0xc1,
	0xf2, 0x98, 0xb4, 0x2b, 0x84, 0x69, 0x89, 0x3d, 0xf1, 0x2b, 0x77, 0x50, 0x72, 0x04, 0x07, 0xa9,
	0xd7, 0x21, 0x19, 0x6a, 0xc9, 0x5e, 0x0e, 0x45, 0xf6, 0x72, 0xa8, 0x6f, 0x15, 0x98, 0x8d, 0xd0,
	0xef, 0xa7, 0xa2, 0x5b, 0x3c, 0xb3, 0x85, 0xb7, 0xcf, 0x4b, 0x46, 0xe7, 0x06, 0xc1, 0xd2, 0x22,
	0xfa, 0xe8, 0x8e, 0xcc, 0x3f, 0xe7, 0x07, 0xfb, 0xa7, 0xcb, 0x2f, 0xea, 0x37, 0x31, 0x48, 0xfd,
	0x72, 0x62, 0x21, 0x0b, 0xe3, 0x86, 0x6e, 0xea, 0x4c, 0x3c, 0xee, 0x71, 0xcd, 0x9b, 0xf4, 0xa5,
	0x9b, 0x64, 0x7f, 0xba, 0x91, 0x78, 0x19, 0xa4, 0x5e, 0x66, 0x70, 0x7a, 0x8d, 0x34, 0x75, 0x2b,
	0x4a, 0xf8, 0xb1, 0xd4, 0xde, 0x86, 0x89, 0x20, 0x30, 0x3d, 0x5a, 0xaf, 0x0c, 0xa6, 0x35, 0x08,
	0xcd, 0x60, 0x97, 0xfa, 0xbd, 0x02, 0xe9, 0x7b, 0xb6, 0x69, 0xea, 0xec, 0x78, 0x63, 0x0b, 0x30,
	0x1d, 0x71, 0x46, 0x55, 0x6f, 0x08, 0x9b, 0x53, 0x8f, 0x4e, 0x68, 0xe9, 0xc8, 0xfa, 0x46, 0x03,
	0xfd, 0x09, 0xe6, 0xa8, 0x6e, 0x35, 0x0d, 0xe2, 0x95, 0x9d, 0x11, 0xdf, 0xc7, 0x3f, 0x02, 0xe4,
	0xa3, 0x13, 0x5a, 0xd6, 0x3b, 0x86, 0x57, 0xa0, 0x91, 0x28, 0xb8, 0x01, 0xc9, 0xa0, 0xbf, 0xe0,
	0xef, 0x38, 0x0f, 0xfc, 0xb3, 0x92, 0x13, 0xb7, 0x7c, 0x1d, 0xad, 0xa3, 0xbd, 0x96, 0xee, 0x0a,
	0x45, 0xf5, 0x39, 0x4c, 0x07, 0x1f, 0xef, 0xdf, 0xaa, 0x75, 0xc8, 0xd4, 0xc5, 0x4a, 0x35, 0xec,
	0x81, 0x04, 0x0d, 0x83, 0x4b, 0xe6, 0x19, 0x6f, 0x4f, 0xb8, 0xa0, 0x6a, 0x30, 0xa3, 0xd9, 0x86,
	0x51, 0xc3, 0xf5, 0xbd, 0xe3, 0x79, 0xbd, 0x22, 0xe7, 0xb5, 0x87, 0xd5, 0xe5, 0xbf, 0xcf, 0xc2,
	0x44, 0xc5, 0xfb, 0x3c, 0xf4, 0x3f, 0xee, 0xb6, 0x68, 0xab, 0x83, 0x16, 0x24, 0x0c, 0xc8, 0x9a,
	0xa1, 0xfc, 0x80, 0x82, 0x55, 0x5d, 0xff, 0xdb, 0xb7, 0xdf, 0xbd, 0x8d, 0xdd, 0x56, 0x57, 0x79,
	0x63, 0xf5, 0xd7, 0xa0, 0xc2, 0xfe, 0x9d, 0xe3, 0xda, 0x7f, 0x21, 0x75, 0x46, 0x4b, 0x85, 0x92,
	0x6e, 0x51, 0x86, 0xad, 0x3a, 0xe1, 0xe3, 0x40, 0x4e, 0x4b, 0x85, 0x37, 0xa5, 0xa0, 0xd4, 0x5d,
	0x55, 0x0a, 0xe8, 0x9f, 0x0a, 0x40, 0xa7, 0xde, 0x47, 0x97, 0x25, 0x16, 0xfb, 0xda, 0x81, 0x81,
	0xb8, 0xee, 0x08, 0x5c, 0xab, 0x68, 0x45, 0xe0, 0xe2, 0xd5, 0xef, 0x10, 0x98, 0x42, 0x48, 0xa5,
	0xc2, 0x1b, 0xf4, 0x99, 0x02, 0x53, 0xd1, 0x8a, 0x1e, 0xc9, 0xde, 0x1f, 0x49, 0xe7, 0x91, 0x5f,
	0x38, 0x56, 0xcf, 0x8b, 0x1c, 0x75, 0x4d, 0x60, 0xbc, 0x85, 0x46, 0xe0, 0x0e, 0xfd, 0x5b, 0x81,
	0x74, 0x57, 0xfd, 0x2f, 0x75, 0xab, 0xac, 0x43, 0xc8, 0xcf, 0xf5, 0x85, 0xe7, 0x3a, 0xef, 0xff,
	0x03, 0xea, 0x0a, 0x23, 0x51, 0x07, 0x9d, 0x62, 0x58, 0xea, 0xcd, 0xbe, 0x5a, 0x39, 0x2f, 0xcb,
	0x44, 0x9a, 0x68, 0xf9, 0x2b, 0x84, 0xa9, 0x4f, 0x05, 0xa8, 0xc7, 0xea, 0x03, 0x01, 0xca, 0x37,
	0xf6, 0x91, 0xb8, 0x56, 0x49, 0x68, 0x94, 0xc7, 0xdc, 0x17, 0x0a, 0x9c, 0x0c, 0x60, 0x30, 0x97,
	0x60, 0x53, 0xb7, 0x9a, 0xc3, 0xc3, 0x3d, 0x32, 0x9f, 0x63, 0xa3, 0x83, 0xfa, 0x85, 0x40, 0xbd,
	0xa3, 0x6e, 0x7f, 0x0a, 0xd4, 0x11, 0x8c, 0xab, 0x4a, 0xe1, 0x9a, 0x82, 0xfe, 0xa5, 0xc0, 0x18,
	0xcf, 0xa7, 0xe8, 0xbc, 0x94, 0xba, 0x30, 0xd1, 0x1e, 0x43, 0xed, 0x63, 0x01, 0x72, 0x5d, 0xbd,
	0x33, 0x0a, 0x48, 0x97, 0xe0, 0x06, 0x27, 0xf5, 0x9d, 0x02, 0xe9, 0x10, 0xe9, 0x50, 0xe0, 0x86,
	0x22, 0x72, 0x47, 0x60, 0x7c, 0xa2, 0x6e, 0x8c, 0x82, 0x91, 0x46, 0x71, 0x79, 0x14, 0x7e, 0x50,
	0x20, 0xd3, 0x9b, 0x43, 0x51, 0x41, 0x82, 0xe8, 0x88, 0x44, 0x9b, 0x3f, 0xa6, 0x00, 0x52, 0x9f,
	0x0b, 0xe0, 0x4f, 0xd5, 0xcd, 0x51, 0x80, 0xd7, 0x7a, 0x8c, 0x73, 0xa2, 0xff, 0xaf, 0x40, 0xc2,
	0xcb, 0x44, 0x68, 0x5e, 0xf6, 0x90, 0x47, 0x33, 0x74, 0xfe, 0xe2, 0x00, 0x0d, 0xff, 0x31, 0xda,
	0x12, 0x40, 0x1f, 0xaa, 0x6b, 0xa3, 0x00, 0xf5, 0x92, 0x1a, 0x87, 0xf7, 0x5f, 0x05, 0x26, 0x83,
	0x7c, 0x86, 0x54, 0x59, 0x08, 0x74, 0x27, 0xbb, 0x23, 0x5f, 0xa3, 0x6d, 0x81, 0x6b, 0x43, 0xbd,
	0x3f, 0x52, 0x74, 0xfa, 0xc6, 0x38, 0xb2, 0x0f, 0x0a, 0x4c, 0x77, 0xb7, 0x5e, 0x68, 0x71, 0xd8,
	0xee, 0x2c, 0x7f, 0x79, 0x60, 0xb9, 0x1c, 0x70, 0xb9, 0x2b, 0x30, 0x6f, 0xab, 0x7f, 0x18, 0x05,
	0xb3, 0xd3, 0x05, 0x80, 0x23, 0x7f, 0xaf, 0x40, 0xba, 0xab, 0xa9, 0x92, 0xbe, 0xf5, 0xb2, 0xb6,
	0x6b, 0x48, 0xdc, 0x9f, 0xe4, 0x96, 0x39, 0x51, 0xfb, 0xab, 0x4a, 0x61, 0xed, 0x3f, 0x0a, 0x9c,
	0xaa, 0xdb, 0x66, 0x3f, 0x82, 0xb5, 0x29, 0xbf, 0x38, 0x29, 0x73, 0x97, 0x97, 0x95, 0x17, 0x2b,
	0xbe, 0x4a, 0xd3, 0x36, 0xb0, 0xd5, 0x2c, 0xda, 0x6e, 0xb3, 0xd4, 0x24, 0x96, 0x08, 0x88, 0x92,
	0x27, 0xc2, 0x8e, 0x4e, 0x23, 0x7f, 0xe5, 0xde, 0xf4, 0x87, 0x9f, 0xc7, 0x4e, 0x3f, 0xf4, 0xb6,
	0xde, 0x33, 0xec, 0x56, 0xa3, 0xe8, 0x9f, 0x5b, 0x7c, 0xb6, 0xf4, 0x75, 0x20, 0x79, 0x29, 0x24,
	0x2f, 0x7d, 0xc9, 0xcb, 0x67, 0x4b, 0xb5, 0x84, 0x38, 0xf8, 0x37, 0x3f, 0x04, 0x00, 0x00, 0xff,
	0xff, 0x92, 0x18, 0x4b, 0x1c, 0x59, 0x17, 0x00, 0x00,
}
