// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/kms/v1/service.proto

package kms // import "google.golang.org/genproto/googleapis/cloud/kms/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/struct"
import _ "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [KeyManagementService.ListKeyRings][google.cloud.kms.v1.KeyManagementService.ListKeyRings].
type ListKeyRingsRequest struct {
	// Required. The resource name of the location associated with the
	// [KeyRings][google.cloud.kms.v1.KeyRing], in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [KeyRings][google.cloud.kms.v1.KeyRing] to include in the
	// response.  Further [KeyRings][google.cloud.kms.v1.KeyRing] can subsequently be obtained by
	// including the [ListKeyRingsResponse.next_page_token][google.cloud.kms.v1.ListKeyRingsResponse.next_page_token] in a subsequent
	// request.  If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListKeyRingsResponse.next_page_token][google.cloud.kms.v1.ListKeyRingsResponse.next_page_token].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeyRingsRequest) Reset()         { *m = ListKeyRingsRequest{} }
func (m *ListKeyRingsRequest) String() string { return proto.CompactTextString(m) }
func (*ListKeyRingsRequest) ProtoMessage()    {}
func (*ListKeyRingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{0}
}
func (m *ListKeyRingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeyRingsRequest.Unmarshal(m, b)
}
func (m *ListKeyRingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeyRingsRequest.Marshal(b, m, deterministic)
}
func (dst *ListKeyRingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeyRingsRequest.Merge(dst, src)
}
func (m *ListKeyRingsRequest) XXX_Size() int {
	return xxx_messageInfo_ListKeyRingsRequest.Size(m)
}
func (m *ListKeyRingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeyRingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeyRingsRequest proto.InternalMessageInfo

func (m *ListKeyRingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListKeyRingsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListKeyRingsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Request message for [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
type ListCryptoKeysRequest struct {
	// Required. The resource name of the [KeyRing][google.cloud.kms.v1.KeyRing] to list, in the format
	// `projects/*/locations/*/keyRings/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [CryptoKeys][google.cloud.kms.v1.CryptoKey] to include in the
	// response.  Further [CryptoKeys][google.cloud.kms.v1.CryptoKey] can subsequently be obtained by
	// including the [ListCryptoKeysResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeysResponse.next_page_token] in a subsequent
	// request.  If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListCryptoKeysResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeysResponse.next_page_token].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeysRequest) Reset()         { *m = ListCryptoKeysRequest{} }
func (m *ListCryptoKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeysRequest) ProtoMessage()    {}
func (*ListCryptoKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{1}
}
func (m *ListCryptoKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeysRequest.Unmarshal(m, b)
}
func (m *ListCryptoKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeysRequest.Marshal(b, m, deterministic)
}
func (dst *ListCryptoKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeysRequest.Merge(dst, src)
}
func (m *ListCryptoKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeysRequest.Size(m)
}
func (m *ListCryptoKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeysRequest proto.InternalMessageInfo

func (m *ListCryptoKeysRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCryptoKeysRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCryptoKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Request message for [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions].
type ListCryptoKeyVersionsRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to list, in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] to
	// include in the response. Further [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] can
	// subsequently be obtained by including the
	// [ListCryptoKeyVersionsResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeyVersionsResponse.next_page_token] in a subsequent request.
	// If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListCryptoKeyVersionsResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeyVersionsResponse.next_page_token].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeyVersionsRequest) Reset()         { *m = ListCryptoKeyVersionsRequest{} }
func (m *ListCryptoKeyVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeyVersionsRequest) ProtoMessage()    {}
func (*ListCryptoKeyVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{2}
}
func (m *ListCryptoKeyVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Unmarshal(m, b)
}
func (m *ListCryptoKeyVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Marshal(b, m, deterministic)
}
func (dst *ListCryptoKeyVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeyVersionsRequest.Merge(dst, src)
}
func (m *ListCryptoKeyVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Size(m)
}
func (m *ListCryptoKeyVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeyVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeyVersionsRequest proto.InternalMessageInfo

func (m *ListCryptoKeyVersionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCryptoKeyVersionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCryptoKeyVersionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [KeyManagementService.ListKeyRings][google.cloud.kms.v1.KeyManagementService.ListKeyRings].
type ListKeyRingsResponse struct {
	// The list of [KeyRings][google.cloud.kms.v1.KeyRing].
	KeyRings []*KeyRing `protobuf:"bytes,1,rep,name=key_rings,json=keyRings,proto3" json:"key_rings,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListKeyRingsRequest.page_token][google.cloud.kms.v1.ListKeyRingsRequest.page_token] to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [KeyRings][google.cloud.kms.v1.KeyRing] that matched the query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeyRingsResponse) Reset()         { *m = ListKeyRingsResponse{} }
func (m *ListKeyRingsResponse) String() string { return proto.CompactTextString(m) }
func (*ListKeyRingsResponse) ProtoMessage()    {}
func (*ListKeyRingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{3}
}
func (m *ListKeyRingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeyRingsResponse.Unmarshal(m, b)
}
func (m *ListKeyRingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeyRingsResponse.Marshal(b, m, deterministic)
}
func (dst *ListKeyRingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeyRingsResponse.Merge(dst, src)
}
func (m *ListKeyRingsResponse) XXX_Size() int {
	return xxx_messageInfo_ListKeyRingsResponse.Size(m)
}
func (m *ListKeyRingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeyRingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeyRingsResponse proto.InternalMessageInfo

func (m *ListKeyRingsResponse) GetKeyRings() []*KeyRing {
	if m != nil {
		return m.KeyRings
	}
	return nil
}

func (m *ListKeyRingsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListKeyRingsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Response message for [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
type ListCryptoKeysResponse struct {
	// The list of [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	CryptoKeys []*CryptoKey `protobuf:"bytes,1,rep,name=crypto_keys,json=cryptoKeys,proto3" json:"crypto_keys,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListCryptoKeysRequest.page_token][google.cloud.kms.v1.ListCryptoKeysRequest.page_token] to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [CryptoKeys][google.cloud.kms.v1.CryptoKey] that matched the query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeysResponse) Reset()         { *m = ListCryptoKeysResponse{} }
func (m *ListCryptoKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeysResponse) ProtoMessage()    {}
func (*ListCryptoKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{4}
}
func (m *ListCryptoKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeysResponse.Unmarshal(m, b)
}
func (m *ListCryptoKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeysResponse.Marshal(b, m, deterministic)
}
func (dst *ListCryptoKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeysResponse.Merge(dst, src)
}
func (m *ListCryptoKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeysResponse.Size(m)
}
func (m *ListCryptoKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeysResponse proto.InternalMessageInfo

func (m *ListCryptoKeysResponse) GetCryptoKeys() []*CryptoKey {
	if m != nil {
		return m.CryptoKeys
	}
	return nil
}

func (m *ListCryptoKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListCryptoKeysResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Response message for [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions].
type ListCryptoKeyVersionsResponse struct {
	// The list of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	CryptoKeyVersions []*CryptoKeyVersion `protobuf:"bytes,1,rep,name=crypto_key_versions,json=cryptoKeyVersions,proto3" json:"crypto_key_versions,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListCryptoKeyVersionsRequest.page_token][google.cloud.kms.v1.ListCryptoKeyVersionsRequest.page_token] to retrieve the next page of
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] that matched the
	// query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeyVersionsResponse) Reset()         { *m = ListCryptoKeyVersionsResponse{} }
func (m *ListCryptoKeyVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeyVersionsResponse) ProtoMessage()    {}
func (*ListCryptoKeyVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{5}
}
func (m *ListCryptoKeyVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Unmarshal(m, b)
}
func (m *ListCryptoKeyVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Marshal(b, m, deterministic)
}
func (dst *ListCryptoKeyVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeyVersionsResponse.Merge(dst, src)
}
func (m *ListCryptoKeyVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Size(m)
}
func (m *ListCryptoKeyVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeyVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeyVersionsResponse proto.InternalMessageInfo

func (m *ListCryptoKeyVersionsResponse) GetCryptoKeyVersions() []*CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersions
	}
	return nil
}

func (m *ListCryptoKeyVersionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListCryptoKeyVersionsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for [KeyManagementService.GetKeyRing][google.cloud.kms.v1.KeyManagementService.GetKeyRing].
type GetKeyRingRequest struct {
	// The [name][google.cloud.kms.v1.KeyRing.name] of the [KeyRing][google.cloud.kms.v1.KeyRing] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetKeyRingRequest) Reset()         { *m = GetKeyRingRequest{} }
func (m *GetKeyRingRequest) String() string { return proto.CompactTextString(m) }
func (*GetKeyRingRequest) ProtoMessage()    {}
func (*GetKeyRingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{6}
}
func (m *GetKeyRingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKeyRingRequest.Unmarshal(m, b)
}
func (m *GetKeyRingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKeyRingRequest.Marshal(b, m, deterministic)
}
func (dst *GetKeyRingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKeyRingRequest.Merge(dst, src)
}
func (m *GetKeyRingRequest) XXX_Size() int {
	return xxx_messageInfo_GetKeyRingRequest.Size(m)
}
func (m *GetKeyRingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKeyRingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKeyRingRequest proto.InternalMessageInfo

func (m *GetKeyRingRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetCryptoKey][google.cloud.kms.v1.KeyManagementService.GetCryptoKey].
type GetCryptoKeyRequest struct {
	// The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCryptoKeyRequest) Reset()         { *m = GetCryptoKeyRequest{} }
func (m *GetCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetCryptoKeyRequest) ProtoMessage()    {}
func (*GetCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{7}
}
func (m *GetCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCryptoKeyRequest.Unmarshal(m, b)
}
func (m *GetCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (dst *GetCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCryptoKeyRequest.Merge(dst, src)
}
func (m *GetCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetCryptoKeyRequest.Size(m)
}
func (m *GetCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCryptoKeyRequest proto.InternalMessageInfo

func (m *GetCryptoKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.GetCryptoKeyVersion].
type GetCryptoKeyVersionRequest struct {
	// The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCryptoKeyVersionRequest) Reset()         { *m = GetCryptoKeyVersionRequest{} }
func (m *GetCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*GetCryptoKeyVersionRequest) ProtoMessage()    {}
func (*GetCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{8}
}
func (m *GetCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *GetCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (dst *GetCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCryptoKeyVersionRequest.Merge(dst, src)
}
func (m *GetCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Size(m)
}
func (m *GetCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *GetCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.CreateKeyRing][google.cloud.kms.v1.KeyManagementService.CreateKeyRing].
type CreateKeyRingRequest struct {
	// Required. The resource name of the location associated with the
	// [KeyRings][google.cloud.kms.v1.KeyRing], in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. It must be unique within a location and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`
	KeyRingId string `protobuf:"bytes,2,opt,name=key_ring_id,json=keyRingId,proto3" json:"key_ring_id,omitempty"`
	// A [KeyRing][google.cloud.kms.v1.KeyRing] with initial field values.
	KeyRing              *KeyRing `protobuf:"bytes,3,opt,name=key_ring,json=keyRing,proto3" json:"key_ring,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateKeyRingRequest) Reset()         { *m = CreateKeyRingRequest{} }
func (m *CreateKeyRingRequest) String() string { return proto.CompactTextString(m) }
func (*CreateKeyRingRequest) ProtoMessage()    {}
func (*CreateKeyRingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{9}
}
func (m *CreateKeyRingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKeyRingRequest.Unmarshal(m, b)
}
func (m *CreateKeyRingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKeyRingRequest.Marshal(b, m, deterministic)
}
func (dst *CreateKeyRingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKeyRingRequest.Merge(dst, src)
}
func (m *CreateKeyRingRequest) XXX_Size() int {
	return xxx_messageInfo_CreateKeyRingRequest.Size(m)
}
func (m *CreateKeyRingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKeyRingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKeyRingRequest proto.InternalMessageInfo

func (m *CreateKeyRingRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateKeyRingRequest) GetKeyRingId() string {
	if m != nil {
		return m.KeyRingId
	}
	return ""
}

func (m *CreateKeyRingRequest) GetKeyRing() *KeyRing {
	if m != nil {
		return m.KeyRing
	}
	return nil
}

// Request message for [KeyManagementService.CreateCryptoKey][google.cloud.kms.v1.KeyManagementService.CreateCryptoKey].
type CreateCryptoKeyRequest struct {
	// Required. The [name][google.cloud.kms.v1.KeyRing.name] of the KeyRing associated with the
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. It must be unique within a KeyRing and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`
	CryptoKeyId string `protobuf:"bytes,2,opt,name=crypto_key_id,json=cryptoKeyId,proto3" json:"crypto_key_id,omitempty"`
	// A [CryptoKey][google.cloud.kms.v1.CryptoKey] with initial field values.
	CryptoKey            *CryptoKey `protobuf:"bytes,3,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CreateCryptoKeyRequest) Reset()         { *m = CreateCryptoKeyRequest{} }
func (m *CreateCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateCryptoKeyRequest) ProtoMessage()    {}
func (*CreateCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{10}
}
func (m *CreateCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateCryptoKeyRequest.Unmarshal(m, b)
}
func (m *CreateCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (dst *CreateCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateCryptoKeyRequest.Merge(dst, src)
}
func (m *CreateCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateCryptoKeyRequest.Size(m)
}
func (m *CreateCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateCryptoKeyRequest proto.InternalMessageInfo

func (m *CreateCryptoKeyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateCryptoKeyRequest) GetCryptoKeyId() string {
	if m != nil {
		return m.CryptoKeyId
	}
	return ""
}

func (m *CreateCryptoKeyRequest) GetCryptoKey() *CryptoKey {
	if m != nil {
		return m.CryptoKey
	}
	return nil
}

// Request message for [KeyManagementService.CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion].
type CreateCryptoKeyVersionRequest struct {
	// Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with
	// the [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with initial field values.
	CryptoKeyVersion     *CryptoKeyVersion `protobuf:"bytes,2,opt,name=crypto_key_version,json=cryptoKeyVersion,proto3" json:"crypto_key_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateCryptoKeyVersionRequest) Reset()         { *m = CreateCryptoKeyVersionRequest{} }
func (m *CreateCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateCryptoKeyVersionRequest) ProtoMessage()    {}
func (*CreateCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{11}
}
func (m *CreateCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *CreateCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (dst *CreateCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateCryptoKeyVersionRequest.Merge(dst, src)
}
func (m *CreateCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Size(m)
}
func (m *CreateCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *CreateCryptoKeyVersionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateCryptoKeyVersionRequest) GetCryptoKeyVersion() *CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersion
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKey][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKey].
type UpdateCryptoKeyRequest struct {
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] with updated values.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCryptoKeyRequest) Reset()         { *m = UpdateCryptoKeyRequest{} }
func (m *UpdateCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{12}
}
func (m *UpdateCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyRequest.Merge(dst, src)
}
func (m *UpdateCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Size(m)
}
func (m *UpdateCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyRequest) GetCryptoKey() *CryptoKey {
	if m != nil {
		return m.CryptoKey
	}
	return nil
}

func (m *UpdateCryptoKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyVersion].
type UpdateCryptoKeyVersionRequest struct {
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with updated values.
	CryptoKeyVersion *CryptoKeyVersion `protobuf:"bytes,1,opt,name=crypto_key_version,json=cryptoKeyVersion,proto3" json:"crypto_key_version,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCryptoKeyVersionRequest) Reset()         { *m = UpdateCryptoKeyVersionRequest{} }
func (m *UpdateCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyVersionRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{13}
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyVersionRequest.Merge(dst, src)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Size(m)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyVersionRequest) GetCryptoKeyVersion() *CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersion
	}
	return nil
}

func (m *UpdateCryptoKeyVersionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
type EncryptRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] or [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// to use for encryption.
	//
	// If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server will use its
	// [primary version][google.cloud.kms.v1.CryptoKey.primary].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The data to encrypt. Must be no larger than 64KiB.
	Plaintext []byte `protobuf:"bytes,2,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	// Optional data that, if specified, must also be provided during decryption
	// through [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].  Must be no
	// larger than 64KiB.
	AdditionalAuthenticatedData []byte   `protobuf:"bytes,3,opt,name=additional_authenticated_data,json=additionalAuthenticatedData,proto3" json:"additional_authenticated_data,omitempty"`
	XXX_NoUnkeyedLiteral        struct{} `json:"-"`
	XXX_unrecognized            []byte   `json:"-"`
	XXX_sizecache               int32    `json:"-"`
}

func (m *EncryptRequest) Reset()         { *m = EncryptRequest{} }
func (m *EncryptRequest) String() string { return proto.CompactTextString(m) }
func (*EncryptRequest) ProtoMessage()    {}
func (*EncryptRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{14}
}
func (m *EncryptRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptRequest.Unmarshal(m, b)
}
func (m *EncryptRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptRequest.Marshal(b, m, deterministic)
}
func (dst *EncryptRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptRequest.Merge(dst, src)
}
func (m *EncryptRequest) XXX_Size() int {
	return xxx_messageInfo_EncryptRequest.Size(m)
}
func (m *EncryptRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptRequest proto.InternalMessageInfo

func (m *EncryptRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EncryptRequest) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

func (m *EncryptRequest) GetAdditionalAuthenticatedData() []byte {
	if m != nil {
		return m.AdditionalAuthenticatedData
	}
	return nil
}

// Request message for [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
type DecryptRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption.
	// The server will choose the appropriate version.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The encrypted data originally returned in
	// [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
	Ciphertext []byte `protobuf:"bytes,2,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	// Optional data that must match the data originally supplied in
	// [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
	AdditionalAuthenticatedData []byte   `protobuf:"bytes,3,opt,name=additional_authenticated_data,json=additionalAuthenticatedData,proto3" json:"additional_authenticated_data,omitempty"`
	XXX_NoUnkeyedLiteral        struct{} `json:"-"`
	XXX_unrecognized            []byte   `json:"-"`
	XXX_sizecache               int32    `json:"-"`
}

func (m *DecryptRequest) Reset()         { *m = DecryptRequest{} }
func (m *DecryptRequest) String() string { return proto.CompactTextString(m) }
func (*DecryptRequest) ProtoMessage()    {}
func (*DecryptRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{15}
}
func (m *DecryptRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DecryptRequest.Unmarshal(m, b)
}
func (m *DecryptRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DecryptRequest.Marshal(b, m, deterministic)
}
func (dst *DecryptRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DecryptRequest.Merge(dst, src)
}
func (m *DecryptRequest) XXX_Size() int {
	return xxx_messageInfo_DecryptRequest.Size(m)
}
func (m *DecryptRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DecryptRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DecryptRequest proto.InternalMessageInfo

func (m *DecryptRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DecryptRequest) GetCiphertext() []byte {
	if m != nil {
		return m.Ciphertext
	}
	return nil
}

func (m *DecryptRequest) GetAdditionalAuthenticatedData() []byte {
	if m != nil {
		return m.AdditionalAuthenticatedData
	}
	return nil
}

// Response message for [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
type DecryptResponse struct {
	// The decrypted data originally supplied in [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
	Plaintext            []byte   `protobuf:"bytes,1,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DecryptResponse) Reset()         { *m = DecryptResponse{} }
func (m *DecryptResponse) String() string { return proto.CompactTextString(m) }
func (*DecryptResponse) ProtoMessage()    {}
func (*DecryptResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{16}
}
func (m *DecryptResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DecryptResponse.Unmarshal(m, b)
}
func (m *DecryptResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DecryptResponse.Marshal(b, m, deterministic)
}
func (dst *DecryptResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DecryptResponse.Merge(dst, src)
}
func (m *DecryptResponse) XXX_Size() int {
	return xxx_messageInfo_DecryptResponse.Size(m)
}
func (m *DecryptResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DecryptResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DecryptResponse proto.InternalMessageInfo

func (m *DecryptResponse) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

// Response message for [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
type EncryptResponse struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in encryption.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The encrypted data.
	Ciphertext           []byte   `protobuf:"bytes,2,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptResponse) Reset()         { *m = EncryptResponse{} }
func (m *EncryptResponse) String() string { return proto.CompactTextString(m) }
func (*EncryptResponse) ProtoMessage()    {}
func (*EncryptResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{17}
}
func (m *EncryptResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptResponse.Unmarshal(m, b)
}
func (m *EncryptResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptResponse.Marshal(b, m, deterministic)
}
func (dst *EncryptResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptResponse.Merge(dst, src)
}
func (m *EncryptResponse) XXX_Size() int {
	return xxx_messageInfo_EncryptResponse.Size(m)
}
func (m *EncryptResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptResponse proto.InternalMessageInfo

func (m *EncryptResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EncryptResponse) GetCiphertext() []byte {
	if m != nil {
		return m.Ciphertext
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
type UpdateCryptoKeyPrimaryVersionRequest struct {
	// The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the child [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use as primary.
	CryptoKeyVersionId   string   `protobuf:"bytes,2,opt,name=crypto_key_version_id,json=cryptoKeyVersionId,proto3" json:"crypto_key_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateCryptoKeyPrimaryVersionRequest) Reset()         { *m = UpdateCryptoKeyPrimaryVersionRequest{} }
func (m *UpdateCryptoKeyPrimaryVersionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyPrimaryVersionRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyPrimaryVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{18}
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateCryptoKeyPrimaryVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Merge(dst, src)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Size(m)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyPrimaryVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateCryptoKeyPrimaryVersionRequest) GetCryptoKeyVersionId() string {
	if m != nil {
		return m.CryptoKeyVersionId
	}
	return ""
}

// Request message for [KeyManagementService.DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion].
type DestroyCryptoKeyVersionRequest struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to destroy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DestroyCryptoKeyVersionRequest) Reset()         { *m = DestroyCryptoKeyVersionRequest{} }
func (m *DestroyCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*DestroyCryptoKeyVersionRequest) ProtoMessage()    {}
func (*DestroyCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{19}
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (dst *DestroyCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestroyCryptoKeyVersionRequest.Merge(dst, src)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Size(m)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DestroyCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DestroyCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *DestroyCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion].
type RestoreCryptoKeyVersionRequest struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to restore.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreCryptoKeyVersionRequest) Reset()         { *m = RestoreCryptoKeyVersionRequest{} }
func (m *RestoreCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreCryptoKeyVersionRequest) ProtoMessage()    {}
func (*RestoreCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_d4f59c45586ec2a6, []int{20}
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (dst *RestoreCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreCryptoKeyVersionRequest.Merge(dst, src)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Size(m)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *RestoreCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*ListKeyRingsRequest)(nil), "google.cloud.kms.v1.ListKeyRingsRequest")
	proto.RegisterType((*ListCryptoKeysRequest)(nil), "google.cloud.kms.v1.ListCryptoKeysRequest")
	proto.RegisterType((*ListCryptoKeyVersionsRequest)(nil), "google.cloud.kms.v1.ListCryptoKeyVersionsRequest")
	proto.RegisterType((*ListKeyRingsResponse)(nil), "google.cloud.kms.v1.ListKeyRingsResponse")
	proto.RegisterType((*ListCryptoKeysResponse)(nil), "google.cloud.kms.v1.ListCryptoKeysResponse")
	proto.RegisterType((*ListCryptoKeyVersionsResponse)(nil), "google.cloud.kms.v1.ListCryptoKeyVersionsResponse")
	proto.RegisterType((*GetKeyRingRequest)(nil), "google.cloud.kms.v1.GetKeyRingRequest")
	proto.RegisterType((*GetCryptoKeyRequest)(nil), "google.cloud.kms.v1.GetCryptoKeyRequest")
	proto.RegisterType((*GetCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.GetCryptoKeyVersionRequest")
	proto.RegisterType((*CreateKeyRingRequest)(nil), "google.cloud.kms.v1.CreateKeyRingRequest")
	proto.RegisterType((*CreateCryptoKeyRequest)(nil), "google.cloud.kms.v1.CreateCryptoKeyRequest")
	proto.RegisterType((*CreateCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.CreateCryptoKeyVersionRequest")
	proto.RegisterType((*UpdateCryptoKeyRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyRequest")
	proto.RegisterType((*UpdateCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyVersionRequest")
	proto.RegisterType((*EncryptRequest)(nil), "google.cloud.kms.v1.EncryptRequest")
	proto.RegisterType((*DecryptRequest)(nil), "google.cloud.kms.v1.DecryptRequest")
	proto.RegisterType((*DecryptResponse)(nil), "google.cloud.kms.v1.DecryptResponse")
	proto.RegisterType((*EncryptResponse)(nil), "google.cloud.kms.v1.EncryptResponse")
	proto.RegisterType((*UpdateCryptoKeyPrimaryVersionRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyPrimaryVersionRequest")
	proto.RegisterType((*DestroyCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.DestroyCryptoKeyVersionRequest")
	proto.RegisterType((*RestoreCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.RestoreCryptoKeyVersionRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// KeyManagementServiceClient is the client API for KeyManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeyManagementServiceClient interface {
	// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
	ListKeyRings(ctx context.Context, in *ListKeyRingsRequest, opts ...grpc.CallOption) (*ListKeyRingsResponse, error)
	// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error)
	// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	ListCryptoKeyVersions(ctx context.Context, in *ListCryptoKeyVersionsRequest, opts ...grpc.CallOption) (*ListCryptoKeyVersionsResponse, error)
	// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
	GetKeyRing(ctx context.Context, in *GetKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error)
	// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as well as its
	// [primary][google.cloud.kms.v1.CryptoKey.primary] [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKey(ctx context.Context, in *GetCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Returns metadata for a given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKeyVersion(ctx context.Context, in *GetCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and Location.
	CreateKeyRing(ctx context.Context, in *CreateKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error)
	// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] is required.
	CreateCryptoKey(ctx context.Context, in *CreateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	//
	// The server will assign the next sequential id. If unset,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
	CreateCryptoKeyVersion(ctx context.Context, in *CreateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateCryptoKey(ctx context.Context, in *UpdateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s metadata.
	//
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] and
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] using this
	// method. See [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion] and [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] to
	// move between other states.
	UpdateCryptoKeyVersion(ctx context.Context, in *UpdateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Encrypts data, so that it can only be recovered by a call to [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
	Encrypt(ctx context.Context, in *EncryptRequest, opts ...grpc.CallOption) (*EncryptResponse, error)
	// Decrypts data that was protected by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
	Decrypt(ctx context.Context, in *DecryptRequest, opts ...grpc.CallOption) (*DecryptResponse, error)
	// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that will be used in [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]
	UpdateCryptoKeyPrimaryVersion(ctx context.Context, in *UpdateCryptoKeyPrimaryVersionRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for destruction.
	//
	// Upon calling this method, [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be set to a time 24
	// hours in the future, at which point the [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be changed to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED], and the key
	// material will be irrevocably destroyed.
	//
	// Before the [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is reached,
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] may be called to reverse the process.
	DestroyCryptoKeyVersion(ctx context.Context, in *DestroyCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED],
	// state.
	//
	// Upon restoration of the CryptoKeyVersion, [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be set to [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be cleared.
	RestoreCryptoKeyVersion(ctx context.Context, in *RestoreCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
}

type keyManagementServiceClient struct {
	cc *grpc.ClientConn
}

func NewKeyManagementServiceClient(cc *grpc.ClientConn) KeyManagementServiceClient {
	return &keyManagementServiceClient{cc}
}

func (c *keyManagementServiceClient) ListKeyRings(ctx context.Context, in *ListKeyRingsRequest, opts ...grpc.CallOption) (*ListKeyRingsResponse, error) {
	out := new(ListKeyRingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListKeyRings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error) {
	out := new(ListCryptoKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListCryptoKeyVersions(ctx context.Context, in *ListCryptoKeyVersionsRequest, opts ...grpc.CallOption) (*ListCryptoKeyVersionsResponse, error) {
	out := new(ListCryptoKeyVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeyVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetKeyRing(ctx context.Context, in *GetKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error) {
	out := new(KeyRing)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetKeyRing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetCryptoKey(ctx context.Context, in *GetCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetCryptoKeyVersion(ctx context.Context, in *GetCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateKeyRing(ctx context.Context, in *CreateKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error) {
	out := new(KeyRing)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateKeyRing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateCryptoKey(ctx context.Context, in *CreateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateCryptoKeyVersion(ctx context.Context, in *CreateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKey(ctx context.Context, in *UpdateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKeyVersion(ctx context.Context, in *UpdateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Encrypt(ctx context.Context, in *EncryptRequest, opts ...grpc.CallOption) (*EncryptResponse, error) {
	out := new(EncryptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/Encrypt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Decrypt(ctx context.Context, in *DecryptRequest, opts ...grpc.CallOption) (*DecryptResponse, error) {
	out := new(DecryptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/Decrypt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKeyPrimaryVersion(ctx context.Context, in *UpdateCryptoKeyPrimaryVersionRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyPrimaryVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) DestroyCryptoKeyVersion(ctx context.Context, in *DestroyCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/DestroyCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) RestoreCryptoKeyVersion(ctx context.Context, in *RestoreCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/RestoreCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyManagementServiceServer is the server API for KeyManagementService service.
type KeyManagementServiceServer interface {
	// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
	ListKeyRings(context.Context, *ListKeyRingsRequest) (*ListKeyRingsResponse, error)
	// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	ListCryptoKeys(context.Context, *ListCryptoKeysRequest) (*ListCryptoKeysResponse, error)
	// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	ListCryptoKeyVersions(context.Context, *ListCryptoKeyVersionsRequest) (*ListCryptoKeyVersionsResponse, error)
	// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
	GetKeyRing(context.Context, *GetKeyRingRequest) (*KeyRing, error)
	// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as well as its
	// [primary][google.cloud.kms.v1.CryptoKey.primary] [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKey(context.Context, *GetCryptoKeyRequest) (*CryptoKey, error)
	// Returns metadata for a given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKeyVersion(context.Context, *GetCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and Location.
	CreateKeyRing(context.Context, *CreateKeyRingRequest) (*KeyRing, error)
	// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] is required.
	CreateCryptoKey(context.Context, *CreateCryptoKeyRequest) (*CryptoKey, error)
	// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	//
	// The server will assign the next sequential id. If unset,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
	CreateCryptoKeyVersion(context.Context, *CreateCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateCryptoKey(context.Context, *UpdateCryptoKeyRequest) (*CryptoKey, error)
	// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s metadata.
	//
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] and
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] using this
	// method. See [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion] and [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] to
	// move between other states.
	UpdateCryptoKeyVersion(context.Context, *UpdateCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Encrypts data, so that it can only be recovered by a call to [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
	Encrypt(context.Context, *EncryptRequest) (*EncryptResponse, error)
	// Decrypts data that was protected by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
	Decrypt(context.Context, *DecryptRequest) (*DecryptResponse, error)
	// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that will be used in [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]
	UpdateCryptoKeyPrimaryVersion(context.Context, *UpdateCryptoKeyPrimaryVersionRequest) (*CryptoKey, error)
	// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for destruction.
	//
	// Upon calling this method, [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be set to a time 24
	// hours in the future, at which point the [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be changed to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED], and the key
	// material will be irrevocably destroyed.
	//
	// Before the [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is reached,
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] may be called to reverse the process.
	DestroyCryptoKeyVersion(context.Context, *DestroyCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED],
	// state.
	//
	// Upon restoration of the CryptoKeyVersion, [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be set to [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be cleared.
	RestoreCryptoKeyVersion(context.Context, *RestoreCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
}

func RegisterKeyManagementServiceServer(s *grpc.Server, srv KeyManagementServiceServer) {
	s.RegisterService(&_KeyManagementService_serviceDesc, srv)
}

func _KeyManagementService_ListKeyRings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeyRingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListKeyRings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListKeyRings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListKeyRings(ctx, req.(*ListKeyRingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListCryptoKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListCryptoKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListCryptoKeys(ctx, req.(*ListCryptoKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListCryptoKeyVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeyVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListCryptoKeyVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeyVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListCryptoKeyVersions(ctx, req.(*ListCryptoKeyVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetKeyRing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetKeyRing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetKeyRing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetKeyRing(ctx, req.(*GetKeyRingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetCryptoKey(ctx, req.(*GetCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetCryptoKeyVersion(ctx, req.(*GetCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateKeyRing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateKeyRing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateKeyRing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateKeyRing(ctx, req.(*CreateKeyRingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateCryptoKey(ctx, req.(*CreateCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateCryptoKeyVersion(ctx, req.(*CreateCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKey(ctx, req.(*UpdateCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyVersion(ctx, req.(*UpdateCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Encrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EncryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Encrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/Encrypt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Encrypt(ctx, req.(*EncryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Decrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Decrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/Decrypt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Decrypt(ctx, req.(*DecryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKeyPrimaryVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyPrimaryVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyPrimaryVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyPrimaryVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyPrimaryVersion(ctx, req.(*UpdateCryptoKeyPrimaryVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_DestroyCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).DestroyCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/DestroyCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).DestroyCryptoKeyVersion(ctx, req.(*DestroyCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_RestoreCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).RestoreCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/RestoreCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).RestoreCryptoKeyVersion(ctx, req.(*RestoreCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeyManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.KeyManagementService",
	HandlerType: (*KeyManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListKeyRings",
			Handler:    _KeyManagementService_ListKeyRings_Handler,
		},
		{
			MethodName: "ListCryptoKeys",
			Handler:    _KeyManagementService_ListCryptoKeys_Handler,
		},
		{
			MethodName: "ListCryptoKeyVersions",
			Handler:    _KeyManagementService_ListCryptoKeyVersions_Handler,
		},
		{
			MethodName: "GetKeyRing",
			Handler:    _KeyManagementService_GetKeyRing_Handler,
		},
		{
			MethodName: "GetCryptoKey",
			Handler:    _KeyManagementService_GetCryptoKey_Handler,
		},
		{
			MethodName: "GetCryptoKeyVersion",
			Handler:    _KeyManagementService_GetCryptoKeyVersion_Handler,
		},
		{
			MethodName: "CreateKeyRing",
			Handler:    _KeyManagementService_CreateKeyRing_Handler,
		},
		{
			MethodName: "CreateCryptoKey",
			Handler:    _KeyManagementService_CreateCryptoKey_Handler,
		},
		{
			MethodName: "CreateCryptoKeyVersion",
			Handler:    _KeyManagementService_CreateCryptoKeyVersion_Handler,
		},
		{
			MethodName: "UpdateCryptoKey",
			Handler:    _KeyManagementService_UpdateCryptoKey_Handler,
		},
		{
			MethodName: "UpdateCryptoKeyVersion",
			Handler:    _KeyManagementService_UpdateCryptoKeyVersion_Handler,
		},
		{
			MethodName: "Encrypt",
			Handler:    _KeyManagementService_Encrypt_Handler,
		},
		{
			MethodName: "Decrypt",
			Handler:    _KeyManagementService_Decrypt_Handler,
		},
		{
			MethodName: "UpdateCryptoKeyPrimaryVersion",
			Handler:    _KeyManagementService_UpdateCryptoKeyPrimaryVersion_Handler,
		},
		{
			MethodName: "DestroyCryptoKeyVersion",
			Handler:    _KeyManagementService_DestroyCryptoKeyVersion_Handler,
		},
		{
			MethodName: "RestoreCryptoKeyVersion",
			Handler:    _KeyManagementService_RestoreCryptoKeyVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/kms/v1/service.proto", fileDescriptor_service_d4f59c45586ec2a6)
}

var fileDescriptor_service_d4f59c45586ec2a6 = []byte{
	// 1362 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x98, 0xcd, 0x6f, 0xdc, 0xc4,
	0x1b, 0xc7, 0x35, 0xe9, 0xef, 0xd7, 0x66, 0x9f, 0xa4, 0x0d, 0x9d, 0xb4, 0x69, 0xb4, 0x4d, 0x56,
	0xc1, 0x2d, 0x25, 0xdd, 0x22, 0x9b, 0xdd, 0x56, 0x40, 0xb7, 0x2a, 0xa8, 0x69, 0xda, 0xa8, 0xda,
	0x06, 0x22, 0x87, 0x54, 0x50, 0x45, 0xda, 0x4e, 0xed, 0xe9, 0xd6, 0xec, 0xfa, 0x05, 0x7b, 0x36,
	0x74, 0x0b, 0xbd, 0x70, 0x80, 0x1e, 0x7a, 0x2b, 0x87, 0x22, 0x2e, 0x08, 0x6e, 0x08, 0x0e, 0xdc,
	0xb8, 0x70, 0xe3, 0xc4, 0x15, 0x55, 0x1c, 0x90, 0x38, 0xf1, 0x0f, 0x70, 0xe3, 0x88, 0x3c, 0x1e,
	0x7b, 0xd7, 0x5e, 0x7b, 0xdf, 0xba, 0x15, 0xb7, 0xec, 0xf8, 0x99, 0x99, 0xcf, 0x77, 0x9e, 0xc7,
	0xf3, 0x7c, 0x1d, 0x78, 0xb1, 0x6e, 0xdb, 0xf5, 0x26, 0x55, 0xb4, 0xa6, 0xdd, 0xd2, 0x95, 0x86,
	0xe9, 0x29, 0x7b, 0x25, 0xc5, 0xa3, 0xee, 0x9e, 0xa1, 0x51, 0xd9, 0x71, 0x6d, 0x66, 0xe3, 0xf9,
	0x20, 0x44, 0xe6, 0x21, 0x72, 0xc3, 0xf4, 0xe4, 0xbd, 0x52, 0x7e, 0x49, 0xcc, 0x23, 0x8e, 0xa1,
	0x10, 0xcb, 0xb2, 0x19, 0x61, 0x86, 0x6d, 0x79, 0xc1, 0x94, 0xfc, 0x89, 0xb4, 0x55, 0x5d, 0xea,
	0xd9, 0x2d, 0x57, 0xa3, 0x61, 0xd0, 0x8a, 0x08, 0xe2, 0xbf, 0x6e, 0xb7, 0xee, 0x28, 0x77, 0x0c,
	0xda, 0xd4, 0x6b, 0x26, 0xf1, 0x1a, 0x22, 0x62, 0x29, 0x19, 0xe1, 0x31, 0xb7, 0xa5, 0x31, 0xf1,
	0xb4, 0x90, 0x7c, 0xfa, 0x91, 0x4b, 0x1c, 0x87, 0xba, 0x62, 0x7d, 0xc9, 0x80, 0xf9, 0xeb, 0x86,
	0xc7, 0xaa, 0xb4, 0xad, 0x1a, 0x56, 0xdd, 0x53, 0xe9, 0x87, 0x2d, 0xea, 0x31, 0xbc, 0x00, 0xfb,
	0x1d, 0xe2, 0x52, 0x8b, 0x2d, 0xa2, 0x15, 0xb4, 0x9a, 0x53, 0xc5, 0x2f, 0x7c, 0x1c, 0x72, 0x0e,
	0xa9, 0xd3, 0x9a, 0x67, 0xdc, 0xa7, 0x8b, 0x53, 0x2b, 0x68, 0xf5, 0xff, 0xea, 0xb4, 0x3f, 0xb0,
	0x6d, 0xdc, 0xa7, 0x78, 0x19, 0x80, 0x3f, 0x64, 0x76, 0x83, 0x5a, 0x8b, 0xfb, 0xf8, 0x44, 0x1e,
	0xfe, 0xae, 0x3f, 0x20, 0x35, 0xe0, 0xa8, 0xbf, 0xd5, 0x65, 0xb7, 0xed, 0x30, 0xbb, 0x4a, 0xdb,
	0xcf, 0x75, 0x33, 0x17, 0x96, 0x62, 0x9b, 0xdd, 0xa0, 0xae, 0xe7, 0x9f, 0xfd, 0xf3, 0xdc, 0xf3,
	0x09, 0x82, 0x23, 0xf1, 0xc3, 0xf4, 0x1c, 0xdb, 0xf2, 0x28, 0x3e, 0x0f, 0xb9, 0x06, 0x6d, 0xd7,
	0x5c, 0x7f, 0x70, 0x11, 0xad, 0xec, 0x5b, 0x9d, 0x29, 0x2f, 0xc9, 0x29, 0x05, 0x23, 0x8b, 0x99,
	0xea, 0x74, 0x43, 0x2c, 0x81, 0x4f, 0xc1, 0x9c, 0x45, 0xef, 0xb1, 0x5a, 0xd7, 0xbe, 0x53, 0x7c,
	0xdf, 0x83, 0xfe, 0xf0, 0x56, 0xb8, 0xb7, 0x8f, 0xc6, 0x6c, 0x46, 0x9a, 0x01, 0xf8, 0x3e, 0x0e,
	0x9e, 0xe3, 0x23, 0x3e, 0xb9, 0xf4, 0x35, 0x82, 0x85, 0xe4, 0xe1, 0x0b, 0xb8, 0xb7, 0x60, 0x46,
	0xe3, 0xa3, 0xb5, 0x06, 0x6d, 0x87, 0x78, 0x85, 0x54, 0xbc, 0x68, 0xb6, 0x0a, 0x5a, 0xb4, 0xd0,
	0xa4, 0x10, 0x7f, 0x46, 0xb0, 0x9c, 0x91, 0x32, 0x41, 0xba, 0x03, 0xf3, 0x1d, 0xd2, 0xda, 0x9e,
	0x78, 0x2c, 0x88, 0x5f, 0xea, 0x4f, 0x2c, 0x16, 0x53, 0x0f, 0x6b, 0xc9, 0xe5, 0x27, 0xc5, 0xff,
	0x32, 0x1c, 0xde, 0xa0, 0x61, 0xee, 0xc3, 0x32, 0xc3, 0xf0, 0x3f, 0x8b, 0x98, 0x54, 0x14, 0x19,
	0xff, 0x5b, 0x3a, 0x0d, 0xf3, 0x1b, 0xb4, 0x23, 0xb3, 0x5f, 0xe8, 0xab, 0x90, 0xef, 0x0e, 0x0d,
	0x45, 0xf4, 0x99, 0xf1, 0x39, 0x82, 0x23, 0x97, 0x5d, 0x4a, 0x18, 0x4d, 0x90, 0x64, 0x15, 0x7c,
	0x01, 0x66, 0xc2, 0xda, 0xac, 0x19, 0xba, 0x50, 0x9e, 0x13, 0xf5, 0x77, 0x4d, 0xc7, 0xaf, 0xc3,
	0x74, 0xf8, 0x9c, 0x6b, 0x1e, 0x54, 0xba, 0x07, 0xc4, 0x54, 0xe9, 0x31, 0x82, 0x85, 0x80, 0xa4,
	0x47, 0x6a, 0x16, 0x8b, 0x04, 0x07, 0xbb, 0x12, 0x1c, 0xd1, 0xcc, 0x44, 0x39, 0xbb, 0xa6, 0xe3,
	0x8b, 0x00, 0x9d, 0x18, 0x41, 0x34, 0xa8, 0x5a, 0x73, 0xd1, 0x02, 0xd2, 0x23, 0x04, 0xcb, 0x09,
	0xaa, 0xc4, 0xa9, 0x66, 0xc1, 0x6d, 0x03, 0xee, 0xad, 0x3e, 0x4e, 0x38, 0x74, 0xf1, 0xbd, 0x90,
	0x2c, 0x3e, 0xe9, 0x0b, 0x04, 0x0b, 0x3b, 0x8e, 0x9e, 0x76, 0x48, 0x71, 0xa1, 0x68, 0x44, 0xa1,
	0xf8, 0x02, 0xcc, 0xb4, 0xf8, 0xc2, 0xbc, 0x57, 0x08, 0xce, 0x7c, 0x38, 0x3f, 0x6c, 0x07, 0xf2,
	0x55, 0xbf, 0x9d, 0x6c, 0x12, 0xaf, 0xa1, 0x42, 0x10, 0xee, 0xff, 0x2d, 0xfd, 0x88, 0x60, 0x39,
	0x81, 0x95, 0x38, 0xa5, 0xf4, 0xd3, 0x40, 0xcf, 0x74, 0x1a, 0xcf, 0xc6, 0xfc, 0x19, 0x82, 0x43,
	0x57, 0x2c, 0xbe, 0x66, 0x9f, 0x17, 0x04, 0x2f, 0x41, 0xce, 0x69, 0x12, 0xc3, 0x62, 0xf4, 0x1e,
	0xe3, 0x3b, 0xcc, 0xaa, 0x9d, 0x01, 0xbc, 0x06, 0xcb, 0x44, 0xd7, 0x0d, 0xbf, 0x4d, 0x93, 0x66,
	0x8d, 0xb4, 0xd8, 0x5d, 0x6a, 0x31, 0x43, 0x23, 0x8c, 0xea, 0x35, 0x9d, 0x30, 0xc2, 0x0b, 0x6e,
	0x56, 0x3d, 0xde, 0x09, 0xba, 0xd4, 0x1d, 0xb3, 0x4e, 0x18, 0x91, 0x1e, 0x22, 0x38, 0xb4, 0x4e,
	0x07, 0x82, 0x14, 0x00, 0x34, 0xc3, 0xb9, 0x4b, 0xdd, 0x2e, 0x92, 0xae, 0x91, 0x89, 0xa0, 0x28,
	0x30, 0x17, 0x91, 0x88, 0x4b, 0x34, 0xa6, 0x1f, 0x25, 0xf4, 0x4b, 0x57, 0x60, 0x2e, 0x3a, 0x43,
	0x31, 0x61, 0x0c, 0x76, 0xc9, 0x84, 0x93, 0x89, 0xf2, 0xd9, 0x72, 0x0d, 0x93, 0xb8, 0x43, 0xdc,
	0x60, 0xb8, 0x04, 0x47, 0x7b, 0x2b, 0xab, 0x73, 0x19, 0xe0, 0x64, 0xd5, 0x5c, 0xd3, 0xa5, 0x73,
	0x50, 0x58, 0xa7, 0x1e, 0x73, 0xed, 0xf6, 0x28, 0x57, 0xe5, 0x39, 0x28, 0xa8, 0xd4, 0x63, 0xb6,
	0x4b, 0x47, 0x98, 0x55, 0xfe, 0xe3, 0x18, 0x1c, 0xa9, 0xd2, 0xf6, 0x26, 0xb1, 0x48, 0x9d, 0x9a,
	0xd4, 0x62, 0xdb, 0x81, 0x0f, 0xc4, 0x5f, 0x22, 0x98, 0xed, 0xee, 0xfe, 0x78, 0x35, 0xf5, 0x35,
	0x48, 0x71, 0x5b, 0xf9, 0xd3, 0x43, 0x44, 0x06, 0xd9, 0x90, 0xce, 0x7d, 0xfa, 0xdb, 0x5f, 0x8f,
	0xa7, 0x64, 0xfc, 0x8a, 0x6f, 0x16, 0x3f, 0x0e, 0xae, 0xa6, 0x8b, 0x8e, 0x6b, 0x7f, 0x40, 0x35,
	0xe6, 0x29, 0x45, 0xa5, 0x69, 0x6b, 0x81, 0xc9, 0x54, 0x8a, 0x0f, 0x94, 0xc8, 0x45, 0x7c, 0x8f,
	0xe0, 0x50, 0xbc, 0xfd, 0xe3, 0x62, 0xe6, 0x9e, 0x3d, 0x06, 0x2d, 0x7f, 0x66, 0xa8, 0x58, 0x41,
	0x78, 0x89, 0x13, 0x5e, 0xc0, 0xe7, 0x07, 0x13, 0x46, 0x80, 0x3e, 0x6c, 0x97, 0xa3, 0x78, 0x8a,
	0x12, 0x56, 0x31, 0xea, 0xd5, 0xa5, 0xc1, 0x24, 0x09, 0xa7, 0x97, 0x2f, 0x8f, 0x32, 0x45, 0x68,
	0xd8, 0xe1, 0x1a, 0xde, 0xc1, 0x9b, 0x23, 0x69, 0xe8, 0x92, 0x10, 0x13, 0x14, 0xd1, 0x3f, 0x44,
	0x00, 0x1d, 0x8f, 0x80, 0x4f, 0xa5, 0x92, 0xf5, 0x98, 0x88, 0x7c, 0xdf, 0x86, 0x9b, 0xa8, 0x08,
	0xbf, 0x46, 0x87, 0x38, 0x6d, 0xfc, 0x15, 0x82, 0xd9, 0x6e, 0x6b, 0x91, 0x51, 0xad, 0x29, 0x46,
	0x25, 0x3f, 0xa0, 0x09, 0x25, 0x0a, 0x60, 0x38, 0xa0, 0xf8, 0xd1, 0xe1, 0x5f, 0x50, 0xdc, 0x23,
	0x85, 0x0d, 0x42, 0x19, 0x08, 0x19, 0x7f, 0x83, 0xf3, 0xc3, 0xb5, 0xa2, 0x44, 0xbe, 0xc7, 0x40,
	0xee, 0x4d, 0xb6, 0x2f, 0xe3, 0x09, 0x82, 0x83, 0x31, 0x33, 0x86, 0x4f, 0x67, 0xf0, 0xf4, 0x1a,
	0xb6, 0x01, 0x59, 0x7f, 0x93, 0x13, 0xbf, 0x21, 0x8d, 0x74, 0x0f, 0x54, 0x22, 0x2b, 0x87, 0x7f,
	0x40, 0x30, 0x97, 0xf0, 0x41, 0xf8, 0x4c, 0x1f, 0xb8, 0x91, 0xab, 0x60, 0x93, 0x03, 0x6e, 0x48,
	0xe3, 0x5f, 0x03, 0x95, 0x2e, 0xff, 0x83, 0xff, 0xec, 0x75, 0x93, 0x61, 0x51, 0x94, 0x87, 0xc1,
	0x1e, 0xaf, 0x2e, 0x0c, 0x2e, 0x42, 0x93, 0x26, 0x7b, 0x0f, 0x54, 0x52, 0xac, 0x13, 0xfe, 0x09,
	0xc1, 0x5c, 0xa2, 0x67, 0x66, 0x24, 0x24, 0xdd, 0x2f, 0x0e, 0x4c, 0xc8, 0x7b, 0x5c, 0x8b, 0x5a,
	0x5e, 0xe7, 0x5a, 0x3a, 0x04, 0xf2, 0x38, 0x6f, 0x68, 0x2c, 0x37, 0x7f, 0xf7, 0x9a, 0xd8, 0xfe,
	0xb9, 0xe9, 0x6b, 0x2d, 0x87, 0xcd, 0xcd, 0x27, 0x5c, 0xcf, 0x5e, 0xf9, 0x56, 0x42, 0x4f, 0x78,
	0xa2, 0xf2, 0xa4, 0x5e, 0xe3, 0xd4, 0x74, 0x7d, 0x8b, 0xe0, 0x80, 0x70, 0x4a, 0xf8, 0x44, 0x2a,
	0x70, 0xdc, 0x8b, 0xe6, 0x4f, 0xf6, 0x0f, 0x12, 0x8d, 0x27, 0x7c, 0x6b, 0xd6, 0xc6, 0xbd, 0x88,
	0x8a, 0x0f, 0x2a, 0x34, 0x58, 0xb3, 0x82, 0x8a, 0xf8, 0x1b, 0x04, 0x07, 0x84, 0x01, 0xcc, 0xa0,
	0x8c, 0x1b, 0xd5, 0x0c, 0xca, 0x84, 0x87, 0x94, 0xae, 0x73, 0xca, 0xab, 0xd2, 0xa5, 0xb1, 0x6f,
	0xf8, 0x8a, 0x4e, 0x23, 0xc8, 0xa7, 0xbd, 0x1f, 0x1b, 0x71, 0xb7, 0x88, 0xcf, 0x0f, 0x53, 0x45,
	0xa9, 0x0e, 0x73, 0xe0, 0x5b, 0xf1, 0x3e, 0x97, 0xb2, 0x2d, 0xbd, 0x3d, 0xbe, 0x94, 0xe0, 0x1b,
	0x24, 0xbe, 0xbd, 0xaf, 0xeb, 0x77, 0x04, 0xc7, 0x32, 0x6c, 0x29, 0x3e, 0x9b, 0x71, 0xce, 0xfd,
	0x4c, 0xec, 0xb0, 0x2f, 0xc6, 0x2d, 0x2e, 0xe9, 0xa6, 0xb4, 0x33, 0xd1, 0x66, 0x56, 0xd1, 0x03,
	0xb8, 0x50, 0x59, 0x86, 0x75, 0xce, 0x50, 0xd6, 0xdf, 0x68, 0xff, 0xc7, 0xca, 0xdc, 0x00, 0xae,
	0x82, 0x8a, 0x6b, 0x8f, 0x10, 0x1c, 0xd3, 0x6c, 0x33, 0x0d, 0x67, 0x6d, 0xba, 0x6a, 0x7a, 0x5b,
	0xfe, 0x37, 0xe8, 0x16, 0xba, 0xf9, 0x9a, 0x08, 0xa8, 0xdb, 0x4d, 0x62, 0xd5, 0x65, 0xdb, 0xad,
	0x2b, 0x75, 0x6a, 0xf1, 0x2f, 0x54, 0x25, 0x78, 0x44, 0x1c, 0xc3, 0x8b, 0xfd, 0x6b, 0xf7, 0x42,
	0xc3, 0xf4, 0xfe, 0x41, 0xe8, 0xbb, 0xa9, 0xf9, 0x8d, 0x60, 0xee, 0x65, 0xbe, 0x78, 0xd5, 0xf4,
	0xe4, 0x1b, 0xa5, 0x5f, 0xc3, 0xd1, 0x5d, 0x3e, 0xba, 0x5b, 0x35, 0xbd, 0xdd, 0x1b, 0xa5, 0xdb,
	0xfb, 0xf9, 0x8a, 0x67, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x63, 0xc5, 0xfd, 0xff, 0x81, 0x16,
	0x00, 0x00,
}
