// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/session.proto

package dialogflow // import "google.golang.org/genproto/googleapis/cloud/dialogflow/v2beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _struct "github.com/golang/protobuf/ptypes/struct"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"
import latlng "google.golang.org/genproto/googleapis/type/latlng"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Audio encoding of the audio content sent in the conversational query request.
// Refer to the [Cloud Speech API documentation](/speech/docs/basics) for more
// details.
type AudioEncoding int32

const (
	// Not specified.
	AudioEncoding_AUDIO_ENCODING_UNSPECIFIED AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	AudioEncoding_AUDIO_ENCODING_LINEAR_16 AudioEncoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is lossless (therefore
	// recognition is not compromised) and requires only about half the
	// bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	AudioEncoding_AUDIO_ENCODING_FLAC AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	AudioEncoding_AUDIO_ENCODING_MULAW AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
	AudioEncoding_AUDIO_ENCODING_AMR AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_AMR_WB AudioEncoding = 5
	// Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_OGG_OPUS AudioEncoding = 6
	// Although the use of lossy encodings is not recommended, if a very low
	// bitrate encoding is required, `OGG_OPUS` is highly preferred over
	// Speex encoding. The [Speex](https://speex.org/) encoding supported by
	// Dialogflow API has a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in
	// [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each block
	// starts with a byte containing the length of the block, in bytes, followed
	// by one or more frames of Speex data, padded to an integral number of
	// bytes (octets) as specified in RFC 5574. In other words, each RTP header
	// is replaced with a single byte containing the block length. Only Speex
	// wideband is supported. `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE AudioEncoding = 7
)

var AudioEncoding_name = map[int32]string{
	0: "AUDIO_ENCODING_UNSPECIFIED",
	1: "AUDIO_ENCODING_LINEAR_16",
	2: "AUDIO_ENCODING_FLAC",
	3: "AUDIO_ENCODING_MULAW",
	4: "AUDIO_ENCODING_AMR",
	5: "AUDIO_ENCODING_AMR_WB",
	6: "AUDIO_ENCODING_OGG_OPUS",
	7: "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE",
}
var AudioEncoding_value = map[string]int32{
	"AUDIO_ENCODING_UNSPECIFIED":            0,
	"AUDIO_ENCODING_LINEAR_16":              1,
	"AUDIO_ENCODING_FLAC":                   2,
	"AUDIO_ENCODING_MULAW":                  3,
	"AUDIO_ENCODING_AMR":                    4,
	"AUDIO_ENCODING_AMR_WB":                 5,
	"AUDIO_ENCODING_OGG_OPUS":               6,
	"AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE": 7,
}

func (x AudioEncoding) String() string {
	return proto.EnumName(AudioEncoding_name, int32(x))
}
func (AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{0}
}

// Type of the response message.
type StreamingRecognitionResult_MessageType int32

const (
	// Not specified. Should never be used.
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED StreamingRecognitionResult_MessageType = 0
	// Message contains a (possibly partial) transcript.
	StreamingRecognitionResult_TRANSCRIPT StreamingRecognitionResult_MessageType = 1
	// Event indicates that the server has detected the end of the user's speech
	// utterance and expects no additional speech. Therefore, the server will
	// not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This message is only sent if
	// `single_utterance` was set to `true`, and is not used otherwise.
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE StreamingRecognitionResult_MessageType = 2
)

var StreamingRecognitionResult_MessageType_name = map[int32]string{
	0: "MESSAGE_TYPE_UNSPECIFIED",
	1: "TRANSCRIPT",
	2: "END_OF_SINGLE_UTTERANCE",
}
var StreamingRecognitionResult_MessageType_value = map[string]int32{
	"MESSAGE_TYPE_UNSPECIFIED": 0,
	"TRANSCRIPT":               1,
	"END_OF_SINGLE_UTTERANCE":  2,
}

func (x StreamingRecognitionResult_MessageType) String() string {
	return proto.EnumName(StreamingRecognitionResult_MessageType_name, int32(x))
}
func (StreamingRecognitionResult_MessageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{7, 0}
}

// The request to detect user's intent.
type DetectIntentRequest struct {
	// Required. The name of the session this query is sent to. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>`, or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`. Note: Environments and users are under
	// construction and will be available soon. If <Environment ID> is not
	// specified, we assume default 'draft' environment. If <User ID> is not
	// specified, we are using "-". It’s up to the API caller to choose an
	// appropriate <Session ID>. and <User Id>. They can be a random numbers or
	// some type of user and session identifiers (preferably hashed). The length
	// of the <Session ID> and <User ID> must not exceed 36 characters.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config
	//     which instructs the speech recognizer how to process the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Optional. The natural language speech audio to be processed. This field
	// should be populated iff `query_input` is set to an input audio config.
	// A single request can contain up to 1 minute of speech audio data.
	InputAudio           []byte   `protobuf:"bytes,5,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectIntentRequest) Reset()         { *m = DetectIntentRequest{} }
func (m *DetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*DetectIntentRequest) ProtoMessage()    {}
func (*DetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{0}
}
func (m *DetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentRequest.Unmarshal(m, b)
}
func (m *DetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentRequest.Marshal(b, m, deterministic)
}
func (dst *DetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentRequest.Merge(dst, src)
}
func (m *DetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_DetectIntentRequest.Size(m)
}
func (m *DetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentRequest proto.InternalMessageInfo

func (m *DetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *DetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *DetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *DetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The message returned from the DetectIntent method.
type DetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The results of the conversational query or event processing.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// Specifies the status of the webhook request. `webhook_status`
	// is never populated in webhook requests.
	WebhookStatus        *status.Status `protobuf:"bytes,3,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DetectIntentResponse) Reset()         { *m = DetectIntentResponse{} }
func (m *DetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*DetectIntentResponse) ProtoMessage()    {}
func (*DetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{1}
}
func (m *DetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentResponse.Unmarshal(m, b)
}
func (m *DetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentResponse.Marshal(b, m, deterministic)
}
func (dst *DetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentResponse.Merge(dst, src)
}
func (m *DetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_DetectIntentResponse.Size(m)
}
func (m *DetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentResponse proto.InternalMessageInfo

func (m *DetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *DetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *DetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

// Represents the parameters of the conversational query.
type QueryParameters struct {
	// Optional. The time zone of this conversational query from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris. If not provided, the time zone specified in
	// agent settings is used.
	TimeZone string `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The geo location of this conversational query.
	GeoLocation *latlng.LatLng `protobuf:"bytes,2,opt,name=geo_location,json=geoLocation,proto3" json:"geo_location,omitempty"`
	// Optional. The collection of contexts to be activated before this query is
	// executed.
	Contexts []*Context `protobuf:"bytes,3,rep,name=contexts,proto3" json:"contexts,omitempty"`
	// Optional. Specifies whether to delete all contexts in the current session
	// before the new ones are activated.
	ResetContexts bool `protobuf:"varint,4,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Optional. The collection of session entity types to replace or extend
	// developer entities with for this query only. The entity synonyms apply
	// to all languages.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,5,rep,name=session_entity_types,json=sessionEntityTypes,proto3" json:"session_entity_types,omitempty"`
	// Optional. This field can be used to pass custom data into the webhook
	// associated with the agent. Arbitrary JSON objects are supported.
	Payload              *_struct.Struct `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *QueryParameters) Reset()         { *m = QueryParameters{} }
func (m *QueryParameters) String() string { return proto.CompactTextString(m) }
func (*QueryParameters) ProtoMessage()    {}
func (*QueryParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{2}
}
func (m *QueryParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryParameters.Unmarshal(m, b)
}
func (m *QueryParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryParameters.Marshal(b, m, deterministic)
}
func (dst *QueryParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryParameters.Merge(dst, src)
}
func (m *QueryParameters) XXX_Size() int {
	return xxx_messageInfo_QueryParameters.Size(m)
}
func (m *QueryParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryParameters.DiscardUnknown(m)
}

var xxx_messageInfo_QueryParameters proto.InternalMessageInfo

func (m *QueryParameters) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

func (m *QueryParameters) GetGeoLocation() *latlng.LatLng {
	if m != nil {
		return m.GeoLocation
	}
	return nil
}

func (m *QueryParameters) GetContexts() []*Context {
	if m != nil {
		return m.Contexts
	}
	return nil
}

func (m *QueryParameters) GetResetContexts() bool {
	if m != nil {
		return m.ResetContexts
	}
	return false
}

func (m *QueryParameters) GetSessionEntityTypes() []*SessionEntityType {
	if m != nil {
		return m.SessionEntityTypes
	}
	return nil
}

func (m *QueryParameters) GetPayload() *_struct.Struct {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Represents the query input. It can contain either:
//
// 1.  An audio config which
//     instructs the speech recognizer how to process the speech audio.
//
// 2.  A conversational query in the form of text,.
//
// 3.  An event that specifies which intent to trigger.
type QueryInput struct {
	// Required. The input specification.
	//
	// Types that are valid to be assigned to Input:
	//	*QueryInput_AudioConfig
	//	*QueryInput_Text
	//	*QueryInput_Event
	Input                isQueryInput_Input `protobuf_oneof:"input"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *QueryInput) Reset()         { *m = QueryInput{} }
func (m *QueryInput) String() string { return proto.CompactTextString(m) }
func (*QueryInput) ProtoMessage()    {}
func (*QueryInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{3}
}
func (m *QueryInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryInput.Unmarshal(m, b)
}
func (m *QueryInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryInput.Marshal(b, m, deterministic)
}
func (dst *QueryInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryInput.Merge(dst, src)
}
func (m *QueryInput) XXX_Size() int {
	return xxx_messageInfo_QueryInput.Size(m)
}
func (m *QueryInput) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryInput.DiscardUnknown(m)
}

var xxx_messageInfo_QueryInput proto.InternalMessageInfo

type isQueryInput_Input interface {
	isQueryInput_Input()
}

type QueryInput_AudioConfig struct {
	AudioConfig *InputAudioConfig `protobuf:"bytes,1,opt,name=audio_config,json=audioConfig,proto3,oneof"`
}
type QueryInput_Text struct {
	Text *TextInput `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}
type QueryInput_Event struct {
	Event *EventInput `protobuf:"bytes,3,opt,name=event,proto3,oneof"`
}

func (*QueryInput_AudioConfig) isQueryInput_Input() {}
func (*QueryInput_Text) isQueryInput_Input()        {}
func (*QueryInput_Event) isQueryInput_Input()       {}

func (m *QueryInput) GetInput() isQueryInput_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *QueryInput) GetAudioConfig() *InputAudioConfig {
	if x, ok := m.GetInput().(*QueryInput_AudioConfig); ok {
		return x.AudioConfig
	}
	return nil
}

func (m *QueryInput) GetText() *TextInput {
	if x, ok := m.GetInput().(*QueryInput_Text); ok {
		return x.Text
	}
	return nil
}

func (m *QueryInput) GetEvent() *EventInput {
	if x, ok := m.GetInput().(*QueryInput_Event); ok {
		return x.Event
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*QueryInput) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _QueryInput_OneofMarshaler, _QueryInput_OneofUnmarshaler, _QueryInput_OneofSizer, []interface{}{
		(*QueryInput_AudioConfig)(nil),
		(*QueryInput_Text)(nil),
		(*QueryInput_Event)(nil),
	}
}

func _QueryInput_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*QueryInput)
	// input
	switch x := m.Input.(type) {
	case *QueryInput_AudioConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AudioConfig); err != nil {
			return err
		}
	case *QueryInput_Text:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Text); err != nil {
			return err
		}
	case *QueryInput_Event:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Event); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("QueryInput.Input has unexpected type %T", x)
	}
	return nil
}

func _QueryInput_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*QueryInput)
	switch tag {
	case 1: // input.audio_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InputAudioConfig)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_AudioConfig{msg}
		return true, err
	case 2: // input.text
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TextInput)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_Text{msg}
		return true, err
	case 3: // input.event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EventInput)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_Event{msg}
		return true, err
	default:
		return false, nil
	}
}

func _QueryInput_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*QueryInput)
	// input
	switch x := m.Input.(type) {
	case *QueryInput_AudioConfig:
		s := proto.Size(x.AudioConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *QueryInput_Text:
		s := proto.Size(x.Text)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *QueryInput_Event:
		s := proto.Size(x.Event)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Represents the result of conversational query or event processing.
type QueryResult struct {
	// The original conversational query text:
	// - If natural language text was provided as input, `query_text` contains
	//   a copy of the input.
	// - If natural language speech audio was provided as input, `query_text`
	//   contains the speech recognition result. If speech recognizer produced
	//   multiple alternatives, a particular one is picked.
	// - If an event was provided as input, `query_text` is not set.
	QueryText string `protobuf:"bytes,1,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
	// The language that was triggered during intent detection.
	// See [Language Support](https://dialogflow.com/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Speech recognition confidence between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. The default of 0.0 is a sentinel value indicating that confidence
	// was not set.
	//
	// You should not rely on this field as it isn't guaranteed to be accurate, or
	// even set. In particular this field isn't set in Webhook calls and for
	// StreamingDetectIntent since the streaming endpoint has separate confidence
	// estimates per portion of the audio in StreamingRecognitionResult.
	SpeechRecognitionConfidence float32 `protobuf:"fixed32,2,opt,name=speech_recognition_confidence,json=speechRecognitionConfidence,proto3" json:"speech_recognition_confidence,omitempty"`
	// The action name from the matched intent.
	Action string `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// The collection of extracted parameters.
	Parameters *_struct.Struct `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// This field is set to:
	// - `false` if the matched intent has required parameters and not all of
	//    the required parameter values have been collected.
	// - `true` if all required parameter values have been collected, or if the
	//    matched intent doesn't contain any required parameters.
	AllRequiredParamsPresent bool `protobuf:"varint,5,opt,name=all_required_params_present,json=allRequiredParamsPresent,proto3" json:"all_required_params_present,omitempty"`
	// The text to be pronounced to the user or shown on the screen.
	FulfillmentText string `protobuf:"bytes,6,opt,name=fulfillment_text,json=fulfillmentText,proto3" json:"fulfillment_text,omitempty"`
	// The collection of rich messages to present to the user.
	FulfillmentMessages []*Intent_Message `protobuf:"bytes,7,rep,name=fulfillment_messages,json=fulfillmentMessages,proto3" json:"fulfillment_messages,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `source` field returned in the webhook response.
	WebhookSource string `protobuf:"bytes,8,opt,name=webhook_source,json=webhookSource,proto3" json:"webhook_source,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `payload` field returned in the webhook response.
	WebhookPayload *_struct.Struct `protobuf:"bytes,9,opt,name=webhook_payload,json=webhookPayload,proto3" json:"webhook_payload,omitempty"`
	// The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name
	// `<parameter name>.original` containing the original parameter values
	// before the query.
	OutputContexts []*Context `protobuf:"bytes,10,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// The intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name`, `display_name` and `webhook_state`.
	Intent *Intent `protobuf:"bytes,11,opt,name=intent,proto3" json:"intent,omitempty"`
	// The intent detection confidence. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	IntentDetectionConfidence float32 `protobuf:"fixed32,12,opt,name=intent_detection_confidence,json=intentDetectionConfidence,proto3" json:"intent_detection_confidence,omitempty"`
	// The free-form diagnostic info. For example, this field
	// could contain webhook call latency.
	DiagnosticInfo       *_struct.Struct `protobuf:"bytes,14,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *QueryResult) Reset()         { *m = QueryResult{} }
func (m *QueryResult) String() string { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()    {}
func (*QueryResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{4}
}
func (m *QueryResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResult.Unmarshal(m, b)
}
func (m *QueryResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResult.Marshal(b, m, deterministic)
}
func (dst *QueryResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResult.Merge(dst, src)
}
func (m *QueryResult) XXX_Size() int {
	return xxx_messageInfo_QueryResult.Size(m)
}
func (m *QueryResult) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResult.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResult proto.InternalMessageInfo

func (m *QueryResult) GetQueryText() string {
	if m != nil {
		return m.QueryText
	}
	return ""
}

func (m *QueryResult) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *QueryResult) GetSpeechRecognitionConfidence() float32 {
	if m != nil {
		return m.SpeechRecognitionConfidence
	}
	return 0
}

func (m *QueryResult) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *QueryResult) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *QueryResult) GetAllRequiredParamsPresent() bool {
	if m != nil {
		return m.AllRequiredParamsPresent
	}
	return false
}

func (m *QueryResult) GetFulfillmentText() string {
	if m != nil {
		return m.FulfillmentText
	}
	return ""
}

func (m *QueryResult) GetFulfillmentMessages() []*Intent_Message {
	if m != nil {
		return m.FulfillmentMessages
	}
	return nil
}

func (m *QueryResult) GetWebhookSource() string {
	if m != nil {
		return m.WebhookSource
	}
	return ""
}

func (m *QueryResult) GetWebhookPayload() *_struct.Struct {
	if m != nil {
		return m.WebhookPayload
	}
	return nil
}

func (m *QueryResult) GetOutputContexts() []*Context {
	if m != nil {
		return m.OutputContexts
	}
	return nil
}

func (m *QueryResult) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *QueryResult) GetIntentDetectionConfidence() float32 {
	if m != nil {
		return m.IntentDetectionConfidence
	}
	return 0
}

func (m *QueryResult) GetDiagnosticInfo() *_struct.Struct {
	if m != nil {
		return m.DiagnosticInfo
	}
	return nil
}

// The top-level message sent by the client to the
// `StreamingDetectIntent` method.
//
// Multiple request messages should be sent in order:
//
// 1.  The first message must contain `session`, `query_input` plus optionally
//     `query_params` and/or `single_utterance`. The message must not contain `input_audio`.
//
// 2.  If `query_input` was set to a streaming input audio config,
//     all subsequent messages must contain only `input_audio`.
//     Otherwise, finish the request stream.
type StreamingDetectIntentRequest struct {
	// Required. The name of the session the query is sent to.
	// Format of the session name:
	// `projects/<Project ID>/agent/sessions/<Session ID>`, or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`. Note: Environments and users are under
	// construction and will be available soon. If <Environment ID> is not
	// specified, we assume default 'draft' environment. If <User ID> is not
	// specified, we are using "-". It’s up to the API caller to choose an
	// appropriate <Session ID>. and <User Id>. They can be a random numbers or
	// some type of user and session identifiers (preferably hashed). The length
	// of the <Session ID> and <User ID> must not exceed 36 characters.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config which instructs the speech recognizer how to process
	//     the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Optional. If `false` (default), recognition does not cease until the
	// client closes the stream.
	// If `true`, the recognizer will detect a single spoken utterance in input
	// audio. Recognition ceases when it detects the audio's voice has
	// stopped or paused. In this case, once a detected intent is received, the
	// client should close the stream and start a new request with a new stream as
	// needed.
	// This setting is ignored when `query_input` is a piece of text or an event.
	SingleUtterance bool `protobuf:"varint,4,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// Optional. The input audio content to be recognized. Must be sent if
	// `query_input` was set to a streaming input audio config. The complete audio
	// over all streaming messages must not exceed 1 minute.
	InputAudio           []byte   `protobuf:"bytes,6,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingDetectIntentRequest) Reset()         { *m = StreamingDetectIntentRequest{} }
func (m *StreamingDetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentRequest) ProtoMessage()    {}
func (*StreamingDetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{5}
}
func (m *StreamingDetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentRequest.Unmarshal(m, b)
}
func (m *StreamingDetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentRequest.Marshal(b, m, deterministic)
}
func (dst *StreamingDetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentRequest.Merge(dst, src)
}
func (m *StreamingDetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentRequest.Size(m)
}
func (m *StreamingDetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentRequest proto.InternalMessageInfo

func (m *StreamingDetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *StreamingDetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetSingleUtterance() bool {
	if m != nil {
		return m.SingleUtterance
	}
	return false
}

func (m *StreamingDetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The top-level message returned from the
// `StreamingDetectIntent` method.
//
// Multiple response messages can be returned in order:
//
// 1.  If the input was set to streaming audio, the first one or more messages
//     contain `recognition_result`. Each `recognition_result` represents a more
//     complete transcript of what the user said. The last `recognition_result`
//     has `is_final` set to `true`.
//
// 2.  The next message contains `response_id`, `query_result`
//     and optionally `webhook_status` if a WebHook was called.
type StreamingDetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,2,opt,name=recognition_result,json=recognitionResult,proto3" json:"recognition_result,omitempty"`
	// The result of the conversational query or event processing.
	QueryResult *QueryResult `protobuf:"bytes,3,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus        *status.Status `protobuf:"bytes,4,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *StreamingDetectIntentResponse) Reset()         { *m = StreamingDetectIntentResponse{} }
func (m *StreamingDetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentResponse) ProtoMessage()    {}
func (*StreamingDetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{6}
}
func (m *StreamingDetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentResponse.Unmarshal(m, b)
}
func (m *StreamingDetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentResponse.Marshal(b, m, deterministic)
}
func (dst *StreamingDetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentResponse.Merge(dst, src)
}
func (m *StreamingDetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentResponse.Size(m)
}
func (m *StreamingDetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentResponse proto.InternalMessageInfo

func (m *StreamingDetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *StreamingDetectIntentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if m != nil {
		return m.RecognitionResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

// Contains a speech recognition result corresponding to a portion of the audio
// that is currently being processed or an indication that this is the end
// of the single requested utterance.
//
// Example:
//
// 1.  transcript: "tube"
//
// 2.  transcript: "to be a"
//
// 3.  transcript: "to be"
//
// 4.  transcript: "to be or not to be"
//     is_final: true
//
// 5.  transcript: " that's"
//
// 6.  transcript: " that is"
//
// 7.  recognition_event_type: `RECOGNITION_EVENT_END_OF_SINGLE_UTTERANCE`
//
// 8.  transcript: " that is the question"
//     is_final: true
//
// Only two of the responses contain final results (#4 and #8 indicated by
// `is_final: true`). Concatenating these generates the full transcript: "to be
// or not to be that is the question".
//
// In each response we populate:
//
// *  for `MESSAGE_TYPE_TRANSCRIPT`: `transcript` and possibly `is_final`.
//
// *  for `MESSAGE_TYPE_END_OF_SINGLE_UTTERANCE`: only `event_type`.
type StreamingRecognitionResult struct {
	// Type of the result message.
	MessageType StreamingRecognitionResult_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.dialogflow.v2beta1.StreamingRecognitionResult_MessageType" json:"message_type,omitempty"`
	// Transcript text representing the words that the user spoke.
	// Populated if and only if `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
	Transcript string `protobuf:"bytes,2,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	// If `false`, the `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, the recognizer will not return
	// any further hypotheses about this piece of the audio. May only be populated
	// for `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
	IsFinal bool `protobuf:"varint,3,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for the current portion of audio.
	// A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set.
	//
	// This field is typically only provided if `is_final` is true and you should
	// not rely on it being accurate or even set.
	Confidence           float32  `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingRecognitionResult) Reset()         { *m = StreamingRecognitionResult{} }
func (m *StreamingRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionResult) ProtoMessage()    {}
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{7}
}
func (m *StreamingRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionResult.Unmarshal(m, b)
}
func (m *StreamingRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionResult.Marshal(b, m, deterministic)
}
func (dst *StreamingRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionResult.Merge(dst, src)
}
func (m *StreamingRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionResult.Size(m)
}
func (m *StreamingRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionResult proto.InternalMessageInfo

func (m *StreamingRecognitionResult) GetMessageType() StreamingRecognitionResult_MessageType {
	if m != nil {
		return m.MessageType
	}
	return StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
}

func (m *StreamingRecognitionResult) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *StreamingRecognitionResult) GetIsFinal() bool {
	if m != nil {
		return m.IsFinal
	}
	return false
}

func (m *StreamingRecognitionResult) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Instructs the speech recognizer how to process the audio content.
type InputAudioConfig struct {
	// Required. Audio encoding of the audio content to process.
	AudioEncoding AudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.dialogflow.v2beta1.AudioEncoding" json:"audio_encoding,omitempty"`
	// Required. Sample rate (in Hertz) of the audio content sent in the query.
	// Refer to [Cloud Speech API documentation](/speech/docs/basics) for more
	// details.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Required. The language of the supplied audio. Dialogflow does not do
	// translations. See [Language
	// Support](https://dialogflow.com/docs/languages) for a list of the
	// currently supported language codes. Note that queries in the same session
	// do not necessarily need to specify the same language.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The collection of phrase hints which are used to boost accuracy
	// of speech recognition.
	// Refer to [Cloud Speech API documentation](/speech/docs/basics#phrase-hints)
	// for more details.
	PhraseHints          []string `protobuf:"bytes,4,rep,name=phrase_hints,json=phraseHints,proto3" json:"phrase_hints,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InputAudioConfig) Reset()         { *m = InputAudioConfig{} }
func (m *InputAudioConfig) String() string { return proto.CompactTextString(m) }
func (*InputAudioConfig) ProtoMessage()    {}
func (*InputAudioConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{8}
}
func (m *InputAudioConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputAudioConfig.Unmarshal(m, b)
}
func (m *InputAudioConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputAudioConfig.Marshal(b, m, deterministic)
}
func (dst *InputAudioConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputAudioConfig.Merge(dst, src)
}
func (m *InputAudioConfig) XXX_Size() int {
	return xxx_messageInfo_InputAudioConfig.Size(m)
}
func (m *InputAudioConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputAudioConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputAudioConfig proto.InternalMessageInfo

func (m *InputAudioConfig) GetAudioEncoding() AudioEncoding {
	if m != nil {
		return m.AudioEncoding
	}
	return AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
}

func (m *InputAudioConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *InputAudioConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *InputAudioConfig) GetPhraseHints() []string {
	if m != nil {
		return m.PhraseHints
	}
	return nil
}

// Represents the natural language text to be processed.
type TextInput struct {
	// Required. The UTF-8 encoded natural language text to be processed.
	// Text length must not exceed 256 bytes.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Required. The language of this conversational query. See [Language
	// Support](https://dialogflow.com/docs/languages) for a list of the
	// currently supported language codes. Note that queries in the same session
	// do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextInput) Reset()         { *m = TextInput{} }
func (m *TextInput) String() string { return proto.CompactTextString(m) }
func (*TextInput) ProtoMessage()    {}
func (*TextInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{9}
}
func (m *TextInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextInput.Unmarshal(m, b)
}
func (m *TextInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextInput.Marshal(b, m, deterministic)
}
func (dst *TextInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextInput.Merge(dst, src)
}
func (m *TextInput) XXX_Size() int {
	return xxx_messageInfo_TextInput.Size(m)
}
func (m *TextInput) XXX_DiscardUnknown() {
	xxx_messageInfo_TextInput.DiscardUnknown(m)
}

var xxx_messageInfo_TextInput proto.InternalMessageInfo

func (m *TextInput) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Events allow for matching intents by event name instead of the natural
// language input. For instance, input `<event: { name: “welcome_event”,
// parameters: { name: “Sam” } }>` can trigger a personalized welcome response.
// The parameter `name` may be used by the agent in the response:
// `“Hello #welcome_event.name! What can I do for you today?”`.
type EventInput struct {
	// Required. The unique identifier of the event.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The collection of parameters associated with the event.
	Parameters *_struct.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Required. The language of this query. See [Language
	// Support](https://dialogflow.com/docs/languages) for a list of the
	// currently supported language codes. Note that queries in the same session
	// do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventInput) Reset()         { *m = EventInput{} }
func (m *EventInput) String() string { return proto.CompactTextString(m) }
func (*EventInput) ProtoMessage()    {}
func (*EventInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_8b8251b07d3dd0d2, []int{10}
}
func (m *EventInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventInput.Unmarshal(m, b)
}
func (m *EventInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventInput.Marshal(b, m, deterministic)
}
func (dst *EventInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventInput.Merge(dst, src)
}
func (m *EventInput) XXX_Size() int {
	return xxx_messageInfo_EventInput.Size(m)
}
func (m *EventInput) XXX_DiscardUnknown() {
	xxx_messageInfo_EventInput.DiscardUnknown(m)
}

var xxx_messageInfo_EventInput proto.InternalMessageInfo

func (m *EventInput) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EventInput) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *EventInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func init() {
	proto.RegisterType((*DetectIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.DetectIntentRequest")
	proto.RegisterType((*DetectIntentResponse)(nil), "google.cloud.dialogflow.v2beta1.DetectIntentResponse")
	proto.RegisterType((*QueryParameters)(nil), "google.cloud.dialogflow.v2beta1.QueryParameters")
	proto.RegisterType((*QueryInput)(nil), "google.cloud.dialogflow.v2beta1.QueryInput")
	proto.RegisterType((*QueryResult)(nil), "google.cloud.dialogflow.v2beta1.QueryResult")
	proto.RegisterType((*StreamingDetectIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest")
	proto.RegisterType((*StreamingDetectIntentResponse)(nil), "google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse")
	proto.RegisterType((*StreamingRecognitionResult)(nil), "google.cloud.dialogflow.v2beta1.StreamingRecognitionResult")
	proto.RegisterType((*InputAudioConfig)(nil), "google.cloud.dialogflow.v2beta1.InputAudioConfig")
	proto.RegisterType((*TextInput)(nil), "google.cloud.dialogflow.v2beta1.TextInput")
	proto.RegisterType((*EventInput)(nil), "google.cloud.dialogflow.v2beta1.EventInput")
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.AudioEncoding", AudioEncoding_name, AudioEncoding_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.StreamingRecognitionResult_MessageType", StreamingRecognitionResult_MessageType_name, StreamingRecognitionResult_MessageType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
}

type sessionsClient struct {
	cc *grpc.ClientConn
}

func NewSessionsClient(cc *grpc.ClientConn) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Sessions/DetectIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[0], "/google.cloud.dialogflow.v2beta1.Sessions/StreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SessionsServer is the server API for Sessions service.
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
}

func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) {
	s.RegisterService(&_Sessions_serviceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Sessions/DetectIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Sessions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/v2beta1/session.proto",
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/session.proto", fileDescriptor_session_8b8251b07d3dd0d2)
}

var fileDescriptor_session_8b8251b07d3dd0d2 = []byte{
	// 1609 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0xbd, 0x73, 0x1b, 0xc7,
	0x15, 0xd7, 0x81, 0xdf, 0x0f, 0x20, 0x09, 0xaf, 0x64, 0xeb, 0x44, 0x4a, 0x96, 0x02, 0x8f, 0x27,
	0x14, 0xe3, 0x00, 0x16, 0x93, 0x38, 0x63, 0x6b, 0xe4, 0x08, 0x04, 0x8e, 0x24, 0x66, 0x28, 0x12,
	0x5e, 0x80, 0xa6, 0xad, 0x66, 0x67, 0x79, 0x58, 0x1e, 0x4f, 0x39, 0xec, 0x1e, 0x6f, 0xf7, 0x64,
	0xd3, 0x99, 0xa4, 0xc8, 0xbf, 0x90, 0x2a, 0x29, 0x32, 0x99, 0x34, 0x99, 0x71, 0x9b, 0x26, 0x4d,
	0xaa, 0x34, 0xe9, 0x53, 0xa7, 0x4b, 0x99, 0x2e, 0x29, 0x32, 0x93, 0x26, 0x73, 0xbb, 0x7b, 0x00,
	0x04, 0x52, 0x02, 0x94, 0xa4, 0x72, 0x25, 0xec, 0x7b, 0xbf, 0xf7, 0xf6, 0xbd, 0xdf, 0xbd, 0x8f,
	0xa5, 0xe0, 0xbb, 0x81, 0x10, 0x41, 0xc4, 0x6a, 0x7e, 0x24, 0xd2, 0x5e, 0xad, 0x17, 0xd2, 0x48,
	0x04, 0xa7, 0x91, 0xf8, 0xa2, 0xf6, 0x7c, 0xeb, 0x84, 0x29, 0xfa, 0xa0, 0x26, 0x99, 0x94, 0xa1,
	0xe0, 0xd5, 0x38, 0x11, 0x4a, 0xa0, 0xbb, 0x06, 0x5e, 0xd5, 0xf0, 0xea, 0x10, 0x5e, 0xb5, 0xf0,
	0xb5, 0xdb, 0xd6, 0x1f, 0x8d, 0xc3, 0x1a, 0xe5, 0x5c, 0x28, 0xaa, 0x42, 0xc1, 0xa5, 0x31, 0x5f,
	0x9b, 0x78, 0x9b, 0x2f, 0xb8, 0x62, 0x5f, 0x2a, 0x0b, 0x7f, 0x6f, 0x12, 0x3c, 0xe4, 0x8a, 0xf1,
	0x1c, 0xfd, 0xe1, 0x94, 0xa9, 0x10, 0xc6, 0x55, 0xa8, 0x2e, 0x88, 0xba, 0x88, 0x99, 0x35, 0xcd,
	0xa3, 0xd6, 0xa7, 0x93, 0xf4, 0xb4, 0x26, 0x55, 0x92, 0xfa, 0xb9, 0xe3, 0x9b, 0x56, 0x9b, 0xc4,
	0x7e, 0x4d, 0x2a, 0xaa, 0xd2, 0x3c, 0x1d, 0xd7, 0x2a, 0x32, 0x4f, 0xb5, 0x88, 0xaa, 0x88, 0x07,
	0x46, 0x53, 0xf9, 0x87, 0x03, 0xd7, 0x9b, 0x4c, 0x31, 0x5f, 0xb5, 0x74, 0x88, 0x98, 0x9d, 0xa7,
	0x4c, 0x2a, 0xe4, 0xc2, 0x82, 0x8d, 0xc2, 0x75, 0xee, 0x39, 0x1b, 0x4b, 0x38, 0x3f, 0xa2, 0x0e,
	0x94, 0xce, 0x53, 0x96, 0x5c, 0x90, 0x98, 0x26, 0xb4, 0x2f, 0xdd, 0xc2, 0x3d, 0x67, 0xa3, 0xb8,
	0xf5, 0x7e, 0x75, 0x02, 0xe1, 0xd5, 0x4f, 0x32, 0xa3, 0x76, 0x66, 0xc3, 0x14, 0x4b, 0x24, 0x2e,
	0x9e, 0x0f, 0x04, 0x12, 0xed, 0x83, 0x39, 0x92, 0x90, 0xc7, 0xa9, 0x72, 0x67, 0xb4, 0xcf, 0xef,
	0x4c, 0xe7, 0xb3, 0x95, 0x99, 0x60, 0x38, 0x1f, 0xfc, 0x46, 0x77, 0xa1, 0xa8, 0xfd, 0x10, 0x9a,
	0xf6, 0x42, 0xe1, 0xce, 0xdd, 0x73, 0x36, 0x4a, 0x18, 0xb4, 0xa8, 0x9e, 0x49, 0x2a, 0x7f, 0x72,
	0xe0, 0xc6, 0x8b, 0x59, 0xcb, 0x58, 0x70, 0xc9, 0x32, 0xcb, 0xc4, 0xfe, 0x26, 0x61, 0xcf, 0xa6,
	0x0e, 0xb9, 0xa8, 0xd5, 0x43, 0x87, 0x79, 0xf6, 0x09, 0x93, 0x69, 0xa4, 0x6c, 0xf6, 0xef, 0x4d,
	0x17, 0x29, 0xd6, 0x36, 0x36, 0x73, 0x73, 0x40, 0x1f, 0xc2, 0xca, 0x17, 0xec, 0xe4, 0x4c, 0x88,
	0x1f, 0x13, 0xf3, 0xc9, 0x6c, 0xf2, 0x28, 0x77, 0x99, 0xc4, 0x7e, 0xb5, 0xa3, 0x35, 0x78, 0xd9,
	0x22, 0xcd, 0xb1, 0xf2, 0xf7, 0x02, 0xac, 0x8e, 0xb1, 0x8a, 0xd6, 0x61, 0x49, 0x85, 0x7d, 0x46,
	0xbe, 0x12, 0x9c, 0xd9, 0xf0, 0x17, 0x33, 0xc1, 0x53, 0xc1, 0x19, 0xfa, 0x00, 0x4a, 0x01, 0x13,
	0x24, 0x12, 0xbe, 0x2e, 0x76, 0x1b, 0xfc, 0xf5, 0xfc, 0x26, 0x5d, 0x67, 0xfb, 0x54, 0xed, 0xf3,
	0x00, 0x17, 0x03, 0x26, 0xf6, 0x2d, 0x0e, 0x35, 0x61, 0xd1, 0xd6, 0x7b, 0x16, 0xdd, 0xcc, 0x46,
	0x71, 0x6b, 0x63, 0x62, 0xc2, 0x0d, 0x63, 0x80, 0x07, 0x96, 0xe8, 0x5d, 0x58, 0x49, 0x98, 0x64,
	0x8a, 0x0c, 0x7c, 0xcd, 0xde, 0x73, 0x36, 0x16, 0xf1, 0xb2, 0x96, 0x36, 0x72, 0x58, 0x0f, 0x6e,
	0x5c, 0x51, 0xff, 0xd2, 0x9d, 0xd3, 0x17, 0x6f, 0x4d, 0xbc, 0xb8, 0x63, 0x8c, 0x3d, 0x6d, 0xdb,
	0xbd, 0x88, 0x19, 0x46, 0x72, 0x5c, 0x24, 0xd1, 0x03, 0x58, 0x88, 0xe9, 0x45, 0x24, 0x68, 0xcf,
	0x9d, 0xd7, 0x2c, 0xdc, 0xcc, 0x1d, 0xe7, 0xad, 0x55, 0xed, 0xe8, 0xd6, 0xc2, 0x39, 0xae, 0xf2,
	0x4f, 0x07, 0x60, 0x58, 0x70, 0xe8, 0x53, 0x28, 0xe9, 0xf2, 0xca, 0xd2, 0x39, 0x0d, 0x03, 0x4d,
	0x76, 0x71, 0xeb, 0xc1, 0xc4, 0xf8, 0x5a, 0x83, 0x32, 0x6c, 0x68, 0xc3, 0xbd, 0x6b, 0xb8, 0x48,
	0x87, 0x47, 0xf4, 0x18, 0x66, 0x33, 0x22, 0xec, 0xc7, 0xd9, 0x9c, 0xe8, 0xaf, 0xcb, 0xbe, 0x54,
	0xda, 0xe7, 0xde, 0x35, 0xac, 0x2d, 0x51, 0x03, 0xe6, 0xd8, 0x73, 0xc6, 0xa7, 0x6f, 0x23, 0x2f,
	0x43, 0xe7, 0x3e, 0x8c, 0xed, 0xf6, 0x02, 0xcc, 0xe9, 0x86, 0xa9, 0xfc, 0x7e, 0x1e, 0x8a, 0x23,
	0xd5, 0x8b, 0xee, 0x80, 0x69, 0x35, 0xa2, 0xa3, 0x34, 0x25, 0xb6, 0xa4, 0x25, 0x59, 0x24, 0xe8,
	0x1d, 0x58, 0x8e, 0x28, 0x0f, 0x52, 0x1a, 0x30, 0xe2, 0x8b, 0x1e, 0x73, 0x57, 0x35, 0xa2, 0x94,
	0x0b, 0x1b, 0xa2, 0xc7, 0xd0, 0x36, 0xdc, 0x91, 0x31, 0x63, 0xfe, 0x19, 0x49, 0x98, 0x2f, 0x02,
	0x1e, 0x66, 0x65, 0x66, 0x88, 0xec, 0x31, 0xee, 0x33, 0x9d, 0x7c, 0x01, 0xaf, 0x1b, 0x10, 0x1e,
	0x62, 0x1a, 0x03, 0x08, 0x7a, 0x0b, 0xe6, 0xa9, 0xaf, 0xcb, 0x78, 0x46, 0xdf, 0x60, 0x4f, 0xe8,
	0x87, 0x00, 0xf1, 0xa0, 0x1f, 0x74, 0x89, 0xbd, 0xe2, 0xe3, 0x8e, 0x40, 0xd1, 0x23, 0x58, 0xa7,
	0x51, 0x44, 0x12, 0x76, 0x9e, 0x86, 0x09, 0xeb, 0xd9, 0xf9, 0x46, 0xe2, 0xac, 0x3c, 0xb9, 0xd2,
	0x53, 0x64, 0x11, 0xbb, 0x34, 0x8a, 0xb0, 0x45, 0x98, 0xd9, 0xd5, 0x36, 0x7a, 0x74, 0x1f, 0xca,
	0xa7, 0x69, 0x74, 0x1a, 0x46, 0x51, 0x9f, 0x71, 0x65, 0xd8, 0x99, 0xd7, 0x91, 0xad, 0x8e, 0xc8,
	0x35, 0x47, 0x27, 0x70, 0x63, 0x14, 0xda, 0x67, 0x52, 0xd2, 0x80, 0x49, 0x77, 0x41, 0x97, 0x78,
	0x6d, 0x8a, 0x12, 0xd2, 0xdb, 0xe4, 0x89, 0xb1, 0xc3, 0xd7, 0x47, 0x9c, 0x59, 0x99, 0xee, 0xb6,
	0xc1, 0x5c, 0x11, 0x69, 0xe2, 0x33, 0x77, 0x51, 0x07, 0x33, 0x98, 0x21, 0x5a, 0x88, 0x1e, 0xc3,
	0x6a, 0x0e, 0xcb, 0xfb, 0x61, 0xe9, 0xd5, 0x94, 0xe5, 0x6e, 0xdb, 0x06, 0x8e, 0x3e, 0x81, 0x55,
	0x91, 0xaa, 0x6c, 0xda, 0x0e, 0xfa, 0x1a, 0x5e, 0x73, 0x46, 0xac, 0x18, 0x07, 0x83, 0x11, 0xf0,
	0x23, 0x98, 0x37, 0x0b, 0xd3, 0x2d, 0xea, 0x58, 0xbe, 0x3d, 0x25, 0x23, 0xd8, 0x9a, 0xa1, 0x8f,
	0x61, 0xdd, 0xfc, 0x22, 0x3d, 0x3d, 0xe5, 0xc7, 0xaa, 0xab, 0xa4, 0xab, 0xeb, 0x96, 0x81, 0x34,
	0x73, 0xc4, 0x48, 0x6d, 0x3d, 0x86, 0xd5, 0x5e, 0x48, 0x03, 0x2e, 0xa4, 0x0a, 0x7d, 0x12, 0xf2,
	0x53, 0xe1, 0xae, 0x4c, 0x60, 0x65, 0x88, 0x6f, 0xf1, 0x53, 0x51, 0xf9, 0x5d, 0x01, 0x6e, 0x77,
	0x54, 0xc2, 0x68, 0x3f, 0xe4, 0xc1, 0x37, 0x6e, 0xc1, 0xde, 0x87, 0xb2, 0x0c, 0x79, 0x10, 0x31,
	0x92, 0x2a, 0xc5, 0x12, 0x9a, 0x91, 0x6a, 0x86, 0xf9, 0xaa, 0x91, 0x1f, 0xe5, 0xe2, 0xf1, 0x5d,
	0x3c, 0x7f, 0x69, 0x17, 0xff, 0xa1, 0x00, 0x77, 0x5e, 0xc2, 0xd4, 0xb4, 0x4b, 0xf9, 0x19, 0xa0,
	0xd1, 0x39, 0xf2, 0xc2, 0x6a, 0x7e, 0x38, 0x79, 0x61, 0xe4, 0x97, 0x8f, 0xcc, 0x19, 0xbb, 0xa9,
	0xdf, 0x48, 0xc6, 0x45, 0x97, 0x1e, 0x00, 0x33, 0xff, 0xff, 0x07, 0xc0, 0xec, 0xb4, 0x0f, 0x80,
	0x3f, 0x16, 0x60, 0xed, 0xe5, 0xd1, 0xa3, 0x67, 0x50, 0xb2, 0xa3, 0x45, 0xaf, 0x50, 0x4d, 0xdc,
	0xca, 0xd6, 0xee, 0xff, 0x40, 0x48, 0x3e, 0x72, 0xf4, 0x5a, 0x2d, 0xf6, 0x87, 0x07, 0xf4, 0x36,
	0x80, 0x4a, 0x28, 0x97, 0x7e, 0x12, 0xc6, 0x86, 0xfa, 0x25, 0x3c, 0x22, 0x41, 0xb7, 0x60, 0x31,
	0x94, 0xe4, 0x34, 0xe4, 0x34, 0xd2, 0x94, 0x2d, 0xe2, 0x85, 0x50, 0xee, 0x64, 0xc7, 0xcc, 0x74,
	0xa4, 0x37, 0x67, 0x75, 0x6f, 0x8e, 0x48, 0x2a, 0x9f, 0x41, 0x71, 0xe4, 0x5a, 0x74, 0x1b, 0xdc,
	0x27, 0x5e, 0xa7, 0x53, 0xdf, 0xf5, 0x48, 0xf7, 0xf3, 0xb6, 0x47, 0x8e, 0x0e, 0x3a, 0x6d, 0xaf,
	0xd1, 0xda, 0x69, 0x79, 0xcd, 0xf2, 0x35, 0xb4, 0x02, 0xd0, 0xc5, 0xf5, 0x83, 0x4e, 0x03, 0xb7,
	0xda, 0xdd, 0xb2, 0x83, 0xd6, 0xe1, 0xa6, 0x77, 0xd0, 0x24, 0x87, 0x3b, 0xa4, 0xd3, 0x3a, 0xd8,
	0xdd, 0xf7, 0xc8, 0x51, 0xb7, 0xeb, 0xe1, 0xfa, 0x41, 0xc3, 0x2b, 0x17, 0x2a, 0x7f, 0x75, 0xa0,
	0x3c, 0xbe, 0x8e, 0xd1, 0x11, 0xac, 0x98, 0xbd, 0xce, 0xb8, 0x2f, 0x7a, 0x21, 0x0f, 0x2c, 0x6f,
	0xd5, 0x89, 0xbc, 0x69, 0x2f, 0x9e, 0xb5, 0xc2, 0xcb, 0x74, 0xf4, 0x88, 0x36, 0xe1, 0x0d, 0x49,
	0xfb, 0x71, 0xc4, 0x48, 0x42, 0x15, 0x23, 0x67, 0x2c, 0x51, 0x5f, 0x69, 0x9e, 0xe6, 0xf0, 0xaa,
	0x51, 0x60, 0xaa, 0xd8, 0x5e, 0x26, 0xbe, 0xbc, 0x43, 0x67, 0xae, 0xd8, 0xa1, 0xdf, 0x82, 0x52,
	0x7c, 0x96, 0x50, 0xc9, 0xc8, 0x59, 0xc8, 0xf5, 0x63, 0x6a, 0x66, 0x63, 0x09, 0x17, 0x8d, 0x6c,
	0x2f, 0x13, 0x55, 0x9a, 0xb0, 0x34, 0x78, 0x1d, 0x20, 0x64, 0xdf, 0x15, 0xa6, 0x7d, 0xcc, 0x4b,
	0xe1, 0xd2, 0x45, 0x85, 0xcb, 0x17, 0x55, 0x7e, 0x06, 0x30, 0x7c, 0x20, 0x64, 0x6e, 0x38, 0xed,
	0xe7, 0x6f, 0x4b, 0xfd, 0x7b, 0x6c, 0xe5, 0x16, 0xa6, 0x5f, 0xb9, 0xd3, 0x24, 0xba, 0xf9, 0x6f,
	0x07, 0x96, 0x5f, 0xa0, 0x16, 0xbd, 0x0d, 0x6b, 0xf5, 0xa3, 0x66, 0xeb, 0x90, 0x78, 0x07, 0x8d,
	0xc3, 0x66, 0xeb, 0x60, 0x77, 0xac, 0x08, 0x6e, 0x83, 0x3b, 0xa6, 0xdf, 0x6f, 0x1d, 0x78, 0x75,
	0x4c, 0x1e, 0x7c, 0x50, 0x76, 0xd0, 0x4d, 0xb8, 0x3e, 0xa6, 0xdd, 0xd9, 0xaf, 0x37, 0xca, 0x05,
	0xe4, 0xc2, 0x8d, 0x31, 0xc5, 0x93, 0xa3, 0xfd, 0xfa, 0x71, 0x79, 0x06, 0xbd, 0x05, 0x68, 0x4c,
	0x53, 0x7f, 0x82, 0xcb, 0xb3, 0xe8, 0x16, 0xbc, 0x79, 0x59, 0x4e, 0x8e, 0xb7, 0xcb, 0x73, 0x59,
	0xe1, 0x8d, 0xa9, 0x0e, 0x77, 0x77, 0xc9, 0x61, 0xfb, 0xa8, 0x53, 0x9e, 0x47, 0xf7, 0xe1, 0xdd,
	0x31, 0x65, 0xa7, 0xed, 0x79, 0x9f, 0x91, 0xe3, 0x56, 0x77, 0x8f, 0xec, 0x79, 0xf5, 0xa6, 0x87,
	0xc9, 0xf6, 0xe7, 0x5d, 0xaf, 0xbc, 0xb0, 0xf5, 0xe7, 0x19, 0x58, 0xb4, 0x4f, 0x5a, 0x89, 0x7e,
	0x5d, 0x80, 0xd2, 0xe8, 0x88, 0x44, 0xdf, 0x9f, 0x58, 0x94, 0x57, 0xec, 0x9e, 0xb5, 0x1f, 0xbc,
	0xa6, 0x95, 0x19, 0xb4, 0x95, 0xdf, 0x38, 0x3f, 0xff, 0xcb, 0xdf, 0x7e, 0x51, 0xf8, 0xa5, 0x53,
	0x79, 0x38, 0xf8, 0x53, 0xf5, 0x27, 0x76, 0x6b, 0x3d, 0x8a, 0x13, 0xf1, 0x8c, 0xf9, 0x4a, 0xd6,
	0x36, 0x6b, 0x34, 0x60, 0x5c, 0xe5, 0x7f, 0xc4, 0xca, 0xda, 0xe6, 0x4f, 0x3f, 0xea, 0x8d, 0xb8,
	0xfb, 0xc8, 0xd9, 0x7c, 0x7a, 0x5c, 0xc1, 0x53, 0x78, 0x60, 0xfc, 0x79, 0x98, 0x08, 0x9e, 0x3d,
	0x6b, 0x32, 0x61, 0x2a, 0x59, 0x92, 0xfd, 0xfb, 0x0a, 0xc7, 0xe8, 0x57, 0x0e, 0xbc, 0x79, 0xe5,
	0x32, 0x41, 0x8f, 0xa6, 0x1f, 0x7b, 0x57, 0x51, 0xf6, 0xf1, 0x7f, 0x6b, 0x6e, 0xb8, 0xdb, 0x70,
	0xde, 0x77, 0xb6, 0xbf, 0x76, 0xe0, 0x1d, 0x5f, 0xf4, 0x27, 0x79, 0xda, 0x2e, 0xd9, 0xef, 0xdd,
	0xce, 0x3a, 0xa7, 0xed, 0x3c, 0x6d, 0x59, 0x83, 0x40, 0x64, 0x7d, 0x51, 0x15, 0x49, 0x50, 0x0b,
	0x18, 0xd7, 0x7d, 0x55, 0x33, 0x2a, 0x1a, 0x87, 0xf2, 0xa5, 0xff, 0x9d, 0xf0, 0x70, 0x28, 0xfa,
	0x97, 0xe3, 0xfc, 0xb6, 0x50, 0x68, 0xee, 0x7c, 0x5d, 0xb8, 0xbb, 0x6b, 0x7c, 0x36, 0x74, 0x10,
	0xcd, 0x61, 0x10, 0x9f, 0x1a, 0xa3, 0x93, 0x79, 0xed, 0xff, 0x7b, 0xff, 0x09, 0x00, 0x00, 0xff,
	0xff, 0x40, 0x45, 0xcf, 0x26, 0x78, 0x11, 0x00, 0x00,
}
