// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/datastore/v1beta3/query.proto

package datastore // import "google.golang.org/genproto/googleapis/datastore/v1beta3"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/type/latlng"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Specifies what data the 'entity' field contains.
// A `ResultType` is either implied (for example, in `LookupResponse.missing`
// from `datastore.proto`, it is always `KEY_ONLY`) or specified by context
// (for example, in message `QueryResultBatch`, field `entity_result_type`
// specifies a `ResultType` for all the values in field `entity_results`).
type EntityResult_ResultType int32

const (
	// Unspecified. This value is never used.
	EntityResult_RESULT_TYPE_UNSPECIFIED EntityResult_ResultType = 0
	// The key and properties.
	EntityResult_FULL EntityResult_ResultType = 1
	// A projected subset of properties. The entity may have no key.
	EntityResult_PROJECTION EntityResult_ResultType = 2
	// Only the key.
	EntityResult_KEY_ONLY EntityResult_ResultType = 3
)

var EntityResult_ResultType_name = map[int32]string{
	0: "RESULT_TYPE_UNSPECIFIED",
	1: "FULL",
	2: "PROJECTION",
	3: "KEY_ONLY",
}
var EntityResult_ResultType_value = map[string]int32{
	"RESULT_TYPE_UNSPECIFIED": 0,
	"FULL":       1,
	"PROJECTION": 2,
	"KEY_ONLY":   3,
}

func (x EntityResult_ResultType) String() string {
	return proto.EnumName(EntityResult_ResultType_name, int32(x))
}
func (EntityResult_ResultType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{0, 0}
}

// The sort direction.
type PropertyOrder_Direction int32

const (
	// Unspecified. This value must not be used.
	PropertyOrder_DIRECTION_UNSPECIFIED PropertyOrder_Direction = 0
	// Ascending.
	PropertyOrder_ASCENDING PropertyOrder_Direction = 1
	// Descending.
	PropertyOrder_DESCENDING PropertyOrder_Direction = 2
)

var PropertyOrder_Direction_name = map[int32]string{
	0: "DIRECTION_UNSPECIFIED",
	1: "ASCENDING",
	2: "DESCENDING",
}
var PropertyOrder_Direction_value = map[string]int32{
	"DIRECTION_UNSPECIFIED": 0,
	"ASCENDING":             1,
	"DESCENDING":            2,
}

func (x PropertyOrder_Direction) String() string {
	return proto.EnumName(PropertyOrder_Direction_name, int32(x))
}
func (PropertyOrder_Direction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{5, 0}
}

// A composite filter operator.
type CompositeFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	CompositeFilter_OPERATOR_UNSPECIFIED CompositeFilter_Operator = 0
	// The results are required to satisfy each of the combined filters.
	CompositeFilter_AND CompositeFilter_Operator = 1
)

var CompositeFilter_Operator_name = map[int32]string{
	0: "OPERATOR_UNSPECIFIED",
	1: "AND",
}
var CompositeFilter_Operator_value = map[string]int32{
	"OPERATOR_UNSPECIFIED": 0,
	"AND": 1,
}

func (x CompositeFilter_Operator) String() string {
	return proto.EnumName(CompositeFilter_Operator_name, int32(x))
}
func (CompositeFilter_Operator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{7, 0}
}

// A property filter operator.
type PropertyFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	PropertyFilter_OPERATOR_UNSPECIFIED PropertyFilter_Operator = 0
	// Less than.
	PropertyFilter_LESS_THAN PropertyFilter_Operator = 1
	// Less than or equal.
	PropertyFilter_LESS_THAN_OR_EQUAL PropertyFilter_Operator = 2
	// Greater than.
	PropertyFilter_GREATER_THAN PropertyFilter_Operator = 3
	// Greater than or equal.
	PropertyFilter_GREATER_THAN_OR_EQUAL PropertyFilter_Operator = 4
	// Equal.
	PropertyFilter_EQUAL PropertyFilter_Operator = 5
	// Has ancestor.
	PropertyFilter_HAS_ANCESTOR PropertyFilter_Operator = 11
)

var PropertyFilter_Operator_name = map[int32]string{
	0:  "OPERATOR_UNSPECIFIED",
	1:  "LESS_THAN",
	2:  "LESS_THAN_OR_EQUAL",
	3:  "GREATER_THAN",
	4:  "GREATER_THAN_OR_EQUAL",
	5:  "EQUAL",
	11: "HAS_ANCESTOR",
}
var PropertyFilter_Operator_value = map[string]int32{
	"OPERATOR_UNSPECIFIED":  0,
	"LESS_THAN":             1,
	"LESS_THAN_OR_EQUAL":    2,
	"GREATER_THAN":          3,
	"GREATER_THAN_OR_EQUAL": 4,
	"EQUAL":                 5,
	"HAS_ANCESTOR":          11,
}

func (x PropertyFilter_Operator) String() string {
	return proto.EnumName(PropertyFilter_Operator_name, int32(x))
}
func (PropertyFilter_Operator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{8, 0}
}

// The possible values for the `more_results` field.
type QueryResultBatch_MoreResultsType int32

const (
	// Unspecified. This value is never used.
	QueryResultBatch_MORE_RESULTS_TYPE_UNSPECIFIED QueryResultBatch_MoreResultsType = 0
	// There may be additional batches to fetch from this query.
	QueryResultBatch_NOT_FINISHED QueryResultBatch_MoreResultsType = 1
	// The query is finished, but there may be more results after the limit.
	QueryResultBatch_MORE_RESULTS_AFTER_LIMIT QueryResultBatch_MoreResultsType = 2
	// The query is finished, but there may be more results after the end
	// cursor.
	QueryResultBatch_MORE_RESULTS_AFTER_CURSOR QueryResultBatch_MoreResultsType = 4
	// The query is finished, and there are no more results.
	QueryResultBatch_NO_MORE_RESULTS QueryResultBatch_MoreResultsType = 3
)

var QueryResultBatch_MoreResultsType_name = map[int32]string{
	0: "MORE_RESULTS_TYPE_UNSPECIFIED",
	1: "NOT_FINISHED",
	2: "MORE_RESULTS_AFTER_LIMIT",
	4: "MORE_RESULTS_AFTER_CURSOR",
	3: "NO_MORE_RESULTS",
}
var QueryResultBatch_MoreResultsType_value = map[string]int32{
	"MORE_RESULTS_TYPE_UNSPECIFIED": 0,
	"NOT_FINISHED":                  1,
	"MORE_RESULTS_AFTER_LIMIT":      2,
	"MORE_RESULTS_AFTER_CURSOR":     4,
	"NO_MORE_RESULTS":               3,
}

func (x QueryResultBatch_MoreResultsType) String() string {
	return proto.EnumName(QueryResultBatch_MoreResultsType_name, int32(x))
}
func (QueryResultBatch_MoreResultsType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{11, 0}
}

// The result of fetching an entity from Datastore.
type EntityResult struct {
	// The resulting entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The version of the entity, a strictly positive number that monotonically
	// increases with changes to the entity.
	//
	// This field is set for [`FULL`][google.datastore.v1beta3.EntityResult.ResultType.FULL] entity
	// results.
	//
	// For [missing][google.datastore.v1beta3.LookupResponse.missing] entities in `LookupResponse`, this
	// is the version of the snapshot that was used to look up the entity, and it
	// is always set except for eventually consistent reads.
	Version int64 `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	// A cursor that points to the position after the result entity.
	// Set only when the `EntityResult` is part of a `QueryResultBatch` message.
	Cursor               []byte   `protobuf:"bytes,3,opt,name=cursor,proto3" json:"cursor,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityResult) Reset()         { *m = EntityResult{} }
func (m *EntityResult) String() string { return proto.CompactTextString(m) }
func (*EntityResult) ProtoMessage()    {}
func (*EntityResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{0}
}
func (m *EntityResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityResult.Unmarshal(m, b)
}
func (m *EntityResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityResult.Marshal(b, m, deterministic)
}
func (dst *EntityResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityResult.Merge(dst, src)
}
func (m *EntityResult) XXX_Size() int {
	return xxx_messageInfo_EntityResult.Size(m)
}
func (m *EntityResult) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityResult.DiscardUnknown(m)
}

var xxx_messageInfo_EntityResult proto.InternalMessageInfo

func (m *EntityResult) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *EntityResult) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *EntityResult) GetCursor() []byte {
	if m != nil {
		return m.Cursor
	}
	return nil
}

// A query for entities.
type Query struct {
	// The projection to return. Defaults to returning all properties.
	Projection []*Projection `protobuf:"bytes,2,rep,name=projection,proto3" json:"projection,omitempty"`
	// The kinds to query (if empty, returns entities of all kinds).
	// Currently at most 1 kind may be specified.
	Kind []*KindExpression `protobuf:"bytes,3,rep,name=kind,proto3" json:"kind,omitempty"`
	// The filter to apply.
	Filter *Filter `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// The order to apply to the query results (if empty, order is unspecified).
	Order []*PropertyOrder `protobuf:"bytes,5,rep,name=order,proto3" json:"order,omitempty"`
	// The properties to make distinct. The query results will contain the first
	// result for each distinct combination of values for the given properties
	// (if empty, all results are returned).
	DistinctOn []*PropertyReference `protobuf:"bytes,6,rep,name=distinct_on,json=distinctOn,proto3" json:"distinct_on,omitempty"`
	// A starting point for the query results. Query cursors are
	// returned in query result batches and
	// [can only be used to continue the same query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
	StartCursor []byte `protobuf:"bytes,7,opt,name=start_cursor,json=startCursor,proto3" json:"start_cursor,omitempty"`
	// An ending point for the query results. Query cursors are
	// returned in query result batches and
	// [can only be used to limit the same query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
	EndCursor []byte `protobuf:"bytes,8,opt,name=end_cursor,json=endCursor,proto3" json:"end_cursor,omitempty"`
	// The number of results to skip. Applies before limit, but after all other
	// constraints. Optional. Must be >= 0 if specified.
	Offset int32 `protobuf:"varint,10,opt,name=offset,proto3" json:"offset,omitempty"`
	// The maximum number of results to return. Applies after all other
	// constraints. Optional.
	// Unspecified is interpreted as no limit.
	// Must be >= 0 if specified.
	Limit                *wrappers.Int32Value `protobuf:"bytes,12,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Query) Reset()         { *m = Query{} }
func (m *Query) String() string { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()    {}
func (*Query) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{1}
}
func (m *Query) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Query.Unmarshal(m, b)
}
func (m *Query) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Query.Marshal(b, m, deterministic)
}
func (dst *Query) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Query.Merge(dst, src)
}
func (m *Query) XXX_Size() int {
	return xxx_messageInfo_Query.Size(m)
}
func (m *Query) XXX_DiscardUnknown() {
	xxx_messageInfo_Query.DiscardUnknown(m)
}

var xxx_messageInfo_Query proto.InternalMessageInfo

func (m *Query) GetProjection() []*Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (m *Query) GetKind() []*KindExpression {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (m *Query) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *Query) GetOrder() []*PropertyOrder {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *Query) GetDistinctOn() []*PropertyReference {
	if m != nil {
		return m.DistinctOn
	}
	return nil
}

func (m *Query) GetStartCursor() []byte {
	if m != nil {
		return m.StartCursor
	}
	return nil
}

func (m *Query) GetEndCursor() []byte {
	if m != nil {
		return m.EndCursor
	}
	return nil
}

func (m *Query) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *Query) GetLimit() *wrappers.Int32Value {
	if m != nil {
		return m.Limit
	}
	return nil
}

// A representation of a kind.
type KindExpression struct {
	// The name of the kind.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KindExpression) Reset()         { *m = KindExpression{} }
func (m *KindExpression) String() string { return proto.CompactTextString(m) }
func (*KindExpression) ProtoMessage()    {}
func (*KindExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{2}
}
func (m *KindExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KindExpression.Unmarshal(m, b)
}
func (m *KindExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KindExpression.Marshal(b, m, deterministic)
}
func (dst *KindExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KindExpression.Merge(dst, src)
}
func (m *KindExpression) XXX_Size() int {
	return xxx_messageInfo_KindExpression.Size(m)
}
func (m *KindExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_KindExpression.DiscardUnknown(m)
}

var xxx_messageInfo_KindExpression proto.InternalMessageInfo

func (m *KindExpression) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A reference to a property relative to the kind expressions.
type PropertyReference struct {
	// The name of the property.
	// If name includes "."s, it may be interpreted as a property name path.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PropertyReference) Reset()         { *m = PropertyReference{} }
func (m *PropertyReference) String() string { return proto.CompactTextString(m) }
func (*PropertyReference) ProtoMessage()    {}
func (*PropertyReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{3}
}
func (m *PropertyReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PropertyReference.Unmarshal(m, b)
}
func (m *PropertyReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PropertyReference.Marshal(b, m, deterministic)
}
func (dst *PropertyReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PropertyReference.Merge(dst, src)
}
func (m *PropertyReference) XXX_Size() int {
	return xxx_messageInfo_PropertyReference.Size(m)
}
func (m *PropertyReference) XXX_DiscardUnknown() {
	xxx_messageInfo_PropertyReference.DiscardUnknown(m)
}

var xxx_messageInfo_PropertyReference proto.InternalMessageInfo

func (m *PropertyReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A representation of a property in a projection.
type Projection struct {
	// The property to project.
	Property             *PropertyReference `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Projection) Reset()         { *m = Projection{} }
func (m *Projection) String() string { return proto.CompactTextString(m) }
func (*Projection) ProtoMessage()    {}
func (*Projection) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{4}
}
func (m *Projection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Projection.Unmarshal(m, b)
}
func (m *Projection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Projection.Marshal(b, m, deterministic)
}
func (dst *Projection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Projection.Merge(dst, src)
}
func (m *Projection) XXX_Size() int {
	return xxx_messageInfo_Projection.Size(m)
}
func (m *Projection) XXX_DiscardUnknown() {
	xxx_messageInfo_Projection.DiscardUnknown(m)
}

var xxx_messageInfo_Projection proto.InternalMessageInfo

func (m *Projection) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

// The desired order for a specific property.
type PropertyOrder struct {
	// The property to order by.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The direction to order by. Defaults to `ASCENDING`.
	Direction            PropertyOrder_Direction `protobuf:"varint,2,opt,name=direction,proto3,enum=google.datastore.v1beta3.PropertyOrder_Direction" json:"direction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PropertyOrder) Reset()         { *m = PropertyOrder{} }
func (m *PropertyOrder) String() string { return proto.CompactTextString(m) }
func (*PropertyOrder) ProtoMessage()    {}
func (*PropertyOrder) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{5}
}
func (m *PropertyOrder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PropertyOrder.Unmarshal(m, b)
}
func (m *PropertyOrder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PropertyOrder.Marshal(b, m, deterministic)
}
func (dst *PropertyOrder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PropertyOrder.Merge(dst, src)
}
func (m *PropertyOrder) XXX_Size() int {
	return xxx_messageInfo_PropertyOrder.Size(m)
}
func (m *PropertyOrder) XXX_DiscardUnknown() {
	xxx_messageInfo_PropertyOrder.DiscardUnknown(m)
}

var xxx_messageInfo_PropertyOrder proto.InternalMessageInfo

func (m *PropertyOrder) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *PropertyOrder) GetDirection() PropertyOrder_Direction {
	if m != nil {
		return m.Direction
	}
	return PropertyOrder_DIRECTION_UNSPECIFIED
}

// A holder for any type of filter.
type Filter struct {
	// The type of filter.
	//
	// Types that are valid to be assigned to FilterType:
	//	*Filter_CompositeFilter
	//	*Filter_PropertyFilter
	FilterType           isFilter_FilterType `protobuf_oneof:"filter_type"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{6}
}
func (m *Filter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Filter.Unmarshal(m, b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
}
func (dst *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(dst, src)
}
func (m *Filter) XXX_Size() int {
	return xxx_messageInfo_Filter.Size(m)
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

type isFilter_FilterType interface {
	isFilter_FilterType()
}

type Filter_CompositeFilter struct {
	CompositeFilter *CompositeFilter `protobuf:"bytes,1,opt,name=composite_filter,json=compositeFilter,proto3,oneof"`
}
type Filter_PropertyFilter struct {
	PropertyFilter *PropertyFilter `protobuf:"bytes,2,opt,name=property_filter,json=propertyFilter,proto3,oneof"`
}

func (*Filter_CompositeFilter) isFilter_FilterType() {}
func (*Filter_PropertyFilter) isFilter_FilterType()  {}

func (m *Filter) GetFilterType() isFilter_FilterType {
	if m != nil {
		return m.FilterType
	}
	return nil
}

func (m *Filter) GetCompositeFilter() *CompositeFilter {
	if x, ok := m.GetFilterType().(*Filter_CompositeFilter); ok {
		return x.CompositeFilter
	}
	return nil
}

func (m *Filter) GetPropertyFilter() *PropertyFilter {
	if x, ok := m.GetFilterType().(*Filter_PropertyFilter); ok {
		return x.PropertyFilter
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Filter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Filter_OneofMarshaler, _Filter_OneofUnmarshaler, _Filter_OneofSizer, []interface{}{
		(*Filter_CompositeFilter)(nil),
		(*Filter_PropertyFilter)(nil),
	}
}

func _Filter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Filter)
	// filter_type
	switch x := m.FilterType.(type) {
	case *Filter_CompositeFilter:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CompositeFilter); err != nil {
			return err
		}
	case *Filter_PropertyFilter:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PropertyFilter); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Filter.FilterType has unexpected type %T", x)
	}
	return nil
}

func _Filter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Filter)
	switch tag {
	case 1: // filter_type.composite_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CompositeFilter)
		err := b.DecodeMessage(msg)
		m.FilterType = &Filter_CompositeFilter{msg}
		return true, err
	case 2: // filter_type.property_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PropertyFilter)
		err := b.DecodeMessage(msg)
		m.FilterType = &Filter_PropertyFilter{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Filter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Filter)
	// filter_type
	switch x := m.FilterType.(type) {
	case *Filter_CompositeFilter:
		s := proto.Size(x.CompositeFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Filter_PropertyFilter:
		s := proto.Size(x.PropertyFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A filter that merges multiple other filters using the given operator.
type CompositeFilter struct {
	// The operator for combining multiple filters.
	Op CompositeFilter_Operator `protobuf:"varint,1,opt,name=op,proto3,enum=google.datastore.v1beta3.CompositeFilter_Operator" json:"op,omitempty"`
	// The list of filters to combine.
	// Must contain at least one filter.
	Filters              []*Filter `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CompositeFilter) Reset()         { *m = CompositeFilter{} }
func (m *CompositeFilter) String() string { return proto.CompactTextString(m) }
func (*CompositeFilter) ProtoMessage()    {}
func (*CompositeFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{7}
}
func (m *CompositeFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompositeFilter.Unmarshal(m, b)
}
func (m *CompositeFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompositeFilter.Marshal(b, m, deterministic)
}
func (dst *CompositeFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompositeFilter.Merge(dst, src)
}
func (m *CompositeFilter) XXX_Size() int {
	return xxx_messageInfo_CompositeFilter.Size(m)
}
func (m *CompositeFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_CompositeFilter.DiscardUnknown(m)
}

var xxx_messageInfo_CompositeFilter proto.InternalMessageInfo

func (m *CompositeFilter) GetOp() CompositeFilter_Operator {
	if m != nil {
		return m.Op
	}
	return CompositeFilter_OPERATOR_UNSPECIFIED
}

func (m *CompositeFilter) GetFilters() []*Filter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A filter on a specific property.
type PropertyFilter struct {
	// The property to filter by.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The operator to filter by.
	Op PropertyFilter_Operator `protobuf:"varint,2,opt,name=op,proto3,enum=google.datastore.v1beta3.PropertyFilter_Operator" json:"op,omitempty"`
	// The value to compare the property to.
	Value                *Value   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PropertyFilter) Reset()         { *m = PropertyFilter{} }
func (m *PropertyFilter) String() string { return proto.CompactTextString(m) }
func (*PropertyFilter) ProtoMessage()    {}
func (*PropertyFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{8}
}
func (m *PropertyFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PropertyFilter.Unmarshal(m, b)
}
func (m *PropertyFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PropertyFilter.Marshal(b, m, deterministic)
}
func (dst *PropertyFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PropertyFilter.Merge(dst, src)
}
func (m *PropertyFilter) XXX_Size() int {
	return xxx_messageInfo_PropertyFilter.Size(m)
}
func (m *PropertyFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PropertyFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PropertyFilter proto.InternalMessageInfo

func (m *PropertyFilter) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *PropertyFilter) GetOp() PropertyFilter_Operator {
	if m != nil {
		return m.Op
	}
	return PropertyFilter_OPERATOR_UNSPECIFIED
}

func (m *PropertyFilter) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// A [GQL query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
type GqlQuery struct {
	// A string of the format described
	// [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
	QueryString string `protobuf:"bytes,1,opt,name=query_string,json=queryString,proto3" json:"query_string,omitempty"`
	// When false, the query string must not contain any literals and instead must
	// bind all values. For example,
	// `SELECT * FROM Kind WHERE a = 'string literal'` is not allowed, while
	// `SELECT * FROM Kind WHERE a = @value` is.
	AllowLiterals bool `protobuf:"varint,2,opt,name=allow_literals,json=allowLiterals,proto3" json:"allow_literals,omitempty"`
	// For each non-reserved named binding site in the query string, there must be
	// a named parameter with that name, but not necessarily the inverse.
	//
	// Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
	// `__.*__`, and must not be `""`.
	NamedBindings map[string]*GqlQueryParameter `protobuf:"bytes,5,rep,name=named_bindings,json=namedBindings,proto3" json:"named_bindings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Numbered binding site @1 references the first numbered parameter,
	// effectively using 1-based indexing, rather than the usual 0.
	//
	// For each binding site numbered i in `query_string`, there must be an i-th
	// numbered parameter. The inverse must also be true.
	PositionalBindings   []*GqlQueryParameter `protobuf:"bytes,4,rep,name=positional_bindings,json=positionalBindings,proto3" json:"positional_bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GqlQuery) Reset()         { *m = GqlQuery{} }
func (m *GqlQuery) String() string { return proto.CompactTextString(m) }
func (*GqlQuery) ProtoMessage()    {}
func (*GqlQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{9}
}
func (m *GqlQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GqlQuery.Unmarshal(m, b)
}
func (m *GqlQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GqlQuery.Marshal(b, m, deterministic)
}
func (dst *GqlQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GqlQuery.Merge(dst, src)
}
func (m *GqlQuery) XXX_Size() int {
	return xxx_messageInfo_GqlQuery.Size(m)
}
func (m *GqlQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_GqlQuery.DiscardUnknown(m)
}

var xxx_messageInfo_GqlQuery proto.InternalMessageInfo

func (m *GqlQuery) GetQueryString() string {
	if m != nil {
		return m.QueryString
	}
	return ""
}

func (m *GqlQuery) GetAllowLiterals() bool {
	if m != nil {
		return m.AllowLiterals
	}
	return false
}

func (m *GqlQuery) GetNamedBindings() map[string]*GqlQueryParameter {
	if m != nil {
		return m.NamedBindings
	}
	return nil
}

func (m *GqlQuery) GetPositionalBindings() []*GqlQueryParameter {
	if m != nil {
		return m.PositionalBindings
	}
	return nil
}

// A binding parameter for a GQL query.
type GqlQueryParameter struct {
	// The type of parameter.
	//
	// Types that are valid to be assigned to ParameterType:
	//	*GqlQueryParameter_Value
	//	*GqlQueryParameter_Cursor
	ParameterType        isGqlQueryParameter_ParameterType `protobuf_oneof:"parameter_type"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *GqlQueryParameter) Reset()         { *m = GqlQueryParameter{} }
func (m *GqlQueryParameter) String() string { return proto.CompactTextString(m) }
func (*GqlQueryParameter) ProtoMessage()    {}
func (*GqlQueryParameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{10}
}
func (m *GqlQueryParameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GqlQueryParameter.Unmarshal(m, b)
}
func (m *GqlQueryParameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GqlQueryParameter.Marshal(b, m, deterministic)
}
func (dst *GqlQueryParameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GqlQueryParameter.Merge(dst, src)
}
func (m *GqlQueryParameter) XXX_Size() int {
	return xxx_messageInfo_GqlQueryParameter.Size(m)
}
func (m *GqlQueryParameter) XXX_DiscardUnknown() {
	xxx_messageInfo_GqlQueryParameter.DiscardUnknown(m)
}

var xxx_messageInfo_GqlQueryParameter proto.InternalMessageInfo

type isGqlQueryParameter_ParameterType interface {
	isGqlQueryParameter_ParameterType()
}

type GqlQueryParameter_Value struct {
	Value *Value `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}
type GqlQueryParameter_Cursor struct {
	Cursor []byte `protobuf:"bytes,3,opt,name=cursor,proto3,oneof"`
}

func (*GqlQueryParameter_Value) isGqlQueryParameter_ParameterType()  {}
func (*GqlQueryParameter_Cursor) isGqlQueryParameter_ParameterType() {}

func (m *GqlQueryParameter) GetParameterType() isGqlQueryParameter_ParameterType {
	if m != nil {
		return m.ParameterType
	}
	return nil
}

func (m *GqlQueryParameter) GetValue() *Value {
	if x, ok := m.GetParameterType().(*GqlQueryParameter_Value); ok {
		return x.Value
	}
	return nil
}

func (m *GqlQueryParameter) GetCursor() []byte {
	if x, ok := m.GetParameterType().(*GqlQueryParameter_Cursor); ok {
		return x.Cursor
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GqlQueryParameter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GqlQueryParameter_OneofMarshaler, _GqlQueryParameter_OneofUnmarshaler, _GqlQueryParameter_OneofSizer, []interface{}{
		(*GqlQueryParameter_Value)(nil),
		(*GqlQueryParameter_Cursor)(nil),
	}
}

func _GqlQueryParameter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GqlQueryParameter)
	// parameter_type
	switch x := m.ParameterType.(type) {
	case *GqlQueryParameter_Value:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Value); err != nil {
			return err
		}
	case *GqlQueryParameter_Cursor:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Cursor)
	case nil:
	default:
		return fmt.Errorf("GqlQueryParameter.ParameterType has unexpected type %T", x)
	}
	return nil
}

func _GqlQueryParameter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GqlQueryParameter)
	switch tag {
	case 2: // parameter_type.value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Value)
		err := b.DecodeMessage(msg)
		m.ParameterType = &GqlQueryParameter_Value{msg}
		return true, err
	case 3: // parameter_type.cursor
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ParameterType = &GqlQueryParameter_Cursor{x}
		return true, err
	default:
		return false, nil
	}
}

func _GqlQueryParameter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GqlQueryParameter)
	// parameter_type
	switch x := m.ParameterType.(type) {
	case *GqlQueryParameter_Value:
		s := proto.Size(x.Value)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GqlQueryParameter_Cursor:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Cursor)))
		n += len(x.Cursor)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A batch of results produced by a query.
type QueryResultBatch struct {
	// The number of results skipped, typically because of an offset.
	SkippedResults int32 `protobuf:"varint,6,opt,name=skipped_results,json=skippedResults,proto3" json:"skipped_results,omitempty"`
	// A cursor that points to the position after the last skipped result.
	// Will be set when `skipped_results` != 0.
	SkippedCursor []byte `protobuf:"bytes,3,opt,name=skipped_cursor,json=skippedCursor,proto3" json:"skipped_cursor,omitempty"`
	// The result type for every entity in `entity_results`.
	EntityResultType EntityResult_ResultType `protobuf:"varint,1,opt,name=entity_result_type,json=entityResultType,proto3,enum=google.datastore.v1beta3.EntityResult_ResultType" json:"entity_result_type,omitempty"`
	// The results for this batch.
	EntityResults []*EntityResult `protobuf:"bytes,2,rep,name=entity_results,json=entityResults,proto3" json:"entity_results,omitempty"`
	// A cursor that points to the position after the last result in the batch.
	EndCursor []byte `protobuf:"bytes,4,opt,name=end_cursor,json=endCursor,proto3" json:"end_cursor,omitempty"`
	// The state of the query after the current batch.
	MoreResults QueryResultBatch_MoreResultsType `protobuf:"varint,5,opt,name=more_results,json=moreResults,proto3,enum=google.datastore.v1beta3.QueryResultBatch_MoreResultsType" json:"more_results,omitempty"`
	// The version number of the snapshot this batch was returned from.
	// This applies to the range of results from the query's `start_cursor` (or
	// the beginning of the query if no cursor was given) to this batch's
	// `end_cursor` (not the query's `end_cursor`).
	//
	// In a single transaction, subsequent query result batches for the same query
	// can have a greater snapshot version number. Each batch's snapshot version
	// is valid for all preceding batches.
	// The value will be zero for eventually consistent queries.
	SnapshotVersion      int64    `protobuf:"varint,7,opt,name=snapshot_version,json=snapshotVersion,proto3" json:"snapshot_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryResultBatch) Reset()         { *m = QueryResultBatch{} }
func (m *QueryResultBatch) String() string { return proto.CompactTextString(m) }
func (*QueryResultBatch) ProtoMessage()    {}
func (*QueryResultBatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_query_78e38e7bbd181d7f, []int{11}
}
func (m *QueryResultBatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResultBatch.Unmarshal(m, b)
}
func (m *QueryResultBatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResultBatch.Marshal(b, m, deterministic)
}
func (dst *QueryResultBatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultBatch.Merge(dst, src)
}
func (m *QueryResultBatch) XXX_Size() int {
	return xxx_messageInfo_QueryResultBatch.Size(m)
}
func (m *QueryResultBatch) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultBatch.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultBatch proto.InternalMessageInfo

func (m *QueryResultBatch) GetSkippedResults() int32 {
	if m != nil {
		return m.SkippedResults
	}
	return 0
}

func (m *QueryResultBatch) GetSkippedCursor() []byte {
	if m != nil {
		return m.SkippedCursor
	}
	return nil
}

func (m *QueryResultBatch) GetEntityResultType() EntityResult_ResultType {
	if m != nil {
		return m.EntityResultType
	}
	return EntityResult_RESULT_TYPE_UNSPECIFIED
}

func (m *QueryResultBatch) GetEntityResults() []*EntityResult {
	if m != nil {
		return m.EntityResults
	}
	return nil
}

func (m *QueryResultBatch) GetEndCursor() []byte {
	if m != nil {
		return m.EndCursor
	}
	return nil
}

func (m *QueryResultBatch) GetMoreResults() QueryResultBatch_MoreResultsType {
	if m != nil {
		return m.MoreResults
	}
	return QueryResultBatch_MORE_RESULTS_TYPE_UNSPECIFIED
}

func (m *QueryResultBatch) GetSnapshotVersion() int64 {
	if m != nil {
		return m.SnapshotVersion
	}
	return 0
}

func init() {
	proto.RegisterType((*EntityResult)(nil), "google.datastore.v1beta3.EntityResult")
	proto.RegisterType((*Query)(nil), "google.datastore.v1beta3.Query")
	proto.RegisterType((*KindExpression)(nil), "google.datastore.v1beta3.KindExpression")
	proto.RegisterType((*PropertyReference)(nil), "google.datastore.v1beta3.PropertyReference")
	proto.RegisterType((*Projection)(nil), "google.datastore.v1beta3.Projection")
	proto.RegisterType((*PropertyOrder)(nil), "google.datastore.v1beta3.PropertyOrder")
	proto.RegisterType((*Filter)(nil), "google.datastore.v1beta3.Filter")
	proto.RegisterType((*CompositeFilter)(nil), "google.datastore.v1beta3.CompositeFilter")
	proto.RegisterType((*PropertyFilter)(nil), "google.datastore.v1beta3.PropertyFilter")
	proto.RegisterType((*GqlQuery)(nil), "google.datastore.v1beta3.GqlQuery")
	proto.RegisterMapType((map[string]*GqlQueryParameter)(nil), "google.datastore.v1beta3.GqlQuery.NamedBindingsEntry")
	proto.RegisterType((*GqlQueryParameter)(nil), "google.datastore.v1beta3.GqlQueryParameter")
	proto.RegisterType((*QueryResultBatch)(nil), "google.datastore.v1beta3.QueryResultBatch")
	proto.RegisterEnum("google.datastore.v1beta3.EntityResult_ResultType", EntityResult_ResultType_name, EntityResult_ResultType_value)
	proto.RegisterEnum("google.datastore.v1beta3.PropertyOrder_Direction", PropertyOrder_Direction_name, PropertyOrder_Direction_value)
	proto.RegisterEnum("google.datastore.v1beta3.CompositeFilter_Operator", CompositeFilter_Operator_name, CompositeFilter_Operator_value)
	proto.RegisterEnum("google.datastore.v1beta3.PropertyFilter_Operator", PropertyFilter_Operator_name, PropertyFilter_Operator_value)
	proto.RegisterEnum("google.datastore.v1beta3.QueryResultBatch_MoreResultsType", QueryResultBatch_MoreResultsType_name, QueryResultBatch_MoreResultsType_value)
}

func init() {
	proto.RegisterFile("google/datastore/v1beta3/query.proto", fileDescriptor_query_78e38e7bbd181d7f)
}

var fileDescriptor_query_78e38e7bbd181d7f = []byte{
	// 1323 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xcb, 0x6e, 0xdb, 0x46,
	0x14, 0x35, 0xa9, 0x87, 0xa5, 0xab, 0x17, 0x33, 0x69, 0x53, 0xc6, 0x79, 0xd4, 0x21, 0x92, 0x46,
	0x41, 0x51, 0x09, 0x56, 0x10, 0x34, 0x48, 0xdb, 0x85, 0x1e, 0xb4, 0xad, 0x46, 0x16, 0x95, 0x91,
	0x6c, 0x20, 0x85, 0x0b, 0x82, 0x96, 0xc6, 0x0a, 0x1b, 0x8a, 0x64, 0xc8, 0x71, 0x12, 0x7f, 0x48,
	0x81, 0x7e, 0x43, 0x77, 0xfd, 0x83, 0x2e, 0xba, 0x2a, 0xd0, 0x6d, 0xb7, 0xfd, 0x80, 0x6e, 0xfa,
	0x07, 0x2d, 0x38, 0x33, 0xd4, 0xcb, 0x51, 0xe4, 0x02, 0xd9, 0x69, 0xee, 0x9c, 0x73, 0xee, 0xcc,
	0xe1, 0x9d, 0x99, 0x2b, 0xb8, 0x3b, 0xf6, 0xbc, 0xb1, 0x43, 0xaa, 0x23, 0x8b, 0x5a, 0x21, 0xf5,
	0x02, 0x52, 0x7d, 0xbd, 0x73, 0x42, 0xa8, 0xf5, 0xb0, 0xfa, 0xea, 0x8c, 0x04, 0xe7, 0x15, 0x3f,
	0xf0, 0xa8, 0x87, 0x54, 0x8e, 0xaa, 0x4c, 0x51, 0x15, 0x81, 0xda, 0xba, 0x29, 0xf8, 0x96, 0x6f,
	0x57, 0x2d, 0xd7, 0xf5, 0xa8, 0x45, 0x6d, 0xcf, 0x0d, 0x39, 0x6f, 0xeb, 0xde, 0x4a, 0x75, 0xe2,
	0x52, 0x9b, 0x0a, 0xf9, 0xad, 0xdb, 0x02, 0xc6, 0x46, 0x27, 0x67, 0xa7, 0xd5, 0x37, 0x81, 0xe5,
	0xfb, 0x24, 0x88, 0x65, 0x44, 0xfa, 0x2a, 0x3d, 0xf7, 0x49, 0xd5, 0xb1, 0xa8, 0xe3, 0x8e, 0xf9,
	0x8c, 0xf6, 0x87, 0x04, 0x79, 0x9d, 0x49, 0x61, 0x12, 0x9e, 0x39, 0x14, 0x3d, 0x86, 0x34, 0x97,
	0x56, 0xa5, 0x6d, 0xa9, 0x9c, 0xab, 0x6d, 0x57, 0x56, 0x2d, 0xbd, 0x22, 0x78, 0x02, 0x8f, 0x54,
	0xd8, 0x7c, 0x4d, 0x82, 0xd0, 0xf6, 0x5c, 0x35, 0xb9, 0x2d, 0x95, 0x13, 0x38, 0x1e, 0xa2, 0x6b,
	0x90, 0x1e, 0x9e, 0x05, 0xa1, 0x17, 0xa8, 0x89, 0x6d, 0xa9, 0x9c, 0xc7, 0x62, 0xa4, 0x3d, 0x03,
	0xe0, 0x59, 0x07, 0xe7, 0x3e, 0x41, 0x37, 0xe0, 0x13, 0xac, 0xf7, 0x0f, 0x3b, 0x03, 0x73, 0xf0,
	0xbc, 0xa7, 0x9b, 0x87, 0xdd, 0x7e, 0x4f, 0x6f, 0xb6, 0x77, 0xdb, 0x7a, 0x4b, 0xd9, 0x40, 0x19,
	0x48, 0xee, 0x1e, 0x76, 0x3a, 0x8a, 0x84, 0x8a, 0x00, 0x3d, 0x6c, 0x7c, 0xab, 0x37, 0x07, 0x6d,
	0xa3, 0xab, 0xc8, 0x28, 0x0f, 0x99, 0xa7, 0xfa, 0x73, 0xd3, 0xe8, 0x76, 0x9e, 0x2b, 0x09, 0xed,
	0xaf, 0x04, 0xa4, 0x9e, 0x45, 0xc6, 0xa3, 0x16, 0x80, 0x1f, 0x78, 0x3f, 0x90, 0x61, 0xe4, 0xa7,
	0x2a, 0x6f, 0x27, 0xca, 0xb9, 0xda, 0xdd, 0xd5, 0x9b, 0xe9, 0x4d, 0xb1, 0x78, 0x8e, 0x87, 0xbe,
	0x86, 0xe4, 0x4b, 0xdb, 0x1d, 0xa9, 0x09, 0xc6, 0x2f, 0xaf, 0xe6, 0x3f, 0xb5, 0xdd, 0x91, 0xfe,
	0xd6, 0x0f, 0x48, 0x18, 0x6d, 0x19, 0x33, 0x56, 0x64, 0xe6, 0xa9, 0xed, 0x50, 0x12, 0x30, 0x47,
	0xde, 0x6b, 0xe6, 0x2e, 0xc3, 0x61, 0x81, 0x47, 0xdf, 0x40, 0xca, 0x0b, 0x46, 0x24, 0x50, 0x53,
	0x2c, 0xf1, 0xfd, 0xf7, 0x2e, 0xdc, 0x27, 0x01, 0x3d, 0x37, 0x22, 0x38, 0xe6, 0x2c, 0xd4, 0x81,
	0xdc, 0xc8, 0x0e, 0xa9, 0xed, 0x0e, 0xa9, 0xe9, 0xb9, 0x6a, 0x9a, 0x89, 0x7c, 0xbe, 0x5e, 0x04,
	0x93, 0x53, 0x12, 0x10, 0x77, 0x48, 0x30, 0xc4, 0x7c, 0xc3, 0x45, 0x77, 0x20, 0x1f, 0x52, 0x2b,
	0xa0, 0xa6, 0xf8, 0x8a, 0x9b, 0xec, 0x2b, 0xe6, 0x58, 0xac, 0xc9, 0x42, 0xe8, 0x16, 0x00, 0x71,
	0x47, 0x31, 0x20, 0xc3, 0x00, 0x59, 0xe2, 0x8e, 0xc4, 0xf4, 0x35, 0x48, 0x7b, 0xa7, 0xa7, 0x21,
	0xa1, 0x2a, 0x6c, 0x4b, 0xe5, 0x14, 0x16, 0x23, 0xb4, 0x03, 0x29, 0xc7, 0x9e, 0xd8, 0x54, 0xcd,
	0x33, 0x7f, 0x6e, 0xc4, 0x2b, 0x8c, 0x0b, 0xb9, 0xd2, 0x76, 0xe9, 0xc3, 0xda, 0x91, 0xe5, 0x9c,
	0x11, 0xcc, 0x91, 0xda, 0x5d, 0x28, 0x2e, 0x7a, 0x8d, 0x10, 0x24, 0x5d, 0x6b, 0x42, 0x58, 0xc1,
	0x66, 0x31, 0xfb, 0xad, 0xdd, 0x87, 0x2b, 0x17, 0xf6, 0x34, 0x05, 0xca, 0x73, 0xc0, 0x43, 0x80,
	0xd9, 0xa7, 0x47, 0x7b, 0x90, 0xf1, 0x05, 0x4d, 0xd4, 0xff, 0xff, 0x32, 0x6d, 0x4a, 0xd6, 0xfe,
	0x91, 0xa0, 0xb0, 0xf0, 0x65, 0x3e, 0x98, 0x34, 0x32, 0x20, 0x3b, 0xb2, 0x83, 0x69, 0x5d, 0x4b,
	0xe5, 0x62, 0x6d, 0xe7, 0x92, 0xe5, 0x51, 0x69, 0xc5, 0x44, 0x3c, 0xd3, 0xd0, 0x74, 0xc8, 0x4e,
	0xe3, 0xe8, 0x3a, 0x7c, 0xdc, 0x6a, 0x63, 0x7e, 0xba, 0x96, 0xce, 0x60, 0x01, 0xb2, 0xf5, 0x7e,
	0x53, 0xef, 0xb6, 0xda, 0xdd, 0x3d, 0x7e, 0x10, 0x5b, 0xfa, 0x74, 0x2c, 0x6b, 0xbf, 0x49, 0x90,
	0xe6, 0x55, 0x8c, 0x8e, 0x40, 0x19, 0x7a, 0x13, 0xdf, 0x0b, 0x6d, 0x4a, 0x4c, 0x71, 0x02, 0xf8,
	0x9e, 0x1f, 0xac, 0x5e, 0x69, 0x33, 0x66, 0x70, 0x91, 0xfd, 0x0d, 0x5c, 0x1a, 0x2e, 0x86, 0x50,
	0x1f, 0x4a, 0xb1, 0x0d, 0xb1, 0xac, 0xcc, 0x64, 0xcb, 0xeb, 0x0d, 0x98, 0xaa, 0x16, 0xfd, 0x85,
	0x48, 0xa3, 0x00, 0x39, 0xae, 0x65, 0x46, 0xd7, 0xa3, 0xf6, 0xab, 0x04, 0xa5, 0xa5, 0xa5, 0xa0,
	0x06, 0xc8, 0x9e, 0xcf, 0x76, 0x50, 0xac, 0xd5, 0x2e, 0xbd, 0x83, 0x8a, 0xe1, 0x93, 0xc0, 0xa2,
	0x5e, 0x80, 0x65, 0xcf, 0x47, 0x4f, 0x60, 0x93, 0xa7, 0x09, 0xc5, 0x65, 0xb4, 0xfe, 0x32, 0x88,
	0x09, 0xda, 0x17, 0x90, 0x89, 0xb5, 0x90, 0x0a, 0x1f, 0x19, 0x3d, 0x1d, 0xd7, 0x07, 0x06, 0x5e,
	0xfa, 0x3e, 0x9b, 0x90, 0xa8, 0x77, 0x5b, 0x8a, 0xa4, 0xfd, 0x2d, 0x43, 0x71, 0x71, 0xdb, 0x1f,
	0xae, 0xfa, 0xea, 0xcc, 0x8a, 0x4b, 0x97, 0xdd, 0xbb, 0x9c, 0x78, 0x04, 0xa9, 0xd7, 0xd1, 0x89,
	0x66, 0xaf, 0x41, 0xae, 0xf6, 0xe9, 0x6a, 0x15, 0x71, 0xf0, 0x19, 0x5a, 0xfb, 0x51, 0xba, 0x94,
	0x0b, 0x05, 0xc8, 0x76, 0xf4, 0x7e, 0xdf, 0x1c, 0xec, 0xd7, 0xbb, 0x8a, 0x84, 0xae, 0x01, 0x9a,
	0x0e, 0x4d, 0x03, 0x9b, 0xfa, 0xb3, 0xc3, 0x7a, 0x47, 0x91, 0x91, 0x02, 0xf9, 0x3d, 0xac, 0xd7,
	0x07, 0x3a, 0xe6, 0xc8, 0x44, 0x54, 0xf9, 0xf3, 0x91, 0x19, 0x38, 0x89, 0xb2, 0x90, 0xe2, 0x3f,
	0x53, 0x11, 0x6f, 0xbf, 0xde, 0x37, 0xeb, 0xdd, 0xa6, 0xde, 0x1f, 0x18, 0x58, 0xc9, 0x69, 0xff,
	0xca, 0x90, 0xd9, 0x7b, 0xe5, 0xf0, 0x57, 0xe7, 0x0e, 0xe4, 0xd9, 0xbb, 0x6f, 0x86, 0x34, 0xb0,
	0xdd, 0xb1, 0xb8, 0x93, 0x72, 0x2c, 0xd6, 0x67, 0x21, 0x74, 0x0f, 0x8a, 0x96, 0xe3, 0x78, 0x6f,
	0x4c, 0xc7, 0xa6, 0x24, 0xb0, 0x9c, 0x90, 0xb9, 0x99, 0xc1, 0x05, 0x16, 0xed, 0x88, 0x20, 0x3a,
	0x86, 0x62, 0x74, 0x41, 0x8d, 0xcc, 0x13, 0xdb, 0x1d, 0xd9, 0xee, 0x38, 0x14, 0x4f, 0xc1, 0xa3,
	0xd5, 0x76, 0xc5, 0xab, 0xa8, 0x74, 0x23, 0x62, 0x43, 0xf0, 0x74, 0x97, 0x06, 0xe7, 0xb8, 0xe0,
	0xce, 0xc7, 0xd0, 0x31, 0x5c, 0x65, 0xa5, 0x6a, 0x7b, 0xae, 0xe5, 0xcc, 0x52, 0x24, 0xd7, 0x3d,
	0x14, 0x71, 0x8a, 0x9e, 0x15, 0x58, 0x13, 0x12, 0x15, 0x29, 0x9a, 0xe9, 0xc4, 0xea, 0x5b, 0x13,
	0x40, 0x17, 0x97, 0x80, 0x14, 0x48, 0xbc, 0x24, 0xe7, 0xc2, 0x92, 0xe8, 0x27, 0xaa, 0xc7, 0x95,
	0x20, 0xaf, 0x2b, 0xc9, 0x8b, 0x79, 0x39, 0xf3, 0x89, 0xfc, 0x58, 0xd2, 0xde, 0xc2, 0x95, 0x0b,
	0xf3, 0xe8, 0xcb, 0x45, 0xed, 0x75, 0x55, 0xb6, 0xbf, 0x21, 0x14, 0x91, 0xba, 0xd8, 0xad, 0xec,
	0x6f, 0xc4, 0xfd, 0x4a, 0x43, 0x81, 0xa2, 0x1f, 0xeb, 0xf3, 0xcb, 0xe2, 0xcf, 0x24, 0x28, 0x2c,
	0x2f, 0xef, 0x63, 0x1a, 0x16, 0x1d, 0xbe, 0x40, 0xf7, 0xa1, 0x14, 0xbe, 0xb4, 0x7d, 0x9f, 0x8c,
	0xcc, 0x80, 0x85, 0x43, 0x35, 0xcd, 0x5e, 0xbd, 0xa2, 0x08, 0x73, 0x70, 0x18, 0x55, 0x42, 0x0c,
	0x5c, 0xe8, 0x8f, 0x0a, 0x22, 0x2a, 0x1e, 0x4f, 0x13, 0x10, 0x6f, 0xb1, 0x84, 0x1c, 0x4b, 0x2d,
	0x6e, 0xa3, 0x9d, 0xb5, 0xed, 0x19, 0xa3, 0x54, 0x66, 0x7d, 0x16, 0x56, 0xc8, 0xdc, 0x04, 0xeb,
	0xbc, 0x0e, 0xa0, 0xb8, 0x90, 0x20, 0xbe, 0xa1, 0x3e, 0xbb, 0x9c, 0x38, 0x2e, 0xcc, 0x2b, 0x86,
	0x4b, 0xbd, 0x40, 0x72, 0xb9, 0x17, 0xf8, 0x1e, 0xf2, 0x13, 0x2f, 0x20, 0xd3, 0x5c, 0x29, 0xb6,
	0x91, 0x27, 0xab, 0x73, 0x2d, 0x1b, 0x5c, 0x39, 0xf0, 0x02, 0x22, 0x92, 0xb1, 0x1d, 0xe5, 0x26,
	0xb3, 0x00, 0x7a, 0x00, 0x4a, 0xe8, 0x5a, 0x7e, 0xf8, 0xc2, 0xa3, 0x66, 0xdc, 0x8f, 0x6e, 0xb2,
	0x7e, 0xb4, 0x14, 0xc7, 0x8f, 0x78, 0x58, 0xfb, 0x49, 0x82, 0xd2, 0x92, 0x16, 0xba, 0x03, 0xb7,
	0x0e, 0x0c, 0xac, 0x9b, 0xbc, 0x15, 0xed, 0xbf, 0xab, 0x17, 0x55, 0x20, 0xdf, 0x35, 0x06, 0xe6,
	0x6e, 0xbb, 0xdb, 0xee, 0xef, 0xeb, 0x2d, 0x45, 0x42, 0x37, 0x41, 0x5d, 0x20, 0xd5, 0x77, 0xa3,
	0x5b, 0xa4, 0xd3, 0x3e, 0x68, 0x0f, 0x14, 0x19, 0xdd, 0x82, 0xeb, 0xef, 0x98, 0x6d, 0x1e, 0xe2,
	0xbe, 0x81, 0x95, 0x24, 0xba, 0x0a, 0xa5, 0xae, 0x61, 0xce, 0x23, 0x94, 0x44, 0xe3, 0x17, 0x09,
	0x6e, 0x0e, 0xbd, 0xc9, 0x4a, 0x53, 0x1a, 0xc0, 0xcb, 0x3d, 0xea, 0x93, 0x7a, 0xd2, 0x77, 0x75,
	0x81, 0x1b, 0x7b, 0x8e, 0xe5, 0x8e, 0x2b, 0x5e, 0x30, 0xae, 0x8e, 0x89, 0xcb, 0xba, 0xa8, 0x2a,
	0x9f, 0xb2, 0x7c, 0x3b, 0xbc, 0xf8, 0x37, 0xe2, 0xab, 0x69, 0xe4, 0x67, 0xf9, 0xf6, 0x1e, 0xd7,
	0x68, 0x3a, 0xde, 0xd9, 0xa8, 0xd2, 0x9a, 0x66, 0x3c, 0xda, 0x69, 0x44, 0xd0, 0xdf, 0x63, 0xc0,
	0x31, 0x03, 0x1c, 0x4f, 0x01, 0xc7, 0x47, 0x5c, 0xeb, 0x24, 0xcd, 0xf2, 0x3d, 0xfc, 0x2f, 0x00,
	0x00, 0xff, 0xff, 0x61, 0xdf, 0x90, 0xd9, 0x13, 0x0d, 0x00, 0x00,
}
