Copilot な仲間たちとアプリケーションや動画、ブログポストを共有しよう！

## ブログポスト

| Title                                                                                                                                                                                                                                                                                            | Description                                                                                                                                                                                                                                                                                                                                                            |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [**Prefect Cloud based data pipelines using AWS Copilot on ECS**](https://www.core27.co/post/prefect-cloud-based-data-pipelines-using-aws-copilot-on-ecs) by <a href="https://twitter.com/Core27_">@Core27_</a>                                                                                 | Core27 takes you through building and deploying a production-grade data stack on Amazon Elastic Container Service.                                                                                                                                                                                                             |
| [**AWS Copilot GitHub Actions**](https://blog.sivamuthukumar.com/aws-copilot-github-actions) by <a href="https://twitter.com/ksivamuthu">@ksivamuthu</a>                                                                                                                                         | Sivamuthu  Kumar is back again, this time setting up OpenID Connect to link AWS and GitHub Actions, then using GitHub Actions to install Copilot and deploy an app.                                                                                                                                                                                                    |
| [**Deploy Serverless Containerized NodeJs Apps on AWS ECS Fargate with AWS Copilot**](https://www.serverlessguru.com/blog/deploy-serverless-containerized-nodejs-application-on-aws-ecs-fargate) by <a href="https://twitter.com/jaymitb">@gaymitb</a>                                           | Jaymit Bhoraniya takes you through deploying to AWS, first with basic config, then with a CI/CD pipeline.                                                                                                                                                                                                                                                              |
| [**How to Use Copilot to Deploy Projects on ECS**](https://www.wednesday.is/writing-tutorials/how-to-use-copilot-to-deploy-projects-on-ecs) by Christin Itty                                                                                                                                     | This tutorial includes a demo repo with a script of Copilot commands, showing you how to launch an entire app (including an Aurora serverless cluster with a PostgreSQL engine) in just one command.                                                                                                                                                                   |
| [**AWS Copilot CLI を使って複数環境で既存の DynamoDB を使う**](https://zenn.dev/hkdord/articles/aws-copilot-cli-existing-dynamodb) by <a href="https://twitter.com/hkford3">@hkford3</a>                                                                                                                        | [Japanese] Hidekazu Karino walks us through the deployment of a service to two environments, leveraging an existing DynamoDB table, and setting up a CI/CD pipeline, all with Copilot.                                                                                                                                                                                 |
| [**レンティオの本番環境をAWS Copilot/Fargate構成に切り替えた話**](https://zenn.dev/rentio/articles/convox-to-copilot) by <a href="https://zenn.dev/rentio">the Rentio development team</a>                                                                                                                           | [Japanese] A real-life account of switching from Convox to Copilot, including the 'why's and the 'how's, what went well and what didn't.                                                                                                                                                                                                                               |
| [**Deploy .NET 6 API to AWS App Runner using AWS Copilot CLI**](https://dev.to/aws-builders/deploy-net-6-api-to-aws-app-runner-using-aws-copilot-cli-4hnl) by <a href="https://twitter.com/ksivamuthu">@ksivamuthu</a>                                                                           | Using Copilot and App Runner, Sivamuthu Kumar deploys a .NET API project.                                                                                                                                                                                                                                                                                              |
| [**Container-to-Container Communication**](https://www.miketheman.net/2021/12/28/container-to-container-communication/) by <a href="https://twitter.com/mikefiedler">@mikefiedler</a>                                                                                                            | Mike takes us through a science experiment of sorts, a "who will win" type of battle, to determine if TCP or Unix sockets are better for inter-container communication.                                                                                                                                                                                                |
| [**AWS Copilot で ECS(Fargate) に Express(Node.js) をデプロイする**](https://blog.morugu.com/entry/copilot-express) by Shoya Shiraki <a href="https://twitter.com/morugu">@morugu</a>                                                                                                                     | [Japanese] Follow along this blog post to build an Express Node.js app with Copilot.                                                                                                                                                                                                                                                                                   |
| [**AWS Copilot – ECS**](https://blog.sivamuthukumar.com/series/aws-copilot-ecs) by <a href="https://twitter.com/ksivamuthu">@ksivamuthu</a>                                                                                                                                                      | Here we have a three-part series devoted to Copilot! Sivamuthu Kumar demos launching a .NET coffeeshop app, exploring pipelines, storage, addons, and logs along the way.                                                                                                                                                                                              |
| [**Deploying a Telegram Bot to AWS ECS with AWS Copilot**](https://dev.to/chrisciokler/deploying-a-telegram-bot-to-aws-ecs-with-aws-copilot-step-by-step-for-absolut-beginners-ngl) by Christian Prado Ciokler                                                                                   | Christian takes you through building a Node.js app, step-by-step, with Copilot on Docker Desktop Windows Subsystem for Linux (WSL) 2.                                                                                                                                                                                                                                  |
| [**Deploying a Containerized Web App with AWS Copilot**](https://towardsdatascience.com/deploying-a-containerized-web-app-with-aws-copilot-db5c90467fbd) by <a href="https://twitter.com/edkruegerdata">@edkruegerdata</a> and <a href="https://www.linkedin.com/in/dylan-rossi/">Dylan Rossi</a> | Edward and Dylan start from the basics, including IAM account creation and AWS CLI installation. (Note: you'll also need to install AWS Copilot.) They demonstrate using Postman to test the deployed app.                                                                                                                                                             |
| [**Pilot your containers like a boss with AWS Copilot!**](https://blog.flolight.dev/pilot-your-containers-like-a-boss-with-aws-copilot) by <a href="https://twitter.com/FlolightC">@FlolightC</a>                                                                                                | Florian simplifies getting started with AWS Copilot by demoing deployment of a [sample app](https://github.com/aws-samples/amazon-ecs-cli-sample-app) from start to finish, including links to both required and optional resources.                                                                                                                                   |
| [**Use AWS Copilot CLI to deploy containers on an existing infrastructure - Tutorial**](https://towardsthecloud.com/aws-copilot-cli-deploy-containers-existing-infrastructure-tutorial) by <a href="https://twitter.com/dannysteenman">@dannysteenman</a>                                        | Danny explains how to use your existing VPC and subnets with AWS Copilot to quickly set up a working container environment. Follow along as he deploys a Django app with an RDS Postgres database and Elasticache Redis cluster.                                                                                                                                       |
| [**Automatically deploying your container application with AWS Copilot**](https://aws.amazon.com/blogs/containers/automatically-deploying-your-container-application-with-aws-copilot/) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a>                                            | Nathan shows how to set up a release pipeline with the CLI that builds, pushes, and deploys an application. Finally, he sets up integration tests for validation before releasing to production.                                                                                                                                                                       |
| [**Deploying containers with the AWS Copilot CLI**](https://maartenbruntink.nl/blog/2020/08/16/deploying-containers-with-the-aws-copilot-cli-part-1/) by <a href="https://twitter.com/maartenbruntink">@maartenbruntink</a>                                                                      | Maarten shows how to use the AWS Copilot CLI to deploy the [sample Docker voting app](https://github.com/dockersamples/example-voting-app), which showcases how to set up your own Redis and Postgres servers. In the [second part](https://maartenbruntink.nl/blog/2020/08/16/deploying-containers-with-the-aws-copilot-cli-part-2), he automates the release process. |
| [**AWS Copilot: an application-first CLI for containers on AWS**](https://aws.amazon.com/blogs/containers/aws-copilot-an-application-first-cli-for-containers-on-aws/) by <a href="https://twitter.com/efekarakus">@efekarakus</a>                                                               | Efe walks through the design tenets of the CLI: why they were chosen, how they map to Copilot features, and the vision for how the CLI will evolve in the future.                                                                                                                                                                                                      |
| [**Introducing AWS Copilot**](https://aws.amazon.com/blogs/containers/introducing-aws-copilot/) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a>                                                                                                                                    | Nathan explains how with the AWS Copilot CLI you can go from idea to implementation much faster, with the confidence that the infrastructure you have deployed has production-ready configuration.     
## 動画

| タイトル     | 概要                         |
| ----------- | ------------------------------------ |
| [**Build, Operate, and Observe a Containerized Application on AWS Fargate**](https://nathanpeck.com/build-operate-and-observe-container-application-on-aws-fargate/) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a> | AWS's indefatigable Nathan Peck is back! In this session for AWS Application Modernization Day, he champions containers and demonstrates the deployment of a load-balanced web service and a load-testing scheduled job. |
| [**Using Jenkins and AWS Copilot CLI to Deploy to AWS App Runner**](https://www.youtube.com/watch?v=ajgQ4WfgKA8) by <a href="https://twitter.com/DarinPope">@DarinPope</a> | Darin, a developer advocate for CloudBees, uses AWS Copilot and a Jenkinsfile to deploy to AWS AppRunner. |
| [**Deploy a Web App with AWS CoPilot**](https://www.youtube.com/watch?v=OLiO5LLl6Ng&list=PLoxFga2t8Vw0tB6QRMZiADnAvmuTUZcc6) by <a href="https://twitter.com/edkruegerdata">@edkruegerdata</a> | This three-part series includes "Creating an Administrator User Group in AWS," "Create an IAM Account on AWS," and "Deploying the Web App." |
| [**Container Day: Amazon ECS Edition-- Demo: deploy a modern application on AWS Fargate with ECS Copilot**](https://www.youtube.com/watch?v=k01AdJC-dcA&t=14236s) by <a href="https://twitter.com/efekarakus">@efekarakus</a> and <a href="https://twitter.com/realadamjkeller">@realadamjkeller</a> | Efe goes beyond the basics, demoing how to grow [an application](https://github.com/efekarakus/day2-with-copilot); he highlights the `alias` field, secrets and environment variables, addons, and more. |
| [**Copilot– What AWS ECS and Fargate Container Management Should Have Been**](https://www.youtube.com/watch?v=YCCFK2RRm7U) by <a href="https://twitter.com/vfarcic">@vfarcic</a> | Viktor lauds Copilot for its simplicity and ease of use in this clear, step-by-step demo. |
| [**AWS Copilot CLI v1.8.0 Release Highlights**](https://www.youtube.com/watch?v=Oyr-n59mVjI) by <a href="https://twitter.com/realadamjkeller">@realadamjkeller</a> | Adam walks through the features that shipped with version 1.8.0 of the AWS Copilot CLI, including `alias`, the `svc status` update, and container dependency. |
| [**DevBeardOps with !Cobus & !Darko: Playing with Containers**](https://www.pscp.tv/w/1ypJdgQoLDqGW) by <a href="https://twitter.com/cobusbernard">@cobusbernard</a> and <a href="https://twitter.com/darkosubotica">@darkosubotica</a> | Learn alongside Cobus and Darko as they experiment with AWS Copilot, from installation to pipeline setup. |
| [**Containers from the Couch series**](https://www.youtube.com/c/ContainersfromtheCouch/search?query=copilot) by <a href="https://twitter.com/realadamjkeller">@realadamjkeller</a>, <a href="https://twitter.com/brentContained">@brentContained</a>, and guests | Join Adam and Brent to learn about many of the existing features of AWS Copilot with fun demos. Watch as they [set up](https://www.youtube.com/watch?v=Ay8iUFWzF4U) a three-tier application [with autoscaling](https://www.youtube.com/watch?v=TE-E_ZtMiv0); [create a continuous delivery pipeline with integration tests](https://www.youtube.com/watch?v=SpTI9be5whk); show how easy it is to ['exec' with Copilot](https://www.youtube.com/watch?v=NyiMoyx_xj4); and highlight [ephemeral storage](https://www.youtube.com/watch?v=lGmLhQjagVs) and [scheduled job](https://www.youtube.com/watch?v=veffvwZ6hG8) features. |
| [**AWS Copilot and another 6 ways to easily deploy apps to AWS**](https://www.youtube.com/watch?v=0lxcfJ20TwA) by <a href="https://twitter.com/Fodoj">Kirill Shirinkin</a> | Kirill Shirinkin explores ways to easily deploy a new product on AWS - including a new favorite one, AWS Copilot. |
| [**AWS re:Invent 2020: AWS Copilot: Simplifying container development**](https://youtu.be/EqW--TKQ_PQ) by <a href="https://twitter.com/efekarakus">@efekarakus</a> | Learn about the motivation behind AWS Copilot, get an overview of the existing commands and a demo of how to deploy a three-tier application. |
| [**How to Deploy a .NET Application to Amazon Elastic Container Service (ECS) with AWS Copilot**](https://youtu.be/nWaw8Rp8JgQ) by <a href="https://twitter.com/ignacioafuentes">@ignacioafuentes</a> | Get a demo on how to build and deploy a .NET application to Amazon ECS on AWS Fargate. |
| [**AWS What's Next**](https://www.youtube.com/watch?v=vmTJgVDERZU) by <a href="https://twitter.com/nathankpeck">@nathankpeck</a> and <a href="https://twitter.com/efekarakus">@efekarakus</a> | Nathan and Efe discuss what makes AWS Copilot unique compared to other infrastructure provisioning tools and then demo an overview of the existing commands. |

## コード・サンプル

| リポジトリ     | 詳細                         | 特徴 |
| ----------- | ------------------------------------ | ------------ |
[**Server Side Swift Guides**](https://www.swift.org/server/guides/deploying/aws-copilot-fargate-vapor-mongo.html) | Server Side Swift on AWS with Fargate, Vapor, and MongoDB Atlas deployed with Copilot | Fargate, Vapor, MongoDB, API Gateway
[**github.com/kcearns/fargate-node-example**](https://github.com/kcearns/fargate-node-example) | A sample Node application that includes a pipeline. | Node, pipeline
[**github.com/efekarakus/day2-with-copilot**](https://github.com/efekarakus/day2-with-copilot) | A REST API coffeeshop application that goes beyond the basics, demoed in the ["Container Day" video](./guides.en.md#videos), above. | `alias`, secrets, DynamoDB, Redis |
[**github.com/bvtujo/copilot-wordpress**](https://github.com/bvtujo/copilot-wordpress) | A WordPress installation launched by AWS Copilot with step-by-step instructions and options for customization. | [EFS](../docs/developing/storage.en.md#managed-efs), MySQL RDS cluster, autoscaling |
[**#2378**](https://github.com/aws/copilot-cli/discussions/2378) | Show-and-tell with sample templates for launching isolated tasks in private subnets. | VPC Endpoints, [custom environments](../docs/developing/custom-environment-resources.en.md) |
[**github.com/copilot-example-voting-app**](https://github.com/copilot-example-voting-app), [**#1745**](https://github.com/aws/copilot-cli/discussions/1745) | A voting application distributed over three ECS services created with AWS Copilot. | Amazon Aurora PostgreSQL database, service discovery, autoscaling |
[**#1925**](https://github.com/aws/copilot-cli/discussions/1925) | Show-and-tell explaining how you can do continuous deployments from branches with AWS Copilot pipelines. | Branch-based deploys, AWS CodePipeline |

## ワークショップ

| タイトル     | 詳細                         |
| ----------- | ------------------------------------ |
[**Deploy .NET Apps with AWS Copilot**](https://aws-labs.net/netonaws/copilot-windows-dotnet.html) | This lab, part of the AWS Windows Workshop, guides you through creating a .NET 6 project, including deploying CI/CD pipelines. Plenty of screen shots help you see what's happening in the terminal, in VS Code, and on the console. |
[**Copilot Rocks**](https://www.copilot.rocks/) | This open-source, comprehensive, modular workshop lets you pick and choose from multiple mini-workshops, covering everything from installation to implementing pub/sub patterns. Step-by-step guides offer tips and tricks, clarify with useful diagrams, and delve into advanced patterns. (Source code is hosted [here](https://github.com/donnieprakoso/copilot.rocks).) |
[**ECS Workshop**](https://ecsworkshop.com/microservices/) | In this workshop, we deploy a three-tier microservices application using the AWS Copilot CLI. (Optional accompanying video [here](https://www.youtube.com/watch?v=o8o9Ea9o0aI).) |
[**Copilot Primer Workshop**](https://catalog.us-east-1.prod.workshops.aws/workshops/d03316be-3c29-49db-8dc3-eb196c1778c9/ja-JP) | In this workshop, you will experience AWS Copilot CLI through the creation of a sample to-do list application. With AWS Copilot CLI, you initialize your application, create a development environment and deploy containers onto the environment. You can also deploy your containers from a pipeline. |
