// @flow
import {Linking} from 'react-native'
import {smsResults, type SMSResult} from './sms.meta'

// based loosely off of https://github.com/anarchicknight/react-native-communications/blob/master/AKCommunications.js
// returns the promise generated by RN Linking helper
//      resolve => url opened
//      reject => user stopped the action / url didn't open
const openSMS = (phonenos: Array<string>, body?: string): Promise<SMSResult> => {
  const proto = 'sms:'
  let query = ''
  if (body) {
    query = `?body=${body}`
  }

  const url = proto + phonenos.join(';') + query
  if (Linking.canOpenURL(url)) {
    return new Promise((resolve, reject) => {
      Linking.openURL(url)
        .then(val => {
          resolve(smsResults.UNKNOWN)
        })
        .catch(err => reject(err))
    })
  }
  return Promise.reject(new Error('Cannot open SMS url!'))
}

export default openSMS
